/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IExtraAssetApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.product.PProduct;
import cms.tmx.entity.ExtraAsset;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IExtraAssetService;
import java.util.List;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ExtraAssetMngServiceImpl
implements IExtraAssetService {
    @Inject
    private MObjFactory of;
    @Inject
    private IExtraAssetApi extApi;
    private ObservableList<ExtraAsset> list = FxUtils.newList();

    @Override
    public ObservableList<ExtraAsset> getExtraAssetList(String productId) throws MException {
        this.list.clear();
        List assets = this.extApi.GetExtraAssetList(productId);
        for (PProduct.ExtraAsset asset : assets) {
            ExtraAsset accntGrp = (ExtraAsset)this.of.create(ExtraAsset.class);
            accntGrp.update((Object)asset);
            this.list.add((Object)accntGrp);
        }
        return this.list;
    }

    @Override
    public PBase.OpStatus addExtraAsset(ExtraAsset asset) throws MException {
        PProduct.ExtraAsset.Builder builder = PProduct.ExtraAsset.newBuilder();
        builder.setAssetName(asset.getName());
        builder.setAssetType(asset.getType().getRaw());
        builder.setProductId(asset.getProductId());
        builder.setCurrency(asset.getCurrency().getRaw());
        builder.setEffectiveTime(asset.getEffectiveTime());
        builder.setLastUpdateTime(asset.getLastUpdateTime());
        builder.setNetValue(Double.parseDouble(asset.getValue()));
        return this.extApi.addExtraAsset(builder.build());
    }

    @Override
    public void deleteExtraAsset(String id) throws MException {
        this.extApi.deleteExtraAsset(id);
    }
}

