/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.utils.FxUtils;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ExcCmbModelSp {
    private ObservableList<MxNodePwf> listChecked = FxUtils.newList();
    boolean flag = false;
    private boolean bool = true;
    private static final String HS_STR = "XSHG,XSHE";
    private static final String QH_STR = "CCFX,XSGE,XDCE,XZCE,XINE";
    private static final String GJS_STR = "SGEX";
    private static final String CFETS_STR = "XCFE";
    private static final String JW_STR = "XHKG,XNYS,XNAS";

    @PostConstruct
    public void init() {
    }

    public void initCellFactory(ComboBox<MxNodePwf> cmb, Label lbShow, List<String> exChange) {
        this.setLabelTimely(lbShow, cmb, exChange);
        this.setCellFactory(cmb);
    }

    private void setCellFactory(ComboBox<MxNodePwf> cmb) {
        cmb.setCellFactory(value -> new ListCell<MxNodePwf>(){
            private HBox graphic = new HBox();
            CheckBox cBox = new CheckBox();
            Label label = new Label();
            private MxNodePwf item;
            {
                this.label.setMaxWidth(Double.POSITIVE_INFINITY);
                this.graphic.getChildren().setAll((Object[])new Node[]{this.cBox, this.label});
                HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }

            protected void updateItem(MxNodePwf item, boolean empty) {
                if (item != null) {
                    if (this.item == null) {
                        this.item = item;
                    }
                    this.label.textProperty().bind((ObservableValue)item.nameProperty());
                    if (item.isDefaluted()) {
                        item.setSelected(true);
                    } else {
                        item.setSelected(false);
                    }
                    this.cBox.setDisable(true);
                    this.cBox.selectedProperty().bind((ObservableValue)item.selectedProperty());
                }
                if (empty) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)this.graphic);
                }
            }
        });
        cmb.setSkin((Skin)new ComboBoxListViewSkin<MxNodePwf>(cmb){

            protected boolean isHideOnClickEnabled() {
                return false;
            }
        });
    }

    private void setLabelTimely(Label label, ComboBox<MxNodePwf> cmb, List<String> exChange) {
        label.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (this.flag) {
                cmb.hide();
                this.flag = false;
            } else {
                cmb.show();
                this.flag = true;
            }
            event.consume();
        });
        label.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.flag = false;
            }
        });
        this.listChecked.addListener(ob -> {
            String str = this.listChecked.toString();
            label.setText(str.substring(1, str.length() - 1));
            label.setTooltip(new Tooltip(label.getText()));
            if (this.listChecked.size() == 0) {
                if (exChange == null) {
                    cmb.getItems().forEach(node -> node.setDisable(true));
                } else if (exChange != null) {
                    cmb.getItems().forEach(node -> {
                        String type = ExcCmbModelSp.getExcTypeDesc((String)exChange.get(0));
                        node.setDisable(!type.contains(node.getRaw()));
                    });
                }
                this.bool = true;
            }
            if (this.bool && this.listChecked.size() == 1) {
                String type = ExcCmbModelSp.getExcTypeDesc(((MxNodePwf)this.listChecked.get(0)).getRaw());
                cmb.getItems().forEach(node -> node.setDisable(!type.contains(node.getRaw())));
                this.bool = false;
            }
        });
    }

    public void check(MxNodePwf defaultValue, boolean enable) {
        defaultValue.setDefaluted(true);
        defaultValue.setSelected(true);
        defaultValue.setDisable(!enable);
        this.filter(defaultValue);
    }

    public void clearCheck(MxNodePwf defaultValue, boolean enable) {
        defaultValue.setDefaluted(false);
        defaultValue.setSelected(false);
        defaultValue.setDisable(!enable);
        this.listChecked.remove((Object)defaultValue);
    }

    public ObservableList<MxNodePwf> getCheckItems() {
        return this.listChecked;
    }

    private void filter(MxNodePwf node) {
        if (!this.listChecked.contains((Object)node)) {
            this.listChecked.add((Object)node);
        }
    }

    private static String getExcTypeDesc(String exc) {
        if (HS_STR.contains(exc)) {
            return HS_STR;
        }
        if (QH_STR.contains(exc)) {
            return QH_STR;
        }
        if (GJS_STR.contains(exc)) {
            return GJS_STR;
        }
        if (CFETS_STR.contains(exc)) {
            return CFETS_STR;
        }
        if (JW_STR.contains(exc)) {
            return JW_STR;
        }
        return "";
    }
}

