/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MProps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CustomPaneModel {
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    private MProps idMenu;
    private MProps idData;
    private File customPanefile;
    protected final Logger logger = LogManager.getLogger(CustomPaneModel.class);

    @PostConstruct
    private void init() {
        this.idMenu = this.getIdMenuProp();
        this.idData = this.getIdDataProp();
    }

    public void add(String id, String menu, String data) {
        this.idMenu.setValue(id, (Object)menu);
        this.idData.setValue(id, (Object)data);
    }

    public void delete(String id) {
        this.idMenu.deleteValue(id);
        this.idData.deleteValue(id);
    }

    public Collection<Object> queryAll() {
        return this.idMenu.values();
    }

    public String queryById(String id) {
        return this.idData.get(id);
    }

    private MProps getIdMenuProp() {
        MProps mProps = new MProps();
        String userId = this.eCore.getStr("user_id");
        String postId = this.eCore.getStr("post_id");
        Path savePath = Paths.get(this.pathBase, "data", userId, postId, "idMenu.properties");
        this.customPanefile = savePath.toFile();
        File parentFile = this.customPanefile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!this.customPanefile.exists()) {
            try {
                this.customPanefile.createNewFile();
            }
            catch (IOException e) {
                this.logger.error("\u521b\u5efa\u81ea\u5b9a\u4e49\u9762\u677f\u6587\u4ef6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            }
        }
        mProps.load(this.customPanefile);
        return mProps;
    }

    private MProps getIdDataProp() {
        MProps mProps = new MProps();
        String userId = this.eCore.getStr("user_id");
        String postId = this.eCore.getStr("post_id");
        Path savePath = Paths.get(this.pathBase, "data", userId, postId, "idData.properties");
        this.customPanefile = savePath.toFile();
        File parentFile = this.customPanefile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!this.customPanefile.exists()) {
            try {
                this.customPanefile.createNewFile();
            }
            catch (IOException e) {
                this.logger.error("\u521b\u5efa\u81ea\u5b9a\u4e49\u9762\u677f\u6587\u4ef6\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            }
        }
        mProps.load(this.customPanefile);
        return mProps;
    }
}

