/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.utils.FxUtils;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class CurCmbModel {
    private ObservableList<MxNodePwf> listChecked = FxUtils.newList();
    boolean flag = false;

    public void initCellFactory(ComboBox<MxNodePwf> cmb, Label lbShow) {
        this.setLabelTimely(lbShow, cmb);
        this.setCellFactory(cmb);
    }

    private void setCellFactory(ComboBox<MxNodePwf> cmb) {
        cmb.setCellFactory(value -> new ListCell<MxNodePwf>(){
            private HBox graphic = new HBox();
            CheckBox cBox = new CheckBox();
            Label label = new Label();
            private MxNodePwf item;
            {
                this.label.setMaxWidth(Double.POSITIVE_INFINITY);
                this.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
                    if (!this.cBox.isDisable()) {
                        this.cBox.setSelected(!this.cBox.isSelected());
                        if (this.cBox.isSelected()) {
                            CurCmbModel.this.listChecked.add((Object)this.item);
                        } else {
                            CurCmbModel.this.listChecked.remove((Object)this.item);
                        }
                        this.item.setSelected(this.cBox.isSelected());
                    }
                    event.consume();
                });
                this.graphic.getChildren().setAll((Object[])new Node[]{this.cBox, this.label});
                HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }

            protected void updateItem(MxNodePwf item, boolean empty) {
                if (item != null) {
                    if (this.item == null) {
                        this.item = item;
                    }
                    if (this.label.getText().isEmpty()) {
                        this.label.setText(item.getValue());
                    }
                    if (item.isDisable()) {
                        this.cBox.setSelected(item.isSelected());
                        this.cBox.setDisable(true);
                    } else {
                        this.cBox.setSelected(item.isSelected());
                        this.cBox.setDisable(false);
                    }
                }
                if (empty) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)this.graphic);
                }
            }
        });
        cmb.setSkin((Skin)new ComboBoxListViewSkin<MxNodePwf>(cmb){

            protected boolean isHideOnClickEnabled() {
                return false;
            }
        });
    }

    private void setLabelTimely(Label label, ComboBox<MxNodePwf> cmb) {
        label.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (this.flag) {
                cmb.hide();
                this.flag = false;
            } else {
                cmb.show();
                this.flag = true;
            }
            event.consume();
        });
        label.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.flag = false;
            }
        });
        this.listChecked.addListener(ob -> {
            String str = this.listChecked.toString();
            label.setText(str.substring(1, str.length() - 1));
        });
    }

    public void check(MxNodePwf defaultValue, boolean enable) {
        this.listChecked.add((Object)defaultValue);
        defaultValue.setDefaluted(true);
        defaultValue.setSelected(true);
        defaultValue.setDisable(!enable);
    }

    public ObservableList<MxNodePwf> getCheckItems() {
        return this.listChecked;
    }

    public ObservableList<MxNodePwf> getNewItems() {
        return this.listChecked.filtered(node -> !node.isDefaluted());
    }
}

