/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPartyApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.http.manage.api.CounterPartyServiceApi;
import cms.tmx.http.manage.dto.CounterPartyEvent;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.http.workflow.dto.CounterPartyAccount;
import cms.tmx.http.workflow.dto.GetCounterPartyAcountReq;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CounterPartyMngService {
    private static final Logger logger = LogManager.getLogger(CounterPartyMngService.class);
    @Inject
    private CounterPartyServiceApi cpApi;
    @Inject
    private IPartyApi partyApi;
    @Inject
    private IBaseApi baseApi;
    private List<CounterPartyAccount> counterPartyies = new ArrayList<CounterPartyAccount>();
    @Inject
    private MEventService es;

    @PostConstruct
    private void init() {
        this.es.subscribe("uap.push.CounterPartyEvent", event -> this.onPush(event));
    }

    private void onPush(MEvent event) {
        JsonObject pushMsg = (JsonObject)event.getObj(JsonObject.class);
        CounterPartyEvent se = (CounterPartyEvent)GsonFactory.getInstance().fromJson(pushMsg.toString(), CounterPartyEvent.class);
        CounterPartyAccount newCounterParty = se.getCounterPartyAccount();
        if (newCounterParty == null) {
            return;
        }
        CounterPartyAccount old = null;
        if (se.getCounterPartyAccount().getCounterParty() != null) {
            for (CounterPartyAccount counterPartyAccount : this.counterPartyies) {
                if (!counterPartyAccount.getCounterParty().getId().equals(se.getCounterPartyAccount().getCounterParty().getId())) continue;
                old = counterPartyAccount;
            }
        }
        event.setObj((Object)newCounterParty);
        if ("kEventCreate".equals(se.getEvent())) {
            if (old == null) {
                this.counterPartyies.add(newCounterParty);
                this.es.sendEvent("counterparty_create", event);
            }
        } else if ("kEventUpdate".equals(se.getEvent())) {
            if (old != null) {
                old.update(newCounterParty);
            } else {
                this.counterPartyies.add(newCounterParty);
                this.es.sendEvent("counterparty_create", event);
            }
        } else if ("kEventDelete".equals(se.getEvent()) && old != null) {
            event.setObj((Object)old);
            this.counterPartyies.remove(old);
            this.es.sendEvent("counterparty_delete", event);
        }
    }

    public synchronized List<CounterPartyAccount> getCounterBanks() {
        if (!this.counterPartyies.isEmpty()) {
            return this.counterPartyies;
        }
        GetCounterPartyAcountReq req = new GetCounterPartyAcountReq();
        List counterBanks = null;
        List parties = new ArrayList();
        try {
            parties = this.partyApi.getPartyListContainOwn(this.baseApi.getPartyId());
        }
        catch (MException mException) {
            logger.error("\u4ea4\u6613\u5bf9\u624b\u65b9\u67e5\u8be2\u5b50\u673a\u6784\u51fa\u9519");
        }
        for (PHierarchy.Party party : parties) {
            req.getSysPartyId().add(party.getPartyId());
        }
        if (req.getSysPartyId().isEmpty()) {
            req.getSysPartyId().add(this.baseApi.getPartyId());
        }
        try {
            counterBanks = this.cpApi.getCounterPartyAcount(req);
        }
        catch (MException | Exception e) {
            logger.error("\u67e5\u8be2\u4ea4\u6613\u5bf9\u624b\u65b9\u51fa\u9519", e);
        }
        if (counterBanks != null) {
            this.counterPartyies.addAll(counterBanks);
        }
        return this.counterPartyies;
    }
}

