/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.ClearingNewInfo;
import cms.tmx.entity.ClearingNewStep;
import cms.tmx.entity.factory.ClearingNewInfoFactory;
import cms.tmx.entity.factory.ClearingNewStepFactory;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.settlement.api.ClearingNewServiceApi;
import cms.tmx.http.settlement.dto.ExecuteSettleReq;
import cms.tmx.http.settlement.dto.GetSettleStepReq;
import cms.tmx.http.settlement.dto.GetSettleStepResp;
import cms.tmx.http.settlement.dto.GetSettleSystemStatusReq;
import cms.tmx.http.settlement.dto.GetSettleSystemStatusResp;
import cms.tmx.http.settlement.dto.SettleReport;
import cms.tmx.http.settlement.dto.SettleStep;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IClearingNewModel;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ClearingNewModel
implements IClearingNewModel {
    @Inject
    private ClearingNewServiceApi clearApi;
    @Inject
    private HttpBaseApi httpApi;
    @Inject
    private ClearingNewStepFactory factoryStep;
    @Inject
    private ClearingNewInfoFactory factoryInfo;
    @Inject
    private MEventService es;
    private MxList<ClearingNewStep> stepList = new MxList();
    private ClearingNewInfo clearingInfo;
    private StringBuilder curLog = new StringBuilder();
    private AtomicInteger logNum = new AtomicInteger(0);
    private Gson gson = new Gson();
    private static final Logger logger = LogManager.getLogger(ClearingNewModel.class);
    boolean firstPush = true;
    private DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMdd HH:mm:ss");
    private LocalDateTime preBeginTime;
    private LocalDateTime preEndTime;
    private BooleanProperty changed = new SimpleBooleanProperty(false);
    private BooleanProperty logChanged = new SimpleBooleanProperty(false);
    private BooleanProperty logOverrided = new SimpleBooleanProperty(false);

    @PostConstruct
    public void init() {
        this.clearingInfo = this.factoryInfo.create();
        this.es.subscribe("uap.push.SettlementReport", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        if (!(event.getObj() instanceof JsonPrimitive)) {
            return;
        }
        JsonPrimitive obj = (JsonPrimitive)event.getObj();
        SettleReport settleEvent = (SettleReport)this.gson.fromJson(obj.getAsString(), SettleReport.class);
        SettleStep settleStep = settleEvent.getStep();
        ClearingNewStep step = this.factoryStep.create();
        step.update((Object)settleStep);
        this.stepList.updatePart((MxObject)step);
        try {
            this.queryStatus();
        }
        catch (MException e) {
            logger.error("\u65b0\u6846\u67b6\u6e05\u7b97\u63a8\u9001\u67e5\u8be2\u7cfb\u7edf\u72b6\u6001" + e.getMessage(), (Throwable)e);
        }
        this.changed();
        this.curLog.setLength(0);
        this.curLog.append("\u5f00\u59cb\u65f6\u95f4\uff1a").append(step.getBeginTime()).append("\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a").append(step.getEndTime()).append("\uff0c\u7f16\u53f7\uff1a").append(step.getStepNo()).append("\uff0c\u540d\u79f0\uff1a").append(step.getStepName()).append("\uff0c\u72b6\u6001\uff1a").append(step.getCurrStatus()).append("\uff0c").append(StringUtils.isEmpty((String)step.getAttachment()) ? "" : step.getAttachment()).append("\n");
        this.logChanged();
    }

    @Override
    public List<ClearingNewStep> getStepList() {
        return this.stepList.getList();
    }

    @Override
    public void queryStepList() throws MException {
        LinkedList<ClearingNewStep> newList = new LinkedList<ClearingNewStep>();
        GetSettleStepReq request = new GetSettleStepReq();
        request.setOpUser(this.httpApi.getHttpOpUser());
        GetSettleStepResp resp = this.clearApi.clearQueryStepInfo(request);
        this.curLog.setLength(0);
        for (SettleStep settleStep : resp.getStep()) {
            ClearingNewStep step = this.factoryStep.create();
            step.update((Object)settleStep);
            newList.add(step);
            this.curLog.append("\u5f00\u59cb\u65f6\u95f4\uff1a").append(step.getBeginTime()).append("\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a").append(step.getEndTime()).append("\uff0c\u7f16\u53f7\uff1a").append(step.getStepNo()).append("\uff0c\u540d\u79f0\uff1a").append(step.getStepName()).append("\uff0c\u72b6\u6001\uff1a").append(step.getCurrStatus()).append("\uff0c").append(StringUtils.isEmpty((String)step.getAttachment()) ? "" : step.getAttachment()).append("\n");
        }
        this.update(newList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void update(List<ClearingNewStep> listQuery) {
        ObservableList observableList = this.stepList.getList();
        synchronized (observableList) {
            this.stepList.setAll(listQuery);
        }
        this.changed();
        this.logOverrided();
    }

    private void changed() {
        this.changed.set(!this.changed.get());
    }

    public BooleanProperty changedProperty() {
        return this.changed;
    }

    private void logChanged() {
        this.logChanged.set(!this.logChanged.get());
    }

    @Override
    public BooleanProperty logChangedProperty() {
        return this.logChanged;
    }

    @Override
    public synchronized void queryLog() throws MException {
    }

    @Override
    public String getLog() {
        return this.curLog.toString();
    }

    @Override
    public void startRun(ClearingNewStep step) throws MException {
        if (step == null) {
            return;
        }
        for (ClearingNewStep preStep : this.getStepList()) {
            if (!preStep.getStepNo().equals(step.getFrontStepNo())) continue;
            this.preBeginTime = LocalDateTime.parse(preStep.getBeginTime(), this.df);
            this.preEndTime = LocalDateTime.parse(preStep.getEndTime(), this.df);
            if (!this.preBeginTime.isBefore(LocalDate.now().atStartOfDay()) && !this.preEndTime.isBefore(LocalDate.now().atStartOfDay()) && preStep.getCurrStatus().getRaw().equals("2")) continue;
            throw new MException(-1, "\u524d\u7f6e\u6b65\u9aa4\u672a\u6267\u884c");
        }
        ExecuteSettleReq request = new ExecuteSettleReq();
        request.setOpUser(this.httpApi.getHttpOpUser());
        request.setStepNo(step.getStepNo());
        this.clearApi.clearRunStep(request);
    }

    @Override
    public void runClearing() throws MException {
        this.firstPush = true;
        ExecuteSettleReq request = new ExecuteSettleReq();
        request.setOpUser(this.httpApi.getHttpOpUser());
        request.setStepNo("000");
        this.clearApi.clearRunStep(request);
    }

    @Override
    public void queryStatus() throws MException {
        GetSettleSystemStatusReq request = new GetSettleSystemStatusReq();
        request.setOpUser(this.httpApi.getHttpOpUser());
        GetSettleSystemStatusResp resp = this.clearApi.clearQuerySysStatus(request);
        this.clearingInfo.update(resp.getSystemStatus());
    }

    @Override
    public ClearingNewInfo getStatus() {
        return this.clearingInfo;
    }

    @Override
    public BooleanProperty logOverridedProperty() {
        return this.logOverrided;
    }

    private void logOverrided() {
        this.logOverrided.set(!this.logOverrided.get());
    }

    @Override
    public void clearLogNum() {
        this.logNum.set(0);
    }

    @Override
    public boolean isFirstPush() {
        return this.firstPush;
    }

    @Override
    public void setFirstPush(boolean firstPush) {
        this.firstPush = firstPush;
    }
}

