/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.clearing.IClearingApi;
import cms.tmx.core.MException;
import cms.tmx.entity.ClearingInfo;
import cms.tmx.entity.ClearingStep;
import cms.tmx.entity.factory.ClearingInfoFactory;
import cms.tmx.entity.factory.ClearingStepFactory;
import cms.tmx.manage.IClearingModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ClearingModel
implements IClearingModel {
    @Inject
    private IClearingApi clearApi;
    @Inject
    private ClearingStepFactory factoryStep;
    @Inject
    private ClearingInfoFactory factoryInfo;
    private List<ClearingStep> stepList = new LinkedList<ClearingStep>();
    private ClearingInfo clearingInfo;
    private String curLog = "";
    private AtomicInteger logNum = new AtomicInteger(0);
    private BooleanProperty changed = new SimpleBooleanProperty(false);
    private BooleanProperty logChanged = new SimpleBooleanProperty(false);
    private BooleanProperty logOverrided = new SimpleBooleanProperty(false);

    @PostConstruct
    public void init() {
        this.clearingInfo = this.factoryInfo.create();
    }

    @Override
    public List<ClearingStep> getStepList() {
        return this.stepList;
    }

    @Override
    public void queryStepList() throws MException {
        LinkedList<ClearingStep> newList = new LinkedList<ClearingStep>();
        String resp = this.clearApi.clearQueryStepInfo();
        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        JsonArray jsonArray = jsonObject.getAsJsonArray("DATA");
        if (jsonArray == null || jsonArray.size() < 2) {
            return;
        }
        int i = 1;
        while (i < jsonArray.size()) {
            ClearingStep step = this.factoryStep.create();
            step.update((Object)jsonArray.get(i).getAsJsonArray());
            newList.add(step);
            ++i;
        }
        this.stepList = newList;
        this.changed();
    }

    private void changed() {
        this.changed.set(!this.changed.get());
    }

    public BooleanProperty changedProperty() {
        return this.changed;
    }

    private void logChanged() {
        this.logChanged.set(!this.logChanged.get());
    }

    @Override
    public BooleanProperty logChangedProperty() {
        return this.logChanged;
    }

    @Override
    public synchronized void queryLog() throws MException {
        String resp = this.clearApi.clearQueryLog(this.logNum.intValue());
        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        if (jsonObject.get("DATA") == null) {
            this.curLog = "";
            return;
        }
        JsonArray arrLog = jsonObject.get("DATA").getAsJsonArray();
        String strLog = "";
        String type = "";
        if (arrLog != null && arrLog.size() > 1) {
            type = arrLog.get(1).getAsString();
            int i = 2;
            while (i < arrLog.size()) {
                strLog = String.valueOf(strLog) + arrLog.get(i).getAsString();
                ++i;
            }
            this.logNum.set(this.logNum.intValue() + arrLog.size() - 2);
        }
        this.curLog = strLog;
        if (type.equals("delete")) {
            this.logNum.set(arrLog.size() - 2);
            this.logOverrided();
        } else {
            this.logChanged();
        }
    }

    @Override
    public String getLog() {
        return this.curLog;
    }

    @Override
    public void startRun(ClearingStep step) throws MException {
        int code;
        if (step == null) {
            return;
        }
        for (ClearingStep preStep : this.getStepList()) {
            if (!preStep.getStepNo().equals(step.getFrontStepNo()) || preStep.getCurrStatus().getRaw().equals("2")) continue;
            throw new MException(-1, "\u524d\u7f6e\u6b65\u9aa4\u672a\u6267\u884c");
        }
        String resp = this.clearApi.clearRunStep(step.getStepNo());
        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        JsonObject jsonPara = jsonObject.getAsJsonObject("PARA");
        if (jsonPara != null && (code = jsonPara.get("ret_code").getAsInt()) == -1) {
            throw new MException(code, jsonPara.get("ret_msg").getAsString());
        }
    }

    @Override
    public void runClearing() throws MException {
        int code;
        String resp = this.clearApi.clearRunStep("999");
        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        JsonObject jsonPara = jsonObject.getAsJsonObject("PARA");
        if (jsonPara != null && (code = jsonPara.get("ret_code").getAsInt()) == -1) {
            throw new MException(code, jsonPara.get("ret_msg").getAsString());
        }
    }

    @Override
    public void queryStatus() throws MException {
        String resp = this.clearApi.clearQuerySysStatus();
        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        JsonArray jsonArray = jsonObject.getAsJsonArray("DATA");
        if (jsonArray != null && jsonArray.size() > 1) {
            this.clearingInfo.update(jsonArray.get(1).getAsJsonArray());
        }
    }

    @Override
    public String getLastTradingDay() throws MException {
        this.queryStatus();
        return this.clearingInfo.getLastTradingDay();
    }

    @Override
    public ClearingInfo getStatus() {
        return this.clearingInfo;
    }

    @Override
    public BooleanProperty logOverridedProperty() {
        return this.logOverrided;
    }

    private void logOverrided() {
        this.logOverrided.set(!this.logOverrided.get());
    }

    @Override
    public void clearLogNum() {
        this.logNum.set(0);
    }
}

