/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBrokerApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.broker.PBroker;
import cms.tmx.entity.Broker;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IBrokerService;
import java.util.List;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BrokerMngServiceImpl
implements IBrokerService {
    @Inject
    private IBrokerApi api;
    @Inject
    private MObjFactory of;
    private ObservableList<Broker> listBroker = FxUtils.newList();

    @Override
    public ObservableList<Broker> queryBrokerList() throws MException {
        this.getBrokerListDeatil();
        return this.listBroker;
    }

    @Override
    public Broker getBroker(String id) {
        for (Broker broker : this.listBroker) {
            if (!broker.getCode().equals(id)) continue;
            return broker;
        }
        return null;
    }

    private List<Broker> getBrokerListDeatil() throws MException {
        this.listBroker.clear();
        List list = this.api.getBrokerList();
        list.forEach(item -> {
            Broker broker = (Broker)this.of.create(Broker.class);
            broker.update(item);
            this.listBroker.add((Object)broker);
        });
        return this.listBroker;
    }

    @Override
    public String addBroker(Broker broker) throws MException {
        PBroker.Broker.Builder builder = PBroker.Broker.newBuilder();
        builder.setName(broker.getName());
        builder.setFullName(broker.getFullName());
        builder.setBrokerId(broker.getCode());
        builder.addAllBusinessTypes((Iterable)broker.getTypes());
        String id = this.api.addBroker(builder.build());
        return id;
    }

    @Override
    public void updateBroker(Broker broker) throws MException {
        PBroker.Broker.Builder builder = PBroker.Broker.newBuilder();
        builder.setId(broker.getId());
        builder.setName(broker.getName());
        builder.setFullName(broker.getFullName());
        builder.setBrokerId(broker.getCode());
        builder.addAllBusinessTypes((Iterable)broker.getTypes());
        this.api.updateBroker(builder.build());
    }
}

