/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBlacklistApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.user.PUser;
import cms.tmx.entity.Blacklist;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.manage.IBlacklistService;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class BlacklistMngServiceImpl
implements IBlacklistService {
    @Inject
    private IBlacklistApi blackApi;
    @Inject
    private HttpBaseApi baseApi;

    @Override
    public void addBlacklist(Blacklist blacklist, int type) throws MException {
        PUser.BlackList.Builder builder = PUser.BlackList.newBuilder();
        builder.setIp(blacklist.getIp());
        builder.setSource(blacklist.getSource());
        builder.setDesc(blacklist.getDesc());
        builder.setStatus(blacklist.isStatus());
        this.blackApi.addBlacklist(builder.build(), type);
    }

    @Override
    public void updateBlacklist(Blacklist blacklist, int type) throws MException {
        PUser.BlackList.Builder builder = PUser.BlackList.newBuilder();
        builder.setIp(blacklist.getIp());
        builder.setSource(blacklist.getSource());
        builder.setDesc(blacklist.getDesc());
        builder.setUpdator(this.baseApi.getHttpOpUser().getUserId());
        this.blackApi.updateBlacklist(builder.build(), type);
    }

    @Override
    public List<Blacklist> queryBlacklistList(int type) throws MException {
        ArrayList<Blacklist> blacklist = new ArrayList<Blacklist>();
        List pBlackList = this.blackApi.getBlacklist(type);
        for (PUser.BlackList pBlack : pBlackList) {
            Blacklist black = new Blacklist();
            black.update((Object)pBlack);
            blacklist.add(black);
        }
        return blacklist;
    }

    @Override
    public void delBlacklist(Blacklist blacklist, int type) throws MException {
        PUser.BlackList.Builder builder = PUser.BlackList.newBuilder();
        builder.setIp(blacklist.getIp());
        builder.setSource(blacklist.getSource());
        builder.setDesc(blacklist.getDesc());
        this.blackApi.delBlacklist(builder.build(), type);
    }

    @Override
    public void enableBlacklist(Blacklist blacklist, int type, boolean status) throws MException {
        PUser.BlackList.Builder builder = PUser.BlackList.newBuilder();
        builder.setIp(blacklist.getIp());
        builder.setSource(blacklist.getSource());
        builder.setDesc(blacklist.getDesc());
        builder.setStatus(status);
        this.blackApi.enableBlacklist(builder.build(), type);
    }
}

