/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.assetgroup.PAssetgroupService;
import cms.tmx.entity.factory.AssetGrpFactory;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.manage.IAssetGrpService;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.manage.models.ProductMngServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AssetGrpMngServiceImpl
implements IAssetGrpService {
    private static final Logger logger = LogManager.getLogger(AssetGrpMngServiceImpl.class);
    @Inject
    private IAssetGrpApi assetGrpApi;
    @Inject
    private IBaseApi iba;
    @Inject
    private AssetGrpFactory af;
    @Inject
    private ProductMngServiceImpl productServiceImpl;
    @Inject
    private AccountMngServiceImpl accountServiceImpl;
    @Inject
    private PortfolioMngServiceImpl portfolioServiceImpl;
    private Map<String, String> assetMap = new HashMap<String, String>();
    private volatile boolean bInit = true;

    @Override
    public List<AssetGrp> getAssetGrpsByPartyId(String partyId, Boolean all) throws MException {
        LinkedList<AssetGrp> assetGrps = new LinkedList<AssetGrp>();
        if (partyId.isEmpty()) {
            return assetGrps;
        }
        List plist = this.assetGrpApi.getAssetGrps(partyId, all);
        plist.forEach(item -> {
            AssetGrp assetGrp = this.af.create();
            ArrayList nameList = new ArrayList();
            ArrayList idList = new ArrayList();
            item.getExtAccntIdList().forEach(extAccntId -> {
                if (extAccntId.isEmpty()) {
                    return;
                }
                try {
                    idList.add(extAccntId);
                    nameList.add(this.accountServiceImpl.getAccountFromCache((String)extAccntId).getName());
                }
                catch (MException | Exception e) {
                    logger.error("\u83b7\u53d6\u7f13\u5b58\u8d26\u53f7\u540d\u79f0\u5931\u8d25" + e.getMessage(), e);
                }
            });
            item.getProductIdList().forEach(productId -> {
                if (productId.isEmpty()) {
                    return;
                }
                try {
                    idList.add(productId);
                    nameList.add(this.productServiceImpl.getProductDetailFromCache((String)productId).getName());
                }
                catch (MException | Exception e) {
                    logger.error("\u83b7\u53d6\u7f13\u5b58\u4ea7\u54c1\u540d\u79f0\u5931\u8d25" + e.getMessage(), e);
                }
            });
            item.getPortfolioIdList().forEach(portfolioId -> {
                if (portfolioId.isEmpty() || portfolioId == null) {
                    return;
                }
                try {
                    idList.add(portfolioId);
                    nameList.add(this.portfolioServiceImpl.getPortfolioFromCache((String)portfolioId).getName());
                }
                catch (MException | Exception e) {
                    logger.error("\u83b7\u53d6\u7f13\u5b58\u6295\u7ec4\u540d\u79f0\u5931\u8d25" + portfolioId + e.getMessage(), e);
                }
            });
            assetGrp.update(item);
            assetGrp.setAssetUnit(String.join((CharSequence)",", nameList));
            assetGrp.setAssetUnitId(String.join((CharSequence)",", idList));
            assetGrps.add(assetGrp);
        });
        return assetGrps;
    }

    public String getCacheAsset(String assetId) {
        if (this.bInit) {
            try {
                List<AssetGrp> list = this.getAssetGrpsByPartyId(this.iba.getPartyId(), true);
                list.forEach(item -> this.assetMap.put(item.getId(), item.getName()));
                this.bInit = false;
            }
            catch (MException e) {
                logger.error("\u67e5\u8d44\u4ea7\u7ec4\u51fa\u9519", (Throwable)e);
                return "";
            }
        }
        return this.assetMap.get(assetId);
    }

    @Override
    public String addAssetGrp(AssetGrp assetGrp) throws MException {
        PAssetgroupService.AssetGroup.Builder pBuilder = PAssetgroupService.AssetGroup.newBuilder();
        pBuilder.setAssetGroupName(assetGrp.getName());
        pBuilder.setPartyId(assetGrp.getPartyId());
        pBuilder.setStatus(true);
        pBuilder.setAssetTypeValue(Integer.parseInt(assetGrp.getType().getRaw()));
        pBuilder.setDesc(assetGrp.getDes());
        return this.assetGrpApi.addAssetGrp(pBuilder.build());
    }

    @Override
    public void updateAssetGrp(AssetGrp assetGrp) throws MException {
        PAssetgroupService.AssetGroup.Builder pBuilder = PAssetgroupService.AssetGroup.newBuilder();
        pBuilder.setAssetGroupId(assetGrp.getId());
        pBuilder.setAssetGroupName(assetGrp.getName());
        pBuilder.setPartyId(assetGrp.getPartyId());
        pBuilder.setStatus(true);
        pBuilder.setAssetTypeValue(Integer.parseInt(assetGrp.getType().getRaw()));
        pBuilder.setDesc(assetGrp.getDes());
        this.assetGrpApi.updateAssetGrp(pBuilder.build());
    }

    @Override
    public AssetGrp getAssetGrpById(String assetGrpId) throws MException {
        PAssetgroupService.AssetGroup pAssetGrp = this.assetGrpApi.getAssetGrpDetail(assetGrpId);
        AssetGrp assetGrp = this.af.create();
        assetGrp.update((Object)pAssetGrp);
        return assetGrp;
    }

    @Override
    public void delAssetGrp(String assetGrpId) throws MException {
        this.assetGrpApi.delAssetGrp(assetGrpId);
    }

    @Override
    public void enableAssetGrp(String assetGrpId, boolean enabled) throws MException {
        this.assetGrpApi.enableAssetGrp(assetGrpId, enabled);
    }

    @Override
    public void assignAccntToAssetGrp(AssetGrp assetGrp, List<String> accountIds) throws MException {
        PAssetgroupService.AssetGroup.Builder pBuilder = PAssetgroupService.AssetGroup.newBuilder();
        pBuilder.setAssetGroupId(assetGrp.getId());
        pBuilder.setAssetGroupName(assetGrp.getName());
        pBuilder.setPartyId(assetGrp.getPartyId());
        pBuilder.setStatus(assetGrp.isStatus());
        pBuilder.setAssetTypeValue(Integer.parseInt(assetGrp.getType().getRaw()));
        pBuilder.setDesc(assetGrp.getDes());
        pBuilder.setCreator(assetGrp.getCreator());
        pBuilder.setCreateTime(assetGrp.getCreateTime());
        pBuilder.addAllExtAccntId(accountIds);
        this.assetGrpApi.addAssets(pBuilder.build());
    }

    @Override
    public void assignProductToAssetGrp(AssetGrp assetGrp, List<String> productIds) throws MException {
        PAssetgroupService.AssetGroup.Builder pBuilder = PAssetgroupService.AssetGroup.newBuilder();
        pBuilder.setAssetGroupId(assetGrp.getId());
        pBuilder.setAssetGroupName(assetGrp.getName());
        pBuilder.setPartyId(assetGrp.getPartyId());
        pBuilder.setStatus(assetGrp.isStatus());
        pBuilder.setAssetTypeValue(Integer.parseInt(assetGrp.getType().getRaw()));
        pBuilder.setDesc(assetGrp.getDes());
        pBuilder.addAllProductId(productIds);
        this.assetGrpApi.addAssets(pBuilder.build());
    }

    @Override
    public void assignPortfolioToAssetGrp(AssetGrp assetGrp, List<String> portfolioIds) throws MException {
        PAssetgroupService.AssetGroup.Builder pBuilder = PAssetgroupService.AssetGroup.newBuilder();
        pBuilder.setAssetGroupId(assetGrp.getId());
        pBuilder.setAssetGroupName(assetGrp.getName());
        pBuilder.setPartyId(assetGrp.getPartyId());
        pBuilder.setStatus(assetGrp.isStatus());
        pBuilder.setAssetTypeValue(Integer.parseInt(assetGrp.getType().getRaw()));
        pBuilder.setDesc(assetGrp.getDes());
        pBuilder.addAllPortfolioId(portfolioIds);
        this.assetGrpApi.addAssets(pBuilder.build());
    }
}

