/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IAccountApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.utils.DesEncrypt;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.datatype.message.PMarketService;
import cms.tmx.datatype.proto.account.PExtAccnt;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Account;
import cms.tmx.entity.AccountChangeRecord;
import cms.tmx.entity.AccountStatus;
import cms.tmx.entity.CcsCommission;
import cms.tmx.entity.ExternalAsset;
import cms.tmx.entity.factory.AccountFactory;
import cms.tmx.entity.factory.AccountStatusFactory;
import cms.tmx.http.accnt.AccntLoginReq;
import cms.tmx.http.accnt.AccntLogoutReq;
import cms.tmx.http.accnt.AccountServiceApi;
import cms.tmx.http.accnt.MarketServiceApi;
import cms.tmx.http.accnt.dto.GetAccntSessionResp;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.query.marginxt.XtAccLoginResp;
import cms.tmx.http.query.marginxt.api.XtAccLoginServiceApi;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IAccountService;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AccountMngServiceImpl
extends MxModel
implements IAccountService {
    @Inject
    private IAccountApi api;
    @Inject
    private AccountServiceApi newAccApi;
    @Inject
    private XtAccLoginServiceApi xtAccApi;
    @Inject
    private MarketServiceApi newMarketApi;
    @Inject
    private MObjFactory of;
    @Inject
    private AccountFactory af;
    @Inject
    private AccountStatusFactory asf;
    @Inject
    protected MEventService es;
    @Inject
    private HttpBaseApi baseApi;
    private ObservableList<Account> listAccnt = FxUtils.newList();
    private Map<String, Account> cacheMap = new HashMap<String, Account>();
    private Map<String, String> cacheNameMap = new HashMap<String, String>();
    @Inject
    private ScheduledExecutorService sdExecutor;
    @Inject
    private MConfService cs;
    private static final int FULL_QUERY_INTERVAL = 20000;
    private static final int OPT_QUERY_TIME = 2000;
    private static final int PAGESIZE = 100;

    @PostConstruct
    private void init() {
        this.initQuery();
    }

    private void initQuery() {
        this.sdExecutor.scheduleAtFixedRate(() -> this.changed(), 0L, 20000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Account getAccountById(String accountId) throws MException {
        ArrayList<String> accountIdList = new ArrayList<String>();
        accountIdList.add(accountId);
        List accountList = this.api.getAccountList(accountIdList);
        if (accountList != null && accountList.size() > 0) {
            Account accnt = this.af.create();
            accnt.update(accountList.get(0));
            this.cacheMap.put(accountId, accnt);
            this.cacheNameMap.put(accnt.getInvestorId(), accnt.getName());
            return accnt;
        }
        return null;
    }

    @Override
    public Account getAccountFromCache(String accountId) throws MException {
        if (this.cacheMap.get(accountId) == null) {
            ArrayList<String> accountIdList = new ArrayList<String>();
            accountIdList.add(accountId);
            List accountList = this.api.getAccountList(accountIdList);
            if (accountList != null && accountList.size() > 0) {
                Account accnt = this.af.create();
                accnt.update(accountList.get(0));
                this.cacheMap.put(accountId, accnt);
            }
        }
        return this.cacheMap.get(accountId);
    }

    public String getAccountNameFromCache(String investorId) throws MException {
        if (this.cacheNameMap.get(investorId) == null) {
            return "";
        }
        return this.cacheNameMap.get(investorId);
    }

    @Override
    public ObservableList<Account> getAccountListByParty(String partyId, PCommon.AssignType type, PHierarchy.GetExtAccntIdsViaPartyReq.Option option) throws MException {
        ObservableList returnList = FxUtils.newList();
        List list = this.api.getAccountIdListByPartyId(partyId, type, option);
        returnList.addAll(this.getAccountList(list));
        return returnList;
    }

    @Override
    public String addAccount(Account account) throws MException {
        PExtAccnt.ExtAccnt.Builder pBuilder = PExtAccnt.ExtAccnt.newBuilder();
        pBuilder.setInvestorId(account.getInvestorId());
        pBuilder.setBrokerId(account.getBrokerId());
        pBuilder.setTradePlatformId(account.getTradePlatformId());
        pBuilder.setAccntName(account.getName());
        PCommon.CarryOver.Builder cBuilder = PCommon.CarryOver.newBuilder();
        cBuilder.setCarryTypeValue(account.getCarryCode());
        if (account.getCarryCode() == 3) {
            cBuilder.setCarryYears(Double.valueOf(account.getCarryYears()).doubleValue());
        }
        if (account.getCarryCode() != 1) {
            cBuilder.setFirstCarryDay(account.getCarryDay());
        }
        pBuilder.setCarryOver(cBuilder.build());
        pBuilder.setNeeqEnable(account.isNeeqEnable() ? 1 : -1);
        pBuilder.setOtcEnable(account.isOtcEnable() ? 1 : -1);
        pBuilder.setMultiCenterEnable(account.isMultiCenter() ? 1 : 0);
        pBuilder.setFileorderManualConfirmEnable(account.isFileOrderManualConfirmation() ? 0 : -1);
        if (account.isExternalAsset()) {
            pBuilder.setIsExternalAccnt(true);
            PExtAccnt.ExternalAccnt.Builder externalAcc = PExtAccnt.ExternalAccnt.newBuilder();
            String dataSource = account.getDataSource().getRaw();
            externalAcc.setDataSourceValue(Integer.parseInt(dataSource));
            if ("1".equals(dataSource)) {
                externalAcc.setAutoSyncConf(PExtAccnt.ExternalAccnt.AutoSyncConfig.AUTO_SYNC_DATA_CENTER);
            }
            externalAcc.setRelatedAccntId(account.getExternalAccnt());
            pBuilder.setExternalAccnt(externalAcc);
        } else {
            pBuilder.setIsExternalAccnt(false);
            String nonTraAsset = account.getNonTradableAsset().getRaw();
            if (!"0".equals(nonTraAsset)) {
                pBuilder.addNonTradableAssets(nonTraAsset);
            }
        }
        String decrypt = "";
        try {
            if (!StringUtils.isEmpty((String)account.getPwd())) {
                decrypt = DesEncrypt.encrypt((String)account.getPwd(), (String)"ficc2018");
            }
        }
        catch (Exception e) {
            this.logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        pBuilder.setPassword(decrypt);
        pBuilder.addAllSecExchange((Iterable)account.getSecExc());
        pBuilder.addAllCurrency((Iterable)account.getCurrency());
        String accountId = this.api.addAccount(pBuilder.build(), account.getPartyId());
        return accountId;
    }

    @Override
    public void updateAccount(Account account) throws MException {
        PExtAccnt.ExtAccnt.Builder builderAcc = PExtAccnt.ExtAccnt.newBuilder();
        builderAcc.setBrokerId(account.getBrokerId());
        builderAcc.setTradePlatformId(account.getTradePlatformId());
        builderAcc.setAccntId(account.getId());
        builderAcc.setInvestorId(account.getInvestorId());
        builderAcc.setAccntName(account.getName());
        builderAcc.setPassword(account.getPwd());
        builderAcc.addAllCurrency((Iterable)account.getCurrency());
        builderAcc.addAllSecExchange((Iterable)account.getSecExc());
        builderAcc.setNeeqEnable(account.isNeeqEnable() ? 1 : -1);
        builderAcc.setOtcEnable(account.isOtcEnable() ? 1 : -1);
        builderAcc.setFileorderManualConfirmEnable(account.isFileOrderManualConfirmation() ? 0 : -1);
        PCommon.CarryOver.Builder cBuilder = PCommon.CarryOver.newBuilder();
        cBuilder.setCarryTypeValue(account.getCarryCode());
        if (account.getCarryCode() == 3) {
            cBuilder.setCarryYears(Double.valueOf(account.getCarryYears()).doubleValue());
        }
        if (account.getCarryCode() != 1) {
            cBuilder.setFirstCarryDay(account.getCarryDay());
        }
        builderAcc.setCarryOver(cBuilder.build());
        if (account.isExternalAsset()) {
            builderAcc.setIsExternalAccnt(true);
            PExtAccnt.ExternalAccnt.Builder externalAcc = PExtAccnt.ExternalAccnt.newBuilder();
            String dataSource = account.getDataSource().getRaw();
            externalAcc.setDataSourceValue(Integer.parseInt(dataSource));
            if ("1".equals(dataSource)) {
                externalAcc.setAutoSyncConf(PExtAccnt.ExternalAccnt.AutoSyncConfig.AUTO_SYNC_DATA_CENTER);
            }
            externalAcc.setRelatedAccntId(account.getExternalAccnt());
            builderAcc.setExternalAccnt(externalAcc);
        } else {
            builderAcc.setIsExternalAccnt(false);
            String nonTraAsset = account.getNonTradableAsset().getRaw();
            if (!"0".equals(nonTraAsset)) {
                builderAcc.addNonTradableAssets(nonTraAsset);
            }
        }
        builderAcc.setExternalOrderFlags(account.isExternalOrderFlags() ? 0 : -1);
        this.api.updateAccount(builderAcc.build(), account.getPartyId());
    }

    @Override
    public int checkAccontPwd(String pwd, Account account) throws MException {
        String decrypt = "";
        try {
            decrypt = DesEncrypt.encrypt((String)pwd, (String)"ficc2018");
        }
        catch (Exception e) {
            this.logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        return this.api.checkAccontPwd(decrypt, account.getId());
    }

    @Override
    public int enableAccount(Boolean isEnable, String id) throws MException {
        return this.api.enableAccount(isEnable, id);
    }

    @Override
    public ObservableList<Account> getAccountListByPost(String postId) throws MException {
        List<String> list = new LinkedList<String>();
        if (!StringUtils.isEmpty((String)postId)) {
            list = this.api.getAccountIdListByPostId(postId);
        }
        return this.getAccountList(list);
    }

    @Override
    public ObservableList<Account> getAccountListByPostWithLoginStatus(String postId) throws MException {
        List<String> list = new LinkedList<String>();
        if (!StringUtils.isEmpty((String)postId)) {
            list = this.api.getAccountIdListByPostId(postId);
        }
        ObservableList<Account> accountList = this.getAccountList(list);
        this.queryLoginStatus(accountList);
        return accountList;
    }

    @Override
    public ObservableList<Account> getAccountListByProduct(List<String> productIds) throws MException {
        List<String> list = new LinkedList<String>();
        if (productIds.size() > 0) {
            list = this.api.getAccountIdListByProductId(productIds);
        }
        return this.getAccountList(list);
    }

    private ObservableList<Account> getAccountList(List<String> ids) throws MException {
        ObservableList list = FxUtils.newList();
        if (ids.size() > 0) {
            List accntList = this.api.getAccountList(ids);
            accntList.forEach(item -> {
                Account accnt = this.af.create();
                accnt.update(item);
                list.add((Object)accnt);
                if (this.cacheMap.get(accnt.getId()) == null) {
                    this.cacheMap.put(accnt.getId(), accnt);
                }
                if (this.cacheNameMap.get(accnt.getInvestorId()) == null) {
                    this.cacheNameMap.put(accnt.getInvestorId(), accnt.getName());
                }
            });
        }
        return list;
    }

    @Override
    public void loginAccntReq(Account account, String marketGrp) throws MException {
        AccntLoginReq req;
        if ("99999-04-01".equals(account.getTradePlatformId()) || "55555-04-01".equals(account.getTradePlatformId())) {
            return;
        }
        if (this.cs.getValueAsBool("newframe", false) && Account.isNewFrame((Account)account)) {
            AccntLoginReq req2 = new AccntLoginReq();
            req2.setOpUser(this.baseApi.getHttpOpUser());
            req2.setAccntId(account.getId());
            req2.setInvestorId(account.getInvestorId());
            req2.setPassword(account.getPwd());
            OpStatus status = this.newMarketApi.loginAccnt(req2);
            if (status.getStatus() != 1) {
                throw new MException(404, "\u767b\u5f55\u5931\u8d25");
            }
            return;
        }
        if (account.isNeeqEnable()) {
            req = new AccntLoginReq();
            req.setOpUser(this.baseApi.getHttpOpUser());
            req.setAccntId(account.getId());
            req.setInvestorId(account.getInvestorId());
            req.setPassword(account.getPwd());
            try {
                this.newMarketApi.loginAccnt(req);
            }
            catch (MException | Exception e) {
                this.logger.error("\u65b0\u4e09\u677f\u8d26\u53f7\u767b\u5f55\u65b0\u6846\u67b6\u51fa\u9519", e);
            }
        }
        if (account.isOtcEnable()) {
            req = new AccntLoginReq();
            req.setOpUser(this.baseApi.getHttpOpUser());
            req.setAccntId(account.getId());
            req.setInvestorId(account.getInvestorId());
            req.setPassword(account.getPwd());
            req.setTradePlatformId(account.getTradePlatformId());
            try {
                this.newMarketApi.otcLoginAccnt(req);
            }
            catch (MException | Exception e) {
                this.logger.error("\u65b0\u4e09\u677f\u8d26\u53f7\u767b\u5f55\u65b0\u6846\u67b6\u51fa\u9519", e);
            }
        }
        PExtAccnt.ExtAccnt.Builder builderAcc = PExtAccnt.ExtAccnt.newBuilder();
        builderAcc.setBrokerId(account.getBrokerId());
        builderAcc.setAccntId(account.getId());
        builderAcc.setInvestorId(account.getInvestorId());
        builderAcc.setAccntName(account.getName());
        builderAcc.setPassword(account.getPwd());
        builderAcc.setTradePlatformId(account.getTradePlatformId());
        if (!account.getStatus().getRaw().isEmpty()) {
            builderAcc.setStatus(Integer.parseInt(account.getStatus().getRaw()));
        }
        builderAcc.addAllCurrency((Iterable)account.getCurrency());
        builderAcc.addAllSecExchange((Iterable)account.getSecExc());
        PExtAccnt.ExtAccnt extAccnt = builderAcc.build();
        this.api.loginAccntReq(extAccnt, marketGrp);
        if ("FUTURES".equals(marketGrp)) {
            try {
                this.api.loginAccntRefDataReq(extAccnt, marketGrp);
            }
            catch (MException e) {
                this.logger.error("\u671f\u8d27\u8d26\u53f7\u9759\u6001\u884c\u60c5\u767b\u5f55\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
    }

    @Override
    public void logOutAccntReq(Account account, String marketGrp) throws MException {
        if ("99999-04-01".equals(account.getTradePlatformId()) || "55555-04-01".equals(account.getTradePlatformId())) {
            return;
        }
        AccntLogoutReq req = new AccntLogoutReq();
        if (this.cs.getValueAsBool("newframe", false) && Account.isNewFrame((Account)account)) {
            req.setOpUser(this.baseApi.getHttpOpUser());
            req.setAccntId(account.getId());
            req.setInvestorId(account.getInvestorId());
            OpStatus status = this.newMarketApi.logoutAccnt(req);
            if (status.getStatus() != 1) {
                throw new MException(404, "\u8c03\u7528\u65b0\u6846\u67b6\u767b\u51fa\u5931\u8d25");
            }
        } else {
            if (account.isNeeqEnable()) {
                try {
                    req.setOpUser(this.baseApi.getHttpOpUser());
                    req.setAccntId(account.getId());
                    req.setInvestorId(account.getInvestorId());
                    this.newMarketApi.logoutAccnt(req);
                }
                catch (MException | Exception e) {
                    this.logger.error("\u8c03\u7528\u65b0\u6846\u67b6\u767b\u51fa\u5931\u8d25", e);
                }
            }
            if (account.isOtcEnable()) {
                try {
                    req.setOpUser(this.baseApi.getHttpOpUser());
                    req.setAccntId(account.getId());
                    req.setInvestorId(account.getInvestorId());
                    req.setTradePlatformId(account.getTradePlatformId());
                    this.newMarketApi.otcLogoutAccnt(req);
                }
                catch (MException | Exception e) {
                    this.logger.error("\u8c03\u7528\u65b0\u6846\u67b6\u767b\u51fa\u5931\u8d25", e);
                }
            }
            PExtAccnt.ExtAccnt.Builder builderAcc = PExtAccnt.ExtAccnt.newBuilder();
            builderAcc.setBrokerId(account.getBrokerId());
            builderAcc.setAccntId(account.getId());
            builderAcc.setInvestorId(account.getInvestorId());
            builderAcc.setAccntName(account.getName());
            builderAcc.setPassword(account.getPwd());
            builderAcc.setTradePlatformId(account.getTradePlatformId());
            builderAcc.setStatus(Integer.parseInt(account.getStatus().getRaw()));
            builderAcc.addAllCurrency((Iterable)account.getCurrency());
            builderAcc.addAllSecExchange((Iterable)account.getSecExc());
            this.api.logoutAccntReq(builderAcc.build(), marketGrp);
        }
    }

    @Override
    public ObservableList<Account> getAccountList() {
        return this.listAccnt;
    }

    public void setAccountList() {
        this.listAccnt.clear();
    }

    public ObservableList<AccountStatus> getLoginStatusByIds(List<String> accntList, String marketGrp) throws MException {
        int size = accntList.size();
        ArrayList<String> listSub = new ArrayList<String>();
        ObservableList listStatus = FxUtils.newList();
        if (size > 0 && size <= 100) {
            return this.getLoginStatus(marketGrp, accntList);
        }
        if (size > 100) {
            size = size % 100 > 0 ? size / 100 + 1 : (size /= 100);
            int y = 0;
            while (y < size) {
                if (accntList.size() < 100) {
                    listStatus.addAll(this.getLoginStatus(marketGrp, accntList));
                } else {
                    listSub.clear();
                    listSub.addAll(accntList.subList(0, 100));
                    listStatus.addAll(this.getLoginStatus(marketGrp, listSub));
                    accntList.removeAll(listSub);
                }
                ++y;
            }
            return listStatus;
        }
        return null;
    }

    public ObservableList<AccountStatus> getNewFrameLoginStatusByIds(List<String> accntIds) throws MException {
        ObservableList list = FxUtils.newList();
        if (accntIds.isEmpty()) {
            return list;
        }
        GetAccntSessionResp accountLoginStatus = this.newMarketApi.getAccountLoginStatus(accntIds);
        if (accountLoginStatus.getAccntSession() != null) {
            accountLoginStatus.getAccntSession().stream().forEach(item -> {
                AccountStatus accnt = this.asf.create();
                accnt.update(item);
                list.add((Object)accnt);
            });
        }
        return list;
    }

    public ObservableList<AccountStatus> getXtLoginStatusByIds(List<String> accntIds) throws MException {
        ObservableList list = FxUtils.newList();
        if (accntIds.isEmpty()) {
            return list;
        }
        XtAccLoginResp accountLoginStatus = this.xtAccApi.getAccLoginStatus(accntIds);
        if (accountLoginStatus != null && accountLoginStatus.getResp() != null) {
            accountLoginStatus.getResp().stream().forEach(item -> {
                AccountStatus accnt = this.asf.create();
                accnt.update(item);
                list.add((Object)accnt);
            });
        }
        return list;
    }

    public ObservableList<AccountStatus> getOtcLoginStatusByIds(List<String> accntIds) throws MException {
        ObservableList list = FxUtils.newList();
        if (accntIds.isEmpty()) {
            return list;
        }
        GetAccntSessionResp accountLoginStatus = this.newMarketApi.getOtcAccountLoginStatus(accntIds);
        if (accountLoginStatus.getAccntSession() != null) {
            accountLoginStatus.getAccntSession().stream().forEach(item -> {
                AccountStatus accnt = this.asf.create();
                accnt.update(item);
                list.add((Object)accnt);
            });
        }
        return list;
    }

    @Override
    public ObservableList<AccountStatus> getLoginStatus(String marketGrp, List<String> investorIds) throws MException {
        ObservableList list = FxUtils.newList();
        if (investorIds.isEmpty()) {
            return list;
        }
        List accntList = this.api.getLoginStatus(marketGrp, investorIds);
        accntList.forEach(item -> {
            AccountStatus accnt = this.asf.create();
            accnt.update(item);
            list.add((Object)accnt);
        });
        return list;
    }

    @Override
    public List<CcsCommission> getCommissions(List<CcsCommission> list, String market_grp) throws MException {
        LinkedList<PMarketService.Commission> linkedList = new LinkedList<PMarketService.Commission>();
        for (CcsCommission ccs : list) {
            PMarketService.Commission.Builder buider = PMarketService.Commission.newBuilder();
            buider.setExtAccntId(ccs.getExt_accnt_id());
            buider.setMarketGrp(market_grp);
            PMarketService.Commission build = buider.build();
            linkedList.add(build);
        }
        PMarketService.Commissions.Builder b = PMarketService.Commissions.newBuilder();
        b.addAllCommission(linkedList);
        b.setMarketGrp(market_grp);
        List commissions = this.api.getCommissions(b.build());
        LinkedList<CcsCommission> l = new LinkedList<CcsCommission>();
        for (PMarketService.Commission com : commissions) {
            CcsCommission c = (CcsCommission)this.of.create(CcsCommission.class);
            c.update((Object)com);
            l.add(0, c);
        }
        Collections.sort(l, (o1, o2) -> {
            SimpleDateFormat sdf;
            block4: {
                try {
                    sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
                    if (sdf.parse(o1.getTime()).getTime() <= sdf.parse(o2.getTime()).getTime()) break block4;
                    return 1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
            if (sdf.parse(o1.getTime()).getTime() < sdf.parse(o2.getTime()).getTime()) {
                return -1;
            }
            return 0;
        });
        return l;
    }

    @Override
    public void addCommissions(List<CcsCommission> list, String market_grp) throws MException {
        LinkedList<PMarketService.Commission> linkedList = new LinkedList<PMarketService.Commission>();
        for (CcsCommission ccs : list) {
            PMarketService.Commission.Builder buider = PMarketService.Commission.newBuilder();
            buider.setExtAccntId(ccs.getExt_accnt_id());
            buider.setMarketGrp(market_grp);
            buider.setType(ccs.getType());
            PCcsExtra.CcsCommissionExtra message = null;
            PCcsExtra.CcsCommissionExtra.Builder buider1 = PCcsExtra.CcsCommissionExtra.newBuilder();
            buider1.setCurrency(ccs.getCurrency());
            buider1.setBuyCommissionRate(ccs.getBuy_commission_rate());
            buider1.setSellCommissionRate(ccs.getSell_commission_rate());
            buider1.setMinBuyCommission(ccs.getMin_buy_commission());
            buider1.setMinSellCommission(ccs.getMin_buy_commission());
            buider1.setBuyTransferFeeRate(ccs.getBuy_transfer_fee_rate());
            buider1.setSellTransferFeeRate(ccs.getBuy_transfer_fee_rate());
            buider1.setMinBuyTransferFee(ccs.getMin_buy_transfer_fee());
            buider1.setMinSellTransferFee(ccs.getMin_buy_transfer_fee());
            buider1.setBuyStampTaxRate(ccs.getBuy_stamp_tax_rate());
            buider1.setSellStampTaxRate(ccs.getSell_stamp_tax_rate());
            message = buider1.build();
            buider.setObject(Any.pack((Message)message));
            PMarketService.Commission build = buider.build();
            linkedList.add(build);
        }
        PMarketService.Commissions.Builder b = PMarketService.Commissions.newBuilder();
        b.addAllCommission(linkedList);
        b.setMarketGrp(market_grp);
        this.api.addCommissions(b.build());
    }

    @Override
    public void delCommissions(List<CcsCommission> list, String market_grp) throws MException {
        LinkedList<PMarketService.Commission> linkedList = new LinkedList<PMarketService.Commission>();
        for (CcsCommission ccs : list) {
            PMarketService.Commission.Builder buider = PMarketService.Commission.newBuilder();
            buider.setExtAccntId(ccs.getExt_accnt_id());
            buider.setMarketGrp(market_grp);
            buider.setType(ccs.getType());
            PMarketService.Commission build = buider.build();
            linkedList.add(build);
        }
        PMarketService.Commissions.Builder b = PMarketService.Commissions.newBuilder();
        b.addAllCommission(linkedList);
        b.setMarketGrp(market_grp);
        this.api.delCommissions(b.build());
    }

    public void queryLoginStatus(ObservableList<Account> filterList) throws MException {
        ArrayList<AccountStatus> logStatusList = new ArrayList<AccountStatus>();
        ObservableList<AccountStatus> ccsList = null;
        ObservableList<AccountStatus> ctpList = null;
        ObservableList<AccountStatus> marginList = FxUtils.newList();
        ObservableList<AccountStatus> otcList = FxUtils.newList();
        ObservableList<AccountStatus> xtMarginList = FxUtils.newList();
        ccsList = this.getLoginStatusByIds(this.getFilterList(filterList, "CCS"), "CCS");
        ctpList = this.getLoginStatusByIds(this.getFilterList(filterList, "FUTURES"), "FUTURES");
        if (this.cs.getValueAsBool("newframe", false)) {
            try {
                marginList = this.getNewFrameLoginStatusByIds(this.getNewFrameFilterList(filterList));
                otcList = this.getOtcLoginStatusByIds(this.getOtcFilterList(filterList));
            }
            catch (MException | Exception e) {
                this.logger.error("\u65b0\u6846\u67b6\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7\u767b\u5f55\u72b6\u6001\u5931\u8d25", e);
            }
            try {
                xtMarginList = this.getXtLoginStatusByIds(this.getXtFilterList(filterList));
            }
            catch (MException | Exception e) {
                this.logger.error("xt\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7\u767b\u5f55\u72b6\u6001\u5931\u8d25", e);
            }
        }
        if (ccsList != null) {
            logStatusList.addAll((Collection<AccountStatus>)ccsList);
        }
        if (ctpList != null) {
            logStatusList.addAll((Collection<AccountStatus>)ctpList);
        }
        if (logStatusList.isEmpty()) {
            return;
        }
        for (Account accnt : filterList) {
            AccountStatus otcStatus;
            AccountStatus status = this.getOneStatus(accnt, (List<AccountStatus>)logStatusList, (List<AccountStatus>)marginList, (List<AccountStatus>)xtMarginList);
            accnt.getFlag().setRaw(status == null ? "" : status.getStatus().getRaw());
            if (status != null) {
                accnt.setLoginErrorInfo(status.getLoginErrorInfo() == null ? "" : status.getLoginErrorInfo());
                if ("99999-02-02".equals(accnt.getTradePlatformId()) || "99999-02-03".equals(accnt.getTradePlatformId())) {
                    accnt.setLoginErrorInfo(status.getNewLoginErrorInfo() == null ? "" : status.getNewLoginErrorInfo());
                }
            }
            if (accnt.isNeeqEnable()) {
                AccountStatus neeqStatus = this.getNeeqStatus(accnt, (List<AccountStatus>)marginList);
                if (neeqStatus == null) continue;
                accnt.getNeeqFlag().setRaw(neeqStatus == null ? "" : neeqStatus.getStatus().getRaw());
                if (neeqStatus != null) {
                    accnt.setNewLoginErrorInfo(neeqStatus.getNewLoginErrorInfo() == null ? "" : neeqStatus.getNewLoginErrorInfo());
                }
            }
            if (!accnt.isOtcEnable() || (otcStatus = this.getNeeqStatus(accnt, (List<AccountStatus>)otcList)) == null) continue;
            accnt.getOtcFlag().setRaw(otcStatus == null ? "" : otcStatus.getStatus().getRaw());
            if (otcStatus == null) continue;
            accnt.setOtcLoginErrorInfo(otcStatus.getNewLoginErrorInfo() == null ? "" : otcStatus.getNewLoginErrorInfo());
        }
    }

    private AccountStatus getNeeqStatus(Account accnt, List<AccountStatus> marginList) {
        for (AccountStatus accntStatus : marginList) {
            if (accntStatus.getInvestorId() == null || !accntStatus.getInvestorId().equals(accnt.getInvestorId())) continue;
            if (StringUtils.isEmpty((String)accntStatus.getBrokerId())) {
                return accntStatus;
            }
            if (!accnt.getBrokerId().equals(accntStatus.getBrokerId())) continue;
            return accntStatus;
        }
        return null;
    }

    private AccountStatus getOneStatus(Account accnt, List<AccountStatus> logStatusList, List<AccountStatus> marginList, List<AccountStatus> xtMarginList) {
        if ("99999-02-01".equals(accnt.getTradePlatformId())) {
            for (AccountStatus accntStatus : xtMarginList) {
                if (accntStatus.getInvestorId() == null || !accntStatus.getInvestorId().equals(accnt.getInvestorId())) continue;
                return accntStatus;
            }
        } else if ("99999-02-02".equals(accnt.getTradePlatformId())) {
            for (AccountStatus accntStatus : marginList) {
                if (accntStatus.getInvestorId() == null || !accntStatus.getInvestorId().equals(accnt.getInvestorId())) continue;
                if (StringUtils.isEmpty((String)accntStatus.getBrokerId())) {
                    return accntStatus;
                }
                if (!accnt.getBrokerId().equals(accntStatus.getBrokerId())) continue;
                return accntStatus;
            }
        } else if ("99999-02-03".equals(accnt.getTradePlatformId())) {
            for (AccountStatus accntStatus : marginList) {
                if (accntStatus.getInvestorId() == null || !accntStatus.getInvestorId().equals(accnt.getInvestorId())) continue;
                return accntStatus;
            }
        } else {
            for (AccountStatus accntStatus : logStatusList) {
                if (!accntStatus.getInvestorId().equals(accnt.getInvestorId())) continue;
                if (StringUtils.isEmpty((String)accntStatus.getBrokerId())) {
                    return accntStatus;
                }
                if (!accnt.getBrokerId().equals(accntStatus.getBrokerId())) continue;
                return accntStatus;
            }
        }
        return null;
    }

    private List<String> getFilterList(ObservableList<Account> filterList, String marketGrp) {
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList list = new ArrayList();
        list.addAll(filterList.stream().filter(each -> MarketUtils.findMarketGrp((List)each.getSecExc()).equals(marketGrp)).collect(Collectors.toList()));
        for (Account accnt : list) {
            strList.add(accnt.getInvestorId());
        }
        return strList;
    }

    private List<String> getNewFrameFilterList(ObservableList<Account> filterList) {
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList list = new ArrayList();
        list.addAll(filterList.stream().filter(each -> "99999-04-01".equals(each.getTradePlatformId()) || "66668-01-01".equals(each.getTradePlatformId()) || "99988-01-01".equals(each.getTradePlatformId()) || "99999-02-02".equals(each.getTradePlatformId()) || "99999-02-03".equals(each.getTradePlatformId()) || "55555-04-01".equals(each.getTradePlatformId()) || each.isNeeqEnable()).collect(Collectors.toList()));
        for (Account accnt : list) {
            strList.add(accnt.getId());
        }
        return strList;
    }

    private List<String> getXtFilterList(ObservableList<Account> filterList) {
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList list = new ArrayList();
        list.addAll(filterList.stream().filter(each -> "99999-02-01".equals(each.getTradePlatformId())).collect(Collectors.toList()));
        for (Account accnt : list) {
            strList.add(accnt.getInvestorId());
        }
        return strList;
    }

    private List<String> getOtcFilterList(ObservableList<Account> filterList) {
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList list = new ArrayList();
        list.addAll(filterList.stream().filter(each -> "99999-01-01".equals(each.getTradePlatformId()) && each.isOtcEnable()).collect(Collectors.toList()));
        for (Account accnt : list) {
            strList.add(accnt.getId());
        }
        return strList;
    }

    public void queryAfterOpt() {
        this.sdExecutor.schedule(() -> this.changed(), 2000L, TimeUnit.MILLISECONDS);
    }

    public void resetAccontPwd(Account account, String marketGrp, String oldPwd, String newPwd) throws MException {
        PMainTenance.ModifyPasswdRequest.Builder accBuilder = PMainTenance.ModifyPasswdRequest.newBuilder();
        accBuilder.setInvestorId(account.getInvestorId());
        accBuilder.setMarketGrp(marketGrp);
        accBuilder.setBrokerId(account.getBrokerId());
        String decryptOld = "";
        String decryptNew = "";
        try {
            decryptOld = DesEncrypt.encrypt((String)oldPwd, (String)"ficc2018");
            decryptNew = DesEncrypt.encrypt((String)newPwd, (String)"ficc2018");
        }
        catch (Exception e) {
            this.logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        accBuilder.setOldPassword(decryptOld);
        accBuilder.setNewPassword(decryptNew);
        this.api.resetAccontPwd(accBuilder);
    }

    public ObservableList<ExternalAsset> getExternalAccounts() throws MException {
        List listResp = this.api.getExternalAssets(PHierarchy.ExtAssetType.EXT_ASSET_ACCOUNT);
        ObservableList list = FxUtils.newList();
        listResp.forEach(asset -> {
            ExternalAsset exter = new ExternalAsset();
            exter.update(asset);
            list.add((Object)exter);
        });
        list.sort((e1, e2) -> Integer.parseInt(e1.getId()) - Integer.parseInt(e2.getId()));
        return list;
    }

    @Override
    public void alertAccountTradeElement(Account account) throws MException {
        PExtAccnt.ExtAccnt.Builder builderAcc = PExtAccnt.ExtAccnt.newBuilder();
        builderAcc.setTradePlatformId(account.getTradePlatformId());
        builderAcc.setAccntId(account.getId());
        builderAcc.addAllSecExchange((Iterable)account.getSecExc());
        PExtAccnt.AlterAccntTradeElementsReq.Builder builder = PExtAccnt.AlterAccntTradeElementsReq.newBuilder();
        builder.setExtAccnt(builderAcc.build());
        this.api.alertAccount(builder);
    }

    @Override
    public ObservableList<AccountChangeRecord> getAccountChangeHistory(String accntId) throws MException {
        PExtAccnt.GetAlterAccntTradeElementsReq.Builder builder = PExtAccnt.GetAlterAccntTradeElementsReq.newBuilder();
        builder.addAccntId(accntId);
        PExtAccnt.GetAlterAccntTradeElementsResp resp = this.api.getAlterRecord(builder);
        ObservableList list = FxUtils.newList();
        if (resp.getAlterRecordsList().isEmpty()) {
            return list;
        }
        PExtAccnt.AlterRecords alterRecords = (PExtAccnt.AlterRecords)resp.getAlterRecordsList().get(0);
        for (PExtAccnt.OneAlterRecord accountChangeRecord : alterRecords.getRecordList()) {
            AccountChangeRecord record = new AccountChangeRecord();
            record.update((Object)accountChangeRecord);
            list.add((Object)record);
        }
        return list;
    }
}

