/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IAccountApi;
import cms.tmx.api.mng.IAccountGrpApi;
import cms.tmx.api.trade.IRiskApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.account.PExtAccnt;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.unify_risk.PRiskConstants;
import cms.tmx.datatype.proto.unify_risk.PUnifyRiskService;
import cms.tmx.entity.Account;
import cms.tmx.entity.AccountGroup;
import cms.tmx.entity.SecClassify;
import cms.tmx.entity.factory.AccountFactory;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IAccountGrpService;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class AccountGrpMngServiceImpl
implements IAccountGrpService {
    @Inject
    private IAccountGrpApi api;
    @Inject
    private IAccountApi ai;
    @Inject
    private MObjFactory of;
    @Inject
    private AccountFactory af;
    @Inject
    private IRiskApi riskApi;

    @Override
    public List<AccountGroup> getAccountGrpListByParty(String partyId) throws MException {
        LinkedList<AccountGroup> listAccntGrp = new LinkedList<AccountGroup>();
        List accntGrpDetails = this.api.getAccountGrpList(this.api.getAccountGrpByPartyId(partyId));
        for (PExtAccnt.AccountGroupDetails a : accntGrpDetails) {
            AccountGroup accntGrp = (AccountGroup)this.of.create(AccountGroup.class);
            accntGrp.update((Object)a);
            listAccntGrp.add(accntGrp);
        }
        return listAccntGrp;
    }

    @Override
    public String addAccountGrp(AccountGroup accntGrp) throws MException {
        PExtAccnt.AccountGroup.Builder builder = PExtAccnt.AccountGroup.newBuilder();
        builder.setName(accntGrp.getName());
        builder.setGroupType(Integer.valueOf(accntGrp.getGrpType().getRaw()).intValue());
        PExtAccnt.ClassDetails.Builder b = PExtAccnt.ClassDetails.newBuilder();
        if (accntGrp.isClassifyType()) {
            builder.setClassifyType(2);
            b.setClassifyId(accntGrp.getClassifyId());
            builder.addClassDetails(b.build());
        } else {
            builder.setClassifyType(0);
        }
        return this.api.addAccountGrp(builder.build(), accntGrp.getPartyId());
    }

    @Override
    public int deleteAccountGrp(String accntGrpId) throws MException {
        this.api.deleteAccountGrp(accntGrpId);
        return 1;
    }

    @Override
    public int updateAccountGrp(AccountGroup accntGrp) throws MException {
        PExtAccnt.AccountGroup.Builder builder = PExtAccnt.AccountGroup.newBuilder();
        builder.setId(accntGrp.getId());
        builder.setName(accntGrp.getName());
        builder.setGroupType(Integer.valueOf(accntGrp.getGrpType().getRaw()).intValue());
        PExtAccnt.ClassDetails.Builder b = PExtAccnt.ClassDetails.newBuilder();
        if (accntGrp.isClassifyType()) {
            builder.setClassifyType(2);
            b.setClassifyId(accntGrp.getClassifyId());
            builder.addClassDetails(b.build());
        } else {
            builder.setClassifyType(0);
        }
        this.api.updateAccountGrp(builder.build());
        return 1;
    }

    @Override
    public List<Account> GetAccountGroupDetails(String grpId) throws MException {
        List accntList = this.ai.getAccountList(this.api.GetAccountGroupDetails(grpId));
        ObservableList list = FxUtils.newList();
        accntList.forEach(item -> {
            Account accnt = this.af.create();
            accnt.update(item);
            list.add((Object)accnt);
        });
        return list;
    }

    @Override
    public void AssignAccountsToGroup(String grpId, String grpType, Collection<Account> account, PCommon.Operation action) throws MException {
        LinkedList details = new LinkedList();
        account.forEach(item -> {
            PExtAccnt.AssignedAccountDetails.Builder b = PExtAccnt.AssignedAccountDetails.newBuilder();
            b.setAccountId(item.getId());
            b.setInvestorId(item.getInvestorId());
            details.add(b.build());
        });
        int type = 1;
        if (!grpType.isEmpty()) {
            type = Integer.valueOf(grpType);
        }
        this.api.AssignAccountsToGroup(grpId, type, details, action);
    }

    public List<SecClassify> getSecClassifyList(List<String> partyIds, PRiskConstants.ClassifyType type) throws MException {
        if (partyIds.isEmpty()) {
            return new LinkedList<SecClassify>();
        }
        LinkedList<SecClassify> list = new LinkedList<SecClassify>();
        PBase.Page.Builder builder = PBase.Page.newBuilder();
        builder.setPageSize(150);
        builder.setStartRow(1);
        this.querySecClassifyByPage(partyIds, list, builder.build(), type);
        return list;
    }

    public List<SecClassify> getSecClassifyList(List<String> partyIds) throws MException {
        if (partyIds.isEmpty()) {
            return new LinkedList<SecClassify>();
        }
        LinkedList<SecClassify> list = new LinkedList<SecClassify>();
        PBase.Page.Builder builder = PBase.Page.newBuilder();
        builder.setPageSize(150);
        builder.setStartRow(1);
        this.querySecClassifyByPage(partyIds, list, builder.build(), null);
        return list;
    }

    private void querySecClassifyByPage(List<String> partyIds, List<SecClassify> list, PBase.Page defPage, PRiskConstants.ClassifyType type) throws MException {
        PUnifyRiskService.SecClassifyListResp resp = this.riskApi.getRiskSecClassList("", partyIds, defPage, type);
        for (PUnifyRiskService.SecClassify item : resp.getSecClassifyList()) {
            SecClassify obj = new SecClassify();
            obj.update((Object)item);
            list.add(obj);
        }
        if (resp.getPage().getPageSize() == 0) {
            return;
        }
        if (resp.getPage().getTotalRow() > defPage.getStartRow() + resp.getPage().getPageSize() - 1) {
            PBase.Page.Builder pageBuilder = defPage.toBuilder();
            pageBuilder.setStartRow(defPage.getStartRow() + resp.getPage().getPageSize());
            this.querySecClassifyByPage(partyIds, list, pageBuilder.build(), type);
        }
    }
}

