/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import cms.tmx.api.mng.IUserApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.user.PUser;
import cms.tmx.javafx.MxNode;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UserRegisterModel {
    private static final Logger logger = LogManager.getLogger(UserRegisterModel.class);
    private String product = "";
    private MxNode instMode;
    private int userMode;
    private String trader = "";
    private String adviser = "";
    private String manager = "";
    private String admin = "";
    private String risk = "";
    private String phone = "";
    private static final int SINGLE_USER = 1;
    private static final int MULTI_USER = 2;
    public static final int INST_MODEL_SINGLE_TRADER = 1;
    public static final int INST_MODEL_MANAGER_TRADER = 2;
    public static final int INST_MODEL_ADVISER_TRADER = 3;
    public static final int INST_MODEL_ADIVSER_MANAGER = 4;
    @Inject
    private IUserApi userApi;

    public void userRegister() throws MException {
        PUser.UserRegisterReq.Builder req = PUser.UserRegisterReq.newBuilder();
        req.setProductName(this.product);
        int instModeValue = Integer.parseInt(this.instMode.getRaw());
        req.setInstModeValue(instModeValue);
        req.setUserModeValue(this.userMode);
        req.setAdministrator(this.admin);
        req.setTelephone(this.phone);
        if (this.userMode == 2) {
            switch (instModeValue) {
                case 1: {
                    req.setSingleTrader(this.trader);
                    break;
                }
                case 2: {
                    req.setTrader(this.trader);
                    req.setInvestManager(this.manager);
                    req.setRiskController(this.risk);
                    break;
                }
                case 3: {
                    req.setTrader(this.trader);
                    req.setInvestAdvisor(this.adviser);
                    req.setRiskController(this.risk);
                    break;
                }
                case 4: {
                    req.setTrader(this.trader);
                    req.setInvestAdvisor(this.adviser);
                    req.setInvestManager(this.manager);
                    req.setRiskController(this.risk);
                }
            }
        }
        String id = this.userApi.userRegister(req.build());
        logger.info("user register succeed " + id);
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public MxNode getInstMode() {
        return this.instMode;
    }

    public void setInstMode(MxNode instMode) {
        this.instMode = instMode;
    }

    public int getUserMode() {
        return this.userMode;
    }

    public void setUserMode(boolean single) {
        this.userMode = single ? 1 : 2;
    }

    public String getTrader() {
        return this.trader;
    }

    public void setTrader(String trader) {
        this.trader = trader;
    }

    public String getAdviser() {
        return this.adviser;
    }

    public void setAdviser(String adviser) {
        this.adviser = adviser;
    }

    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public String getAdmin() {
        return this.admin;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public String getRisk() {
        return this.risk;
    }

    public void setRisk(String risk) {
        this.risk = risk;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public IUserApi getUserApi() {
        return this.userApi;
    }

    public void setUserApi(IUserApi userApi) {
        this.userApi = userApi;
    }
}

