/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import cms.tmx.api.mng.IUserApi;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.login.UserRegisterModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserRegisterDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(UserRegisterDialog.class);
    @FXML
    private TextField txtProduct;
    @FXML
    private TextField txtAdviser;
    @FXML
    private TextField txtManager;
    @FXML
    private TextField txtTrader;
    @FXML
    private TextField txtAdmin;
    @FXML
    private TextField txtRisk;
    @FXML
    private TextField txtPhone;
    @FXML
    private ComboBox<MxNode> cmbInstMode;
    @FXML
    private RadioButton rdoSingle;
    @FXML
    private RadioButton rdomulti;
    @FXML
    private HBox hboxOne;
    @FXML
    private HBox hboxTwo;
    @FXML
    private HBox hboxThree;
    @FXML
    private Label lbAdmin;
    @FXML
    private Label lbTrader;
    @FXML
    private Label lbProductErr;
    @FXML
    private Label lbAdviserErr;
    @FXML
    private Label lbMngerErr;
    @FXML
    private Label lbTraderErr;
    @FXML
    private Label lbAdminErr;
    @FXML
    private Label lbRiskErr;
    @FXML
    private Label lbUserErr;
    @FXML
    private Label lbPhoneErr;
    @Inject
    private IUserApi userApi;
    @Inject
    private MxAlert alert;
    @Inject
    private UserRegisterModel model;
    private ToggleGroup userTg = new ToggleGroup();
    private List<Node> listUnique = new LinkedList<Node>();

    @FXML
    public void initialize() {
        this.initControls();
        this.formatters();
        this.checks();
    }

    private void formatters() {
        this.txtProduct.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtAdviser.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtManager.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtTrader.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtAdmin.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtRisk.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtPhone.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
    }

    protected void checks() {
        this.registerCheck((Node)this.lbProductErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            String user;
            if (!this.txtProduct.isFocused() && (user = this.txtProduct.getText()).isEmpty()) {
                HBox box = (HBox)this.getNode((Node)this.txtProduct);
                Label lbName = (Label)box.getChildren().get(0);
                this.lbProductErr.setText("\u8bf7\u8f93\u5165" + lbName.getText());
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtProduct.focusedProperty()}));
        this.registerCheck((Node)this.lbPhoneErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            String user;
            if (!this.txtPhone.isFocused() && (user = this.txtPhone.getText()).isEmpty()) {
                HBox box = (HBox)this.getNode((Node)this.txtPhone);
                Label lbName = (Label)box.getChildren().get(0);
                this.lbPhoneErr.setText("\u8bf7\u8f93\u5165" + lbName.getText());
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtPhone.focusedProperty()}));
        this.addCheck(this.txtAdviser, this.lbAdviserErr);
        this.addCheck(this.txtManager, this.lbMngerErr);
        this.addCheck(this.txtTrader, this.lbTraderErr);
        this.addCheck(this.txtAdmin, this.lbAdminErr);
        this.addCheck(this.txtRisk, this.lbRiskErr);
    }

    private void initControls() {
        this.rdoSingle.setToggleGroup(this.userTg);
        this.rdomulti.setToggleGroup(this.userTg);
        this.userTg.selectToggle((Toggle)this.rdoSingle);
        this.userTg.getSelectedToggle().selectedProperty().addListener(ob -> this.instModelChange((MxNode)this.cmbInstMode.getValue()));
        MxNode node = MxNodeFactory.create((String)"instruction_model", (String)"1");
        this.cmbInstMode.setItems(node.getNodes());
        this.cmbInstMode.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.instModelChange((MxNode)now));
        this.clearInstModel();
        this.cmbInstMode.setValue((Object)node);
    }

    private void addCheck(TextField txt, Label lbErr) {
        this.registerCheck((Node)lbErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!txt.isFocused()) {
                String user = txt.getText();
                if (user.isEmpty()) {
                    HBox box = (HBox)this.getNode((Node)txt);
                    Label lbName = (Label)box.getChildren().get(0);
                    lbErr.setText("\u8bf7\u8f93\u5165" + lbName.getText());
                    return false;
                }
                try {
                    String id = this.userApi.getIdByName(user);
                    if (!id.isEmpty()) {
                        lbErr.setText("\u8be5\u7528\u6237\u5df2\u5b58\u5728!");
                        return false;
                    }
                }
                catch (MException e) {
                    this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
                    lbErr.setText("\u7528\u6237\u552f\u4e00\u6027\u6821\u9a8c\u51fa\u73b0\u95ee\u9898!");
                    return false;
                }
            }
            return true;
        }, (Observable[])new Observable[]{txt.focusedProperty()}));
    }

    private void instModelChange(MxNode now) {
        this.clearInstModel();
        if (this.rdoSingle.isSelected()) {
            this.lbAdmin.setText("\u7528\u6237\u540d");
            this.addItems(new Node[]{this.txtAdmin, this.txtPhone});
            return;
        }
        this.lbAdmin.setText("\u673a\u6784\u7ba1\u7406\u5458");
        switch (Integer.parseInt(now.getRaw())) {
            case 1: {
                this.addItems(new Node[]{this.txtTrader, this.txtAdmin, this.txtPhone});
                break;
            }
            case 2: {
                this.addItems(new Node[]{this.txtManager, this.txtTrader, this.txtAdmin, this.txtRisk, this.txtPhone});
                break;
            }
            case 3: {
                this.addItems(new Node[]{this.txtAdviser, this.txtTrader, this.txtAdmin, this.txtRisk, this.txtPhone});
                break;
            }
            case 4: {
                this.addItems(new Node[]{this.txtAdviser, this.txtManager, this.txtTrader, this.txtAdmin, this.txtRisk, this.txtPhone});
            }
        }
    }

    private boolean checkUnique() {
        HashSet<String> set = new HashSet<String>();
        for (Node node : this.listUnique) {
            TextField tf = (TextField)node;
            set.add(tf.getText());
        }
        return set.size() == this.listUnique.size();
    }

    private void clearInstModel() {
        this.hboxOne.getChildren().clear();
        this.hboxTwo.getChildren().clear();
        this.hboxThree.getChildren().clear();
        this.listUnique.clear();
    }

    private void addItems(Node ... nodes) {
        this.lbTrader.setText(nodes.length > 3 ? "\u4ea4\u6613\u5458" : "\u72ec\u7acb\u4ea4\u6613\u5458");
        if (nodes.length >= 2) {
            this.hboxOne.getChildren().add((Object)this.getNode(nodes[0]));
            this.hboxOne.getChildren().add((Object)this.getNode(nodes[1]));
        }
        if (nodes.length >= 3) {
            this.hboxTwo.getChildren().add((Object)this.getNode(nodes[2]));
        }
        if (nodes.length >= 4) {
            this.hboxTwo.getChildren().add((Object)this.getNode(nodes[3]));
        }
        if (nodes.length >= 5) {
            this.hboxThree.getChildren().add((Object)this.getNode(nodes[4]));
        }
        if (nodes.length >= 6) {
            this.hboxThree.getChildren().add((Object)this.getNode(nodes[5]));
        }
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            this.listUnique.add(node);
            this.listUnique.remove(this.txtPhone);
            ++n2;
        }
    }

    private Parent getNode(Node node) {
        return node.getParent().getParent();
    }

    public boolean valid() {
        LinkedList<Parent> list = new LinkedList<Parent>();
        list.add(this.getNode((Node)this.txtProduct));
        list.addAll((Collection<Parent>)this.hboxOne.getChildren());
        list.addAll((Collection<Parent>)this.hboxTwo.getChildren());
        list.addAll((Collection<Parent>)this.hboxThree.getChildren());
        for (Map.Entry entry : this.mapValid.entrySet()) {
            this.checkNode((Node)entry.getValue(), (ObservableBooleanValue)entry.getKey());
            if (!list.contains(this.getNode((Node)entry.getValue())) || ((ObservableBooleanValue)entry.getKey()).get()) continue;
            return false;
        }
        return true;
    }

    protected boolean isOK(ButtonType bt) {
        if (!this.checkUnique()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u7528\u6237\u540d\u4e0d\u80fd\u76f8\u540c");
            return false;
        }
        this.model.setProduct(this.txtProduct.getText());
        this.model.setInstMode((MxNode)this.cmbInstMode.getValue());
        this.model.setUserMode(this.userTg.getSelectedToggle().equals(this.rdoSingle));
        this.model.setAdviser(this.txtAdviser.getText());
        this.model.setManager(this.txtManager.getText());
        this.model.setRisk(this.txtRisk.getText());
        this.model.setTrader(this.txtTrader.getText());
        this.model.setAdmin(this.txtAdmin.getText());
        this.model.setPhone(this.txtPhone.getText());
        try {
            this.model.userRegister();
            this.alert.alert(Alert.AlertType.INFORMATION, this.successInfo());
        }
        catch (MException e) {
            logger.error("user register faild", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return false;
        }
        return true;
    }

    private String successInfo() {
        LinkedList listNode = new LinkedList();
        listNode.addAll(this.hboxOne.getChildren());
        listNode.addAll(this.hboxTwo.getChildren());
        listNode.addAll(this.hboxThree.getChildren());
        LinkedList listUser = new LinkedList();
        listNode.remove(listNode.size() - 1);
        listNode.forEach(node -> {
            HBox hbox = (HBox)node;
            VBox vbox = (VBox)hbox.getChildren().get(1);
            TextField txt = (TextField)vbox.getChildren().get(0);
            listUser.add(txt.getText());
        });
        String users = ((Object)listUser).toString();
        return "\u5df2\u521b\u5efa\u6210\u529f\u7528\u6237 " + users + ", \u521d\u59cb\u5bc6\u7801\u4e3aDd123456\uff0c\u9996\u6b21\u767b\u9646\u9700\u4fee\u6539\u5bc6\u7801";
    }
}

