/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.javafx.MxGroup;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.login.LoginConfMng;
import cms.tmx.utils.StringUtils;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SetDialog
extends DialogObj {
    private static final int SHOW_COUNT = 5;
    @FXML
    private ComboBox<String> cmbSerIp;
    @FXML
    private ComboBox<String> cmbSerPort;
    @FXML
    private ComboBox<String> cmbProxy;
    @FXML
    private TextField txtIp;
    @FXML
    private TextField txtPort;
    @FXML
    private TextField txtUser;
    @FXML
    private TextField txtPwd;
    @FXML
    private Label lbSerIp;
    @FXML
    private Label lbSerPort;
    @FXML
    private Label lbIp;
    @FXML
    private Label lbPort;
    @Inject
    private LoginConfMng lcMng;
    private static final String HTTP = "http";
    private static final String PROXY_TYPE_EMPTY = "\u4e0d\u4f7f\u7528\u4ee3\u7406";
    private static final String PROXY_TYPE_HTTP = "HTTP\u4ee3\u7406";
    private MxGroup group = new MxGroup();
    private MxGroup gpErr = new MxGroup();
    private static final String CMB_SER_IP = "cmbSerIp";
    private static final String CMB_SER_PORT = "cmbSerPort";

    public void onFinished(ButtonType bt) {
        if (bt == ButtonType.OK) {
            this.lcMng.setIp((String)this.cmbSerIp.getValue());
            this.lcMng.setPort((String)this.cmbSerPort.getValue());
            this.lcMng.setProxyType(this.proxyConvert((String)this.cmbProxy.getValue()));
            this.lcMng.setProxyIPAddress(this.txtIp.getText());
            this.lcMng.setProxyPort(this.txtPort.getText());
            this.lcMng.setProxyUserName(this.txtUser.getText());
            this.lcMng.setProxyPassword(this.txtPwd.getText());
            this.lcMng.saveServerInfo();
        }
    }

    @FXML
    public void initialize() {
        this.setComboBox(this.cmbSerIp);
        this.cmbSerIp.setItems(this.lcMng.getIpList());
        this.cmbSerIp.setValue((Object)this.lcMng.getIp());
        this.cmbSerIp.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9.]*", 15));
        this.cmbSerIp.getEditor().textProperty().addListener((ob, old, now) -> this.cmbSerIp.getSelectionModel().select(now));
        this.setComboBox(this.cmbSerPort);
        this.cmbSerPort.setValue((Object)this.lcMng.getPort());
        this.cmbSerPort.setItems(this.lcMng.getPortList(this.lcMng.getIp()));
        this.cmbSerPort.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 5));
        this.cmbSerPort.getEditor().textProperty().addListener((ob, old, now) -> this.cmbSerPort.getSelectionModel().select(now));
        this.cmbSerIp.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (this.lcMng.getPortList((String)now) != null) {
                this.cmbSerPort.setItems(this.lcMng.getPortList((String)now));
                if (!this.lcMng.getPortList((String)now).isEmpty()) {
                    this.cmbSerPort.setValue((Object)((String)this.lcMng.getPortList((String)now).get(0)));
                }
            } else {
                this.cmbSerPort.setItems(null);
            }
        });
        this.txtIp.setTextFormatter((TextFormatter)new MxFormatter("[0-9.]*", 15));
        this.txtPort.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 5));
        this.txtIp.setText(this.lcMng.getPproxyIPAddress());
        this.txtPort.setText(this.lcMng.getProxyPort());
        this.txtUser.setText(this.lcMng.getProxyUserName());
        this.txtPwd.setText(this.lcMng.getProxyPassword());
        this.group.add(new Control[]{this.txtIp, this.txtPort, this.txtUser, this.txtPwd});
        this.gpErr.add(new Control[]{this.lbIp, this.lbPort});
        this.cmbProxy.valueProperty().addListener((ob, old, now) -> {
            this.group.setEnabled(Boolean.valueOf(PROXY_TYPE_HTTP.equals(now)));
            this.gpErr.setVisible(PROXY_TYPE_HTTP.equals(now));
        });
        ObservableList proxyList = FxUtils.newList();
        proxyList.add((Object)PROXY_TYPE_EMPTY);
        proxyList.add((Object)PROXY_TYPE_HTTP);
        this.cmbProxy.setItems(proxyList);
        this.cmbProxy.setValue((Object)this.proxyConvert(this.lcMng.getProxyType()));
        this.check();
    }

    private void check() {
        this.mapValid.clear();
        this.registerCheck((Node)this.lbSerIp, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbSerIp.getEditor().getText().trim().isEmpty()) {
                this.lbSerIp.setText("\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            if (!StringUtils.isIp((String)this.cmbSerIp.getEditor().getText())) {
                this.lbSerIp.setText("\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbSerIp.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbSerPort, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.cmbSerPort.getEditor().getText().trim().isEmpty(), (Observable[])new Observable[]{this.cmbSerPort.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbIp, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (PROXY_TYPE_HTTP.equals(this.cmbProxy.getValue())) {
                if (this.txtIp.getText().trim().isEmpty()) {
                    this.lbIp.setText("\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                    return false;
                }
                if (!StringUtils.isIp((String)this.txtIp.getText())) {
                    this.lbIp.setText("\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
                    return false;
                }
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbProxy.valueProperty(), this.txtIp.textProperty()}));
        this.registerCheck((Node)this.lbPort, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> PROXY_TYPE_EMPTY.equals(this.cmbProxy.getValue()) || !this.txtPort.getText().trim().isEmpty(), (Observable[])new Observable[]{this.cmbProxy.valueProperty(), this.txtPort.textProperty()}));
    }

    public void setComboBox(final ComboBox<String> cmb) {
        cmb.setCellFactory(lv -> new ListCell<String>(){
            private HBox graphic;
            {
                Label label = new Label();
                label.textProperty().bind((ObservableValue)this.itemProperty());
                label.setMaxWidth(Double.POSITIVE_INFINITY);
                label.setOnMouseClicked(event -> comboBox.hide());
                comboBox.setVisibleRowCount(5);
                Button btnDel = new Button("");
                btnDel.setOnAction(event -> {
                    String item = (String)this.getItem();
                    if (this.isSelected()) {
                        comboBox.getSelectionModel().select(null);
                    }
                    comboBox.getItems().remove((Object)item);
                    if (SetDialog.CMB_SER_IP.equals(comboBox.getId())) {
                        SetDialog.this.lcMng.removeIp(item);
                    }
                    if (SetDialog.CMB_SER_PORT.equals(comboBox.getId())) {
                        SetDialog.this.lcMng.removePort((String)SetDialog.this.cmbSerIp.getValue(), item);
                    }
                    comboBox.hide();
                    comboBox.show();
                });
                this.graphic = new HBox(new Node[]{label, btnDel});
                HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)this.graphic);
                }
            }
        });
        cmb.setSkin((Skin)new ComboBoxListViewSkin<String>(cmb){

            protected boolean isHideOnClickEnabled() {
                return false;
            }
        });
    }

    private String proxyConvert(String str) {
        if (HTTP.equals(str)) {
            return PROXY_TYPE_HTTP;
        }
        if (PROXY_TYPE_HTTP.equals(str)) {
            return HTTP;
        }
        if ("".equals(str)) {
            return PROXY_TYPE_EMPTY;
        }
        if (PROXY_TYPE_EMPTY.equals(str)) {
            return "";
        }
        return str;
    }
}

