/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.TableUtils;
import cms.tmx.entity.Post;
import cms.tmx.javafx.MxList;
import com.jfoenix.controls.JFXRadioButton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class SelectPostDialog
extends DialogObj {
    @FXML
    private TableView<Post> tablePost;
    @FXML
    private TableColumn<Post, JFXRadioButton> colRadio;
    @FXML
    private TableColumn<Post, String> colUser;
    @FXML
    private TableColumn<Post, String> colParty;
    private String lastSelectPostId;
    private Button btnSure;
    private ToggleGroup group = new ToggleGroup();
    private Map<Post, JFXRadioButton> radios = new HashMap<Post, JFXRadioButton>();
    private MxList<Post> mlist = new MxList();
    private Post post;
    private String userId;

    public void onFinished(ButtonType bt) {
        this.post = (Post)this.tablePost.getSelectionModel().getSelectedItem();
    }

    public void initialize() {
        this.createTable();
        this.tablePost.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.TAB.equals((Object)event.getCode())) {
                int index = this.tablePost.getItems().indexOf(this.tablePost.getSelectionModel().getSelectedItem());
                this.tablePost.getSelectionModel().select(index + 1 == this.tablePost.getItems().size() ? 0 : index + 1);
                Platform.runLater(() -> this.tablePost.requestFocus());
            } else if (KeyCode.ENTER.equals((Object)event.getCode())) {
                this.btnSure.fire();
            }
        });
        boolean selectLast = false;
        for (Post p : this.mlist.getList()) {
            if (!p.getId().equals(this.lastSelectPostId)) continue;
            p.setSelected(true);
            this.tablePost.scrollTo((Object)p);
            this.tablePost.getSelectionModel().select((Object)p);
            selectLast = true;
            break;
        }
        if (!selectLast) {
            this.tablePost.scrollTo(0);
            this.tablePost.getSelectionModel().select(0);
            ((Post)this.tablePost.getSelectionModel().getSelectedItem()).setSelected(true);
        }
        Platform.runLater(() -> this.tablePost.requestFocus());
        this.group.selectedToggleProperty().addListener((ob, old, now) -> {
            if (old != null) {
                Post oldPost = (Post)Post.class.cast(old.getUserData());
                oldPost.setSelected(false);
            }
            Post nowPost = (Post)Post.class.cast(now.getUserData());
            nowPost.setSelected(true);
            this.tablePost.getSelectionModel().select((Object)nowPost);
        });
        this.tablePost.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.group.selectToggle((Toggle)this.radios.get(now)));
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tablePost);
        this.colRadio.setCellValueFactory(data -> this.setJFXRadioButton((Post)data.getValue()));
        this.colUser.setCellValueFactory(data -> new ReadOnlyStringWrapper(this.userId));
        this.tablePost.setItems(this.mlist.getList());
        this.tablePost.setPlaceholder((Node)new Label());
    }

    private ReadOnlyObjectWrapper<JFXRadioButton> setJFXRadioButton(Post post) {
        JFXRadioButton radio = new JFXRadioButton();
        radio.setToggleGroup(this.group);
        radio.setUserData((Object)post);
        this.radios.put(post, radio);
        if (post.isSelected()) {
            radio.setSelected(true);
        }
        return new ReadOnlyObjectWrapper((Object)radio);
    }

    public Post getPost() {
        return this.post;
    }

    public void setInfo(String userId, List<Post> list) {
        this.userId = userId;
        this.mlist.update(list);
    }

    public Button getBtnSure() {
        return this.btnSure;
    }

    public void setBtnSure(Button btnSure) {
        this.btnSure = btnSure;
    }

    public String getLastSelectPostId() {
        return this.lastSelectPostId;
    }

    public void setLastSelectPostId(String lastSelectPostId) {
        this.lastSelectPostId = lastSelectPostId;
    }
}

