/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.inject.Singleton;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Creatable
@Singleton
public class Md5Inspector
extends DefaultHandler {
    private static Logger logger = LogManager.getLogger(Md5Inspector.class);
    private Stack<String> tags = new Stack();
    private Map<String, String> md5Map = new HashMap<String, String>();

    public void parseXml() {
        long lasting = System.currentTimeMillis();
        try {
            SAXParserFactory sf = SAXParserFactory.newInstance();
            SAXParser sp = sf.newSAXParser();
            String baseDir = System.getProperty("user.dir");
            Path path = Paths.get(baseDir, "cmstmupdate.xml");
            sp.parse(new InputSource(path.toString()), (DefaultHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("\u8fd0\u884c\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - lasting) + "\u6beb\u79d2");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        if (attrs.getValue("path") != null && attrs.getValue("path").contains("plugins\\cms.tmx.")) {
            this.md5Map.put(attrs.getValue("path").replace("plugins\\", ""), attrs.getValue("ver"));
        }
        this.tags.push(qName);
    }

    public Map<String, String> getMd5Map() {
        return this.md5Map;
    }

    public void setMd5Map(Map<String, String> md5Map) {
        this.md5Map = md5Map;
    }
}

