/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.manage.login.LoginModel;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class LoginService
extends Service<MEvent> {
    @Inject
    private LoginModel manager;
    private StringProperty user = new SimpleStringProperty("");
    private StringProperty passwd = new SimpleStringProperty("");
    private static final Logger logger = LogManager.getLogger(LoginService.class);

    protected Task<MEvent> createTask() {
        return new LoginTask();
    }

    public StringProperty userProperty() {
        return this.user;
    }

    public String getUser() {
        return (String)this.userProperty().get();
    }

    public void setUser(String user) {
        this.userProperty().set((Object)user);
    }

    public StringProperty passwdProperty() {
        return this.passwd;
    }

    public String getPasswd() {
        return (String)this.passwdProperty().get();
    }

    public void setPasswd(String passwd) {
        this.passwdProperty().set((Object)passwd);
    }

    private class LoginTask
    extends Task<MEvent> {
        private LoginTask() {
        }

        protected MEvent call() throws Exception {
            try {
                LoginService.this.manager.login((String)LoginService.this.user.get(), (String)LoginService.this.passwd.get());
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                return new MEvent(e.getCode(), e.getDesc());
            }
            return new MEvent(0, "");
        }
    }
}

