/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MProps;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.user.PUser;
import cms.tmx.entity.Party;
import cms.tmx.entity.Post;
import cms.tmx.http.update.dto.CheckVersionResult;
import cms.tmx.javafx.DadActivator;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.SceneService;
import cms.tmx.javafx.utils.StageUtils;
import cms.tmx.manage.login.LoginAlert;
import cms.tmx.manage.login.LoginConfMng;
import cms.tmx.manage.login.LoginModel;
import cms.tmx.manage.login.MainWindowCloseHandler;
import cms.tmx.manage.login.SelectPostDialog;
import cms.tmx.manage.login.SetDialog;
import cms.tmx.manage.login.UserRegisterDialog;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.manage.parts.SetNewPwdDialog;
import cms.tmx.utils.CommUtils;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.PasswordField;
import javafx.scene.control.Skin;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;

@Creatable
public class LoginPart
extends MxPart {
    private static final String LOGIN_TEXT = "\u767b  \u5f55";
    private static final String CANCEL_TEXT = "\u53d6\u6d88\u767b\u5f55";
    private static final String UPDATE_TEXT = "\u51c6\u5907\u66f4\u65b0";
    private static final String ID_PROMOTE_TEXT = "\u8bf7\u8f93\u5165\u7528\u6237\u8d26\u53f7";
    private static final String PWD_PROMOTE_TEXT = "\u8bf7\u8f93\u5165\u5bc6\u7801";
    private static final int ERROR_USER_LOCKED = 3111;
    private static final int ERROR_USER_PWD_OUTTIME = 3116;
    private static final int ERROR_USER_INIT_PWD = 3118;
    public static final int ERROR_GENERAL = 999999;
    public static final int ERROR_IP_IN_BLACKLIST = 3125;
    public static final int ERROR_IP_IN_POSTCONTROL = 3126;
    public static final int ERROR_MAC_IN_POSTCONTROL = 3127;
    private static final int SHOW_COUNT = 5;
    @FXML
    private HBox hboxProgress;
    @FXML
    private Label lbProText;
    @FXML
    private Label lbProNum;
    @Inject
    private ExecutorService exe;
    @Inject
    private Stage stage;
    @Inject
    private MEventService es;
    @FXML
    private ComboBox<String> combUserID;
    @FXML
    private PasswordField txtPasswd;
    @FXML
    private GridPane title;
    @FXML
    private Button btnLogin;
    @FXML
    private Label lbVersion;
    @FXML
    private Label lbRegister;
    @FXML
    private Button btnSet;
    @FXML
    private Button btnMin;
    @Inject
    private LoginConfMng lcm;
    @Inject
    private EModelService ms;
    @Inject
    private MApplication app;
    @Inject
    private MObjFactory of;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private LoginAlert alert;
    @Inject
    private MWindow window;
    private static final Logger logger = LogManager.getLogger(LoginPart.class);
    @Inject
    private LoginModel model;
    @Inject
    private DialogFactory df;
    @Inject
    @Named(value="base.path")
    private String basePath;
    @Inject
    private IBaseApi iba;
    @Inject
    private SceneService service;
    @Inject
    private MConfService cs;
    private List<String> rList = new LinkedList<String>();
    private int retryTimes = 0;
    private String localIp = "";
    private ObservableList<String> userList = FxUtils.newList();
    private DadActivator dad;
    private MProps props;
    private String lastIp = "";
    private String lastMac = "";
    private String dateTime = "";
    private String lastLocalIp = "";
    private MEventHandler hAppStart = event -> {
        this.checkUpdate();
        this.initClientInfo();
    };
    private ChangeListener<Number> lstnModelPro = (ob, old, now) -> this.lbProNum.setText(String.format("%d%%", now.intValue()));
    private ChangeListener<Boolean> lstnModelDone = (ob, old, now) -> {
        if (!now.booleanValue()) {
            return;
        }
        MWindow mainWin = (MWindow)this.ms.findElements((MUIElement)this.app, "cms.tmx.twin.main", MWindow.class, null).get(0);
        mainWin.setToBeRendered(true);
        this.of.setContext(mainWin.getContext());
        this.of.setWin(mainWin);
        Stage mainStage = (Stage)mainWin.getContext().get(Stage.class);
        MProps mProps = this.initProp();
        Platform.runLater(() -> {
            StageUtils.updateStageStyle((Stage)mainStage);
            if (mProps != null) {
                boolean bool = mProps.getBool("isFullScreen", false);
                mainStage.setFullScreenExitHint("\u6309F10\u53ef\u4ee5\u9000\u51fa\u5168\u5c4f");
                mainStage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
                mainStage.setFullScreen(bool);
                MEvent mEvent = new MEvent();
                mEvent.put((Object)"close_part", (Object)bool);
                this.es.sendEvent("close_menu", mEvent);
                if (bool) {
                    this.service.disableCursor(mainStage);
                    this.service.hideTopBottom(mainStage);
                } else {
                    this.service.enableCursor(mainStage);
                    this.service.showTopBottom(mainStage);
                }
            }
        });
        this.of.setMainStage(mainStage);
        mainWin.getContext().set(IWindowCloseHandler.class, (Object)((IWindowCloseHandler)this.of.create(MainWindowCloseHandler.class)));
        this.es.postEvent("stage.after.login", null);
        this.window.setToBeRendered(false);
    };

    @PostConstruct
    public void init() {
        System.setProperty("init_done", "done");
        super.initTransparent();
        this.stage.centerOnScreen();
        this.stage.setWidth(640.0);
        this.stage.setHeight(360.0);
        this.lbProText.textProperty().bind((ObservableValue)this.model.descProperty());
        this.model.perProperty().addListener(this.lstnModelPro);
        this.model.doneProperty().addListener(this.lstnModelDone);
    }

    @PreDestroy
    private void close() {
        this.model.perProperty().removeListener(this.lstnModelPro);
        this.model.doneProperty().removeListener(this.lstnModelDone);
        this.es.unSubscribe("application.start", this.hAppStart);
    }

    private void initClientInfo() {
        this.exe.execute(() -> {
            CommUtils.getPI();
            CommUtils.getVolNew();
            CommUtils.getCPUSerial();
        });
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FXML
    public void initialize() {
        String clientEnv;
        this.userList.setAll(this.lcm.getUserList());
        this.optimizeComboBox();
        this.combUserID.setValue((Object)this.lcm.getId());
        this.combUserID.setItems(this.userList);
        this.combUserID.setPromptText(ID_PROMOTE_TEXT);
        this.combUserID.getEditor().setTextFormatter((TextFormatter)new MxFormatter(16));
        this.txtPasswd.setPromptText(PWD_PROMOTE_TEXT);
        this.txtPasswd.setTextFormatter((TextFormatter)new MxFormatter(16));
        this.lbVersion.setText(String.valueOf(this.lbVersion.getText()) + " " + StringUtils.getClientVersion((String)this.cs.getValue("client_env")) + " v" + this.cs.getProps("client.properties").getDesValue("client_version"));
        this.dad = new DadActivator(this.stage);
        this.dad.activate((Node)this.title);
        this.btnLogin.setText(LOGIN_TEXT);
        if ("".equals(this.lcm.getId())) {
            Platform.runLater(() -> this.combUserID.requestFocus());
        } else {
            Platform.runLater(() -> this.txtPasswd.requestFocus());
        }
        this.combUserID.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.txtPasswd.clear());
        this.txtPasswd.setContextMenu(new ContextMenu());
        this.txtPasswd.textProperty().addListener((ob, oldV, newV) -> {
            if (!StringUtils.isEmpty((String)newV) && StringUtils.containsChinese((String)newV)) {
                try {
                    Robot robot = new Robot();
                    robot.keyPress(17);
                    robot.keyPress(32);
                    robot.keyRelease(17);
                    robot.keyRelease(32);
                    Platform.runLater(() -> {
                        this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u4e0d\u8981\u8f93\u5165\u4e2d\u6587, \u5df2\u4e3a\u60a8\u5207\u6362\u5230\u82f1\u6587\u8f93\u5165\u6cd5");
                        this.txtPasswd.clear();
                        this.txtPasswd.layout();
                    });
                }
                catch (AWTException e) {
                    logger.error("\u5207\u6362\u8f93\u5165\u6cd5\u51fa\u9519", (Throwable)e);
                }
            }
        });
        this.btnLogin.setDisable(true);
        this.txtPasswd.setDisable(true);
        this.es.subscribe("application.start", this.hAppStart);
        this.combUserID.getEditor().textProperty().addListener((ob, old, now) -> this.combUserID.getSelectionModel().select(now));
        try {
            String property = System.getProperty("begin_time");
            long start = Long.parseLong(property);
            logger.info(String.format("client init complete cost %d", System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("get start time failed", (Throwable)e);
        }
        switch (clientEnv = this.cs.getValue("client_env")) {
            default: {
                this.lbRegister.setVisible(false);
                break;
            }
            case "dev": 
            case "exp": 
            case "test": 
            case "integ": 
        }
        this.lbRegister.setOnMouseClicked(event -> {
            try {
                MEvent mEvent = null;
                switch (clientEnv) {
                    case "dev": {
                        mEvent = this.model.login("U0000000086", "Cc123456");
                        break;
                    }
                    case "test": {
                        mEvent = this.model.login("U0000000086", "Cc123456");
                        break;
                    }
                    case "integ": {
                        mEvent = this.model.login("U0000000074", "Cc123456");
                        break;
                    }
                    case "exp": {
                        mEvent = this.model.login("U0000000212", "Cc123456");
                    }
                }
                PBase.OpStatus status = (PBase.OpStatus)mEvent.getObj(PBase.OpStatus.class);
                if (status.getStatus() == 1) {
                    UserRegisterDialog obj = (UserRegisterDialog)((Object)((Object)this.of.create(UserRegisterDialog.class)));
                    MxDialog dialog = this.df.create((DialogObj)obj, "\u81ea\u52a9\u6ce8\u518c");
                    dialog.launch();
                }
            }
            catch (MException e) {
                logger.error("user register dialog faild", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, "\u6ce8\u518c\u754c\u9762\u52a0\u8f7d\u5931\u8d25\uff01");
            }
            catch (Exception e) {
                logger.error("user register dialog faild", (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, "\u6ce8\u518c\u754c\u9762\u52a0\u8f7d\u5931\u8d25\uff01");
            }
        });
        this.props = this.cs.getUserProps();
    }

    private MProps initProp() {
        try {
            MProps mProps = new MProps();
            Path dataPath = Paths.get(String.valueOf(this.basePath) + File.separator + "data" + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.iba.getPostId()) + ".properties");
            File file = dataPath.toFile();
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!file.exists()) {
                new File(String.valueOf(this.basePath) + File.separator + "data" + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.iba.getPostId()) + ".properties").createNewFile();
            }
            mProps.load(file);
            return mProps;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private void checkUpdate() {
        this.model.initProxy();
        String localVersion = this.cs.getProps("client.properties").getDesValue("client_version");
        this.exe.execute(() -> {
            CheckVersionResult version = this.model.getVersion(localVersion);
            if (version.isNeedUpdate()) {
                if (!version.isForceUpdate()) {
                    Platform.runLater(() -> {
                        if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u68c0\u6d4b\u5230\u5ba2\u6236\u7aef\u6709\u66f4\u65b0\uff0c\u662f\u5426\u8fdb\u884c\u5347\u7ea7", "\u5347\u7ea7\u63d0\u793a")) {
                            try {
                                this.startUpdate(false);
                            }
                            catch (Exception e) {
                                logger.error("\u542f\u52a8\u5347\u7ea7\u811a\u672c\u5f02\u5e38", (Throwable)e);
                                this.checkUpdateDone();
                            }
                            return;
                        }
                        this.checkUpdateDone();
                    });
                } else {
                    Platform.runLater(() -> {
                        boolean startUpdate = this.alert.alert(Alert.AlertType.WARNING, "\u68c0\u6d4b\u5230\u5ba2\u6236\u7aef\u6709\u66f4\u65b0\uff0c\u8bf7\u8fdb\u884c\u5347\u7ea7", "\u5347\u7ea7\u63d0\u793a", () -> this.killPoc());
                        try {
                            if (startUpdate) {
                                this.startUpdate(true);
                            }
                        }
                        catch (Exception e) {
                            logger.error("\u542f\u52a8\u5347\u7ea7\u811a\u672c\u5f02\u5e38", (Throwable)e);
                            this.checkUpdateDone();
                        }
                    });
                }
            } else {
                if (!StringUtils.isEmpty((String)version.getRemark())) {
                    Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, version.getRemark()));
                }
                this.checkUpdateDone();
            }
        });
    }

    private void checkUpdateDone() {
        Platform.runLater(() -> {
            this.btnLogin.setDisable(false);
            this.txtPasswd.setDisable(false);
            if (this.combUserID.getEditor().getText().isEmpty()) {
                this.combUserID.requestFocus();
            } else {
                this.txtPasswd.requestFocus();
            }
        });
    }

    private void killPoc() {
        String[] cmd = new String[]{"cmd", "/C", ""};
        String id = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        cmd[2] = "taskkill /pid " + id + " -t -f ";
        try {
            logger.error("start kill process: " + cmd[2]);
            Runtime.getRuntime().exec(cmd);
            logger.error("kill process complete");
        }
        catch (IOException e) {
            logger.error("kill process fail", (Throwable)e);
        }
    }

    private void optimizeComboBox() {
        this.combUserID.setCellFactory(lv -> new ListCell<String>(){
            private HBox graphic;
            {
                Label label = new Label();
                label.textProperty().bind((ObservableValue)this.itemProperty());
                label.setMaxWidth(Double.POSITIVE_INFINITY);
                label.setOnMouseClicked(event -> LoginPart.this.combUserID.hide());
                LoginPart.this.combUserID.setVisibleRowCount(5);
                Button btnDel = new Button("");
                btnDel.setOnAction(event -> {
                    String item = (String)this.getItem();
                    if (this.isSelected()) {
                        LoginPart.this.combUserID.getSelectionModel().select(null);
                    }
                    LoginPart.this.userList.remove((Object)item);
                    LoginPart.this.lcm.getUserList().remove((Object)item);
                    LoginPart.this.lcm.setUserList((List<String>)LoginPart.this.userList);
                    LoginPart.this.combUserID.hide();
                    LoginPart.this.combUserID.show();
                });
                this.graphic = new HBox(new Node[]{label, btnDel});
                HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)this.graphic);
                }
            }
        });
        this.combUserID.setSkin((Skin)new ComboBoxListViewSkin<String>(this.combUserID){

            protected boolean isHideOnClickEnabled() {
                return false;
            }
        });
    }

    @FXML
    private void onUserIDKey(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.txtPasswd.requestFocus();
        }
    }

    @FXML
    private void onPasswdKey(KeyEvent key) throws MException {
        if (KeyCode.ENTER == key.getCode()) {
            this.onLogin();
        }
    }

    @FXML
    private void onLoginKey(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.combUserID.requestFocus();
        }
    }

    @FXML
    public void onClose() {
        if (this.combUserID.getValue() != null) {
            this.model.logout((String)this.combUserID.getValue());
        }
        this.stage.close();
    }

    @FXML
    public void onMin() {
        this.stage.setIconified(true);
    }

    private void endLogin() {
        if (!this.model.isLogging()) {
            return;
        }
        this.model.setLogging(false);
        this.rList.clear();
        this.retryTimes = 0;
        this.btnLogin.setText(LOGIN_TEXT);
        this.combUserID.setDisable(false);
        this.txtPasswd.setDisable(false);
        this.hboxProgress.setVisible(false);
        this.btnSet.setDisable(false);
    }

    private void startLogin() {
        if (this.model.isLogging()) {
            return;
        }
        this.model.setLogging(true);
        this.btnLogin.setText(CANCEL_TEXT);
        this.combUserID.setDisable(true);
        this.txtPasswd.setDisable(true);
        this.btnSet.setDisable(true);
    }

    @FXML
    private void onLogin() {
        if (this.model.isLogging()) {
            this.endLogin();
            return;
        }
        String user = (String)this.combUserID.getValue();
        String passwd = this.txtPasswd.getText();
        if (user.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u8f93\u5165\u7528\u6237\u53f7");
            return;
        }
        if (passwd.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, PWD_PROMOTE_TEXT);
            return;
        }
        this.startLogin();
        this.exe.execute(() -> this.doLogin(user, passwd));
    }

    private void startUpdate(boolean forceUpdate) throws IOException {
        this.btnLogin.setText(UPDATE_TEXT);
        this.combUserID.setDisable(true);
        this.txtPasswd.setDisable(true);
        this.btnLogin.setDisable(true);
        this.btnSet.setDisable(true);
        this.model.setLoginProgress(70, "\u51c6\u5907\u542f\u52a8\u66f4\u65b0\u7a0b\u5e8f");
        String id = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        logger.error("check update start kill process pid:" + id);
        Runtime.getRuntime().exec("cmd.exe  /C  start  /b  cmstmupdate.exe  " + id + " " + forceUpdate);
    }

    private void doLogin(String user, String passwd) {
        try {
            MEvent event = this.model.login(user, passwd);
            if (!this.model.isLogging()) {
                return;
            }
            Platform.runLater(() -> {
                this.onLoginOK(event);
                this.props.setValue("last.type", (Object)"1");
            });
        }
        catch (MException e) {
            logger.error("login failed: " + user, (Throwable)e);
            this.onLoginError(e.getEvent());
        }
    }

    private void onLoginError(MEvent event) {
        if (!this.model.isLogging()) {
            return;
        }
        if (event.getCode() == 3126) {
            Platform.runLater(() -> {
                try {
                    logger.info("\u767b\u5f55\u7684\u804c\u4f4dIP\u9a8c\u8bc1\u672a\u901a\u8fc7");
                    this.alert.alert(Alert.AlertType.ERROR, "\u767b\u5f55\u7684\u804c\u4f4dIP\u9a8c\u8bc1\u672a\u901a\u8fc7");
                }
                finally {
                    logger.info("start end login");
                    this.endLogin();
                }
            });
            return;
        }
        if (event.getCode() == 3127) {
            Platform.runLater(() -> {
                try {
                    logger.info("\u767b\u5f55\u7684\u804c\u4f4dMAC\u9a8c\u8bc1\u672a\u901a\u8fc7");
                    this.alert.alert(Alert.AlertType.ERROR, "\u767b\u5f55\u7684\u804c\u4f4dMAC\u9a8c\u8bc1\u672a\u901a\u8fc7");
                }
                finally {
                    logger.info("start end login");
                    this.endLogin();
                }
            });
            return;
        }
        if (event.getCode() == 3125) {
            InetAddress ia = null;
            try {
                ia = InetAddress.getLocalHost();
                this.localIp = ia.getHostAddress();
            }
            catch (Exception e) {
                logger.error("get localIp failed", (Throwable)e);
            }
            Platform.runLater(() -> {
                try {
                    logger.info("\u5f53\u524dIP\u5728\u9ed1\u540d\u5355\u4e2d");
                    this.alert.alert(Alert.AlertType.ERROR, "\u8be5IP\uff1a" + this.localIp + "\uff0c\u5df2\u7eb3\u5165\u4ea4\u6613\u5927\u5e08\u9ed1\u540d\u5355\u3002");
                }
                finally {
                    logger.info("start end login");
                    this.endLogin();
                }
            });
            return;
        }
        int size = this.lcm.getRetryList().size();
        if (event.getCode() == 999999) {
            if (size == this.retryTimes) {
                Platform.runLater(() -> {
                    try {
                        logger.info("\u5c1d\u8bd5\u8fde\u63a5\u6240\u6709ip\u5168\u90e8\u5931\u8d25");
                        this.alert.alert(Alert.AlertType.ERROR, "\u5c1d\u8bd5\u8fde\u63a5\u6240\u6709ip\u5168\u90e8\u5931\u8d25");
                    }
                    finally {
                        logger.info("start end login");
                        this.endLogin();
                        this.hboxProgress.setVisible(false);
                    }
                });
                return;
            }
            String oldIp = event.getStr("failed_ip");
            String oldPort = event.getStr("failed_port");
            this.rList.add(String.valueOf(oldIp) + "_" + oldPort);
            String value = this.lcm.getRetryList().get(this.retryTimes);
            String newIp = value.split("_")[0];
            String newPort = value.split("_")[1];
            this.cs.getUserProps().setDesValue("uap.server.ip", (Object)newIp);
            this.cs.getUserProps().setValue("uap.server.port", (Object)newPort);
            ++this.retryTimes;
            logger.info(String.format("ip:\u3010%s\u3011 port:\u3010%s\u3011 connect server failed , begin retry ip:\u3010%s\u3011 port:\u3010%s\u3011", oldIp, oldPort, newIp, newPort));
            this.doLogin((String)this.combUserID.getValue(), this.txtPasswd.getText());
        }
        Platform.runLater(() -> {
            if (event.getCode() == 3111) {
                String time = (String)event.getObj(String.class);
                this.alert.alertLockInfo(Alert.AlertType.ERROR, event.getDesc(), time);
                this.endLogin();
            } else if (event.getCode() == 3116) {
                ButtonType launch;
                SetNewPwdDialog obj = (SetNewPwdDialog)((Object)((Object)this.of.create(SetNewPwdDialog.class)));
                String userId = "";
                try {
                    userId = this.model.getIdByName((String)this.combUserID.getValue());
                }
                catch (MException mException) {
                    userId = (String)this.combUserID.getValue();
                }
                if (userId.isEmpty()) {
                    obj.setUserId((String)this.combUserID.getValue());
                } else {
                    obj.setUserId(userId);
                }
                MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u5bc6\u7801");
                Button btnOK = dialog.getButton(ButtonType.OK);
                if (btnOK != null) {
                    btnOK.disableProperty().bind((ObservableValue)obj.saveProperty().not());
                }
                if ((launch = dialog.launch()).equals(ButtonType.OK)) {
                    String passwd = obj.getNewPwd();
                    if (userId.isEmpty()) {
                        userId = (String)this.combUserID.getValue();
                    }
                    this.txtPasswd.setText(passwd);
                    this.doLogin(userId, passwd);
                } else {
                    this.endLogin();
                    this.txtPasswd.clear();
                }
            } else if (event.getCode() == 3118) {
                ButtonType launch;
                SetNewPwdDialog obj = (SetNewPwdDialog)((Object)((Object)this.of.create(SetNewPwdDialog.class)));
                String userId = "";
                try {
                    userId = this.model.getIdByName((String)this.combUserID.getValue());
                }
                catch (MException mException) {
                    userId = (String)this.combUserID.getValue();
                }
                if (userId.isEmpty()) {
                    obj.setUserId((String)this.combUserID.getValue());
                } else {
                    obj.setUserId(userId);
                }
                MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u5bc6\u7801");
                obj.getInfo().setText("\u9996\u6b21\u767b\u5f55,\u9700\u4fee\u6539\u5bc6\u7801!");
                Button btnOK = dialog.getButton(ButtonType.OK);
                if (btnOK != null) {
                    btnOK.disableProperty().bind((ObservableValue)obj.saveProperty().not());
                    FxUtils.focusBtnSure((Button)btnOK, (Node[])new Node[]{obj.getPwdOldPwd(), obj.getPwdPwd(), obj.getPwdPwdConfirm()});
                }
                if ((launch = dialog.launch()).equals(ButtonType.OK)) {
                    this.txtPasswd.clear();
                    this.endLogin();
                }
            } else if (event.getCode() != 999999) {
                this.alert.alert(Alert.AlertType.ERROR, event.getDesc());
                this.endLogin();
            }
        });
    }

    private void onLoginOK(MEvent event) {
        PUser.LoginResp resp = (PUser.LoginResp)event.getObj(PUser.LoginResp.class);
        PBase.OpUser lastInfo = resp.getLastLoginInfo();
        PBase.OpStatus opStatus = resp.getOpStatus();
        this.lastIp = lastInfo.getIp();
        this.lastLocalIp = lastInfo.getLocalIp();
        this.lastMac = lastInfo.getMac();
        this.dateTime = lastInfo.getDatetime();
        String userId = opStatus.getData();
        Post post = this.choosePost(userId);
        if (post == null) {
            this.endLogin();
            return;
        }
        this.btnLogin.setDisable(true);
        String userName = (String)this.combUserID.getValue();
        this.lcm.setId(userName);
        this.lcm.saveUserInfo();
        this.eCore.put((Object)"password", (Object)this.txtPasswd.getText());
        this.hboxProgress.setVisible(true);
        this.exe.execute(() -> {
            try {
                this.model.onLogin(userId, post);
                Platform.runLater(() -> {
                    PBase.OpUser OpUser2 = this.iba.getOpUser();
                    if (this.dateTime.isEmpty()) {
                        this.es.postEvent("message.first.login", null);
                    } else {
                        MEvent e = new MEvent();
                        if (this.lastIp.isEmpty() || "NA".equals(this.lastIp)) {
                            e.setDesc("\u6700\u8fd1\u4e00\u6b21\u767b\u5f55\u7684\u65e5\u671f\u65f6\u95f4\uff1a" + this.dateTime + "\uff0c\u53d6\u4e0d\u5230\u516c\u7f51IP\uff0c\u672c\u5730 IP\uff1a" + this.lastLocalIp);
                            this.es.postEvent("message.info.login", e);
                            if (!this.lastLocalIp.equals(OpUser2.getLocalIp())) {
                                this.es.postEvent("ip.pb.login", null);
                            }
                        } else {
                            e.setDesc("\u6700\u8fd1\u4e00\u6b21\u767b\u5f55\u7684\u65e5\u671f\u65f6\u95f4\uff1a" + this.dateTime + "\uff0c IP\uff1a" + this.lastIp);
                            this.es.postEvent("message.info.login", e);
                            if (!this.lastIp.equals(OpUser2.getLocalIp())) {
                                this.es.postEvent("ip.pb.login", null);
                            }
                        }
                        if (!this.lastMac.equals(OpUser2.getMac())) {
                            this.es.postEvent("mac.pb.login", null);
                        }
                    }
                });
            }
            catch (MException e) {
                this.onLoginError(e.getEvent());
                this.btnLogin.setDisable(false);
            }
            catch (InterruptedException interruptedException) {
                logger.error("\u540c\u6b65\u8bc1\u5238\u8d26\u53f7\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u65b0\u767b\u5f55");
            }
        });
    }

    private Post choosePost(String userId) {
        LinkedList<Post> listValid;
        String postId;
        MProps mprops;
        ObservableList list;
        block9: {
            list = FxUtils.newList();
            mprops = this.initPropWithoutPost(userId);
            postId = mprops.get("post_id", "");
            listValid = new LinkedList<Post>();
            for (Post post : this.postMng.getPostDetailList(userId)) {
                if (!post.getStatus().is("1")) continue;
                listValid.add(post);
            }
            if (listValid.size() != 0) break block9;
            this.alert.alert(Alert.AlertType.ERROR, "\u767b\u5f55\u5931\u8d25\uff0c\u804c\u4f4d\u72b6\u6001\u5f02\u5e38!");
            return null;
        }
        try {
            for (Post post : listValid) {
                PBase.OpUser.Builder builder = PBase.OpUser.newBuilder();
                builder.setUserId((String)this.combUserID.getValue());
                builder.setPartyId(post.getPartyId());
                builder.setDatetime(DateTimeUtils.getTimeStamp());
                PBase.OpUser user = builder.build();
                Party party = this.partyMng.getPartyDetails(user);
                if (party == null) continue;
                post.setPartyName(party.getFullName());
                list.add((Object)post);
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return null;
        }
        int size = list.size();
        if (size == 0) {
            this.alert.alert(Alert.AlertType.ERROR, "\u767b\u5f55\u5931\u8d25\uff0c\u673a\u6784\u72b6\u6001\u5f02\u5e38!");
            return null;
        }
        if (size == 1) {
            mprops.setValue("post_id", (Object)((Post)list.get(0)).getId());
            return (Post)list.get(0);
        }
        SelectPostDialog dlgPostSelect = (SelectPostDialog)((Object)this.of.create(SelectPostDialog.class));
        dlgPostSelect.setInfo((String)this.combUserID.getValue(), (List<Post>)list);
        dlgPostSelect.setLastSelectPostId(postId);
        MxDialog dialog = this.df.create((DialogObj)dlgPostSelect, "\u804c\u4f4d\u9009\u62e9");
        dialog.getDialogPane().setId("select-post-dialog");
        dialog.getCtrl().getCustomPane().removeEventHandler(KeyEvent.KEY_PRESSED, dialog.getCtrl().getHandler());
        dlgPostSelect.setBtnSure(dialog.getButton(ButtonType.OK));
        URL url = this.model.getClass().getResource("post.css");
        if (url != null) {
            dialog.getDialogPane().getStylesheets().add((Object)url.toString());
        }
        if (dialog.launch().equals(ButtonType.OK)) {
            mprops.setValue("post_id", (Object)dlgPostSelect.getPost().getId());
            return dlgPostSelect.getPost();
        }
        this.endLogin();
        this.txtPasswd.setEditable(true);
        return null;
    }

    @FXML
    public void pressSet() {
        SetDialog setDialog = (SetDialog)((Object)this.of.create(SetDialog.class));
        MxDialog dialog = this.df.create((DialogObj)setDialog, "\u8bbe\u7f6e");
        dialog.launch();
    }

    private MProps initPropWithoutPost(String userId) {
        try {
            MProps mProps = new MProps();
            Path dataPath = Paths.get(String.valueOf(this.basePath) + File.separator + "data" + File.separator + userId + File.separator + userId + ".properties", new String[0]);
            File file = dataPath.toFile();
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!file.exists()) {
                new File(String.valueOf(this.basePath) + File.separator + "data" + File.separator + userId + File.separator + userId + ".properties").createNewFile();
            }
            mProps.load(file);
            return mProps;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

