/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPartyApi;
import cms.tmx.api.mng.IPostApi;
import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.api.mng.IUserApi;
import cms.tmx.api.trade.ITradePushApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.utils.DesEncrypt;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.define.BsDict;
import cms.tmx.entity.Post;
import cms.tmx.entity.notice.SyncExtSecAccntsResp;
import cms.tmx.entity.web.algo.WebOpUser;
import cms.tmx.http.update.api.UpdateApi;
import cms.tmx.http.update.dto.CheckVersionResp;
import cms.tmx.http.update.dto.CheckVersionResult;
import cms.tmx.utils.CommUtils;
import cms.tmx.utils.MD5Utils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class LoginModel {
    private static final Logger logger = LogManager.getLogger(LoginModel.class);
    @Inject
    private IUserApi userApi;
    @Inject
    private IBaseApi iBaseApi;
    @Inject
    private IPostApi postApi;
    @Inject
    private IPartyApi partyApi;
    @Inject
    private ISecAccountApi secApi;
    @Inject
    private MEventService es;
    @Inject
    private MConfService cs;
    @Inject
    private HttpClientService http;
    private Gson gson = new Gson();
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private BooleanProperty done = new SimpleBooleanProperty(false);
    private StringProperty desc = new SimpleStringProperty("");
    private IntegerProperty per = new SimpleIntegerProperty(0);
    private BooleanProperty logging = new SimpleBooleanProperty(false);
    private BooleanProperty needUpdate = new SimpleBooleanProperty(true);
    private String userName = "";
    private String password = "";
    private String marketGrp = "";
    private long lastTime = 0L;
    private int seq = 0;
    private ReentrantLock lock = new ReentrantLock();
    private Condition cond = this.lock.newCondition();
    @Inject
    private ExecutorService exe;
    @Inject
    private UpdateApi updateApi;
    @Inject
    private ITradePushApi trdApi;

    @PostConstruct
    private void init() {
        this.es.subscribe("auto_relogin", event -> this.relogin());
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    public MEvent login(String user, String passwd) throws MException {
        this.userName = user;
        this.password = passwd;
        this.eCore.put((Object)"user_login", (Object)user);
        return this.userApi.userLogin(user, passwd);
    }

    public MEvent loginPro(String user, String passwd, String marketGrp) throws MException {
        this.userName = user;
        this.password = passwd;
        this.marketGrp = marketGrp;
        this.eCore.put((Object)"user_login", (Object)user);
        return this.userApi.personalUserLogin(user, passwd, marketGrp);
    }

    public String getIdByName(String name) throws MException {
        return this.userApi.getIdByName(name);
    }

    private void relogin() {
        long now = System.currentTimeMillis();
        if (now - this.lastTime < 10000L) {
            return;
        }
        this.lastTime = now;
        try {
            logger.info("\u89e6\u53d1\u4e86\u65ad\u7ebf\u91cd\u767b");
            if (this.eCore.getInt("client.type") == 1) {
                this.loginPro(this.userName, this.password, this.marketGrp);
            } else {
                this.login(this.userName, this.password);
            }
            logger.info("\u65ad\u7ebf\u91cd\u767b\u6210\u529f");
            this.es.sendEvent("requery_data", null);
            this.buildWebOpUser();
        }
        catch (MException e) {
            logger.error("session\u8fc7\u671f\u81ea\u52a8\u91cd\u65b0\u767b\u5f55\u5931\u8d25" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFourceUpdate(String local) {
        boolean begin = false;
        String hisUrl = this.cs.getProps("client.properties").getDesValue("history_url");
        if (StringUtils.isEmpty((String)hisUrl)) {
            return false;
        }
        try {
            String string = this.http.getAppVersionHisList(hisUrl, false);
            if (string == null) {
                return false;
            }
            string = string.replaceAll("\\n", "");
            String[] split = string.split(";");
            int i = 0;
            while (true) {
                if (i >= split.length) {
                    return false;
                }
                if (!split[i].trim().isEmpty()) {
                    if (begin && "true".equals(split[i].split(",")[1])) {
                        return true;
                    }
                    if (local.equals(split[i].split(",")[0])) {
                        begin = true;
                    }
                }
                ++i;
            }
        }
        catch (MException e) {
            logger.error("\u83b7\u53d6\u7248\u672c\u5386\u53f2\u5931\u8d25", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error("updateHistoryUrl\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
        }
        return false;
    }

    public CheckVersionResult getVersion(String localVersion) {
        CheckVersionResult result = new CheckVersionResult();
        try {
            String version = this.http.getAppVersion(DesEncrypt.decrypt((String)this.cs.getValue("update_url"), (String)"SsdfDfdLfFgAsJafSFgasN2f14wfe"), false);
            logger.info("http version " + version);
            if (version == null || localVersion.isEmpty() || localVersion.trim().equals(version.trim())) {
                logger.info("local version " + localVersion);
                return result;
            }
            if (!"client_version".equals(version)) {
                if (this.isFourceUpdate(localVersion)) {
                    result.setNeedUpdate(true);
                    result.setForceUpdate(true);
                    return result;
                }
                CheckVersionResp checkVersion = this.updateApi.checkVersion("V" + localVersion, CommUtils.getMAC());
                if (checkVersion.getUpdateFlag() == 1) {
                    result.setNeedUpdate(true);
                } else {
                    result.setNeedUpdate(false);
                }
                return result;
            }
        }
        catch (MException | Exception e) {
            logger.error("\u68c0\u6d4b\u66f4\u65b0\u5931\u8d25", e);
            result.setNeedUpdate(false);
            result.setRemark("\u68c0\u6d4b\u66f4\u65b0\u5931\u8d25\uff0c\u82e5\u9700\u5347\u7ea7\u8bf7\u5728\u5b98\u7f51\u4e0b\u8f7d\u6700\u65b0\u7248\u672c\u3002");
        }
        return result;
    }

    public CheckVersionResult checkVersion(String version, String mac) {
        CheckVersionResult result = new CheckVersionResult();
        try {
            CheckVersionResp checkVersion = this.updateApi.checkVersion(version, mac);
            if (checkVersion.getUpdateFlag() == 1) {
                result.setNeedUpdate(true);
            } else {
                result.setNeedUpdate(false);
            }
        }
        catch (MException e) {
            logger.error("\u68c0\u6d4b\u66f4\u65b0\u5931\u8d25", (Throwable)e);
        }
        result.setNeedUpdate(false);
        result.setRemark("\u68c0\u6d4b\u66f4\u65b0\u5931\u8d25\uff0c\u8054\u7cfb\u5ba2\u670d\u4eba\u5458\u6216\u5230\u5b98\u7f51\u4e0b\u8f7d\u6700\u65b0\u7248\u5ba2\u6237\u7aef\u3002");
        return result;
    }

    public void onLogin(String userId, Post post) throws MException, InterruptedException {
        this.setLoginProgress(8, "\u5f00\u59cb\u767b\u5f55");
        this.setLoginProgress(9, "\u5f00\u59cb\u6821\u9a8c\u804c\u4f4dip mac\u6743\u9650");
        this.checkPostIpMac(userId, post.getId());
        this.setLoginProgress(9, "\u6821\u9a8c\u804c\u4f4dip mac\u6743\u9650\u5b8c\u6210");
        this.setLoginProgress(10, "\u5f00\u59cb\u6821\u9a8c\u673a\u6784ip mac\u6743\u9650");
        this.checkPartyIpMac(userId, post.getId(), post.getPartyId());
        this.setLoginProgress(10, "\u6821\u9a8c\u673a\u6784ip mac\u6743\u9650\u5b8c\u6210");
        this.storeInfo(userId, post);
        this.trdApi.subscribe();
        this.es.sendEvent("stage.after.sub", null);
        this.checkSecAccnt();
        this.setLoginProgress(11, "\u6b63\u5728\u67e5\u8be2\u529f\u80fd\u6743\u9650\u83dc\u5355");
        MEvent eCall = new MEvent();
        this.es.sendEvent("query.menus", eCall);
        if (!eCall.isOK()) {
            throw new MException(eCall);
        }
        this.setLoginProgress(20, "\u67e5\u8be2\u529f\u80fd\u6743\u9650\u83dc\u5355\u5b8c\u6210");
        this.initClient();
    }

    private void checkSecAccnt() throws MException, InterruptedException {
        if (this.eCore.getInt("client.type") == 1) {
            this.seq = (int)(Math.random() * 1.0E8);
            this.lock.lock();
            try {
                logger.info("\u5f00\u59cb\u67e5\u8be2\u8bc1\u5238\u8d26\u53f7\u4fe1\u606f");
                PBase.OpStatus status = this.secApi.syncExtsecAccnts(this.userName, this.marketGrp, this.seq);
                if (status.getStatus() == 11) {
                    System.err.println("\u6b63\u5728\u540c\u6b65\u8bc1\u5238\u8d26\u53f7\u4fe1\u606f");
                    this.setLoginProgress(10, "\u6b63\u5728\u540c\u6b65\u8bc1\u5238\u5e10\u53f7\u4fe1\u606f");
                    boolean flag = this.cond.await(5000L, TimeUnit.MILLISECONDS);
                    if (!flag) {
                        throw new MException(1, "\u540c\u6b65\u8bc1\u5238\u8d26\u53f7\u8d85\u65f6");
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void onPush(MEvent event) {
        if (!(event.getObj() instanceof SyncExtSecAccntsResp)) {
            return;
        }
        SyncExtSecAccntsResp resp = (SyncExtSecAccntsResp)SyncExtSecAccntsResp.class.cast(event.getObj());
        if (resp.getReport().getSeq() != this.seq) {
            logger.error("local:" + this.seq + ",receive:" + resp.getReport().getSeq());
            return;
        }
        this.lock.lock();
        try {
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initClient() {
        this.initProxy();
        this.setLoginProgress(30, "\u6b63\u5728\u521d\u59cb\u5316\u5ba2\u6237\u7aef\u63d2\u4ef6");
        this.es.sendEvent("stage.pre.login", null);
        this.setLoginProgress(40, "\u521d\u59cb\u5316\u5ba2\u6237\u7aef\u63d2\u4ef6\u6210\u529f");
        this.setLoginProgress(50, "\u6b63\u5728\u5207\u6362UI\u89c6\u56fe");
        this.es.sendEvent("ui.switch", this.eCore);
        this.setLoginProgress(70, "\u5207\u6362UI\u89c6\u56fe\u6210\u529f");
        this.setLoginProgress(99, "\u6b63\u5728\u6821\u9a8c\u7528\u6237\u6743\u9650");
        this.es.sendEvent("check.rights", null);
        this.setLoginProgress(100, "\u6821\u9a8c\u7528\u6237\u6743\u9650\u6210\u529f");
        this.es.sendEvent("check.rights.down", null);
        this.setDone(true);
    }

    public void setLoginProgress(int per, String desc) {
        Platform.runLater(() -> {
            this.setPer(per);
            this.setDesc(desc);
        });
    }

    private void storeInfo(String userId, Post post) {
        this.iBaseApi.setUserId(userId);
        this.iBaseApi.setPostId(post.getId());
        this.iBaseApi.setPartyId(post.getPartyId());
        this.iBaseApi.setPwd(MD5Utils.MD5((String)this.password).toLowerCase());
        try {
            String name = this.userApi.getActiveUser().getUserName();
            this.eCore.put((Object)"user_name", (Object)name);
            this.eCore.put((Object)"user_id", (Object)userId);
            this.eCore.put((Object)"post_id", (Object)post.getId());
            this.eCore.put((Object)"post_name", (Object)post.getName());
            this.eCore.put((Object)"party_name", (Object)post.getPartyName());
        }
        catch (MException e) {
            logger.error("get user name failed", (Throwable)e);
        }
        this.exe.execute(() -> {
            try {
                this.iBaseApi.setOsv(CommUtils.getOSV());
                this.iBaseApi.setVol(CommUtils.getVolNew());
                this.iBaseApi.setPcn(CommUtils.getPCName());
                this.iBaseApi.setCpu(CommUtils.getCPUSerial());
                this.iBaseApi.setPi(CommUtils.getPI());
                this.buildWebOpUser();
            }
            catch (Throwable e) {
                logger.error("get pc info failed:", e);
            }
        });
    }

    private void buildWebOpUser() {
        if (this.eCore.get((Object)"SESSION_ID") != null) {
            WebOpUser webOpUser = new WebOpUser();
            webOpUser.setUserId(this.iBaseApi.getUserId());
            webOpUser.setPostId(this.iBaseApi.getPostId());
            String userName = "";
            try {
                userName = this.userApi.getActiveUser().getUserName();
            }
            catch (MException | Exception e) {
                logger.error("\u83b7\u53d6\u7528\u6237\u540d\u51fa\u9519", e);
            }
            webOpUser.setUserName(userName);
            webOpUser.setUuid(this.eCore.getStr("uuid"));
            webOpUser.setSessionId((byte[])this.eCore.get((Object)"SESSION_ID"));
            webOpUser.setIp(this.eCore.get((Object)"ip") == null ? CommUtils.getIP() : (String)this.eCore.get((Object)"ip"));
            webOpUser.setMac(CommUtils.getMAC());
            webOpUser.setSn(CommUtils.getSerialNumber());
            webOpUser.setLocalIp(CommUtils.getIP());
            webOpUser.setCpu(CommUtils.getCPUSerial());
            webOpUser.setPort(String.valueOf(this.eCore.getInt("port")));
            webOpUser.setSno("");
            webOpUser.setPcn(CommUtils.getPCName());
            webOpUser.setPi(CommUtils.getPI());
            webOpUser.setVol(CommUtils.getVolNew());
            webOpUser.setOsv(CommUtils.getOSV());
            webOpUser.setTerminalType("PC");
            webOpUser.setTerminalName("T-master");
            webOpUser.setTerminalVersion("V" + this.cs.getProps("client.properties").getDesValue("client_version"));
            Integer level = (Integer)BsDict.LogMap.get(LogManager.getRootLogger().getLevel().toString());
            if (level != null) {
                webOpUser.setLogLevel(level.intValue());
            }
            this.eCore.put((Object)"op_user", (Object)webOpUser);
        }
    }

    private boolean isProxy() {
        return "http".equalsIgnoreCase(this.cs.getUserProps().get("proxy.type"));
    }

    public void initProxy() {
        final String proxyIP = this.cs.getUserProps().get("proxy.ip");
        final String proxyPort = this.cs.getUserProps().get("proxy.port");
        logger.info("proxyIP" + proxyIP);
        logger.info("proxyPort" + proxyPort);
        if (!this.isProxy() || "".equals(proxyPort)) {
            return;
        }
        ProxySelector.setDefault(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                ArrayList<Proxy> list = new ArrayList<Proxy>();
                if (!"".equals(proxyPort)) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyIP, (int)Integer.valueOf(proxyPort)));
                    list.add(proxy);
                }
                return list;
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException e) {
                logger.error("\u65e0\u6cd5\u8fde\u63a5\u5230\u4ee3\u7406\uff01", (Throwable)e);
            }
        });
    }

    public void checkPostIpMac(String userId, String postId) throws MException {
        this.postApi.checkPostIpAndMac(postId, userId);
    }

    public void checkPartyIpMac(String userId, String postId, String partyId) throws MException {
        this.partyApi.checkParyIpAndMac(postId, userId, partyId);
    }

    public final BooleanProperty doneProperty() {
        return this.done;
    }

    public final boolean isDone() {
        return this.doneProperty().get();
    }

    public final void setDone(boolean done) {
        this.doneProperty().set(done);
    }

    public final StringProperty descProperty() {
        return this.desc;
    }

    public final String getDesc() {
        return (String)this.descProperty().get();
    }

    public final void setDesc(String desc) {
        this.descProperty().set((Object)desc);
    }

    public final IntegerProperty perProperty() {
        return this.per;
    }

    public final int getPer() {
        return this.perProperty().get();
    }

    public final void setPer(int per) {
        this.perProperty().set(per);
    }

    public final BooleanProperty loggingProperty() {
        return this.logging;
    }

    public final boolean isLogging() {
        return this.loggingProperty().get();
    }

    public final void setLogging(boolean logging) {
        this.loggingProperty().set(logging);
    }

    public final BooleanProperty needUpdateProperty() {
        return this.needUpdate;
    }

    public final boolean isNeedUpdate() {
        return this.needUpdateProperty().get();
    }

    public final void setNeedUpdate(boolean needUpdate) {
        this.needUpdateProperty().set(needUpdate);
    }

    public void logout(String userId) {
        if (StringUtils.isEmpty((String)this.iBaseApi.getPostId())) {
            return;
        }
        this.iBaseApi.setUserId(userId);
        this.logout();
    }

    public void logout() {
        if (StringUtils.isEmpty((String)this.iBaseApi.getPostId())) {
            return;
        }
        try {
            if (this.eCore.getInt("client.type") == 1) {
                this.userApi.personalUserLogout();
            } else {
                this.userApi.userLogout();
            }
        }
        catch (MException e) {
            logger.error("\u5ba2\u6237\u7aef\u767b\u51fa\u540e\u53f0\u5931\u8d25", (Throwable)e);
        }
    }
}

