/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import cms.tmx.core.MConfService;
import cms.tmx.core.MProps;
import cms.tmx.javafx.utils.FxUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class LoginConfMng {
    @Inject
    private MConfService cs;
    private ObservableList<String> userList = FxUtils.newList();
    private ObservableList<String> ipList = FxUtils.newList();
    private ObservableList<String> addressList = FxUtils.newList();
    private ObservableMap<String, ObservableList<String>> addressMap = FxUtils.newMap();
    private List<String> retryList = new LinkedList<String>();
    private String id;
    private String ip;
    private String port;
    private String proxyType;
    private String proxyIPAddress;
    private String proxyPort;
    private String proxyUserName;
    private String proxyPassword;
    private MProps props;

    @PostConstruct
    public void init() {
        this.props = this.cs.getUserProps();
        this.addressList.setAll((Collection)this.props.getDesValues("address"));
        int i = 0;
        while (i < this.addressList.size()) {
            String[] split = ((String)this.addressList.get(i)).split(":");
            if (this.addressMap.get((Object)split[0]) == null) {
                ObservableList list = FxUtils.newList();
                list.add((Object)split[1]);
                this.addressMap.put((Object)split[0], (Object)list);
            } else if (!((ObservableList)this.addressMap.get((Object)split[0])).contains((Object)split[1])) {
                ((ObservableList)this.addressMap.get((Object)split[0])).add((Object)split[1]);
            }
            this.retryList.add(String.valueOf(split[0]) + "_" + split[1]);
            ++i;
        }
        this.userList.setAll((Collection)this.props.getValues("users"));
        this.ipList.setAll((Collection)this.addressMap.keySet());
        this.id = this.props.get("user");
        this.ip = this.props.getDesValue("uap.server.ip");
        this.port = this.props.get("uap.server.port");
        this.proxyType = this.props.get("proxy.type");
        this.proxyIPAddress = this.props.get("proxy.ip");
        this.proxyPort = this.props.get("proxy.port");
        this.proxyUserName = this.props.get("proxy.username");
        this.proxyPassword = this.props.get("proxy.password");
    }

    public void saveServerInfo() {
        if (!this.ipList.contains((Object)this.ip)) {
            this.ipList.add((Object)this.ip);
        }
        if (this.addressMap.get((Object)this.ip) == null) {
            ObservableList newList = FxUtils.newList();
            newList.add((Object)this.port);
            this.addressMap.put((Object)this.ip, (Object)newList);
        } else if (!((ObservableList)this.addressMap.get((Object)this.ip)).contains((Object)this.port)) {
            ((ObservableList)this.addressMap.get((Object)this.ip)).add((Object)this.port);
        }
        this.retryList.add(String.valueOf(this.ip) + "_" + this.port);
        this.retryList = this.retryList.stream().distinct().collect(Collectors.toList());
        this.ipList.stream().forEach(ip -> {
            if (((ObservableList)this.addressMap.get(ip)).size() == 0) {
                this.removeIp((String)ip);
                this.ipList.remove(ip);
            }
        });
        this.props.setDesValues("address", this.addressMap);
        this.props.setDesValue("uap.server.ip", (Object)this.ip);
        this.props.setValue("uap.server.port", (Object)this.port);
        this.props.setValue("proxy.type", (Object)this.proxyType);
        this.props.setValue("proxy.ip", (Object)this.proxyIPAddress);
        this.props.setValue("proxy.port", (Object)this.proxyPort);
        this.props.setValue("proxy.username", (Object)this.proxyUserName);
        this.props.setValue("proxy.password", (Object)this.proxyPassword);
    }

    public void saveUserInfo() {
        if (!this.userList.contains((Object)this.id)) {
            this.userList.add((Object)this.id);
        }
        this.props.setValues("users", this.userList);
        this.props.setValue("user", (Object)this.id);
    }

    public ObservableList<String> getUserList() {
        return this.userList;
    }

    public void setUserList(List<String> list) {
        this.props.setValues("users", list);
    }

    public ObservableList<String> getIpList() {
        return this.ipList;
    }

    public void setIpList(List<String> list) {
        this.props.setValues("ips", this.ipList);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }

    public String getPproxyIPAddress() {
        return this.proxyIPAddress;
    }

    public void setProxyIPAddress(String proxyIPAddress) {
        this.proxyIPAddress = proxyIPAddress;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public ObservableList<String> getPortList(String ip) {
        return (ObservableList)this.addressMap.get((Object)ip);
    }

    public void removeIp(String ip) {
        this.addressMap.remove((Object)ip);
        this.retryList.removeIf(s -> s.contains(ip));
    }

    public void removePort(String ip, String port) {
        if (this.addressMap.get((Object)ip) != null) {
            this.addressMap.remove((Object)port);
        }
        this.retryList.removeIf(s -> s.contains(port));
    }

    public List<String> getRetryList() {
        return this.retryList;
    }

    public void setRetryList(List<String> retryList) {
        this.retryList = retryList;
    }
}

