/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.login;

import cms.tmx.control.dialog.MxAlert;
import java.util.Optional;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class LoginAlert
extends MxAlert {
    @Inject
    private Stage stage;
    private String S = "";
    private int tmp = 300;

    public Button getButton(Alert alert, ButtonType type) {
        Node node = alert.getDialogPane().lookupButton(type);
        if (node instanceof Button) {
            Button btn = (Button)Button.class.cast(node);
            return btn;
        }
        return null;
    }

    public boolean alertLockInfo(Alert.AlertType type, String info, String time) {
        Alert alert = new Alert(type);
        alert.initOwner((Window)this.stage);
        alert.setTitle("\u63d0\u793a");
        alert.setHeaderText(null);
        this.tmp = Integer.parseInt(time);
        this.S = LoginAlert.secToTime(this.tmp);
        alert.setContentText(String.valueOf(info) + this.S + ")");
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), e -> {
            --this.tmp;
            if (this.tmp >= 0) {
                this.S = LoginAlert.secToTime(this.tmp);
                alert.setContentText(String.valueOf(info) + this.S + ")");
            }
        }, new KeyValue[0])});
        animation.setCycleCount(-1);
        animation.play();
        Button button = this.getButton(alert, ButtonType.CANCEL);
        if (button != null) {
            button.setOnKeyPressed(event -> {
                if (KeyCode.ENTER.equals((Object)event.getCode())) {
                    animation.stop();
                    button.fire();
                }
            });
        }
        Optional result = alert.showAndWait();
        animation.stop();
        if (Alert.AlertType.CONFIRMATION == type) {
            return ButtonType.OK == result.get();
        }
        return false;
    }

    public static String secToTime(int time) {
        String timeStr = null;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (time <= 0) {
            return "00:00:00";
        }
        minute = time / 60;
        hour = minute / 60;
        if (hour > 99) {
            return "99:59:59";
        }
        second = time - hour * 3600 - (minute %= 60) * 60;
        timeStr = String.valueOf(LoginAlert.unitFormat(hour)) + ":" + LoginAlert.unitFormat(minute) + ":" + LoginAlert.unitFormat(second);
        return timeStr;
    }

    public static String unitFormat(int i) {
        String retStr = null;
        retStr = i >= 0 && i < 10 ? "0" + Integer.toString(i) : "" + i;
        return retStr;
    }
}

