/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.heartbeat;

import cms.tmx.api.mng.ICommApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.javafx.MxModel;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HeartBeatMng
extends MxModel {
    private static final int MIN_SERVER_HEART_BEAT_INTERVAL = 1000;
    private static final int DEFAULT_SERVER_HEART_BEAT_INTERVAL = 10000;
    private BooleanProperty connected = new SimpleBooleanProperty(true);
    @Inject
    private ICommApi apiComm;
    @Inject
    private MEventService es;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private MConfService cs;
    private ScheduledFuture<?> futureHB;
    private int interval;
    private AtomicBoolean initF = new AtomicBoolean(false);

    @PostConstruct
    public void init() {
        this.interval = this.cs.getValueAsInt("server.hb.interval", 10000);
        if (this.interval < 1000) {
            this.interval = 1000;
        }
        this.es.subscribe("stage.after.login", event -> this.afterLogin(event));
        this.es.subscribe("stage.after.sub", event -> this.afterLogin(event));
    }

    @PreDestroy
    private void close() {
        if (this.futureHB != null) {
            this.futureHB.cancel(true);
        }
    }

    private void afterLogin(MEvent event) {
        if (!this.initF.get()) {
            this.initF.getAndSet(true);
            this.initHeartBeat();
        }
    }

    private void initHeartBeat() {
        this.es.subscribe("server.connected", eComm -> this.onServerConnected(eComm, true));
        this.es.subscribe("server.disconnected", eComm -> this.onServerConnected(eComm, false));
    }

    private synchronized void onServerConnected(MEvent event, boolean connected) {
        String serverType = event.getStr("server_type");
        if (!serverType.equals("default")) {
            return;
        }
        this.heartBeat();
    }

    public synchronized void heartBeat() {
        boolean bRet = this.doHeartBeat();
        if (bRet) {
            this.logger.debug("[HB Manager] hb ok");
            if (!this.isConnected()) {
                this.es.postEvent("server.hb.reconnected", null);
            }
            this.setConnected(true);
            this.es.postEvent("server.hb.ok", null);
        } else {
            this.logger.error("[HB Manager] hb fail");
            if (this.isConnected()) {
                this.es.postEvent("server.hb.disconnected", null);
            }
            this.setConnected(false);
            this.es.postEvent("server.hb.fail", null);
        }
    }

    private boolean doHeartBeat() {
        return this.apiComm.heartbeatReq();
    }

    public final BooleanProperty connectedProperty() {
        return this.connected;
    }

    public final boolean isConnected() {
        return this.connectedProperty().get();
    }

    public final void setConnected(boolean connected) {
        this.connectedProperty().set(connected);
    }
}

