/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage;

import cms.tmx.core.MAddon;
import cms.tmx.core.MEventService;
import cn.hutool.system.SystemUtil;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.stage.Stage;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.event.Event;

@Creatable
@Singleton
public class MonitorAddon
extends MAddon {
    private Logger logger = LogManager.getLogger(MonitorAddon.class);
    @Inject
    private EModelService ms;
    @Inject
    private MApplication app;
    @Inject
    private MEventService es;
    @Inject
    private ScheduledExecutorService schedule;
    @Inject
    @Named(value="fixed.post.pool")
    protected ExecutorService postPool;

    @PostConstruct
    public void init() {
        super.loadDone();
        this.schedule.scheduleWithFixedDelay(() -> this.postThreadPoolLog(), 0L, 30000L, TimeUnit.MILLISECONDS);
    }

    private void postThreadPoolLog() {
        if (this.postPool == null || !(this.postPool instanceof ExecutorService)) {
            return;
        }
        this.logger.info("====== > post cached pool info < ======");
        ThreadPoolExecutor postCache = (ThreadPoolExecutor)ThreadPoolExecutor.class.cast(this.postPool);
        int queueSize = postCache.getQueue().size();
        this.logger.info("=== > queued tasks : " + queueSize);
        int activeCount = postCache.getActiveCount();
        this.logger.info("=== > active threads : " + activeCount);
        long completedTaskCount = postCache.getCompletedTaskCount();
        this.logger.info("=== > completed tasks : " + completedTaskCount);
        long taskCount = postCache.getTaskCount();
        this.logger.info("=== > total tasks : " + taskCount);
        this.logger.info("\u8fd0\u884c\u671f\u5185\u5b58\u72b6\u6001" + SystemUtil.getRuntimeInfo());
    }

    private void logStackTrace(Thread thread) {
        if (thread == null) {
            return;
        }
        StackTraceElement[] stackElements = thread.getStackTrace();
        if (stackElements != null) {
            int i = 0;
            while (i < stackElements.length) {
                System.err.println(String.valueOf(stackElements[i].getClassName()) + "/t");
                System.err.println(String.valueOf(stackElements[i].getFileName()) + "/t");
                System.err.println(String.valueOf(stackElements[i].getLineNumber()) + "/t");
                System.err.println(stackElements[i].getMethodName());
                System.err.println("-----------------------------------");
                ++i;
            }
        }
    }

    @Inject
    @Optional
    public void applicationStarted(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/appStartupComplete") Event event) {
        this.startMonitor();
        this.es.sendEvent("application.start", null);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.logger.info("shutdown hook start");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.logger.error("shut down hook thread exception", (Throwable)e);
            }
            this.logger.info("halt start");
            Runtime.getRuntime().halt(0);
        }));
    }

    @Inject
    @Optional
    public void applicationStopping(@EventTopic(value="org/eclipse/e4/ui/LifeCycle/appShutdownStarted") Event event) {
        this.logger.info("app shutdown start");
    }

    private void startMonitor() {
        Thread t = new Thread(() -> this.monitor());
        t.setDaemon(true);
        t.start();
    }

    private void monitor() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(5000L);
                    if (this.checkAlive()) continue;
                    Thread.sleep(1000L);
                    this.logger.error("force kill start");
                    this.killProc();
                    this.logger.error("force kill end");
                }
            }
            catch (InterruptedException e) {
                this.logger.error("monitor thread exception", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private boolean checkAlive() {
        boolean loginAlive;
        MWindow winMain = (MWindow)this.ms.findElements((MUIElement)this.app, "cms.tmx.twin.main", MWindow.class, null).get(0);
        MWindow winLogin = (MWindow)this.ms.findElements((MUIElement)this.app, "cms.tmx.twin.login", MWindow.class, null).get(0);
        List windows = this.ms.findElements((MUIElement)this.app, "cms.tmx.twin.login.pro", MWindow.class, null);
        MWindow professionalWinLogin = null;
        if (windows != null && !windows.isEmpty()) {
            professionalWinLogin = (MWindow)windows.get(0);
        }
        boolean mainAlive = this.isWindowAlive(winMain);
        boolean bl = loginAlive = this.isWindowAlive(winLogin) || this.isWindowAlive(professionalWinLogin);
        return mainAlive || loginAlive;
    }

    private boolean isWindowAlive(MWindow win) {
        if (win != null && win.getContext() != null) {
            Stage stage = (Stage)win.getContext().get(Stage.class);
            if (win.isToBeRendered() && stage != null && stage.isShowing()) {
                return true;
            }
        }
        return false;
    }

    private void killProc() {
        String[] cmd = new String[]{"cmd", "/C", ""};
        String id = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        cmd[2] = "taskkill /pid " + id + " -t -f ";
        try {
            this.logger.error("start kill process: " + cmd[2]);
            Runtime.getRuntime().exec(cmd);
            this.logger.error("kill process complete");
        }
        catch (IOException e) {
            this.logger.error("kill process fail", (Throwable)e);
        }
    }
}

