/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.views;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MProps;
import cms.tmx.file.order.entity.DocOrderParamSet;
import cms.tmx.file.order.entity.DocScanAndOrderRecord;
import cms.tmx.file.order.model.DocScanAndOrderRecordModel;
import cms.tmx.file.order.model.ScanFileOrderParamSetModel;
import cms.tmx.file.order.utils.ScanModeGlobalKeyListener;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.notification.MessagePromptTabContent;
import cms.tmx.utils.DateTimeUtils;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleGroup;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.jnativehook.GlobalScreen;
import org.jnativehook.keyboard.NativeKeyListener;

public class ScanFileOrderPart
extends MxPart {
    private static org.apache.logging.log4j.Logger logger = LogManager.getLogger(ScanFileOrderPart.class);
    @FXML
    private ComboBox<String> cmbRequestDir;
    @FXML
    private Button btnEntrustDir;
    @FXML
    private ComboBox<String> cmbResponseDir;
    @FXML
    private Button btnResDir;
    @FXML
    private RadioButton rdoResSingleFile;
    @FXML
    private RadioButton rdoResMultiFile;
    @FXML
    private CheckBox cboxContentMoney;
    @FXML
    private CheckBox cboxContentPosition;
    @FXML
    private CheckBox cboxContentEntrust;
    @FXML
    private CheckBox cboxContentDeal;
    @FXML
    private Button btnStartOrStop;
    @FXML
    private TableView<DocScanAndOrderRecord> tableDoc;
    @FXML
    private TableColumn<DocScanAndOrderRecord, String> fileName;
    @FXML
    private TableColumn<DocScanAndOrderRecord, String> startTime;
    @FXML
    private TableColumn<DocScanAndOrderRecord, String> endTime;
    @FXML
    private Tab tabAlert;
    private final ToggleGroup resGroup = new ToggleGroup();
    @Inject
    private DocOrderParamSet param;
    @Inject
    private ScanFileOrderParamSetModel setModel;
    @Inject
    private MxAlert alert;
    @Inject
    private DocScanAndOrderRecordModel docScanAndOrderRecordModel;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    @Inject
    private IBaseApi iba;
    private MProps props = new MProps();
    private boolean isNew = false;
    @Inject
    private MObjFactory of;
    private volatile boolean isScanning = false;
    private ScanModeGlobalKeyListener listener = null;
    private ChangeListener<Boolean> requestDirFocused = (ob, old, now) -> this.onEntrustDirFocused((boolean)now);
    private ChangeListener<String> requestDirChange = (ob, old, now) -> this.onReqDirChange((ObservableValue<? extends String>)ob, (String)old, (String)now);
    private ChangeListener<Boolean> responseDirFocused = (ob, old, now) -> this.onResponseDirFocused((boolean)now);
    private ChangeListener<String> responseDirChange = (ob, old, now) -> this.onResDirChange((ObservableValue<? extends String>)ob, (String)old, (String)now);
    private ChangeListener<String> paramEntruDirListener = (ob, old, now) -> this.onParamEntruDirChange((String)now);
    private ChangeListener<String> paramResDirListener = (ob, old, now) -> this.onParamResDirChange((String)now);
    private ChangeListener<Boolean> paramResponseModelListener = (ob, old, now) -> this.onParamResponseModelChange((Boolean)now);

    @FXML
    public void initialize() {
        try {
            this.loadProps();
        }
        catch (IOException e) {
            logger.error("\u52a0\u8f7d\u626b\u5355\u6a21\u5f0f\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        this.initListenner();
        this.initBind();
        this.initValue();
        this.createDocTable();
        this.addHotKey();
        this.setSubscribe(true);
        this.docScanAndOrderRecordModel.setWorkMode("scan.work.mode");
        this.eCore.put((Object)"scan.response.model", (Object)(this.param.isResponseModel() ? "monofile" : "multifile"));
        MessagePromptTabContent content = (MessagePromptTabContent)this.of.create(MessagePromptTabContent.class);
        this.tabAlert.setContent((Node)content.getContent());
    }

    private void setSubscribe(boolean status) {
        logger.error("\u626b\u5355\uff0c \u542f\u52a8\u7528\u6237\u8ba2\u9605, status:" + status);
        MEvent event = new MEvent();
        event.put((Object)"scan_subscribe_status", (Object)status);
        event.put((Object)"work.mode", (Object)"scan.work.mode");
        this.es.sendEvent("subscribe/res/info", event);
    }

    private void addHotKey() {
        Platform.runLater(() -> {
            try {
                GlobalScreen.registerNativeHook();
                logger.error("\u5168\u5c40\u5feb\u6377\u952e\u6ce8\u518c...");
                this.listener = (ScanModeGlobalKeyListener)((Object)((Object)this.of.create(ScanModeGlobalKeyListener.class)));
                this.listener.setHotKeyField(this.btnStartOrStop);
                java.util.logging.LogManager.getLogManager().reset();
                Logger l = Logger.getLogger(GlobalScreen.class.getPackage().getName());
                l.setLevel(Level.WARNING);
                GlobalScreen.addNativeKeyListener((NativeKeyListener)this.listener);
            }
            catch (Exception e) {
                logger.error("\u5168\u5c40\u5feb\u6377\u952e\u6ce8\u518c\u5931\u8d25", (Throwable)e);
                MEvent event = new MEvent();
                event.setDesc("\u6587\u4ef6\u5355\u7684\u5168\u5c40\u5feb\u6377\u952e\u6ce8\u518c\u5931\u8d25\uff01");
                this.es.postEvent("message.log", event);
            }
        });
    }

    public void loadProps() throws IOException {
        Path dataPath = Paths.get(String.valueOf(this.pathBase) + File.separator + "data" + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.iba.getPostId()) + "_ScanFile.properties");
        File file = dataPath.toFile();
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!file.exists()) {
            new File(String.valueOf(this.pathBase) + File.separator + "data" + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.iba.getPostId()) + "_ScanFile.properties").createNewFile();
            this.isNew = true;
            logger.info("props file is not exists, create props file:" + file);
        }
        this.props.load(file);
        logger.info("loading props file:" + file);
    }

    private void initBind() {
        this.cmbRequestDir.valueProperty().bindBidirectional((Property)this.param.entrustDirProperty());
        this.cmbResponseDir.valueProperty().bindBidirectional((Property)this.param.responseDirProperty());
        this.rdoResSingleFile.selectedProperty().bindBidirectional((Property)this.param.responseModelProperty());
    }

    private void initListenner() {
        this.cmbRequestDir.focusedProperty().addListener(this.requestDirFocused);
        this.cmbRequestDir.valueProperty().addListener(this.requestDirChange);
        this.cmbRequestDir.getEditor().textProperty().addListener(this.requestDirChange);
        this.cmbResponseDir.focusedProperty().addListener(this.responseDirFocused);
        this.cmbResponseDir.valueProperty().addListener(this.responseDirChange);
        this.cmbResponseDir.getEditor().textProperty().addListener(this.responseDirChange);
        this.param.responseModelProperty().addListener(this.paramResponseModelListener);
        this.param.entrustDirProperty().addListener(this.paramEntruDirListener);
        this.param.responseDirProperty().addListener(this.paramResDirListener);
    }

    private void onParamResponseModelChange(Boolean now) {
        logger.info("switch \u56de\u62a5\u6587\u4ef6\u7684\u6a21\u5f0f to:" + this.param.isResponseModel());
        this.eCore.remove((Object)"scan.response.model");
        this.eCore.put((Object)"scan.response.model", (Object)(this.param.isResponseModel() ? "monofile" : "multifile"));
    }

    @PreDestroy
    public void destroy() {
        logger.info("\u626b\u5355\u9875\u7b7e\u5173\u95ed\uff01");
        this.setSubscribe(false);
        if (this.listener != null) {
            GlobalScreen.removeNativeKeyListener((NativeKeyListener)this.listener);
        }
    }

    private void onParamResDirChange(String dir) {
        boolean isContains = this.cmbResponseDir.getItems().contains((Object)dir);
        if (!isContains) {
            this.props.setValue("response.saved.dirs", (Object)(String.valueOf(this.props.get("response.saved.dirs")) + dir + "|"));
            this.cmbResponseDir.getItems().add((Object)dir);
        }
        this.props.setValue("response.saved.dir", (Object)dir);
    }

    private void onParamEntruDirChange(String dir) {
        boolean isContains = this.cmbRequestDir.getItems().contains((Object)dir);
        if (!isContains) {
            this.cmbRequestDir.getItems().add((Object)dir);
            this.props.setValue("request.saved.dirs", (Object)(String.valueOf(this.props.get("request.saved.dirs")) + dir + "|"));
        }
        this.props.setValue("request.saved.dir", (Object)dir);
    }

    private void onResDirChange(ObservableValue<? extends String> ob, String old, String folder) {
        boolean isFocused = this.cmbResponseDir.isFocused();
        if (!isFocused && !"".equals(folder.trim())) {
            String scanReqPath = this.eCore.getStr("scan.req.req.folder");
            String scanRecPath = this.eCore.getStr("scan.rec.req.folder");
            String monitorResPath = this.eCore.getStr("monitor.res.req.folder");
            String monitorReqPath = this.eCore.getStr("monitor.req.req.folder");
            String monitorRecPath = this.eCore.getStr("monitor.rec.req.folder");
            logger.info("\u626b\u5355\u6a21\u5f0f\u4e0b\u8bf7\u6c42\u6587\u4ef6\u8def\u5f84\u66f4\u6539\uff1a\u8bf7\u6c42\u6587\u4ef6\u8def\u5f84\u2014\u2014folder:" + folder + ", scanResPath:" + monitorResPath + ", scanReqPath:" + scanReqPath + ", scanRecPath:" + scanRecPath + ",monitorReqPath:" + monitorReqPath + ", monitorRecPath:" + monitorRecPath);
            if (folder.equals(monitorResPath) || folder.equals(scanReqPath) || folder.equals(scanRecPath) || folder.equals(monitorReqPath) || folder.equals(monitorRecPath)) {
                logger.error("\u6587\u4ef6\u5355(\u76d1\u542c\u6a21\u5f0f)\u548c\u6587\u4ef6\u5355(\u626b\u5355\u6a21\u5f0f)\u4e0b\u7684\u76ee\u5f55\u5fc5\u987b\u90fd\u4e0d\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u5355(\u76d1\u542c\u6a21\u5f0f)\u548c\u6587\u4ef6\u5355(\u626b\u5355\u6a21\u5f0f)\u4e0b\u7684\u8bf7\u6c42\u76ee\u5f55\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
                });
                this.cmbResponseDir.setValue((Object)old);
                return;
            }
            this.eCore.remove((Object)"scan.res.req.folder");
            this.eCore.put((Object)"scan.res.req.folder", (Object)folder);
            File resFile = new File(folder);
            if (!resFile.exists()) {
                resFile.mkdirs();
            }
        }
    }

    private void onReqDirChange(ObservableValue<? extends String> ob, String old, String folder) {
        boolean isFocused = this.cmbRequestDir.isFocused();
        if (!isFocused && !"".equals(folder.trim())) {
            String monitorResPath = this.eCore.getStr("monitor.res.req.folder");
            String monitorReqPath = this.eCore.getStr("monitor.req.req.folder");
            String monitorRecPath = this.eCore.getStr("monitor.rec.req.folder");
            logger.info("\u626b\u5355\u6a21\u5f0f\u4e0b \u8bf7\u6c42\u6587\u4ef6\u8def\u5f84\u66f4\u6539\uff1a\u8bf7\u6c42\u6587\u4ef6\u8def\u5f84\u2014\u2014folder:" + folder + ", monitorResPath:" + monitorResPath + ", monitorReqPath:" + monitorReqPath + ", monitorRecPath:" + monitorRecPath);
            if (folder.equals(monitorRecPath) || folder.equals(monitorReqPath) || folder.equals(monitorResPath)) {
                logger.error("\u6587\u4ef6\u5355(\u76d1\u542c\u6a21\u5f0f)\u548c\u6587\u4ef6\u5355(\u626b\u5355\u6a21\u5f0f)\u4e0b\u7684\u8bf7\u6c42\u76ee\u5f55\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u5355(\u76d1\u542c\u6a21\u5f0f)\u548c\u6587\u4ef6\u5355(\u626b\u5355\u6a21\u5f0f)\u4e0b\u7684\u8bf7\u6c42\u76ee\u5f55\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
                });
                this.cmbRequestDir.setValue((Object)old);
                return;
            }
            File reqFile = new File(folder);
            this.eCore.remove((Object)"scan.req.req.folder");
            this.eCore.put((Object)"scan.req.req.folder", (Object)reqFile.getPath());
            if (!reqFile.exists()) {
                reqFile.mkdirs();
            }
            String parentPath = reqFile.getParent();
            this.onRequestDirChange(parentPath);
            this.createCopyDir(parentPath);
        }
    }

    private void onResponseDirFocused(boolean isFocused) {
        if (isFocused) {
            return;
        }
        String newPath = (String)this.cmbResponseDir.getValue();
        this.eCore.remove((Object)"scan.res.req.folder");
        this.eCore.put((Object)"scan.res.req.folder", (Object)newPath);
    }

    private void onEntrustDirFocused(boolean isFocused) {
        if (isFocused) {
            return;
        }
        String newPath = (String)this.cmbRequestDir.getValue();
        this.eCore.remove((Object)"scan.req.req.folder");
        this.eCore.put((Object)"scan.req.req.folder", (Object)newPath);
        File file = new File(newPath);
        if (file.isDirectory()) {
            this.onRequestDirChange(file.getParent());
            this.createCopyDir(file.getParent());
        }
    }

    private void createCopyDir(String newPath) {
        if (newPath == null || "".equals(newPath)) {
            return;
        }
        File recFile = new File(String.valueOf(newPath) + "\\record" + File.separator + DateTimeUtils.getDate());
        if (!recFile.exists()) {
            recFile.mkdir();
        }
        logger.info("\u626b\u5355 \u65b0\u7684\u5de5\u4f5c\u6587\u4ef6\u8def\u5f84\u2014\u2014" + recFile.getPath());
        this.eCore.remove((Object)"scan.rec.req.folder");
        this.eCore.put((Object)"scan.rec.req.folder", (Object)recFile.getPath());
        this.clearExpiredFile(String.valueOf(newPath) + "\\record");
    }

    private void initValue() {
        this.rdoResSingleFile.setToggleGroup(this.resGroup);
        this.rdoResMultiFile.setToggleGroup(this.resGroup);
        if (this.isNew) {
            String requestPath = String.valueOf(this.pathBase) + File.separator + "users" + File.separator + this.eCore.getStr("user_id") + File.separator + this.iba.getPostId() + "\\docOrder\\scan\\request";
            String responsePath = String.valueOf(this.pathBase) + File.separator + "users" + File.separator + this.eCore.getStr("user_id") + File.separator + this.iba.getPostId() + "\\docOrder\\scan\\response";
            String recordPath = String.valueOf(this.pathBase) + File.separator + "users" + File.separator + this.eCore.getStr("user_id") + File.separator + this.iba.getPostId() + "\\docOrder\\scan\\record";
            this.eCore.put((Object)"scan.req.req.folder", (Object)requestPath);
            this.eCore.put((Object)"scan.res.req.folder", (Object)responsePath);
            this.eCore.put((Object)"scan.rec.req.folder", (Object)(String.valueOf(recordPath) + File.separator + DateTimeUtils.getDate()));
            this.clearExpiredFile(recordPath);
            logger.info("\u7b2c\u4e00\u6b21\u6253\u5f00\u5f53\u524dpart scanpart");
            this.cmbRequestDir.getItems().add((Object)requestPath);
            this.cmbResponseDir.getItems().add((Object)responsePath);
            this.cmbResponseDir.setValue((Object)responsePath);
            this.cmbRequestDir.setValue((Object)requestPath);
            this.createDefaultDir(requestPath, responsePath, recordPath);
        } else {
            this.readSetConf();
        }
    }

    private void clearExpiredFile(String recordPath) {
        File[] listFiles;
        File file = new File(recordPath);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        Date date = calendar.getTime();
        File[] fileArray = listFiles = file.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                if (!f.isDirectory()) {
                    f.delete();
                } else if (sdf.parse(f.getName()).before(date)) {
                    FileUtil.deleteDir((File)f);
                }
            }
            catch (Exception e) {
                logger.error("\u5b9a\u671f\u6e05\u7406\u65e5\u5fd7\u6587\u4ef6\u5939\u51fa\u9519" + f.getName(), (Throwable)e);
            }
            ++n2;
        }
    }

    private void readSetConf() {
        ObservableList resDirList = FxUtils.newList();
        resDirList.addAll((Collection)this.props.getValues("response.saved.dirs"));
        String resSavedDir = this.props.get("response.saved.dir");
        this.cmbResponseDir.setItems(resDirList);
        this.cmbResponseDir.getSelectionModel().select((Object)resSavedDir);
        ObservableList reqDirList = FxUtils.newList();
        reqDirList.addAll((Collection)this.props.getValues("request.saved.dirs"));
        String reqSavedDir = this.props.get("request.saved.dir");
        this.cmbRequestDir.setItems(reqDirList);
        this.cmbRequestDir.getSelectionModel().select((Object)reqSavedDir);
        this.eCore.put((Object)"scan.req.req.folder", (Object)reqSavedDir);
        this.eCore.put((Object)"scan.res.req.folder", (Object)resSavedDir);
        File reqFile = new File(reqSavedDir);
        this.createCopyDir(reqFile.getParent());
    }

    private void createDefaultDir(String requestPath, String responsePath, String recordPath) {
        File reqFile = new File(requestPath);
        File resFile = new File(responsePath);
        File recFile = new File(recordPath);
        if (!reqFile.exists()) {
            reqFile.mkdirs();
        }
        if (!resFile.exists()) {
            resFile.mkdirs();
        }
        if (!recFile.exists()) {
            recFile.mkdirs();
        }
    }

    private void onRequestDirChange(String newPath) {
        if (newPath == null || "".equals(newPath)) {
            return;
        }
        String resDir = (String)this.cmbResponseDir.getValue();
        if (resDir == null || "".equals(resDir)) {
            File resFile = new File(String.valueOf(newPath) + "\\response");
            if (!resFile.exists()) {
                resFile.mkdir();
            }
            logger.info("\u626b\u5355 \u4fdd\u5b58\u65b0\u7684\u56de\u62a5\u76ee\u5f55" + newPath);
            this.cmbResponseDir.getItems().add((Object)resFile.getPath());
            this.cmbResponseDir.setValue((Object)resFile.getPath());
            this.eCore.remove((Object)"scan.res.req.folder");
            this.eCore.put((Object)"scan.res.req.folder", (Object)resFile.getPath());
        }
    }

    @FXML
    public void onEntrustDirChange() {
        File file;
        DirectoryChooser dirChooser = new DirectoryChooser();
        if (!((String)this.cmbRequestDir.getSelectionModel().getSelectedItem()).isEmpty() && (file = new File((String)this.cmbRequestDir.getSelectionModel().getSelectedItem())).exists()) {
            dirChooser.setInitialDirectory(file);
        }
        if ((file = dirChooser.showDialog((Window)this.stage)) == null) {
            return;
        }
        String path = file.getPath();
        String parentPath = file.getParent();
        if (!this.cmbRequestDir.getItems().contains((Object)path)) {
            this.cmbRequestDir.getItems().add((Object)path);
        }
        this.cmbRequestDir.getSelectionModel().select((Object)path);
        this.onRequestDirChange(parentPath);
        this.createCopyDir(parentPath);
    }

    @FXML
    public void onResDirChange() {
        String requestPath;
        File file;
        DirectoryChooser dirChooser = new DirectoryChooser();
        if (!((String)this.cmbResponseDir.getSelectionModel().getSelectedItem()).isEmpty() && (file = new File((String)this.cmbResponseDir.getSelectionModel().getSelectedItem())).exists()) {
            dirChooser.setInitialDirectory(file);
        }
        if ((file = dirChooser.showDialog((Window)this.stage)) == null) {
            return;
        }
        String path = file.getPath();
        if (path.equals(requestPath = (String)this.cmbRequestDir.getValue())) {
            this.alert.alert(Alert.AlertType.ERROR, "\u56de\u62a5\u6587\u4ef6\u76ee\u5f55\u4e0d\u53ef\u4e0e\u8bf7\u6c42\u6587\u4ef6\u76ee\u5f55\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u5b9a\uff01");
            return;
        }
        String monitorResPath = this.eCore.getStr("monitor.res.req.folder");
        String monitorRecPath = this.eCore.getStr("monitor.rec.req.folder");
        String monitorReqPath = this.eCore.getStr("monitor.req.req.folder");
        String scanRecPath = this.eCore.getStr("scan.rec.req.folder");
        String scanrReqPath = this.eCore.getStr("scan.req.req.folder");
        if (path.equals(monitorResPath) || path.equals(monitorRecPath) || path.equals(monitorReqPath) || path.equals(scanRecPath) || path.equals(scanrReqPath)) {
            logger.error("\u6587\u4ef6\u5355(\u76d1\u542c\u6a21\u5f0f)\u548c\u6587\u4ef6\u5355(\u626b\u5355\u6a21\u5f0f)\u4e0b\u7684\u76ee\u5f55\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
            Platform.runLater(() -> {
                boolean bl = this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u5355(\u76d1\u542c\u6a21\u5f0f)\u548c\u6587\u4ef6\u5355(\u626b\u5355\u6a21\u5f0f)\u4e0b\u7684\u8bf7\u6c42\u76ee\u5f55\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01");
            });
            return;
        }
        logger.error("\u626b\u5355 \u8bbe\u7f6e\u56de\u62a5\u76ee\u5f55\u4e3a[" + path + "]");
        if (!this.cmbResponseDir.getItems().contains((Object)path)) {
            this.cmbResponseDir.getItems().add((Object)path);
        }
        this.cmbResponseDir.getSelectionModel().select((Object)path);
        this.eCore.remove((Object)"scan.res.req.folder");
        this.eCore.put((Object)"scan.res.req.folder", (Object)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void startOrStop() {
        try {
            ScanFileOrderPart scanFileOrderPart = this;
            synchronized (scanFileOrderPart) {
                if (!this.isScanning) {
                    this.startOrder();
                } else {
                    logger.info("\u6b63\u5728\u626b\u5355\u671f\u95f4\u3002\u3002\u3002");
                }
            }
        }
        catch (Exception e) {
            this.isScanning = false;
            logger.error("\u542f\u52a8\u5931\u8d25\uff1a", (Throwable)e);
            Platform.runLater(() -> {
                boolean bl = this.alert.alert(Alert.AlertType.ERROR, "\u542f\u52a8\u5931\u8d25" + e.getMessage());
            });
        }
    }

    private void lockInDoc(boolean isLock) {
        this.btnEntrustDir.setDisable(isLock);
        this.btnResDir.setDisable(isLock);
        this.rdoResSingleFile.setDisable(isLock);
        this.cmbRequestDir.setDisable(isLock);
        this.cmbResponseDir.setDisable(isLock);
        this.btnStartOrStop.setDisable(isLock);
    }

    private void startOrder() throws Exception {
        logger.info("\u754c\u9762 \u542f\u52a8\u6587\u4ef6\u5355\uff08\u626b\u5355\uff09");
        this.theFileExists();
        this.lockInDoc(true);
        this.isScanning = true;
        boolean isFinished = this.setModel.scan(this.param);
        this.isScanning = false;
        logger.info("\u6587\u4ef6\u5355\uff08\u626b\u5355\uff09\u5df2\u5f00\u59cb");
        this.lockInDoc(!isFinished);
    }

    private void theFileExists() {
        String entrustDir = this.param.getEntrustDir();
        String resDir = this.param.getResponseDir();
        File entrustFile = new File(entrustDir);
        File resFile = new File(resDir);
        boolean isExistsEntru = entrustFile.exists();
        boolean isExistsRes = resFile.exists();
        if (!isExistsEntru) {
            logger.error("\u8bf7\u6c42\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
            entrustFile.mkdirs();
        }
        if (!isExistsRes) {
            logger.error("\u56de\u62a5\u6587\u4ef6\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
            resFile.mkdirs();
        }
    }

    private void createDocTable() {
        TableUtils.initValueFactory(this.tableDoc);
        this.tableDoc.setPlaceholder((Node)new Label());
        this.tableDoc.setItems(this.docScanAndOrderRecordModel.getList());
        this.startTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableDoc.getSortOrder().add(this.startTime);
    }

    @FXML
    private void download() {
        InputStream fis = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("help/file_order_template.rar");
        try {
            ExcelUtils.saveFile((InputStream)fis, (String)"\u4ea4\u6613\u5927\u5e08\u6587\u4ef6\u5355\u6750\u6599\u5305.rar");
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (MException mException) {
            logger.error("\u53d6\u6d88\u4e0b\u8f7d");
        }
    }
}

