/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.utils;

import cms.tmx.core.MConfService;
import cms.tmx.core.MObjFactory;
import cms.tmx.file.order.utils.ReqFileListener;
import java.io.File;
import java.io.FileFilter;
import javax.inject.Inject;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ReqFileMonitor {
    @Inject
    private MObjFactory of;
    @Inject
    private MConfService cs;
    private static final Logger logger = LogManager.getLogger(ReqFileMonitor.class);
    private FileAlterationMonitor monitor;
    private final IOFileFilter monoFileIoFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.prefixFileFilter((String)"req.monofile."), FileFilterUtils.suffixFileFilter((String)".csv")});
    private final IOFileFilter mutilFileIoFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.prefixFileFilter((String)"req.multifile."), FileFilterUtils.suffixFileFilter((String)".csv")});

    public void start(File directory, String runModel) throws Exception {
        logger.info("\u5f00\u59cb\u76d1\u63a7\u76ee\u5f55\uff1a" + directory + " runModel[" + runModel + "]");
        if (directory == null || "".equals(directory.getPath())) {
            logger.error("\u76d1\u63a7\u76ee\u5f55\u672a\u8bbe\u7f6e\uff01");
            throw new Exception("\u76d1\u63a7\u76ee\u5f55\u672a\u8bbe\u7f6e\uff01");
        }
        if (!directory.exists()) {
            logger.error("\u76d1\u63a7\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c \u521b\u5efa\u76ee\u5f55");
            directory.mkdirs();
        }
        IOFileFilter fileFilter = runModel.equals("req.monofile.model") ? this.monoFileIoFilter : this.mutilFileIoFilter;
        FileAlterationObserver observer = new FileAlterationObserver(directory, (FileFilter)fileFilter);
        ReqFileListener reqFileListener = (ReqFileListener)this.of.create(ReqFileListener.class);
        observer.addListener((FileAlterationListener)reqFileListener);
        int interval = this.cs.getValueAsInt("file.order.interval", 1);
        this.monitor = new FileAlterationMonitor((long)interval, new FileAlterationObserver[]{observer});
        this.monitor.start();
        logger.info(directory + "\u8bf7\u6c42\u6587\u4ef6\u76d1\u63a7\u5f00\u59cb\u3002\u3002\u3002");
    }

    public void close() throws Exception {
        logger.info("\u5f00\u59cb\u5173\u95ed\u76d1\u63a7\u76ee\u5f55...");
        if (this.monitor == null) {
            return;
        }
        Iterable iterable = this.monitor.getObservers();
        iterable.forEach(val -> this.monitor.removeObserver(val));
        this.monitor.stop();
        logger.info("\u5173\u95ed\u6587\u4ef6\u76d1\u63a7");
    }
}

