/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.utils;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.file.order.utils.FileScanHistory;
import java.io.File;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FileScanner {
    @Inject
    protected MEventService es;
    @Inject
    private FileScanHistory history;
    private static final Logger logger = LogManager.getLogger(FileScanner.class);

    private boolean checkFileNameFormat(String filename) {
        logger.info("\u68c0\u67e5\u6587\u4ef6\u540d\u683c\u5f0f[" + filename + "]");
        String[] fields = filename.split("\\.");
        if (fields.length != 5) {
            return false;
        }
        return ("." + fields[4]).equals(".csv");
    }

    private void onScanFile(String scanID, File file) throws Exception {
        String uuid = UUID.randomUUID().toString();
        logger.info("\u754c\u9762\u626b\u5355\u4e8b\u4ef6ID[" + scanID + "]  \u76ee\u5f55\u4e0b\u5355\u4e2a\u6587\u4ef6\u7684\u626b\u5355ID[" + uuid + "] \u6587\u4ef6[" + file.getName() + "] \u626b\u5355\u5f00\u59cb.\u3002\u3002");
        long startTime = System.currentTimeMillis();
        if (!this.checkFileNameFormat(file.getName())) {
            logger.error("[" + uuid + "]" + file.getName() + " is bad format!");
            this.reportMsg("\u6587\u4ef6\u5355\u626b\u5355[" + file.getName() + "] \u6587\u4ef6\u540d\u683c\u5f0f\u9519\u8bef");
            return;
        }
        MEvent event = new MEvent();
        event.put((Object)"file.manipulate.record.uuid", (Object)uuid);
        event.put((Object)"file", (Object)file);
        event.put((Object)"file.name", (Object)file.getName());
        event.put((Object)"work.mode", (Object)"scan.work.mode");
        event.put((Object)"file.manipulate.record.start.time", (Object)startTime);
        logger.info("[" + uuid + "]" + file.getName() + "\u626b\u5355\uff0c \u591a\u6587\u4ef6\u6a21\u5f0f. begin...");
        this.es.sendEvent("multifile/input", event);
        logger.info("[" + uuid + "]" + file.getName() + "\u5df2\u88ab\u79fb\u81f3\u5185\u5bb9\u5904\u7406\u6a21\u5757");
    }

    private void reportMsg(String msg) {
        MEvent event = new MEvent();
        event.setDesc(msg);
        this.es.postEvent("message.log", event);
    }

    public void scan(File f, String runModel) throws Exception {
        String uuid = UUID.randomUUID().toString();
        logger.info("[" + uuid + "] \u5f00\u59cb\u626b\u5355\u76ee\u5f55\uff1a" + f.getAbsolutePath() + ", runModel[" + runModel + "]");
        if (!f.exists()) {
            logger.error("[" + uuid + "] \u626b\u5355\u76ee\u5f55\uff1a" + f.getAbsolutePath() + "\u4e0d\u5b58\u5728");
            this.reportMsg("\u626b\u5355\u76ee\u5f55\uff1a" + f.getAbsolutePath() + "\u4e0d\u5b58\u5728");
            return;
        }
        if (f != null) {
            if (f.isDirectory()) {
                File[] fileArray = f.listFiles();
                if (fileArray != null) {
                    int i = 0;
                    while (i < fileArray.length) {
                        logger.info("[" + uuid + "] \u5f85\u626b\u5355\u7684\u6587\u4ef6\u5e8f\u53f7[" + i + "] \u6587\u4ef6\u540d[" + fileArray[i].getPath() + "]");
                        if (fileArray[i].getName().startsWith("req.multifile.")) {
                            this.onScanFile(uuid, fileArray[i]);
                        }
                        ++i;
                    }
                }
            } else {
                logger.info("[" + uuid + "] \u626b\u5355\uff0c  \u8bf7\u6c42\u53c2\u6570\u4e0d\u4e3a\u76ee\u5f55\uff1a" + f);
            }
        }
        logger.info("[" + uuid + "] \u5b8c\u6210\u626b\u5355\u7684\u76ee\u5f55\uff1a" + f.getAbsolutePath() + ", runModel[" + runModel + "]");
    }
}

