/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.utils;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PCcsExtra;
import cms.tmx.datatype.message.POrderService;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.notice.CancelRejectReport;
import cms.tmx.entity.notice.InstructionReport;
import cms.tmx.entity.notice.ListExecuteReport;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.TransRecord;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionFlowRecord;
import cms.tmx.file.order.entity.OrderRecord;
import cms.tmx.file.order.pares.Report;
import cms.tmx.file.order.utils.ConvertUtils;
import cms.tmx.file.order.utils.LoggerUtils;
import cms.tmx.http.api.strategy.dto.CancelRejectReportNew;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.ExecutionReport;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.query.CreditDirect;
import cms.tmx.http.query.LifeStatus;
import cms.tmx.http.query.OrderExtra;
import cms.tmx.http.query.PledgeSecurity;
import cms.tmx.http.query.Sofp;
import cms.tmx.http.query.UnderlyingSecurity;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.basket.BasketCcsOrderModel;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.FileUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FileHander {
    @Inject
    protected MEventService es;
    @Inject
    private ExecutorService exe;
    @Inject
    private MScheduler ms;
    @Inject
    private BasketCcsOrderModel bsktOrderModel;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private MarginAccountMap accountMap;
    @Inject
    private PortfolioAccountModel portAccModel;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private static final Logger logger = LogManager.getLogger(FileHander.class);
    private static volatile Map<String, Long> monoFileReadPos = new HashMap<String, Long>();
    private static volatile Map<String, Long> monoResFileWritePos = new HashMap<String, Long>();
    private static volatile Map<String, Object> orderHis = new ConcurrentHashMap<String, Object>();
    private static volatile AtomicBoolean hasSub = new AtomicBoolean(false);
    private LinkedBlockingQueue<MEvent> monitorQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<MEvent> scanQueue = new LinkedBlockingQueue();
    private volatile boolean isMonitorSubscribe = false;
    private volatile boolean isScanSubscribe = false;
    private static final ReentrantLock INS_LOCK = new ReentrantLock();
    private List<InstructionFlowRecord> recordList = new ArrayList<InstructionFlowRecord>();
    private List<MEvent> recordToWrite = new ArrayList<MEvent>();
    private Map<String, StringBuilder> recordToWriteMap = new HashMap<String, StringBuilder>(32);
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected IMarketDataMng marketMng;
    private Future<?> future;
    private Future<?> futureMonitor;
    private List<Integer> list = Arrays.asList(630006, 630005, 630004, 630002, 500011, 640006, 640005, 640004, 640007, 640008, 640009, 640010, 640002, 630007);
    private MEventHandler setSubscribeHandler = e -> {
        String workMode = e.getStr("work.mode");
        if (workMode.equals("monitor.work.mode")) {
            this.isMonitorSubscribe = e.getBool("monitor_subscribe_status");
            logger.info("\u8a2d\u7f6eisMonitorSubscribe:" + this.isMonitorSubscribe);
            return;
        }
        if (workMode.equals("scan.work.mode")) {
            this.isScanSubscribe = e.getBool("scan_subscribe_status");
            logger.info("\u8a2d\u7f6eisScanSubscribe:" + this.isScanSubscribe);
            return;
        }
        logger.error("\u672a\u8bc6\u522b\u7684\u5de5\u4f5c\u6a21\u5f0f\u5bf9\u5e94\u7684\u72b6\u6001\uff01");
    };
    private Gson gson = new Gson();
    private volatile int scan_guid = 0;
    private ConcurrentHashMap<String, OrderRecord> fileorderMap;
    private int times = 0;

    @PreDestroy
    private void close() {
        if (this.future != null) {
            this.future.cancel(true);
            logger.error("\u6587\u4ef6\u5355\u5199\u6587\u4ef6\u7ebf\u7a0b\u5173\u95ed");
        }
        if (this.futureMonitor != null) {
            this.futureMonitor.cancel(true);
            logger.error("\u6587\u4ef6\u5355\u76d1\u542c\u6a21\u5f0f\u5199\u6587\u4ef6\u7ebf\u7a0b\u5173\u95ed");
        }
    }

    @PostConstruct
    public void init() {
        logger.info("=======FileHandler\u6a21\u5757\u521d\u59cb\u5316");
        this.es.subscribe("multifile/input", e -> this.onMultiFileInput(e));
        this.es.subscribe("monofile/input", e -> this.onMonoFileInput(e));
        this.es.subscribe("server.sub", e -> this.onPush(e));
        this.es.subscribe("uap.push.ExecutionReport", e -> this.onPush(e));
        this.es.subscribe("uap.push.OrderCancelReject", e -> this.onCancelReject(e));
        this.es.subscribe("save.order.fundid", e -> this.buildFundMap(e));
        this.es.subscribe("subscribe/res/info", this.setSubscribeHandler);
        this.future = this.exe.submit(() -> this.threadPush());
        this.futureMonitor = this.exe.submit(() -> this.threadPushMonitor());
    }

    private void buildFundMap(MEvent e) {
        Object object = e.get((Object)"fundAccount");
        if (object instanceof CcsFundAccount) {
            CcsFundAccount cast = (CcsFundAccount)CcsFundAccount.class.cast(object);
            orderHis.put(cast.getInvestId(), cast);
            if (!hasSub.get()) {
                hasSub.compareAndSet(false, true);
            }
        } else if (object instanceof Portfolio) {
            Portfolio cast = (Portfolio)Portfolio.class.cast(object);
            orderHis.put(cast.getId(), cast);
            if (!hasSub.get()) {
                hasSub.compareAndSet(false, true);
            }
        }
    }

    private void onFileOperationEnd(MEvent e) {
        String uuid = e.getStr("file.manipulate.record.uuid");
        long endTime = System.currentTimeMillis();
        e.put((Object)"file.manipulate.record.end.time", (Object)endTime);
        this.es.sendEvent("file/request/record", e);
        logger.info("[" + uuid + "]" + "\u6b64\u6b21\u6587\u4ef6\u6539\u53d8\u7684\u4e0b\u5355\u8bf7\u6c42\u5b8c\u6210\uff01 ");
    }

    private void onMessageTip(MEvent e, int code, String desc) {
        String uuid = e.getStr("file.manipulate.record.uuid");
        long endTime = System.currentTimeMillis();
        e.put((Object)"file.manipulate.record.end.time", (Object)endTime);
        e.setCode(code);
        e.setDesc(desc);
        this.es.postEvent("message.log", e);
        logger.info("[" + uuid + "] desc[" + desc + "]\u4e0a\u62a5\u6d88\u606f\u754c\u9762\uff01 ");
    }

    private void onMonoFileInput(MEvent e) {
    }

    private void onMultiFileInput(final MEvent e) {
        final String uuid = e.getStr("file.manipulate.record.uuid");
        logger.info("[" + uuid + "] \u5f00\u59cb\u5904\u7406\u6b64\u6587\u4ef6==============");
        String srcFile = "";
        try {
            String workMode = e.getStr("work.mode");
            String respath = workMode.equals("scan.work.mode") ? this.eCore.getStr("scan.rec.req.folder") : this.eCore.getStr("monitor.rec.req.folder");
            File recReqFolder = new File(respath);
            final File file = (File)e.get((Object)"file");
            srcFile = file.toPath().toString();
            File dstFile = new File(String.valueOf(recReqFolder.getAbsolutePath()) + "\\" + file.getName());
            logger.info("[" + uuid + "] \u5de5\u4f5c\u6a21\u5f0f[" + workMode + "] \u591a\u6587\u4ef6\u6a21\u5f0f  \u51c6\u5907\u79fb\u52a8\u6587\u4ef6\u5230\u5de5\u4f5c\u5907\u4efd\u76ee\u5f55: " + dstFile.getAbsolutePath());
            final Path dst = Paths.get(recReqFolder.getAbsolutePath(), file.getName());
            if (Files.move(file.toPath(), dstFile.toPath(), StandardCopyOption.REPLACE_EXISTING) == null) {
                String msg = "[" + uuid + "] \u5de5\u4f5c\u6a21\u5f0f[" + workMode + "]\u79fb\u52a8" + file + "\u5230 " + dstFile + " fail";
                logger.error(msg);
                this.onMessageTip(e, 999982, msg);
                return;
            }
            logger.info("[" + uuid + "] \u5de5\u4f5c\u6a21\u5f0f[" + workMode + "] \u591a\u6587\u4ef6\u6a21\u5f0f \u79fb\u52a8\u6587\u4ef6\u5230\u5de5\u4f5c\u76ee\u5f55: " + dstFile.getAbsolutePath() + "\u6210\u529f");
            this.es.postEvent("file/request/record", e);
            this.exe.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileHander.this.handleMultiFile(dst, e);
                        if (e.getCode() != 0) {
                            logger.error("[" + uuid + "]" + file.getName() + ", " + e.getDesc());
                            MEvent event = new MEvent();
                            event.setDesc(String.valueOf(file.getName()) + ",\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getDesc());
                            FileHander.this.es.postEvent("message.log", event);
                            return;
                        }
                        try {
                            LoggerUtils.asyncLogger("[" + uuid + "]" + "\u8bf7\u6c42\u54cd\u5e94\u5b8c\u6210\uff0c \u5e76\u53d1\u4e8b\u4ef6\u5230\u754c\u9762 : " + e.entrySet());
                            FileHander.this.onFileOutput(e, true);
                        }
                        catch (IOException e2) {
                            logger.error("[" + uuid + "]", (Throwable)e2);
                        }
                    }
                    finally {
                        FileHander.this.onFileOperationEnd(e);
                    }
                }
            });
        }
        catch (Exception e2) {
            logger.error("[" + uuid + "]", (Throwable)e2);
            String msg = e2.getMessage();
            if (e2 instanceof FileSystemException) {
                msg = "\u53e6\u4e00\u4e2a\u7a0b\u5e8f\u6b63\u5728\u4f7f\u7528\u6b64\u6587\u4ef6" + srcFile + "\uff0c\u8fdb\u7a0b\u65e0\u6cd5\u8bbf\u95ee\u3002";
            }
            this.onMessageTip(e, 999979, msg);
        }
    }

    private void onCancelReject(MEvent event) {
        JsonElement cast = (JsonElement)JsonElement.class.cast(event.getObj());
        CancelRejectReportNew report = (CancelRejectReportNew)this.gson.fromJson(cast.toString(), CancelRejectReportNew.class);
        String clOrderId = report.getClOrdId();
        String clListId = report.getClListId();
        if (!StringUtils.isEmpty((String)clOrderId)) {
            if (clOrderId.contains("|")) {
                String[] split = clOrderId.split("\\|");
                if (split.length == 3) {
                    event.put((Object)"client_seq", (Object)split[2]);
                }
            } else {
                event.put((Object)"client_seq", (Object)clOrderId);
            }
        }
        if (!StringUtils.isEmpty((String)clListId)) {
            if (clListId.contains("|")) {
                String[] splitList = clListId.split("\\|");
                if (splitList.length == 3) {
                    event.put((Object)"cl_list_id", (Object)splitList[2]);
                }
            } else {
                event.put((Object)"cl_list_id", (Object)clListId);
            }
        }
        event.put((Object)"topic", (Object)"cancel_reject");
        event.put((Object)"cust_no", (Object)report.getInvestorId());
        event.put((Object)"entrust_no", (Object)report.getOrderId());
        event.put((Object)"exchange_err_code", (Object)report.getCxlRejReason());
        event.put((Object)"err_msg", (Object)report.getRejMsg());
        this.receiveCallBack(event, 630952, "cancel_reject");
    }

    protected void onPush(MEvent event) {
        if (!hasSub.get()) {
            return;
        }
        Object evObj = event.getObj();
        if (!this.careRepart(evObj)) {
            return;
        }
        MEvent newEvent = this.clone(3, event);
        if (newEvent == null) {
            logger.error("\u63a8\u9001\u4fe1\u606fclone\u5931\u8d25\uff0c" + event);
            return;
        }
        if (newEvent.getObj() instanceof cms.tmx.entity.notice.ExecutionReport) {
            this.onExecutionReport(newEvent);
        } else if (newEvent.getObj() instanceof JsonElement) {
            this.onExecutionReportNew(newEvent);
        } else if (newEvent.getObj() instanceof InstructionReport) {
            this.onInstructionPush(newEvent);
        } else if (newEvent.getObj() instanceof CancelRejectReport) {
            this.onOrderCancelPush(newEvent);
        } else if (newEvent.getObj() instanceof ListExecuteReport) {
            this.onListReport(newEvent);
        }
    }

    private MEvent clone(int i, MEvent event) {
        int j = i;
        while (j > 0) {
            try {
                if (j != i) {
                    logger.info("\u5f00\u59cb\u5c1d\u8bd5clone" + j);
                    Thread.sleep(10L);
                }
                return event.clone();
            }
            catch (Exception e) {
                logger.error("clone\u5931\u8d25" + j, (Throwable)e);
                --j;
            }
        }
        return null;
    }

    private boolean careRepart(Object obj) {
        return obj instanceof cms.tmx.entity.notice.ExecutionReport || obj instanceof JsonElement || obj instanceof InstructionReport || obj instanceof CancelRejectReport || obj instanceof ListExecuteReport;
    }

    private void onOrderCancelPush(MEvent event) {
        CancelRejectReport report = (CancelRejectReport)CancelRejectReport.class.cast(event.getObj());
        String clOrderId = report.getReport().getClOrdId();
        String clListId = report.getReport().getClListId();
        if (!StringUtils.isEmpty((String)clOrderId)) {
            if (clOrderId.contains("|")) {
                String[] split = clOrderId.split("\\|");
                if (split.length == 3) {
                    event.put((Object)"client_seq", (Object)split[2]);
                }
            } else {
                event.put((Object)"client_seq", (Object)clOrderId);
            }
        }
        if (!StringUtils.isEmpty((String)clListId)) {
            if (clListId.contains("|")) {
                String[] splitList = clListId.split("\\|");
                if (splitList.length == 3) {
                    event.put((Object)"cl_list_id", (Object)splitList[2]);
                }
            } else {
                event.put((Object)"cl_list_id", (Object)clListId);
            }
        }
        event.put((Object)"topic", (Object)"cancel_reject");
        event.put((Object)"cust_no", (Object)report.getReport().getExtAccntId().substring(0, report.getReport().getExtAccntId().indexOf("_")));
        event.put((Object)"entrust_no", (Object)report.getReport().getOrderId());
        event.put((Object)"exchange_err_code", (Object)report.getReport().getCxlRejReason());
        event.put((Object)"err_msg", (Object)report.getReport().getRejMsg());
        event.put((Object)"batch_id", (Object)report.getReport().getListId());
        event.put((Object)"portfolio_id", (Object)report.getReport().getPortfolioId());
        this.receiveCallBack(event, 630952, "cancel_reject");
    }

    private void onInstructionPush(MEvent event) {
        if (!hasSub.get()) {
            return;
        }
        InstructionReport report = (InstructionReport)InstructionReport.class.cast(event.getObj());
        INS_LOCK.lock();
        try {
            report.getReport().getInstructionList().forEach(each -> {
                InstructionFlowRecord record = new InstructionFlowRecord();
                record.update(each);
                if (!this.recordList.contains(record)) {
                    this.recordList.add(record);
                }
            });
        }
        finally {
            INS_LOCK.unlock();
        }
        this.recordInstructionPush();
    }

    private void recordInstructionPush() {
        this.ms.schedule(event -> {
            INS_LOCK.lock();
            try {
                ArrayList<InstructionFlowRecord> records = new ArrayList<InstructionFlowRecord>(this.recordList);
                this.recordList.clear();
                for (InstructionFlowRecord re : records) {
                    this.buildInstructionRecord(re);
                }
            }
            finally {
                INS_LOCK.unlock();
            }
        }, true);
    }

    private void onListReport(MEvent event) {
        String type = event.getStr("push_type");
        if (!type.equals("124")) {
            return;
        }
        ListExecuteReport report = (ListExecuteReport)ListExecuteReport.class.cast(event.getObj());
        int failNum = report.getReport().getFailNum();
        if (failNum == 0) {
            return;
        }
        MEvent parent = new MEvent(8);
        StringBuilder builder = new StringBuilder();
        try {
            List queryListOrder = this.bsktOrderModel.queryListOrder(report.getReport().getListId());
            for (BasketCcsOrder order : queryListOrder) {
                String[] split;
                String clListId;
                String[] split2;
                String value = order.getOrdStatus().getRaw();
                if (!"56".equals(value)) continue;
                MEvent ev = new MEvent(8);
                ev.put((Object)"list_id", (Object)order.getListId());
                ev.put((Object)"list_leg_id", (Object)order.getLegId());
                ev.put((Object)"invest_id", (Object)order.getExtAccntId().substring(0, order.getExtAccntId().indexOf("_")));
                ev.put((Object)"portfolio_id", (Object)order.getPortfolioId());
                ev.put((Object)"sec_code", (Object)order.getInstrument().getSecId());
                ev.put((Object)"error_code", (Object)order.getErrorCode());
                ev.put((Object)"erroe_msg", (Object)order.getErrorInfo());
                String clOrderId = order.getClOrderId();
                if (!StringUtils.isEmpty((String)clOrderId) && clOrderId.contains("|") && (split2 = clOrderId.split("\\|")).length == 3) {
                    clOrderId = split2[2];
                }
                if (!StringUtils.isEmpty((String)(clListId = order.getClListId())) && clListId.contains("|") && (split = clListId.split("\\|")).length == 3) {
                    clListId = split[2];
                }
                ev.put((Object)"cl_order_id", (Object)clOrderId);
                ev.put((Object)"cl_list_id", (Object)clListId);
                ev.put((Object)"topic", (Object)"response_batch_entrust_confirm");
                String line = Report.packLine(ev);
                if (!line.trim().equals("")) {
                    builder.append(line);
                    builder.append('\n');
                    continue;
                }
                return;
            }
            parent.put((Object)"res_file.steam", (Object)builder.toString());
            parent.put((Object)"isRes", (Object)true);
            this.receiveCallBack(parent, 0, "batch_entrust_fail");
        }
        catch (MException e) {
            logger.error("\u6839\u636e\u6279\u6b21\u53f7\u67e5\u8be2\u7bee\u5b50\u5355\u5931\u8d25", (Throwable)e);
        }
    }

    private void onExecutionReportNew(MEvent event) {
        String type;
        JsonElement cast = (JsonElement)JsonElement.class.cast(event.getObj());
        ExecutionReport report = (ExecutionReport)this.gson.fromJson(cast.toString(), ExecutionReport.class);
        if (!hasSub.get()) {
            return;
        }
        String account = report.getInvestorId();
        String clOrderId = report.getClOrdId();
        String clListId = report.getListId();
        String code = MarketIndicator.getCode((String)report.getInstrument().getMarketIndicator());
        event.put((Object)"market_indicator", (Object)code);
        if (!StringUtils.isEmpty((String)clOrderId)) {
            if (clOrderId.contains("|")) {
                String[] split = clOrderId.split("\\|");
                if (split.length == 3) {
                    event.put((Object)"client_seq", (Object)split[2]);
                }
            } else {
                event.put((Object)"client_seq", (Object)clOrderId);
            }
        }
        if (!StringUtils.isEmpty((String)clListId)) {
            if (clListId.contains("|")) {
                String[] splitList = clListId.split("\\|");
                if (splitList.length == 3) {
                    event.put((Object)"cl_list_id", (Object)splitList[2]);
                }
            } else {
                event.put((Object)"cl_list_id", (Object)clListId);
            }
        }
        if (!orderHis.containsKey(account)) {
            return;
        }
        switch (type = report.getExecType().getValue()) {
            case "48": {
                this.buildEntrustConfirmReportNew(event, report);
                break;
            }
            case "70": {
                this.buildEntrustDoneReportNew(event, report);
                break;
            }
            case "52": {
                this.buildEntrustCancelReportNew(event, report);
                break;
            }
            case "56": {
                this.buildEntrustRejectReportNew(event, report);
                break;
            }
        }
    }

    private void buildEntrustDoneReportNew(MEvent event, ExecutionReport report) {
        event.put((Object)"topic", (Object)"entrust_done");
        event.put((Object)"cust_no", (Object)report.getAccount());
        event.put((Object)"contract_no", (Object)"");
        event.put((Object)"bs", (Object)ConvertUtils.getBsFlag(Integer.parseInt(report.getSide().getValue())));
        event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(report.getInstrument().getMarket()));
        event.put((Object)"done_no", (Object)report.getExecId());
        event.put((Object)"done_vol", (Object)report.getLastQty());
        event.put((Object)"done_time", (Object)report.getTransactTime());
        event.put((Object)"done_price", (Object)report.getLastPx());
        event.put((Object)"done_amt", (Object)report.getTradeAmount());
        event.put((Object)"done_status", (Object)report.getOrdStatus().getValue());
        event.put((Object)"fund_acc_no", (Object)report.getAccount());
        event.put((Object)"holder_acc_no", (Object)report.getInvestorSecId());
        event.put((Object)"sec_code", (Object)report.getInstrument().getSecurityId());
        event.put((Object)"entrust_status", (Object)ConvertUtils.getOrderStatus(Integer.parseInt(report.getOrdStatus().getValue())));
        event.put((Object)"org_contract_no", (Object)report.getOrderId());
        event.put((Object)"rpt_contract_no", (Object)report.getReportOrdId());
        event.put((Object)"amount", (Object)report.getOrderAmount());
        this.receiveCallBack(event, 630952, "entrust_done");
    }

    private void buildEntrustCancelReportNew(MEvent event, ExecutionReport report) {
        event.put((Object)"topic", (Object)"entrust_cancel");
        event.put((Object)"cust_no", (Object)report.getAccount());
        event.put((Object)"entrust_no", (Object)report.getOrderId());
        event.put((Object)"entrust_status", (Object)report.getOrdStatus().getValue());
        event.put((Object)"cancel_vol", (Object)report.getCxlQty());
        this.receiveCallBack(event, 630952, "entrust_cancel");
    }

    private void buildEntrustRejectReportNew(MEvent event, ExecutionReport report) {
        event.put((Object)"topic", (Object)"entrust_reject");
        event.put((Object)"cust_no", (Object)report.getAccount());
        event.put((Object)"entrust_no", (Object)report.getOrderId());
        event.put((Object)"exchange_err_code", (Object)report.getOrdRejReason());
        event.put((Object)"err_msg", (Object)report.getRejMsg());
        this.receiveCallBack(event, 630952, "entrust_reject");
    }

    private void buildEntrustConfirmReportNew(MEvent event, ExecutionReport report) {
        event.put((Object)"topic", (Object)"entrust_confirm");
        event.put((Object)"cust_no", (Object)report.getAccount());
        event.put((Object)"contract_no", (Object)"");
        event.put((Object)"bs", (Object)ConvertUtils.getBsFlag(Integer.parseInt(report.getSide().getValue())));
        event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(report.getInstrument().getMarket()));
        event.put((Object)"entrust_vol", (Object)report.getOrderQty());
        event.put((Object)"price", (Object)report.getPrice());
        event.put((Object)"holder_acc_no", (Object)report.getInvestorSecId());
        event.put((Object)"sec_code", (Object)report.getInstrument().getSecurityId());
        event.put((Object)"rpt_contract_no", (Object)report.getReportOrdId());
        event.put((Object)"org_contract_no", (Object)report.getOrderId());
        event.put((Object)"amount", (Object)report.getOrderAmount());
        event.put((Object)"confirm_time", (Object)report.getTransactTime());
        this.receiveCallBack(event, 630952, "entrust_confirm");
    }

    private void onExecutionReport(MEvent event) {
        String type;
        if (!hasSub.get()) {
            return;
        }
        if (this.fileorderMap == null) {
            this.fileorderMap = (ConcurrentHashMap)this.eCore.get((Object)"fileorderMap");
        }
        cms.tmx.entity.notice.ExecutionReport report = (cms.tmx.entity.notice.ExecutionReport)cms.tmx.entity.notice.ExecutionReport.class.cast(event.getObj());
        String account = report.getReport().getExtAccntId().substring(0, report.getReport().getExtAccntId().indexOf("_"));
        String portfolioId = report.getReport().getPortfolioId();
        String clOrderId = report.getReport().getClOrdId();
        String clListId = report.getReport().getClListId();
        if (!StringUtils.isEmpty((String)clOrderId)) {
            if (clOrderId.contains("|")) {
                String[] split = clOrderId.split("\\|");
                if (split.length == 3) {
                    OrderRecord record;
                    event.put((Object)"client_seq", (Object)split[2]);
                    String clOrdId = split[2];
                    if (this.fileorderMap != null && this.fileorderMap.get(clOrdId) != null && (record = this.fileorderMap.get(clOrdId)).getEndTime() == 0L) {
                        record.setEndTime(System.currentTimeMillis());
                        logger.error("fileorder test," + report.getReport().getReportOrdId() + record.getClOrderId() + "," + record.getTimeCost());
                    }
                }
            } else {
                event.put((Object)"client_seq", (Object)clOrderId);
            }
        }
        if (!StringUtils.isEmpty((String)clListId)) {
            if (clListId.contains("|")) {
                String[] splitList = clListId.split("\\|");
                if (splitList.length == 3) {
                    event.put((Object)"cl_list_id", (Object)splitList[2]);
                }
            } else {
                event.put((Object)"cl_list_id", (Object)clListId);
            }
        }
        if (!orderHis.containsKey(portfolioId) && !orderHis.containsKey(account)) {
            return;
        }
        switch (type = Integer.toString(report.getType())) {
            case "48": {
                this.buildEntrustConfirmReport(event, report);
                break;
            }
            case "70": {
                this.buildEntrustDoneReport(event, report);
                break;
            }
            case "52": {
                this.buildEntrustCancelReport(event, report);
                break;
            }
            case "56": {
                this.buildEntrustRejectReport(event, report);
                break;
            }
        }
    }

    private void receiveCallBack(MEvent event, int FunctionCode, String topic) {
        String uuid = UUID.randomUUID().toString();
        if (this.eCore.getStr("scan.response.model").equals("monofile")) {
            this.scan_guid = 0;
        }
        if (this.eCore.getStr("monitor.response.model").equals("monofile")) {
            this.scan_guid = 0;
        }
        event.put((Object)"file.manipulate.record.uuid", (Object)uuid);
        event.setFunctionCode(FunctionCode);
        event.put((Object)"file.format", (Object)"csv");
        event.put((Object)"file.guid", (Object)String.valueOf(this.scan_guid));
        event.put((Object)"file.type", (Object)topic);
        event.put((Object)"file.prefix", (Object)"report");
        event.put((Object)"topic", (Object)topic);
        try {
            MEvent clone;
            if (this.isMonitorSubscribe) {
                clone = event.clone();
                clone.setFunctionCode(FunctionCode);
                clone.put((Object)"file.model", (Object)this.eCore.getStr("monitor.response.model"));
                clone.put((Object)"work.mode", (Object)"monitor.work.mode");
                this.monitorQueue.put(clone);
                logger.info("\u76d1\u542c\u6a21\u5f0f\u63a8\u9001\u4e8b\u4ef6\u653e\u5165\u6d88\u606f\u961f\u5217\uff0c\u4e8b\u4ef6UUID\uff1a " + uuid + " \u5f53\u524d\u6392\u961f\u6570\u91cf\uff1a" + this.monitorQueue.size());
            }
            if (this.isScanSubscribe) {
                clone = event.clone();
                clone.setFunctionCode(FunctionCode);
                clone.put((Object)"file.model", (Object)this.eCore.getStr("scan.response.model"));
                clone.put((Object)"work.mode", (Object)"scan.work.mode");
                this.scanQueue.put(clone);
            }
        }
        catch (InterruptedException e) {
            logger.error("filehandler enqueue failed: " + Thread.currentThread(), (Throwable)e);
        }
    }

    private void threadPush() {
        while (true) {
            MEvent ePush = null;
            if (!this.isScanSubscribe) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.error("\u6587\u4ef6\u5355\u63a8\u9001\u7ebf\u7a0b\u4e2d\u65ad", (Throwable)e);
                }
            }
            try {
                if (!this.isScanSubscribe) continue;
                if (this.scanQueue.size() > 5) {
                    this.recordToWrite.clear();
                    this.recordToWriteMap.clear();
                    this.scanQueue.drainTo(this.recordToWrite, 30);
                    logger.info("\u626b\u5355\u961f\u5217\u53d6\u51fa\u6d88\u606f\u4e8b\u4ef6\uff0csize\uff1a " + this.recordToWrite.size() + " \u5f53\u524d\u961f\u5217\u5269\u4f59\u6570\u91cf\uff1a" + this.scanQueue.size());
                    this.onFileOutput(this.recordToWrite, false);
                    continue;
                }
                ePush = this.scanQueue.take();
                String UUID2 = ePush.getStr("file.manipulate.record.uuid");
                logger.info("\u626b\u5355\u961f\u5217\u53d6\u51fa\u6d88\u606f\u4e8b\u4ef6\uff0c\u4e8b\u4ef6UUID\uff1a " + UUID2 + " \u5f53\u524d\u961f\u5217\u5269\u4f59\u6570\u91cf\uff1a" + this.scanQueue.size());
                this.onFileOutput(ePush, false);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("[push manager] dequeue failed: " + Thread.currentThread(), (Throwable)e);
                Thread.currentThread().interrupt();
                throw new RuntimeException();
            }
            catch (Exception e) {
                logger.error("single push failed: " + Thread.currentThread() + (ePush == null ? "" : ePush.get((Object)"method_code")), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void threadPushMonitor() {
        while (true) {
            MEvent ePush = null;
            if (!this.isMonitorSubscribe) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.error("\u6587\u4ef6\u5355\u76d1\u542c\u63a8\u9001\u7ebf\u7a0b\u4e2d\u65ad", (Throwable)e);
                }
            }
            try {
                if (!this.isMonitorSubscribe) continue;
                ePush = this.monitorQueue.take();
                String UUID2 = ePush.getStr("file.manipulate.record.uuid");
                logger.info("\u76d1\u542c\u961f\u5217\u53d6\u51fa\u6d88\u606f\u4e8b\u4ef6\uff0c\u4e8b\u4ef6UUID\uff1a " + UUID2 + " \u5f53\u524d\u961f\u5217\u5269\u4f59\u6570\u91cf\uff1a" + this.monitorQueue.size());
                this.onFileOutput(ePush, false);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("[push manager] dequeue failed: " + Thread.currentThread(), (Throwable)e);
                Thread.currentThread().interrupt();
                throw new RuntimeException();
            }
            catch (Exception e) {
                logger.error("single push failed: " + Thread.currentThread() + (ePush == null ? "" : ePush.get((Object)"method_code")), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void handleMultiFile(Path dst, MEvent e) throws IOException {
        String uuid = e.getStr("file.manipulate.record.uuid");
        String filename = FileUtils.getName((String)dst.toString());
        String[] fields = filename.split("\\.");
        logger.info("[" + uuid + "] \u591a\u6587\u4ef6\u6a21\u5f0f  receving filename: " + filename);
        e.put((Object)"file.name", (Object)filename);
        e.put((Object)"file.type", (Object)fields[2]);
        e.put((Object)"file.guid", (Object)fields[3]);
        e.put((Object)"file.model", (Object)fields[1]);
        String format = FileUtils.getFileExt((String)dst.toString());
        e.put((Object)"file.format", (Object)format);
        byte[] bytes = Files.readAllBytes(dst);
        logger.info("[" + uuid + "] receving content[" + new String(bytes) + "]");
        e.put((Object)"file.steam", (Object)bytes);
        this.handleEvent(e);
    }

    private void handleEvent(MEvent e) {
        String uuid = e.getStr("file.manipulate.record.uuid");
        String format = e.getStr("file.format");
        e.put((Object)"file.prefix", (Object)"res");
        logger.info("[" + uuid + "]  \u5f00\u59cb\u683c\u5f0f\u6821\u9a8c  event:" + e.entrySet());
        this.es.sendEvent("file/check/format/request/" + format, e);
        if (e.getCode() != 0) {
            logger.error("[" + uuid + "] \u683c\u5f0f\u6821\u9a8c\u9519\u8bef:  " + e.getDesc());
            File file = (File)e.get((Object)"file");
            if (e.getStr("file.model").equals("monofile")) {
                long readPos = e.getLong("monofile.last.read.pos");
                logger.info("[" + uuid + "]  \u683c\u5f0f\u6821\u9a8c\u4e0d\u5bf9  \u56de\u6eda\u9605\u8bfb\u4f4d\u7f6e\u5230\u4e0a\u6b21\u7ed3\u675f\u4f4d\u7f6e[" + readPos + "]");
                monoFileReadPos.put(file.getName(), readPos);
            }
            MEvent event = new MEvent();
            event.setDesc(String.valueOf(file.getName()) + "\uff0c\u6587\u4ef6\u5355\u683c\u5f0f\u6821\u9a8c\u9519\u8bef,  " + e.getDesc());
            this.es.postEvent("message.log", event);
            return;
        }
        logger.info("[" + uuid + "]  \u5f00\u59cb\u89e3\u6790\u5b57\u6bb5");
        this.es.sendEvent("file/parsing/request/" + format, e);
        if (e.getCode() != 0) {
            boolean containsKey;
            logger.error("[" + uuid + "] parsing error,  " + e.getDesc());
            File file = (File)e.get((Object)"file");
            if (e.getStr("file.model").equals("monofile")) {
                long readPos = e.getLong("monofile.last.read.pos");
                logger.info("[" + uuid + "]  \u89e3\u6790\u5b57\u6bb5\u9519\u8bef  \u56de\u6eda\u9605\u8bfb\u4f4d\u7f6e\u5230\u4e0a\u6b21\u7ed3\u675f\u4f4d\u7f6e[" + readPos + "]");
                monoFileReadPos.put(file.getName(), readPos);
            }
            if (containsKey = e.containsKey((Object)"file.manipulate.record.error.count")) {
                e.replace((Object)"file.manipulate.record.error.count", (Object)(e.getInt("file.manipulate.record.error.count") + 1));
            } else {
                e.put((Object)"file.manipulate.record.error.count", (Object)1);
            }
            this.es.postEvent("file/request/record", e);
            this.es.postEvent("message.log", e);
            return;
        }
        int count = e.children.size();
        logger.error("[" + uuid + "] \u89e3\u6790\u6210\u529f, \u603b\u5171[" + count + "]\u7b14\u4ea4\u6613");
        if (count == 0) {
            return;
        }
        logger.info("[" + uuid + "] \u5f00\u59cb\u5904\u7406\u4e0b\u5355");
        this.es.sendEvent("tran/file", e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void onFileOutput(MEvent e, boolean isRes) {
        long start = System.nanoTime();
        String uuid = e.getStr("file.manipulate.record.uuid");
        LoggerUtils.asyncLogger("[" + uuid + "]\u5f00\u59cb\u5904\u7406");
        try {
            String stream;
            long begin = System.nanoTime();
            String workMode = e.getStr("work.mode");
            String respath = workMode.equals("scan.work.mode") ? this.eCore.getStr("scan.res.req.folder") : this.eCore.getStr("monitor.res.req.folder");
            File resFolder = new File(respath);
            logger.info("[" + uuid + "] \u4e8b\u4ef6\u7684\u5de5\u4f5c\u6a21\u5f0f[" + workMode + "]\uff0c\u5f00\u59cb\u5904\u7406\u5199\u5165\u6587\u4ef6    : " + resFolder.getPath());
            if (!resFolder.exists()) {
                logger.error("[" + uuid + "] \u56de\u62a5\u76ee\u5f55\u672a\u521b\u5efa  \uff01");
                this.reportMessage("\u4e0d\u5b58\u5728\u7684\u56de\u62a5\u76ee\u5f55[" + resFolder.getPath() + "]");
                return;
            }
            String format = e.getStr("file.format");
            String type = e.getStr("file.type");
            String guid = e.getStr("file.guid");
            boolean bool = e.getBool("isRes");
            if (isRes || bool) {
                stream = e.getStr("res_file.steam");
                if (stream.isEmpty()) {
                    return;
                }
            } else {
                stream = Report.packLine(e);
                stream = String.valueOf(stream) + "\n";
            }
            logger.info("[" + uuid + "]\u4e8b\u4ef6\u7684\u5de5\u4f5c\u6a21\u5f0f[" + workMode + "] \u6253\u5305\u8017\u65f6[" + (System.currentTimeMillis() - start) + "]\u53d1\u9001\u4e8b\u4ef6\u53bb\u5904\u7406\u6253\u5305\u9700\u8981\u5199\u5165\u7684\u5185\u5bb9 , \u5185\u5bb9\u4e2a\u6570\uff1a" + e.children.size() + ",format[" + format + "], type[" + type + "]" + e);
            String model = e.getStr("file.model");
            String file_prefix = e.getStr("file.prefix");
            String recpath = workMode.equals("scan.work.mode") ? this.eCore.getStr("scan.rec.req.folder") : this.eCore.getStr("monitor.rec.req.folder");
            File recResFolder = new File(recpath);
            String name = String.format("%s.%s.%s.%s.%s", file_prefix, model, type, guid, format);
            Path resPath = Paths.get(resFolder.getAbsolutePath(), name);
            logger.info("[" + uuid + "]" + "\u6253\u5305\u5185\u5bb9 [" + stream + "], \u6587\u4ef6\u524d\u7f00[" + file_prefix + "], \u6587\u4ef6\u6a21\u5f0f[" + model + "] \u6587\u4ef6\u540d[" + name + "] \u5de5\u4f5c\u8def\u5f84[" + recResFolder + "]");
            if (stream.isEmpty()) {
                logger.info("[" + uuid + "]" + "\u5185\u5bb9\u4e3a\u7a7a\u5ffd\u7565");
                return;
            }
            if (model.equals("multifile")) {
                logger.info("[" + uuid + "]" + "\u591a\u6587\u4ef6\u6a21\u5f0f\u4e0b \u5de5\u4f5c\u76ee\u5f55\u4e2d \u5148\u5199\u5165 \u4e34\u65f6\u6587\u4ef6 ");
                Path recordPath = Paths.get(recResFolder.getAbsolutePath(), name);
                File recordFile = recordPath.toFile();
                start = System.currentTimeMillis();
                if (!recordFile.exists()) {
                    logger.info("[" + uuid + "]" + "\u591a\u6587\u4ef6\u6a21\u5f0f\u4e0b \u521b\u5efa\u5de5\u4f5c\u76ee\u5f55\u4e2d\u7684 \u4e34\u65f6\u6587\u4ef6 : " + recordFile.getPath());
                    recordFile.createNewFile();
                }
                FileOutputStream fos = new FileOutputStream(recordFile, true);
                if (e.getBool("query_all")) {
                    fos.write(stream.getBytes());
                    fos.close();
                    if (!e.getBool("query_all_end")) {
                        logger.info("\u5168\u91cf\u67e5\u8be2\u5206\u9875\u5199 [" + uuid + "] \u5199\u6587\u4ef6\u8017\u65f6[" + (System.currentTimeMillis() - start) + "], pageIndex[" + e.getInt("query_all_page_index") + "]\u5f53\u524d\u4e0d\u662f\u6700\u540e\u4e00\u9875");
                        return;
                    }
                    logger.info(" [" + uuid + "],\u5168\u91cf\u67e5\u8be2\u5206\u9875\u5199, \u6700\u540e\u4e00\u9875, pageIndex[" + e.getInt("query_all_page_index") + "] ");
                } else {
                    fos.write(stream.getBytes());
                    fos.close();
                    logger.info("[" + uuid + "] \u6807\u51c6\u8bf7\u6c42\uff0c \u5199\u6587\u4ef6\u8017\u65f6[" + (System.currentTimeMillis() - start) + "]");
                }
                logger.info("[" + uuid + "]" + "\u591a\u6587\u4ef6\u6a21\u5f0f\u4e0b \u6700\u540e\u79fb\u52a8\u5230\u56de\u62a5\u76ee\u5f55: " + resPath.toFile().getPath());
                if (Files.move(recordPath, resPath, StandardCopyOption.REPLACE_EXISTING) != null) {
                    logger.info("[" + uuid + "]" + "\u591a\u6587\u4ef6\u6a21\u5f0f\u4e0b \u79fb\u52a8\u5230\u56de\u62a5\u76ee\u5f55\u4e0b\u6210\u529f ");
                    return;
                } else {
                    logger.info("[" + uuid + "]" + "\u591a\u6587\u4ef6\u6a21\u5f0f\u4e0b \u79fb\u52a8\u5230\u56de\u62a5\u76ee\u5f55\u4e0b\u5931\u8d25 ");
                    this.reportMessage("\u591a\u6587\u4ef6\u6a21\u5f0f\u4e0b \u79fb\u52a8\u5230[" + resPath.toFile().getPath() + "]\u5931\u8d25");
                }
                return;
            }
            LoggerUtils.asyncLogger("[" + uuid + "]" + "\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b \u5de5\u4f5c\u76ee\u5f55\u4e2d \u76f4\u63a5\u8ffd\u52a0\u5185\u5bb9  ");
            RandomAccessFile randomResFile = null;
            try {
                try {
                    long WritePos = 0L;
                    if (monoResFileWritePos.containsKey(String.valueOf(name) + workMode)) {
                        WritePos = monoResFileWritePos.get(String.valueOf(name) + workMode);
                    }
                    logger.info("[" + uuid + "]" + "\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b\u6700\u540e\u8ffd\u52a0\u5185\u5bb9[" + stream + "]\u5230\u56de\u62a5\u76ee\u5f55: " + resPath.toFile().getPath() + ", \u4fdd\u5b58\u7684\u5f00\u59cb\u5199\u4f4d\u7f6e[" + WritePos + "]");
                    if (!resPath.toFile().exists()) {
                        resPath.toFile().createNewFile();
                        WritePos = 0L;
                    }
                    if (resPath.toFile().isFile() && resPath.toFile().length() != WritePos) {
                        WritePos = resPath.toFile().length();
                    }
                    if (this.list.contains(e.getFunctionCode()) && resPath.toFile().exists()) {
                        resPath.toFile().delete();
                        resPath.toFile().createNewFile();
                        WritePos = 0L;
                    }
                    LoggerUtils.asyncLogger("[" + uuid + "]" + "\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b\u6700\u540e\u8ffd\u52a0\u5185\u5bb9\u5230\u56de\u62a5\u76ee\u5f55: " + resPath.toFile().getPath() + ", \u8c03\u6574\u540e\u7684\u5f00\u59cb\u5199\u4f4d\u7f6e[" + WritePos + "]");
                    randomResFile = new RandomAccessFile(resPath.toFile(), "rw");
                    randomResFile.seek(WritePos);
                    randomResFile.write(stream.getBytes());
                    WritePos = randomResFile.length();
                    monoResFileWritePos.put(String.valueOf(name) + workMode, WritePos);
                    LoggerUtils.asyncLogger("[" + uuid + "]" + "\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b\u6700\u540e\u8ffd\u52a0\u5185\u5bb9\u5230\u6587\u4ef6[" + name + workMode + "]  \u7ed3\u675f\u5199\u4f4d\u7f6e[" + WritePos + "]" + "\u8017\u65f6" + (System.nanoTime() - begin));
                    this.times = 0;
                    return;
                }
                catch (FileNotFoundException e2) {
                    logger.error("[" + uuid + "]", (Throwable)e2);
                    ++this.times;
                    if (this.times < 3) {
                        logger.info("\u6587\u4ef6\u88ab\u5360\u7528 \u5f00\u59cb\u91cd\u8bd5 \u6b21\u6570 " + this.times);
                        this.onFileOutput(e, isRes);
                    }
                    if (randomResFile == null) return;
                    try {
                        randomResFile.close();
                        return;
                    }
                    catch (IOException e1) {
                        logger.error("[" + uuid + "]", (Throwable)e1);
                        this.reportMessage("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b  \u5173\u95ed\u6587\u4ef6\u5931\u8d25");
                    }
                    return;
                }
                catch (Exception e2) {
                    logger.error("[" + uuid + "]", (Throwable)e2);
                    this.reportMessage("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b \u8ffd\u52a0\u5185\u5bb9\u5230\u6587\u4ef6[" + name + workMode + "]\u5931\u8d25\uff0c \u62d2\u7edd\u8bbf\u95ee\uff01");
                    if (randomResFile == null) return;
                    try {
                        randomResFile.close();
                        return;
                    }
                    catch (IOException e1) {
                        logger.error("[" + uuid + "]", (Throwable)e1);
                        this.reportMessage("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b  \u5173\u95ed\u6587\u4ef6\u5931\u8d25");
                    }
                    return;
                }
            }
            finally {
                if (randomResFile != null) {
                    try {
                        randomResFile.close();
                    }
                    catch (IOException e1) {
                        logger.error("[" + uuid + "]", (Throwable)e1);
                        this.reportMessage("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b  \u5173\u95ed\u6587\u4ef6\u5931\u8d25");
                    }
                }
            }
        }
        catch (Exception e2) {
            logger.error("[" + uuid + "]", (Throwable)e2);
            this.reportMessage(" \u5199\u56de\u62a5\u6587\u4ef6\u5931\u8d25\uff0c" + e2.getMessage());
        }
    }

    private synchronized void onFileOutput(List<MEvent> events, boolean isRes) {
        String workMode = "scan.work.mode";
        String respath = this.eCore.getStr("scan.res.req.folder");
        File resFolder = new File(respath);
        logger.info("\u626b\u5355\u4e8b\u4ef6\u5f00\u59cb\u6279\u91cf\u5904\u7406\u5199\u5165\u6587\u4ef6    : " + resFolder.getPath());
        if (!resFolder.exists()) {
            logger.error("\u56de\u62a5\u76ee\u5f55\u672a\u521b\u5efa  \uff01" + resFolder.getPath());
            this.reportMessage("\u4e0d\u5b58\u5728\u7684\u56de\u62a5\u76ee\u5f55[" + resFolder.getPath() + "]");
            return;
        }
        for (MEvent mEvent : events) {
            String uuid = mEvent.getStr("file.manipulate.record.uuid");
            try {
                String stream;
                String format = mEvent.getStr("file.format");
                String type = mEvent.getStr("file.type");
                String guid = mEvent.getStr("file.guid");
                boolean bool = mEvent.getBool("isRes");
                String model = mEvent.getStr("file.model");
                String file_prefix = mEvent.getStr("file.prefix");
                String name = String.format("%s.%s.%s.%s.%s", file_prefix, model, type, guid, format);
                StringBuilder sb = this.recordToWriteMap.get(name);
                if (sb == null) {
                    sb = new StringBuilder();
                    this.recordToWriteMap.put(name, sb);
                }
                if (isRes || bool) {
                    stream = mEvent.getStr("res_file.steam");
                    if (stream.isEmpty()) {
                        continue;
                    }
                } else {
                    stream = Report.packLine(mEvent);
                    stream = String.valueOf(stream) + "\n";
                }
                sb.append(stream);
            }
            catch (Exception e2) {
                logger.error("[" + uuid + "]", (Throwable)e2);
                this.reportMessage(" \u5199\u56de\u62a5\u6587\u4ef6\u5931\u8d25\uff0c" + e2.getMessage());
            }
        }
        logger.info("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b \u5de5\u4f5c\u76ee\u5f55\u4e2d \u76f4\u63a5\u8ffd\u52a0\u5185\u5bb9  ");
        for (Map.Entry entry : this.recordToWriteMap.entrySet()) {
            long begin = System.nanoTime();
            RandomAccessFile randomResFile = null;
            try {
                try {
                    long WritePos = 0L;
                    if (monoResFileWritePos.containsKey(String.valueOf((String)entry.getKey()) + workMode)) {
                        WritePos = monoResFileWritePos.get(String.valueOf((String)entry.getKey()) + workMode);
                    }
                    Path resPath = Paths.get(resFolder.getAbsolutePath(), (String)entry.getKey());
                    logger.info("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b\u6700\u540e\u8ffd\u52a0\u5185\u5bb9[" + entry.getValue() + "]\u5230\u56de\u62a5\u76ee\u5f55: " + resPath.toFile().getPath() + ", \u4fdd\u5b58\u7684\u5f00\u59cb\u5199\u4f4d\u7f6e[" + WritePos + "]");
                    if (!resPath.toFile().exists()) {
                        resPath.toFile().createNewFile();
                        WritePos = 0L;
                    }
                    if (resPath.toFile().isFile() && resPath.toFile().length() != WritePos) {
                        WritePos = resPath.toFile().length();
                    }
                    randomResFile = new RandomAccessFile(resPath.toFile(), "rw");
                    randomResFile.seek(WritePos);
                    randomResFile.write(String.valueOf(entry.getValue()).getBytes());
                    WritePos = randomResFile.length();
                    monoResFileWritePos.put(String.valueOf((String)entry.getKey()) + workMode, WritePos);
                    logger.info("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b\u6700\u540e\u8ffd\u52a0\u5185\u5bb9\u5230\u6587\u4ef6[" + (String)entry.getKey() + workMode + "]  \u7ed3\u675f\u5199\u4f4d\u7f6e[" + WritePos + "]" + "\u8017\u65f6" + (System.nanoTime() - begin));
                }
                catch (Exception e2) {
                    logger.error("[\u6279\u91cf\u5199\u56de\u62a5\u6587\u4ef6\u51fa\u9519]", (Throwable)e2);
                    this.reportMessage("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b \u8ffd\u52a0\u5185\u5bb9\u5230\u6587\u4ef6[" + (String)entry.getKey() + workMode + "]\u5931\u8d25\uff0c \u62d2\u7edd\u8bbf\u95ee\uff01");
                    if (randomResFile == null) continue;
                    try {
                        randomResFile.close();
                    }
                    catch (IOException e1) {
                        logger.error("[\u6279\u91cf\u5199\u56de\u62a5\u6587\u4ef6\u51fa\u9519]", (Throwable)e1);
                        this.reportMessage("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b  \u5173\u95ed\u6587\u4ef6\u5931\u8d25");
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (randomResFile != null) {
                    try {
                        randomResFile.close();
                    }
                    catch (IOException e1) {
                        logger.error("[\u6279\u91cf\u5199\u56de\u62a5\u6587\u4ef6\u51fa\u9519]", (Throwable)e1);
                        this.reportMessage("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b  \u5173\u95ed\u6587\u4ef6\u5931\u8d25");
                    }
                }
                throw throwable;
            }
            if (randomResFile == null) continue;
            try {
                randomResFile.close();
            }
            catch (IOException e1) {
                logger.error("[\u6279\u91cf\u5199\u56de\u62a5\u6587\u4ef6\u51fa\u9519]", (Throwable)e1);
                this.reportMessage("\u5355\u6587\u4ef6\u6a21\u5f0f\u4e0b  \u5173\u95ed\u6587\u4ef6\u5931\u8d25");
            }
        }
    }

    private void reportMessage(String content) {
        MEvent event = new MEvent();
        event.setDesc(content);
        this.es.postEvent("message.log", event);
    }

    private void buildInstructionRecord(InstructionFlowRecord re) {
        String clInstructionId = "";
        if (!StringUtils.isEmpty((String)re.getClInstructionId()) && re.getClInstructionId().contains("|")) {
            String[] split = re.getClInstructionId().split("\\|");
            if (split.length == 3) {
                clInstructionId = split[2];
            }
        } else {
            clInstructionId = re.getClInstructionId();
        }
        MEvent event = new MEvent();
        event.put((Object)"topic", (Object)"instruction_flow");
        event.put((Object)"INSTRUCTION_ID", (Object)re.getInstructionId());
        event.put((Object)"cl_instruction_id", (Object)clInstructionId);
        event.put((Object)"INSTRUCTION_STATUS_CODE", (Object)re.getInstructionStatusCode());
        event.put((Object)"INSTRUCTION_STATUS", (Object)re.getInstructionStatus().getValue());
        event.put((Object)"INSTRUCTION_REMARK", (Object)re.getRemark());
        this.receiveCallBack(event, 630952, "instruction_flow");
    }

    private void buildEntrustCancelReport(MEvent event, cms.tmx.entity.notice.ExecutionReport report) {
        event.put((Object)"topic", (Object)"entrust_cancel");
        event.put((Object)"cust_no", (Object)report.getReport().getExtAccntId().substring(0, report.getReport().getExtAccntId().indexOf("_")));
        event.put((Object)"entrust_no", (Object)report.getReport().getOrderId());
        event.put((Object)"batch_id", (Object)report.getReport().getListId());
        event.put((Object)"entrust_status", (Object)report.getReport().getOrdStatusValue());
        event.put((Object)"cancel_vol", (Object)report.getReport().getCxlQty());
        event.put((Object)"portfolio_id", (Object)report.getReport().getPortfolioId());
        this.receiveCallBack(event, 630952, "entrust_cancel");
    }

    private void buildEntrustRejectReport(MEvent event, cms.tmx.entity.notice.ExecutionReport report) {
        event.put((Object)"topic", (Object)"entrust_reject");
        event.put((Object)"cust_no", (Object)report.getReport().getExtAccntId().substring(0, report.getReport().getExtAccntId().indexOf("_")));
        event.put((Object)"entrust_no", (Object)report.getReport().getOrderId());
        event.put((Object)"exchange_err_code", (Object)report.getReport().getOrdRejReason());
        event.put((Object)"err_msg", (Object)report.getReport().getRejMsg());
        event.put((Object)"batch_id", (Object)report.getReport().getListId());
        event.put((Object)"portfolio_id", (Object)report.getReport().getPortfolioId());
        this.receiveCallBack(event, 630952, "entrust_reject");
    }

    private void buildEntrustConfirmReport(MEvent event, cms.tmx.entity.notice.ExecutionReport report) {
        event.put((Object)"topic", (Object)"entrust_confirm");
        event.put((Object)"cust_no", (Object)report.getReport().getExtAccntId().substring(0, report.getReport().getExtAccntId().indexOf("_")));
        event.put((Object)"contract_no", (Object)"");
        event.put((Object)"bs", (Object)ConvertUtils.getBsFlag(report.getReport().getSideValue()));
        event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(report.getReport().getInstrument().getMarket()));
        event.put((Object)"entrust_vol", (Object)report.getReport().getOrderQty());
        event.put((Object)"price", (Object)report.getReport().getPrice());
        event.put((Object)"holder_acc_no", (Object)report.getReport().getExtSecAccntId().substring(0, report.getReport().getExtSecAccntId().indexOf("_")));
        event.put((Object)"sec_code", (Object)report.getReport().getInstrument().getSecurityId());
        event.put((Object)"rpt_contract_no", (Object)report.getReport().getReportOrdId());
        event.put((Object)"org_contract_no", (Object)report.getReport().getOrderId());
        event.put((Object)"batch_id", (Object)report.getReport().getListId());
        event.put((Object)"portfolio_id", (Object)report.getReport().getPortfolioId());
        event.put((Object)"confirm_time", (Object)report.getReport().getTransactTime());
        String clOrdLinkId = report.getReport().getClOrdLinkId();
        if (!StringUtils.isEmpty((String)clOrdLinkId) && !clOrdLinkId.contains("|")) {
            event.put((Object)"list_leg_id", (Object)clOrdLinkId);
        }
        this.receiveCallBack(event, 630952, "entrust_confirm");
    }

    private void buildEntrustDoneReport(MEvent event, cms.tmx.entity.notice.ExecutionReport report) {
        event.put((Object)"topic", (Object)"entrust_done");
        event.put((Object)"cust_no", (Object)report.getReport().getExtAccntId().substring(0, report.getReport().getExtAccntId().indexOf("_")));
        event.put((Object)"contract_no", (Object)"");
        event.put((Object)"bs", (Object)ConvertUtils.getBsFlag(report.getReport().getSideValue()));
        event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(report.getReport().getInstrument().getMarket()));
        event.put((Object)"done_no", (Object)report.getReport().getExecId());
        event.put((Object)"done_vol", (Object)report.getReport().getLastQty());
        event.put((Object)"done_time", (Object)report.getReport().getTransactTime());
        event.put((Object)"done_price", (Object)report.getReport().getLastPx());
        event.put((Object)"done_amt", (Object)report.getReport().getTradeAmount());
        event.put((Object)"done_status", (Object)report.getReport().getOrdStatusValue());
        event.put((Object)"currency_type", (Object)ConvertUtils.getCurrency(report.getReport().getExtAccntId().substring(report.getReport().getExtAccntId().indexOf("_") + 1)));
        event.put((Object)"fund_acc_no", (Object)report.getReport().getExtAccntId().substring(0, report.getReport().getExtAccntId().indexOf("_")));
        event.put((Object)"holder_acc_no", (Object)report.getReport().getExtSecAccntId().substring(0, report.getReport().getExtSecAccntId().indexOf("_")));
        event.put((Object)"sec_code", (Object)report.getReport().getInstrument().getSecurityId());
        event.put((Object)"portfolio_id", (Object)report.getReport().getPortfolioId());
        event.put((Object)"entrust_status", (Object)ConvertUtils.getOrderStatus(report.getReport().getOrdStatusValue()));
        event.put((Object)"org_contract_no", (Object)report.getReport().getOrderId());
        event.put((Object)"rpt_contract_no", (Object)report.getReport().getReportOrdId());
        event.put((Object)"batch_id", (Object)report.getReport().getListId());
        this.receiveCallBack(event, 630952, "entrust_done");
    }

    public void buildOrderQuery(List<POrderService.SingleOrder> orderList, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (orderList.isEmpty()) {
            event.put((Object)"topic", (Object)"order_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"batch_sno", (Object)"");
            event.put((Object)"query_index", (Object)"");
            event.put((Object)"contract_no", (Object)"");
            event.put((Object)"currency_type", (Object)"");
            event.put((Object)"entrust_price", (Object)0);
            event.put((Object)"bs", (Object)"");
            event.put((Object)"count", (Object)0);
            event.put((Object)"holder_acc_no", (Object)"");
            event.put((Object)"market_code", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"order_time", (Object)"");
            event.put((Object)"entrust_status", (Object)"");
            event.put((Object)"withdraw_flag", (Object)"");
            event.put((Object)"entrust_date", (Object)"");
            event.put((Object)"org_contract_no", (Object)"");
            event.put((Object)"done_vol", (Object)0);
            event.put((Object)"done_price", (Object)0);
            event.put((Object)"withdraw_vol", (Object)0);
            event.put((Object)"rpt_contract_no", (Object)"");
            event.put((Object)"basket_no", (Object)"");
            event.put((Object)"client_seq", (Object)"");
            event.put((Object)"portfolio_id", (Object)"");
            event.put((Object)"portfolio_name", (Object)"");
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 630005, "order_query");
            }
            return;
        }
        for (POrderService.SingleOrder en : orderList) {
            try {
                event = new MEvent();
                PCcsExtra.CcsSingleOrderExtra ccs = (PCcsExtra.CcsSingleOrderExtra)en.getObject().unpack(PCcsExtra.CcsSingleOrderExtra.class);
                event.put((Object)"topic", (Object)"order_query");
                event.put((Object)"return_code", (Object)e.getCode());
                event.put((Object)"return_message", (Object)e.getDesc());
                event.put((Object)"cust_no", (Object)ccs.getExtAccntId().substring(0, ccs.getExtAccntId().indexOf("_")));
                event.put((Object)"batch_sno", (Object)"");
                event.put((Object)"query_index", (Object)"");
                event.put((Object)"contract_no", (Object)en.getOrderId());
                event.put((Object)"currency_type", (Object)ConvertUtils.getCurrency(ccs.getExtAccntId().substring(ccs.getExtAccntId().indexOf("_") + 1)));
                event.put((Object)"entrust_price", (Object)en.getPrice());
                event.put((Object)"bs", (Object)ConvertUtils.getBsFlag(en.getSideValue()));
                event.put((Object)"count", (Object)en.getOrderQty());
                event.put((Object)"holder_acc_no", (Object)en.getExtSecAccntId().substring(0, en.getExtSecAccntId().indexOf("_")));
                event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(en.getInstrument().getMarket()));
                event.put((Object)"sec_code", (Object)en.getInstrument().getSecurityId());
                event.put((Object)"sec_name", (Object)en.getInstrument().getSymbol());
                event.put((Object)"order_time", (Object)en.getOrdTime());
                event.put((Object)"entrust_status", (Object)ConvertUtils.getOrderStatus(en.getOrdStatusValue()));
                event.put((Object)"withdraw_flag", (Object)"");
                event.put((Object)"entrust_date", (Object)en.getOrdDate());
                event.put((Object)"org_contract_no", (Object)en.getSysOrderId());
                event.put((Object)"done_vol", (Object)en.getCumQty());
                event.put((Object)"done_price", (Object)en.getAvgPx());
                event.put((Object)"withdraw_vol", (Object)ccs.getWthQty());
                event.put((Object)"rpt_contract_no", (Object)"");
                event.put((Object)"basket_no", (Object)"");
                if ("2".equals(Integer.toString(ccs.getLegModeValue()))) {
                    event.put((Object)"client_seq", (Object)en.getAttachment().substring(en.getAttachment().lastIndexOf("|") + 1));
                } else {
                    event.put((Object)"client_seq", (Object)en.getClOrdId().substring(en.getClOrdId().lastIndexOf("|") + 1));
                }
                event.put((Object)"portfolio_id", (Object)ccs.getPortfolioId());
                if (!StringUtils.isEmpty((String)ccs.getPortfolioId())) {
                    String name = this.portAccModel.getPortfolioNameById(ccs.getPortfolioId());
                    event.put((Object)"portfolio_name", (Object)name);
                }
                String order = Report.packLine(event);
                str.append(order).append("\n");
            }
            catch (InvalidProtocolBufferException e1) {
                logger.error(e1.getMessage());
            }
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 630005, "order_query");
        }
    }

    public void buildDealQuery(List<POrderService.Execution> dealList, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (dealList.isEmpty()) {
            event.put((Object)"topic", (Object)"deal_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"query_index", (Object)"");
            event.put((Object)"contract_no", (Object)"");
            event.put((Object)"currency_type", (Object)"");
            event.put((Object)"bs", (Object)"");
            event.put((Object)"done_no", (Object)"");
            event.put((Object)"client_seq", (Object)"");
            event.put((Object)"done_amt", (Object)0);
            event.put((Object)"done_price", (Object)0);
            event.put((Object)"done_time", (Object)"");
            event.put((Object)"deal_count", (Object)0);
            event.put((Object)"market_code", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"org_contract_no", (Object)"");
            event.put((Object)"withdraw_flag", (Object)"");
            event.put((Object)"done_status", (Object)"");
            event.put((Object)"trade_fee", (Object)0);
            event.put((Object)"rpt_contract_no", (Object)"");
            event.put((Object)"basket_no", (Object)"");
            event.put((Object)"error_no", (Object)"");
            event.put((Object)"error_info", (Object)"");
            event.put((Object)"portfolio_id", (Object)"");
            event.put((Object)"portfolio_name", (Object)"");
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 630006, "deal_query");
            }
            return;
        }
        for (POrderService.Execution deal : dealList) {
            event = new MEvent();
            event.put((Object)"topic", (Object)"deal_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)deal.getExtAccntId().substring(0, deal.getExtAccntId().indexOf("_")));
            event.put((Object)"query_index", (Object)"");
            event.put((Object)"contract_no", (Object)deal.getOrderId());
            event.put((Object)"currency_type", (Object)ConvertUtils.getCurrency(deal.getExtAccntId().substring(deal.getExtAccntId().indexOf("_") + 1)));
            event.put((Object)"bs", (Object)ConvertUtils.getBsFlag(deal.getSideValue()));
            event.put((Object)"done_no", (Object)deal.getExecId());
            event.put((Object)"client_seq", (Object)deal.getClOrdId().substring(deal.getClOrdId().lastIndexOf("|") + 1));
            event.put((Object)"done_amt", (Object)deal.getLastAmount());
            event.put((Object)"done_price", (Object)deal.getLastPx());
            event.put((Object)"done_time", (Object)deal.getExecTime());
            event.put((Object)"deal_count", (Object)deal.getLastQty());
            event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(deal.getInstrument().getMarket()));
            event.put((Object)"sec_code", (Object)deal.getInstrument().getSecurityId());
            event.put((Object)"sec_name", (Object)deal.getInstrument().getSymbol());
            event.put((Object)"org_contract_no", (Object)deal.getSysOrderId());
            event.put((Object)"withdraw_flag", (Object)"");
            event.put((Object)"done_status", (Object)"");
            event.put((Object)"trade_fee", (Object)0);
            event.put((Object)"rpt_contract_no", (Object)"");
            event.put((Object)"basket_no", (Object)"");
            event.put((Object)"error_no", (Object)"");
            event.put((Object)"error_info", (Object)"");
            try {
                PCcsExtra.CcsExecutionExtra ccsDeal = (PCcsExtra.CcsExecutionExtra)deal.getObject().unpack(PCcsExtra.CcsExecutionExtra.class);
                event.put((Object)"portfolio_id", (Object)ccsDeal.getPortfolioId());
                if (!StringUtils.isEmpty((String)ccsDeal.getPortfolioId())) {
                    String name = this.portAccModel.getPortfolioNameById(ccsDeal.getPortfolioId());
                    event.put((Object)"portfolio_name", (Object)name);
                }
            }
            catch (InvalidProtocolBufferException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 630006, "deal_query");
        }
    }

    public void buildPositionQuery(Set<Position> list, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"position_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"query_index", (Object)"");
            event.put((Object)"total_vol", (Object)0);
            event.put((Object)"sec_day_start", (Object)0);
            event.put((Object)"sec_avl", (Object)0);
            event.put((Object)"sec_trans_avl", (Object)0);
            event.put((Object)"cur_sell_vol", (Object)0);
            event.put((Object)"cur_buy_vol", (Object)0);
            event.put((Object)"holder_acc_no", (Object)"");
            event.put((Object)"market_code", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"sec_type", (Object)"");
            event.put((Object)"sell_frozen_vol", (Object)0);
            event.put((Object)"manual_frozen_vol", (Object)0);
            event.put((Object)"manual_unfrozen_vol", (Object)0);
            event.put((Object)"transfer_in_vol", (Object)0);
            event.put((Object)"transfer_out_vol", (Object)0);
            event.put((Object)"cost_price", (Object)0);
            event.put((Object)"profit", (Object)0);
            event.put((Object)"portfolio_id", (Object)"");
            event.put((Object)"portfolio_name", (Object)"");
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 630004, "position_query");
            }
            return;
        }
        for (Position po : list) {
            event = new MEvent();
            CcsPosition ccs = (CcsPosition)CcsPosition.class.cast(po);
            event.put((Object)"topic", (Object)"position_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)po.getExtAccId().substring(0, po.getExtAccId().indexOf("_")));
            event.put((Object)"query_index", (Object)"");
            event.put((Object)"total_vol", (Object)ccs.getTotalVol());
            event.put((Object)"sec_day_start", (Object)0);
            event.put((Object)"sec_avl", (Object)ccs.getCanVol());
            event.put((Object)"sec_trans_avl", (Object)0);
            event.put((Object)"cur_sell_vol", (Object)0);
            event.put((Object)"cur_buy_vol", (Object)0);
            event.put((Object)"holder_acc_no", (Object)po.getExtSecAccId().substring(0, po.getExtSecAccId().indexOf("_")));
            event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(po.getMarket().getRaw()));
            event.put((Object)"sec_code", (Object)po.getSecId());
            event.put((Object)"sec_name", (Object)po.getSecName());
            event.put((Object)"sec_type", (Object)po.getSecType());
            event.put((Object)"sell_frozen_vol", (Object)ccs.getSellOutFrozen());
            event.put((Object)"manual_frozen_vol", (Object)ccs.getManualFrozen());
            event.put((Object)"manual_unfrozen_vol", (Object)ccs.getManualUnfrozen());
            event.put((Object)"transfer_in_vol", (Object)ccs.getTransferIn());
            event.put((Object)"transfer_out_vol", (Object)ccs.getTransferOut());
            event.put((Object)"cost_price", (Object)ccs.getCost());
            event.put((Object)"profit", (Object)ccs.getProfit());
            if (!StringUtils.isEmpty((String)e.getStr("portfolio_id"))) {
                String portfolioId = e.getStr("portfolio_id");
                event.put((Object)"portfolio_id", (Object)portfolioId);
                String name = this.portAccModel.getPortfolioNameById(portfolioId);
                event.put((Object)"portfolio_name", (Object)name);
            }
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 630004, "position_query");
        }
    }

    public void buildAccountQuery(List<FundAccount> list, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"account_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"currency_type", (Object)"");
            event.put((Object)"fund_day_start", (Object)0);
            event.put((Object)"balance", (Object)0);
            event.put((Object)"fund_acct", (Object)"");
            event.put((Object)"frozen_balance", (Object)0);
            event.put((Object)"transfer_in_amt", (Object)0);
            event.put((Object)"transfer_out_amt", (Object)0);
            event.put((Object)"portfolio_id", (Object)"");
            event.put((Object)"portfolio_name", (Object)"");
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 630002, "account_query");
            }
            return;
        }
        for (FundAccount account : list) {
            event = new MEvent();
            CcsFundAccount ccs = (CcsFundAccount)CcsFundAccount.class.cast(account);
            event.put((Object)"topic", (Object)"account_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)ccs.getInvestId());
            event.put((Object)"currency_type", (Object)ConvertUtils.getCurrency(ccs.getCurrency()));
            event.put((Object)"fund_day_start", (Object)ccs.getPreBalance());
            event.put((Object)"balance", (Object)ccs.getAvailable());
            event.put((Object)"fund_acct", (Object)ccs.getExtAccntId());
            event.put((Object)"frozen_balance", (Object)ccs.getFrozenAmount());
            event.put((Object)"transfer_in_amt", (Object)0);
            event.put((Object)"transfer_out_amt", (Object)0);
            if (!StringUtils.isEmpty((String)e.getStr("portfolio_id"))) {
                CcsSubFundAccount sub = (CcsSubFundAccount)CcsSubFundAccount.class.cast(account);
                event.put((Object)"portfolio_id", (Object)sub.getPortfolioId());
                String name = this.portAccModel.getPortfolioNameById(sub.getPortfolioId());
                event.put((Object)"portfolio_name", (Object)name);
                event.put((Object)"frozen_balance", (Object)sub.getSubFrozenAmount());
            }
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 630002, "account_query");
        }
    }

    public void buildTransferQuery(List<TransRecord> list, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"transfer_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"transfer_type", (Object)e.getStr("transfer_type"));
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"holder_acc_no", (Object)"");
            event.put((Object)"source", (Object)"");
            event.put((Object)"target", (Object)"");
            event.put((Object)"transfer_amt", (Object)0);
            event.put((Object)"currency_type", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"transfer_qty", (Object)0);
            event.put((Object)"transfer_price", (Object)0);
            event.put((Object)"oper_date", (Object)"");
            event.put((Object)"oper_time", (Object)"");
            event.put((Object)"user_id", (Object)"");
            event.put((Object)"party_Id", (Object)"");
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 630007, "transfer_query");
            }
            return;
        }
        for (TransRecord trans : list) {
            event = new MEvent();
            event.put((Object)"topic", (Object)"transfer_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"transfer_type", (Object)e.getStr("transfer_type"));
            event.put((Object)"cust_no", (Object)trans.getFundAccId());
            event.put((Object)"holder_acc_no", (Object)trans.getSecAccId());
            event.put((Object)"source", (Object)trans.getMasterPortId());
            event.put((Object)"target", (Object)trans.getSlavePortId());
            event.put((Object)"transfer_amt", StringUtils.isEmpty((String)trans.getTransAmt()) ? Integer.valueOf(0) : trans.getTransAmt());
            event.put((Object)"currency_type", (Object)trans.getCurrency());
            event.put((Object)"sec_code", (Object)trans.getCode());
            event.put((Object)"sec_name", (Object)trans.getName());
            event.put((Object)"transfer_qty", (Object)trans.getCount());
            event.put((Object)"transfer_price", (Object)trans.getPrice());
            event.put((Object)"oper_date", (Object)trans.getOperDate());
            event.put((Object)"oper_time", (Object)trans.getOperTime());
            event.put((Object)"user_id", (Object)trans.getUserId());
            event.put((Object)"party_Id", (Object)trans.getPartyId());
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 630007, "transfer_query");
        }
    }

    public void buildInstructionQuery(List<Instruction> list, MEvent e, MEvent parent) {
        List commonIns = list.stream().filter(item -> "2".equals(item.getType().getRaw())).collect(Collectors.toList());
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"instruction_query");
            event.put((Object)"return_code", (Object)"");
            event.put((Object)"return_message", (Object)"");
            event.put((Object)"INSTRUCTION_ID", (Object)"");
            event.put((Object)"INSTRUCTION_BELONG_TO", (Object)"");
            event.put((Object)"INSTRUCTION_TYPE", (Object)"");
            event.put((Object)"INSTRUCTION_TARGET_NAME", (Object)"");
            event.put((Object)"INSTRUCTION_COUNT", (Object)0);
            event.put((Object)"INSTRUCTION_PRICE", (Object)0);
            event.put((Object)"INSTRUCTION_SIDE", (Object)"");
            event.put((Object)"INSTRUCTION_PROGRESS", (Object)0);
            event.put((Object)"INSTRUCTION_CUM_AMOUNT", (Object)0);
            event.put((Object)"INSTRUCTION_AVG_PRICE", (Object)0);
            event.put((Object)"INSTRUCTION_STATUS", (Object)"");
            event.put((Object)"INSTRUCTION_BEGIN", (Object)"");
            event.put((Object)"INSTRUCTION_END", (Object)"");
            event.put((Object)"INSTRUCTION_REMARK", (Object)"");
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 500011, "instruction_query");
            }
            return;
        }
        for (Instruction ins : commonIns) {
            event.put((Object)"topic", (Object)"instruction_query");
            event.put((Object)"return_code", (Object)"");
            event.put((Object)"return_message", (Object)"");
            event.put((Object)"INSTRUCTION_ID", (Object)ins.getId());
            event.put((Object)"INSTRUCTION_BELONG_TO", (Object)ins.getBelongTo());
            event.put((Object)"INSTRUCTION_TYPE", (Object)ins.getType().getValue());
            event.put((Object)"INSTRUCTION_TARGET_NAME", (Object)ins.getOrderObj());
            event.put((Object)"INSTRUCTION_COUNT", (Object)ins.getTotalExpectationQty());
            event.put((Object)"INSTRUCTION_PRICE", (Object)ins.getInsPrice());
            event.put((Object)"INSTRUCTION_SIDE", (Object)ins.getSide());
            event.put((Object)"INSTRUCTION_PROGRESS", (Object)ins.getResource().getRatio());
            event.put((Object)"INSTRUCTION_CUM_AMOUNT", (Object)ins.getCumAmount());
            event.put((Object)"INSTRUCTION_AVG_PRICE", (Object)ins.getAvgPx());
            event.put((Object)"INSTRUCTION_STATUS", (Object)ins.getStatus().getValue());
            event.put((Object)"INSTRUCTION_BEGIN", (Object)ins.getBeginTime());
            event.put((Object)"INSTRUCTION_END", (Object)ins.getEndTime());
            event.put((Object)"INSTRUCTION_REMARK", (Object)ins.getErrInfo());
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 500011, "instruction_query");
        }
    }

    public void buildMarginAccountQuery(Sofp sofp, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (sofp == null) {
            event.put((Object)"topic", (Object)"margin_account_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"fund_acct", (Object)"");
            event.put((Object)"current_balance", (Object)0);
            event.put((Object)"balance", (Object)0);
            event.put((Object)"enable_bail_balance", (Object)0);
            event.put((Object)"FCREDIT_AVL", (Object)0);
            event.put((Object)"DCREDIT_AVL", (Object)0);
            event.put((Object)"FTOTAL_DEBTS", (Object)0);
            event.put((Object)"DTOTAL_DEBTS", (Object)0);
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 630002, "margin_account_query");
            }
            return;
        }
        event.put((Object)"topic", (Object)"margin_account_query");
        event.put((Object)"return_code", (Object)e.getCode());
        event.put((Object)"return_message", (Object)e.getDesc());
        event.put((Object)"fund_acct", (Object)this.fundMng.getCcsInvestorId(sofp.getCashAccntId()));
        event.put((Object)"current_balance", (Object)sofp.getBalance());
        event.put((Object)"balance", (Object)sofp.getAvailable());
        event.put((Object)"enable_bail_balance", (Object)sofp.getMarginAvl());
        event.put((Object)"FCREDIT_AVL", (Object)sofp.getFcreditAvl());
        event.put((Object)"DCREDIT_AVL", (Object)sofp.getDcreditAvl());
        event.put((Object)"FTOTAL_DEBTS", (Object)sofp.getFtotalDebts());
        event.put((Object)"DTOTAL_DEBTS", (Object)sofp.getDtotalDebts());
        String order = Report.packLine(event);
        str.append(order).append("\n");
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 630002, "margin_account_query");
        }
    }

    public void buildMarginOrderQuery(List<SingleOrder> list, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"margin_order_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"contract_no", (Object)"");
            event.put((Object)"entrust_price", (Object)0);
            event.put((Object)"bs", (Object)"");
            event.put((Object)"market_indicator", (Object)"");
            event.put((Object)"count", (Object)0);
            event.put((Object)"holder_acc_no", (Object)"");
            event.put((Object)"market_code", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"order_time", (Object)"");
            event.put((Object)"entrust_status", (Object)"");
            event.put((Object)"entrust_date", (Object)"");
            event.put((Object)"done_vol", (Object)0);
            event.put((Object)"done_price", (Object)0);
            event.put((Object)"withdraw_vol", (Object)0);
            event.put((Object)"rpt_contract_no", (Object)"");
            event.put((Object)"basket_no", (Object)"");
            event.put((Object)"client_seq", (Object)"");
            event.put((Object)"batch_sno", (Object)"");
            event.put((Object)"query_index", (Object)"");
            event.put((Object)"currency_type", (Object)"");
            event.put((Object)"org_contract_no", (Object)"");
            event.put((Object)"batch_id", (Object)"");
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 640005, "margin_order_query");
            }
            return;
        }
        for (SingleOrder en : list) {
            event = new MEvent();
            event.put((Object)"topic", (Object)"margin_order_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)en.getInvestorId());
            event.put((Object)"contract_no", (Object)en.getExtOrderId());
            event.put((Object)"entrust_price", (Object)en.getPrice());
            event.put((Object)"bs", (Object)ConvertUtils.getBsFlag(Integer.parseInt(en.getSide().getValue())));
            event.put((Object)"market_indicator", (Object)MarketIndicator.getCode((String)en.getInstrument().getMarketIndicator()));
            event.put((Object)"count", (Object)en.getOrderQty());
            event.put((Object)"holder_acc_no", (Object)en.getInvestorSecId());
            event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(en.getInstrument().getMarket()));
            event.put((Object)"sec_code", (Object)en.getInstrument().getSecurityId());
            event.put((Object)"sec_name", (Object)en.getInstrument().getSymbol());
            event.put((Object)"order_time", (Object)en.getOrdTime());
            event.put((Object)"entrust_status", (Object)ConvertUtils.getOrderStatus(Integer.parseInt(en.getOrdStatus().getValue())));
            event.put((Object)"entrust_date", (Object)en.getOrdDate());
            event.put((Object)"done_vol", (Object)en.getCumQty());
            event.put((Object)"done_price", (Object)en.getAvgPx());
            event.put((Object)"withdraw_vol", (Object)(en.getObject() == null ? 0 : en.getObject().getWthQty()));
            event.put((Object)"rpt_contract_no", (Object)"");
            event.put((Object)"basket_no", (Object)"");
            event.put((Object)"client_seq", (Object)en.getClOrdId().substring(en.getClOrdId().lastIndexOf("|") + 1));
            event.put((Object)"batch_sno", (Object)"");
            event.put((Object)"query_index", (Object)"");
            event.put((Object)"currency_type", (Object)"");
            event.put((Object)"org_contract_no", (Object)"");
            event.put((Object)"batch_id", (Object)en.getParentId().substring(en.getParentId().lastIndexOf("|") + 1));
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 640005, "margin_order_query");
        }
    }

    public void buildMarginDealQuery(List<Execution> list, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"margin_deal_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"contract_no", (Object)"");
            event.put((Object)"bs", (Object)"");
            event.put((Object)"market_indicator", (Object)"");
            event.put((Object)"done_no", (Object)"");
            event.put((Object)"done_amt", (Object)0);
            event.put((Object)"done_price", (Object)0);
            event.put((Object)"done_time", (Object)"");
            event.put((Object)"deal_count", (Object)0);
            event.put((Object)"market_code", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"withdraw_flag", (Object)"");
            event.put((Object)"done_status", (Object)"");
            event.put((Object)"trade_fee", (Object)0);
            event.put((Object)"rpt_contract_no", (Object)"");
            event.put((Object)"basket_no", (Object)"");
            event.put((Object)"client_seq", (Object)"");
            event.put((Object)"query_index", (Object)"");
            event.put((Object)"currency_type", (Object)"");
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 640006, "margin_deal_query");
            }
            return;
        }
        for (Execution deal : list) {
            event = new MEvent();
            event.put((Object)"topic", (Object)"margin_deal_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)deal.getInvestorId());
            event.put((Object)"contract_no", (Object)deal.getOrderId());
            event.put((Object)"bs", (Object)ConvertUtils.getBsFlag(Integer.parseInt(deal.getSide().getValue())));
            event.put((Object)"market_indicator", (Object)MarketIndicator.getCode((String)deal.getInstrument().getMarketIndicator()));
            event.put((Object)"done_no", (Object)deal.getExecId());
            event.put((Object)"done_amt", (Object)deal.getLastAmount());
            event.put((Object)"done_price", (Object)deal.getLastPx());
            event.put((Object)"done_time", (Object)deal.getExecTime());
            event.put((Object)"deal_count", (Object)deal.getLastQty());
            event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(deal.getInstrument().getMarket()));
            event.put((Object)"sec_code", (Object)deal.getInstrument().getSecurityId());
            event.put((Object)"sec_name", (Object)deal.getInstrument().getSymbol());
            event.put((Object)"withdraw_flag", (Object)"");
            event.put((Object)"done_status", (Object)"");
            event.put((Object)"trade_fee", (Object)0);
            event.put((Object)"rpt_contract_no", (Object)"");
            event.put((Object)"basket_no", (Object)"");
            event.put((Object)"client_seq", (Object)"");
            event.put((Object)"query_index", (Object)"");
            event.put((Object)"currency_type", (Object)ConvertUtils.getCurrency(deal.getInstrument().getCurrencyId()));
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 640006, "margin_deal_query");
        }
    }

    public void buildMarginPositionQuery(List<cms.tmx.http.api.strategy.dto.Position> list, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"margin_position_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"holder_acc_no", (Object)"");
            event.put((Object)"market_code", (Object)"");
            event.put((Object)"cur_sell_vol", (Object)0);
            event.put((Object)"cost_price", (Object)0);
            event.put((Object)"avg_price", (Object)0);
            event.put((Object)"market_value", (Object)0);
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"total_vol", (Object)0);
            event.put((Object)"sec_avl", (Object)0);
            event.put((Object)"cur_buy_vol", (Object)0);
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 640004, "margin_position_query");
            }
            return;
        }
        for (cms.tmx.http.api.strategy.dto.Position po : list) {
            event = new MEvent();
            po.transformQty();
            String type = po.getInstrument().getSecurityType();
            String market = po.getInstrument().getMarket();
            String secId = po.getInstrument().getSecurityId();
            RefItem refItem = this.refMng.getItem(type, market, secId);
            double nowPrice = 0.0;
            double marketValue = 0.0;
            if (refItem == null) {
                logger.error(String.valueOf(secId) + "\u6ca1\u6709\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                if ("STD_BOND".equals(type)) {
                    nowPrice = 100.0;
                    marketValue = QueryUtils.calAmountByMarketAndSecType((String)market, (String)type, (double)((long)po.getSecBalance()), (double)nowPrice);
                }
            } else {
                MarketItem marketItem = this.marketMng.getInfo((IRefItem)refItem);
                if (marketItem != null) {
                    nowPrice = marketItem.getClosePrice();
                    if (marketItem.getNowPrice() != 0.0) {
                        nowPrice = marketItem.getNowPrice();
                    }
                } else {
                    logger.error(String.valueOf(secId) + "\u6ca1\u6709\u83b7\u53d6\u5230\u52a8\u6001\u884c\u60c5");
                }
            }
            if (refItem != null && nowPrice != 0.0) {
                marketValue = QueryUtils.calAmountByMarketAndSecType((String)market, (String)type, (double)((long)po.getSecBalance()), (double)nowPrice);
            }
            event.put((Object)"topic", (Object)"margin_position_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)this.fundMng.getCcsAccntIdToInvestorId(po.getPosAccnt().getAccntId()));
            event.put((Object)"holder_acc_no", (Object)this.accountMap.getMarginInvestorSec(po.getPosAccnt().getSecAccntId()));
            event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(po.getInstrument().getMarket()));
            event.put((Object)"cur_sell_vol", (Object)po.getPosStatistic().getSellOutQty());
            event.put((Object)"cost_price", (Object)po.getPosStatistic().getCost());
            event.put((Object)"avg_price", (Object)po.getPosStatistic().getAvgPrice());
            event.put((Object)"market_value", (Object)((double)Math.round(marketValue * 100.0) / 100.0));
            event.put((Object)"sec_code", (Object)po.getInstrument().getSecurityId());
            event.put((Object)"sec_name", (Object)po.getInstrument().getSymbol());
            event.put((Object)"total_vol", (Object)po.getSecBalance());
            event.put((Object)"sec_avl", (Object)po.getSecAvail());
            event.put((Object)"cur_buy_vol", (Object)po.getPosStatistic().getBuyInQty());
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 640004, "margin_position_query");
        }
    }

    public void buildPledgeSecurityQuery(List<PledgeSecurity> list, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"pledge_security_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"market_code", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"PLEDGE_RATE", (Object)0);
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 640007, "pledge_security_query");
            }
            return;
        }
        for (PledgeSecurity pl : list) {
            event = new MEvent();
            event.put((Object)"topic", (Object)"pledge_security_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(pl.getMarket()));
            event.put((Object)"sec_code", (Object)pl.getSecurityId());
            event.put((Object)"sec_name", (Object)pl.getSecurityName());
            event.put((Object)"PLEDGE_RATE", (Object)pl.getPledgeRate());
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 640007, "pledge_security_query");
        }
    }

    public void buildUnderlyingSecurityQuery(List<UnderlyingSecurity> list, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"underlying_security_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"market_code", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"CREDIT_SEC_CTRL", (Object)"");
            event.put((Object)"CREDIT_FUND_CTRL", (Object)"");
            event.put((Object)"MARGIN_RATE_FUND", (Object)0);
            event.put((Object)"MARGIN_RATE_SEC", (Object)0);
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 640008, "underlying_security_query");
            }
            return;
        }
        for (UnderlyingSecurity un : list) {
            event = new MEvent();
            event.put((Object)"topic", (Object)"underlying_security_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(un.getMarket()));
            event.put((Object)"sec_code", (Object)un.getSecurityId());
            event.put((Object)"sec_name", (Object)un.getSecurityName());
            event.put((Object)"CREDIT_SEC_CTRL", (Object)un.getCreditSecCtrl());
            event.put((Object)"CREDIT_FUND_CTRL", (Object)un.getCreditFundCtrl());
            event.put((Object)"MARGIN_RATE_FUND", (Object)un.getMarginRateFund());
            event.put((Object)"MARGIN_RATE_SEC", (Object)un.getMarginRateSec());
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 640008, "underlying_security_query");
        }
    }

    public void buildContractQuery(List<cms.tmx.http.query.OrderRecord> list, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (list.isEmpty()) {
            event.put((Object)"topic", (Object)"contract_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"market_code", (Object)"");
            event.put((Object)"SNO", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"sec_name", (Object)"");
            event.put((Object)"CREDIT_DIRECT", (Object)"");
            event.put((Object)"LIFE_STATUS", (Object)"");
            event.put((Object)"count", (Object)0);
            event.put((Object)"deal_count", (Object)0);
            event.put((Object)"entrust_balance", (Object)0);
            event.put((Object)"done_amt", (Object)0);
            event.put((Object)"trade_fee", (Object)0);
            event.put((Object)"DEBT_END_DATE", (Object)"");
            event.put((Object)"RATE", (Object)0);
            event.put((Object)"BAIL_RATIO", (Object)0);
            event.put((Object)"REPAY_AMOUNT", (Object)0);
            event.put((Object)"UN_REPAY_AMOUNT", (Object)0);
            event.put((Object)"REPAY_QTY", (Object)0);
            event.put((Object)"UN_REPAY_QTY", (Object)0);
            event.put((Object)"FEE_REPAY", (Object)0);
            event.put((Object)"OVERDUE_FEE", (Object)0);
            event.put((Object)"PUNI_FEE_REPAY", (Object)0);
            event.put((Object)"UN_PUNI_FEE_REPAY", (Object)0);
            event.put((Object)"CLOSE_DATE", (Object)"");
            event.put((Object)"holder_acc_no", (Object)"");
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 640009, "contract_query");
            }
            return;
        }
        for (cms.tmx.http.query.OrderRecord or : list) {
            event = new MEvent();
            OrderExtra obj = or.getObject();
            event.put((Object)"topic", (Object)"contract_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)this.fundMng.getCcsInvestorId(or.getExtCashAccntId()));
            event.put((Object)"market_code", (Object)ConvertUtils.getMarketInt(or.getInstrument().getMarket()));
            event.put((Object)"SNO", (Object)obj.getSno());
            event.put((Object)"sec_code", (Object)or.getInstrument().getSecurityId());
            event.put((Object)"sec_name", (Object)or.getInstrument().getSymbol());
            event.put((Object)"CREDIT_DIRECT", (Object)CreditDirect.getDesc((String)obj.getCreditDirect()));
            event.put((Object)"LIFE_STATUS", (Object)LifeStatus.getDesc((String)obj.getLifeStatus()));
            event.put((Object)"count", (Object)or.getOrderQty());
            event.put((Object)"deal_count", (Object)or.getLastQty());
            event.put((Object)"entrust_balance", (Object)or.getOrderAmount());
            event.put((Object)"done_amt", (Object)or.getTradeAmount());
            event.put((Object)"trade_fee", (Object)or.getFee());
            event.put((Object)"DEBT_END_DATE", (Object)obj.getEndDate());
            event.put((Object)"RATE", (Object)obj.getAnnualInterestRate());
            event.put((Object)"BAIL_RATIO", (Object)obj.getMarginRate());
            if (CreditDirect.CREDIT_DIRECT_STK.getCode().equals(obj.getCreditDirect())) {
                event.put((Object)"REPAY_AMOUNT", (Object)0);
                event.put((Object)"UN_REPAY_AMOUNT", (Object)0);
                event.put((Object)"UN_REPAY_QTY", (Object)obj.getStkRemain());
                event.put((Object)"REPAY_QTY", (Object)(obj.getStkRepay() + obj.getStkRepayUnfrz()));
            } else if (CreditDirect.CREDIT_DIRECT_CASH.getCode().equals(obj.getCreditDirect())) {
                event.put((Object)"REPAY_AMOUNT", (Object)(obj.getCreditRepay() + obj.getCreditRepayUnfrz()));
                event.put((Object)"UN_REPAY_AMOUNT", (Object)(obj.getFundRemain() < 0.0 ? 0.0 : obj.getFundRemain()));
                event.put((Object)"UN_REPAY_QTY", (Object)0);
                event.put((Object)"REPAY_QTY", (Object)0);
            }
            double feeRepay = obj.getPuniDebtsRepay() + obj.getPuniDebtsUnfrz() + obj.getPuniRightsRepay() + obj.getPuniRightsUnfrz();
            event.put((Object)"FEE_REPAY", (Object)feeRepay);
            event.put((Object)"OVERDUE_FEE", (Object)(obj.getPuniDebts() + obj.getPuniRights() - feeRepay));
            event.put((Object)"PUNI_FEE_REPAY", (Object)(obj.getFeeSettRepay() + obj.getFeeUnfrz()));
            event.put((Object)"UN_PUNI_FEE_REPAY", (Object)obj.getFeeSum());
            event.put((Object)"CLOSE_DATE", (Object)obj.getCloseDate());
            event.put((Object)"holder_acc_no", (Object)this.accountMap.getMarginInvestorSec(or.getExtSecAccntId()));
            String order = Report.packLine(event);
            str.append(order).append("\n");
        }
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 640009, "contract_query");
        }
    }

    public void buildMarginRateQuery(Sofp sofp, MEvent e, MEvent parent) {
        MEvent event = new MEvent();
        StringBuilder str = new StringBuilder();
        if (sofp == null) {
            event.put((Object)"topic", (Object)"rate_query");
            event.put((Object)"return_code", (Object)e.getCode());
            event.put((Object)"return_message", (Object)e.getDesc());
            event.put((Object)"cust_no", (Object)"");
            event.put((Object)"CASH_INTRRATE", (Object)0);
            event.put((Object)"STK_INTRRATE", (Object)0);
            String order = Report.packLine(event);
            str.append(order).append("\n");
            parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
            if (e.getBool("is_last")) {
                event.put((Object)"isRes", (Object)true);
                event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
                this.receiveCallBack(event, 640010, "rate_query");
            }
            return;
        }
        event.put((Object)"topic", (Object)"rate_query");
        event.put((Object)"return_code", (Object)e.getCode());
        event.put((Object)"return_message", (Object)e.getDesc());
        event.put((Object)"cust_no", (Object)this.fundMng.getCcsInvestorId(sofp.getCashAccntId()));
        event.put((Object)"CASH_INTRRATE", (Object)sofp.getCashIntrrate());
        event.put((Object)"STK_INTRRATE", (Object)sofp.getStkIntrrate());
        String order = Report.packLine(event);
        str.append(order).append("\n");
        parent.put((Object)"stream_query", (Object)(String.valueOf(parent.getStr("stream_query")) + str.toString()));
        if (e.getBool("is_last")) {
            event.put((Object)"isRes", (Object)true);
            event.put((Object)"res_file.steam", (Object)parent.getStr("stream_query"));
            this.receiveCallBack(event, 640010, "rate_query");
        }
    }
}

