/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.utils;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.file.order.pares.BasketAdvice;
import cms.tmx.file.order.pares.BatchCancelByBatchNo;
import cms.tmx.file.order.pares.BatchCancelByContractNo;
import cms.tmx.file.order.pares.BatchEntrust;
import cms.tmx.file.order.pares.BatchEntrustMargin;
import cms.tmx.file.order.pares.BatchOrder;
import cms.tmx.file.order.pares.CapitalTransfer;
import cms.tmx.file.order.pares.FastSingleAdvice;
import cms.tmx.file.order.pares.InstructionCancel;
import cms.tmx.file.order.pares.InstructionQuery;
import cms.tmx.file.order.pares.LightingInstructionCancel;
import cms.tmx.file.order.pares.LightingSingleAdvice;
import cms.tmx.file.order.pares.LimitSellQuery;
import cms.tmx.file.order.pares.MarginBatchCancelByBatchNo;
import cms.tmx.file.order.pares.MarginTransfer;
import cms.tmx.file.order.pares.MarginTransferCancel;
import cms.tmx.file.order.pares.QueryCapital;
import cms.tmx.file.order.pares.QueryContract;
import cms.tmx.file.order.pares.QueryDeal;
import cms.tmx.file.order.pares.QueryEntrust;
import cms.tmx.file.order.pares.QueryMarginCapital;
import cms.tmx.file.order.pares.QueryMarginDeal;
import cms.tmx.file.order.pares.QueryMarginEntrust;
import cms.tmx.file.order.pares.QueryMarginPosition;
import cms.tmx.file.order.pares.QueryMarginRate;
import cms.tmx.file.order.pares.QueryPledgeSecurity;
import cms.tmx.file.order.pares.QueryStock;
import cms.tmx.file.order.pares.QueryTransfer;
import cms.tmx.file.order.pares.QueryUnderlyingSecurity;
import cms.tmx.file.order.pares.Report;
import cms.tmx.file.order.pares.SingleAdvice;
import cms.tmx.file.order.pares.SingleCancelEntrust;
import cms.tmx.file.order.pares.SingleCancelEntrustMargin;
import cms.tmx.file.order.pares.SingleEntrust;
import cms.tmx.file.order.pares.SingleEntrustMargin;
import cms.tmx.file.order.pares.StockTransfer;
import cms.tmx.file.order.pares.TopSpeedInstructionCancel;
import cms.tmx.file.order.utils.LoggerUtils;
import cms.tmx.javafx.LoggerInterface;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class CSVParser
extends LoggerInterface {
    @Inject
    protected MEventService es;
    @Inject
    private IUiRightService service;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    @Named(value="fixed.fileorder.pool")
    protected ExecutorService fixedPool;
    private volatile boolean scanCanEntrust = false;
    private volatile boolean scanCanEntrustMargin = false;
    private volatile boolean scanCanIntrustction = false;
    private volatile boolean monitorCanEntrust = false;
    private volatile boolean monitorCanEntrustMargin = false;
    private volatile boolean monitorCanIntrustction = false;
    private final String[] entrustArray = new String[]{"620001", "620002", "620021", "620022", "620023", "654106", "654112"};
    private final String[] instructionArray = new String[]{"620004", "620005", "600013"};
    private final String[] entrustMarginArray = new String[]{"620041", "620042", "620043", "620051", "620050", "620060"};

    @PostConstruct
    public void init() {
        this.logger.error("CSV PARSER \u521d\u59cb\u5316 ===============");
        this.es.subscribe("file/parsing/request/csv", e -> {
            MEvent mEvent = this.parse(e);
        });
        this.es.subscribe("file/pack/request/csv", e -> {
            MEvent mEvent = this.pack(e);
        });
        this.es.subscribe("file/check/format/request/csv", e -> {
            MEvent mEvent = this.checkFormat(e);
        });
        this.es.subscribe("check.rights", e -> this.checkRight(e));
    }

    private void checkRight(MEvent event) {
        this.scanCanEntrust = this.service.registerCheck(new String[]{"cms.tmx.file.order.part.scanFilePart_entrust"});
        this.scanCanEntrustMargin = this.service.registerCheck(new String[]{"cms.tmx.file.order.part.scanFilePart_entrustMargin"});
        this.scanCanIntrustction = this.service.registerCheck(new String[]{"cms.tmx.file.order.part.scanFilePart_instruction"});
        this.monitorCanEntrust = this.service.registerCheck(new String[]{"cms.tmx.file.order.part.monitorFilePart_entrust"});
        this.monitorCanEntrustMargin = this.service.registerCheck(new String[]{"cms.tmx.file.order.part.monitorFilePart_entrustMargin"});
        this.monitorCanIntrustction = this.service.registerCheck(new String[]{"cms.tmx.file.order.part.monitorFilePart_instruction"});
    }

    private MEvent pack(MEvent event) {
        try {
            String uuid = event.getStr("file.manipulate.record.uuid");
            String clListId = event.getStr("cl_list_id");
            StringBuilder builder = new StringBuilder();
            int withDrawCount = 0;
            this.logger.info("[" + uuid + "]" + "\u5bf9\u6536\u5230\u7684\u5185\u5bb9\u6309\u56de\u62a5\u6587\u4ef6\u4e0a\u63a5\u53e3\u6587\u6863\u5b9a\u4e49\u7684\u683c\u5f0f\u6253\u5305\uff0c\u4ee5\u4fbf\u5199\u5165\u56de\u62a5\u6587\u4ef6   \u54cd\u5e94\u5305\u4e2a\u6570\uff1a" + event.children.size());
            Object orders = event.get((Object)"basket_orders");
            if (orders != null && orders instanceof ConcurrentHashMap) {
                event.setFunctionCode(630952);
                Map map = (Map)orders;
                if (map.isEmpty()) {
                    String line = Report.packLine(event);
                    this.logger.info("[" + uuid + "]" + " \u54cd\u5e94\u4fe1\u606f\u6253\u5305\u5b8c\u6210\uff0c\u54cd\u5e94\u5185\u5bb9\u4e3a\uff1a" + line);
                    if (!line.trim().equals("")) {
                        builder.append(line);
                        builder.append('\n');
                    } else {
                        this.logger.error("[" + uuid + "] pack line failed" + event);
                        return event;
                    }
                }
                String portfolioId = event.getStr("portfolio_id");
                for (Map.Entry listOrder : map.entrySet()) {
                    for (BasketCcsOrder order : (List)listOrder.getValue()) {
                        String[] split;
                        MEvent ev = new MEvent(8);
                        ev.put((Object)"list_id", (Object)order.getListId());
                        ev.put((Object)"list_leg_id", (Object)order.getLegId());
                        ev.put((Object)"invest_id", (Object)order.getInvestorId());
                        ev.put((Object)"portfolio_id", (Object)portfolioId);
                        ev.put((Object)"sec_code", (Object)order.getInstrument().getSecId());
                        ev.put((Object)"cl_list_id", (Object)clListId);
                        ev.put((Object)"error_code", (Object)"1");
                        ev.put((Object)"erroe_msg", (Object)"\u8bf7\u6c42\u6210\u529f");
                        String clOrderId = order.getClOrderId();
                        if (!StringUtils.isEmpty((String)clOrderId) && clOrderId.contains("|") && (split = clOrderId.split("\\|")).length == 3) {
                            clOrderId = split[2];
                        }
                        ev.put((Object)"cl_order_id", (Object)clOrderId);
                        ev.put((Object)"topic", (Object)"response_batch_entrust_confirm");
                        String line = Report.packLine(ev);
                        this.logger.info("[" + uuid + "]" + " \u54cd\u5e94\u4fe1\u606f\u6253\u5305\u5b8c\u6210\uff0c\u54cd\u5e94\u5185\u5bb9\u4e3a\uff1a" + line);
                        if (!line.trim().equals("")) {
                            withDrawCount += ev.getInt("file.manipulate.record.withdraw.count");
                            builder.append(line);
                            builder.append('\n');
                            continue;
                        }
                        this.logger.error("[" + uuid + "] pack line failed" + ev);
                        return event;
                    }
                }
                this.logger.info("[" + uuid + "] \u6253\u5305\u5b8c\u6210\uff01 ");
                event.put((Object)"res_file.steam", (Object)builder.toString());
                event.put((Object)"file.manipulate.record.withdraw.count", (Object)withDrawCount);
                event.setOK();
                return event;
            }
            if (event.getFunctionCode() == 620005) {
                event.setFunctionCode(630952);
                String line = Report.packLine(event);
                this.logger.info("[" + uuid + "]" + " \u54cd\u5e94\u4fe1\u606f\u6253\u5305\u5b8c\u6210\uff0c\u54cd\u5e94\u5185\u5bb9\u4e3a\uff1a" + line);
                if (!line.trim().equals("")) {
                    withDrawCount += event.getInt("file.manipulate.record.withdraw.count");
                    builder.append(line);
                    builder.append('\n');
                } else {
                    this.logger.error("[" + uuid + "] pack line failed" + event);
                }
            }
            for (MEvent sub : event.children) {
                int function = sub.getFunctionCode();
                if (function == 620003 || function == 620006 || function == 620008 || function == 620009 || function == 620001 || function == 620021 || function == 620002 || function == 620022 || function == 620004 || function == 600013 || function == 620041 || function == 620042 || function == 620050 || function == 620043 || function == 620051 || function == 620060 || function == 620007) {
                    String[] split;
                    String clListIdBatch;
                    String[] split2;
                    String clOrderId = sub.getStr("cl_order_id");
                    if (!StringUtils.isEmpty((String)clOrderId) && clOrderId.contains("|") && (split2 = clOrderId.split("\\|")).length == 3) {
                        clOrderId = split2[2];
                        sub.put((Object)"cl_order_id", (Object)clOrderId);
                    }
                    if (!StringUtils.isEmpty((String)(clListIdBatch = sub.getStr("cl_list_id"))) && clListIdBatch.contains("|") && (split = clListIdBatch.split("\\|")).length == 3) {
                        clListIdBatch = split[2];
                        sub.put((Object)"cl_list_id", (Object)clListIdBatch);
                    }
                    sub.setFunctionCode(630952);
                } else {
                    sub.setFunctionCode(0);
                }
                String line = this.packLine(sub);
                this.logger.info("[" + uuid + "]" + " \u54cd\u5e94\u4fe1\u606f\u6253\u5305\u5b8c\u6210\uff0c\u54cd\u5e94\u5185\u5bb9\u4e3a\uff1a" + line);
                if (!line.trim().equals("")) {
                    withDrawCount += sub.getInt("file.manipulate.record.withdraw.count");
                    builder.append(line);
                    builder.append('\n');
                    continue;
                }
                this.logger.error("[" + uuid + "] pack line failed" + sub);
            }
            this.logger.info("[" + uuid + "] \u6253\u5305\u5b8c\u6210\uff01 ");
            event.put((Object)"res_file.steam", (Object)builder.toString());
            event.put((Object)"file.manipulate.record.withdraw.count", (Object)withDrawCount);
            event.setOK();
            return event;
        }
        catch (Exception e) {
            this.logger.error("  pack line failed", (Throwable)e);
            event.setDesc("pack line failed:" + e.toString());
            event.setCode(999981);
            return event;
        }
    }

    private MEvent checkFormat(MEvent event) {
        try {
            String userId = this.eCore.getStr("user_id");
            String uuid = event.getStr("file.manipulate.record.uuid");
            byte[] stream = (byte[])event.get((Object)"file.steam");
            String content = new String(stream);
            LoggerUtils.asyncLogger("uuid[" + uuid + "] \u5f85\u683c\u5f0f\u6548\u9a8c\u524d\u5185\u5bb9\uff1a" + content);
            String[] lines = content.split("\\\r\\\n");
            event.put((Object)"fund_acct", (Object)userId);
            int i = 0;
            while (i < lines.length) {
                if (!lines[i].isEmpty() && !lines[i].trim().equals("")) {
                    MEvent sub = this.checkFormatLine(lines[i], i, userId);
                    event.setFunctionCode(sub.getInt("func_no"));
                    if (sub.getCode() != 0) {
                        this.logger.error("[" + uuid + "]\u5f53\u524d\u683c\u5f0f\u6548\u9a8c\uff0c\u8bfb\u53d6\u5185\u5bb9\u7684\u7b2c[" + (i + 1) + "]\u884c\u5185\u5bb9\u9519\u8bef\uff1a" + lines[i] + "\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + sub.getDesc());
                        event.setCode(sub.getCode());
                        event.setDesc(sub.getDesc());
                        boolean containsKey = event.containsKey((Object)"file.manipulate.record.error.count");
                        if (containsKey) {
                            event.replace((Object)"file.manipulate.record.error.count", (Object)(event.getInt("file.manipulate.record.error.count") + lines.length));
                        } else {
                            event.put((Object)"file.manipulate.record.error.count", (Object)lines.length);
                        }
                        this.es.sendEvent("file/request/record", event);
                        return event;
                    }
                }
                ++i;
            }
            LoggerUtils.asyncLogger("uuid[" + uuid + "] \u6548\u9a8c\u683c\u5f0f\u6210\u529f\uff1a");
            event.setOK();
            return event;
        }
        catch (Exception e) {
            this.logger.error(" ", (Throwable)e);
            event.setCode(999981);
            return event;
        }
    }

    private MEvent parse(MEvent event) {
        List<String> entrustList = Arrays.asList(this.entrustArray);
        List<String> instructionList = Arrays.asList(this.instructionArray);
        List<String> entrustListMargin = Arrays.asList(this.entrustMarginArray);
        HashSet<Integer> fundCodeSet = new HashSet<Integer>();
        boolean isContainEntrust = false;
        int batchCount = 0;
        String workModel = event.getStr("work.mode");
        try {
            String uuid = event.getStr("file.manipulate.record.uuid");
            LoggerUtils.asyncLogger("uuid[" + uuid + "] \u5bf9\u8bf7\u6c42\u6587\u4ef6\u4e2d\u7684\u8bf7\u6c42\u6309\u63a5\u53e3\u6587\u6863\u7684\u683c\u5f0f\u8fdb\u884c\u89e3\u6790\uff0c\u5199\u5165\u5bf9\u8c61,  event\uff1a" + event.entrySet());
            byte[] stream = (byte[])event.get((Object)"file.steam");
            String content = new String(stream);
            LoggerUtils.asyncLogger("uuid[" + uuid + "] \u5f85\u89e3\u6790\u524d\u5185\u5bb9\uff1a" + content);
            String[] lines = content.split("\\\n|\\\r\\\n");
            int i = 0;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                block25: {
                    String line = stringArray[n2];
                    LoggerUtils.asyncLogger("uuid[" + uuid + "] \u89e3\u6790\u884c\u4f4d\u7f6e\u4e3a\u8bfb\u53d6\u5185\u5bb9\u7684\u7b2c[" + ++i + "] ,\u89e3\u6790\u540e\u5185\u5bb9[" + line + "]");
                    if (line.isEmpty() || line.trim().equals("")) break block25;
                    MEvent sub = this.parseLine(line);
                    if (sub.getCode() != 0) {
                        String log = String.format("uuid[%s]\u4e3a\u8bfb\u53d6\u5185\u5bb9\u7684\u7b2c[ %d]\u884c \u89e3\u6790\u9519\u8bef\u3010%s\u3011", uuid, i, sub.getDesc());
                        this.logger.error(log);
                        event.setCode(999989);
                        event.setDesc(log);
                        return event;
                    }
                    String functionCode = String.valueOf(sub.getFunctionCode());
                    switch (workModel) {
                        case "scan.work.mode": {
                            if (entrustList.contains(functionCode)) {
                                if (this.scanCanEntrust) {
                                    isContainEntrust = true;
                                    break;
                                }
                                event.setCode(999989);
                                event.setDesc("\u626b\u5355\u6a21\u5f0f\u65e0\u4e0b\u5355\u59d4\u6258\u6743\u9650");
                                return event;
                            }
                            if (instructionList.contains(functionCode)) {
                                if (this.scanCanIntrustction) {
                                    isContainEntrust = true;
                                    break;
                                }
                                event.setCode(999989);
                                event.setDesc("\u626b\u5355\u6a21\u5f0f\u65e0\u4e0b\u5355\u6307\u4ee4\u6743\u9650");
                                return event;
                            }
                            if (!entrustListMargin.contains(functionCode)) break;
                            if (this.scanCanEntrustMargin) {
                                isContainEntrust = true;
                                break;
                            }
                            event.setCode(999989);
                            event.setDesc("\u626b\u5355\u6a21\u5f0f\u65e0\u4e0b\u8fbe\u878d\u8d44\u878d\u5238\u59d4\u6258\u6743\u9650");
                            return event;
                        }
                        case "monitor.work.mode": {
                            if (entrustList.contains(functionCode)) {
                                if (this.monitorCanEntrust) {
                                    isContainEntrust = true;
                                    break;
                                }
                                event.setCode(999989);
                                event.setDesc("\u76d1\u542c\u6a21\u5f0f\u65e0\u4e0b\u5355\u59d4\u6258\u6743\u9650");
                                return event;
                            }
                            if (instructionList.contains(functionCode)) {
                                if (this.monitorCanIntrustction) {
                                    isContainEntrust = true;
                                    break;
                                }
                                event.setCode(999989);
                                event.setDesc("\u76d1\u542c\u6a21\u5f0f\u65e0\u4e0b\u5355\u6307\u4ee4\u6743\u9650");
                                return event;
                            }
                            if (!entrustListMargin.contains(functionCode)) break;
                            if (this.monitorCanEntrustMargin) {
                                isContainEntrust = true;
                                break;
                            }
                            event.setCode(999989);
                            event.setDesc("\u76d1\u542c\u6a21\u5f0f\u65e0\u4e0b\u8fbe\u878d\u8d44\u878d\u5238\u59d4\u6258\u6743\u9650");
                            return event;
                        }
                    }
                    fundCodeSet.add(sub.getFunctionCode());
                    if (620002 == sub.getFunctionCode() || 620043 == sub.getFunctionCode() || 620003 == sub.getFunctionCode()) {
                        ++batchCount;
                    }
                    sub.put((Object)"file.manipulate.record.start.time", (Object)event.getLong("file.manipulate.record.start.time"));
                    event.children.add(sub);
                }
                ++n2;
            }
            LoggerUtils.asyncLogger("uuid[" + uuid + "]  \u6587\u4ef6\u4e2d\u5305\u542b\u6279\u91cf\u59d4\u6258\u603b\u884c\u6570 \u3010" + batchCount + "\u3011\uff0c\u6279\u91cf\u59d4\u6258\u603b\u7b14\u6570\u3010" + (batchCount > 0 ? 1 : 0) + "\u3011\uff0c\u603b\u59d4\u6258\u7b14\u6570\u3010" + event.children.size() + "\u3011");
            LoggerUtils.asyncLogger("uuid[" + uuid + "]  \u6587\u4ef6\u4e2d\u5305\u542b\uff1a" + fundCodeSet + " \u3010" + fundCodeSet.size() + "\u3011\u79cd\u7c7b\u578b\u7684\u3010" + event.children.size() + "\u3011\u7b14\u59d4\u6258");
            LoggerUtils.asyncLogger("uuid[" + uuid + "]  \u89e3\u6790OK");
            event.put((Object)"batch_count", (Object)batchCount);
            event.put((Object)"is_contain_cntrust", (Object)isContainEntrust);
            event.setOK();
        }
        catch (Exception e) {
            this.logger.error("\u5bf9\u8bf7\u6c42\u6587\u4ef6\u4e2d\u7684\u8bf7\u6c42\u6309\u63a5\u53e3\u6587\u6863\u7684\u683c\u5f0f\u8fdb\u884c\u89e3\u6790\uff0c\u5199\u5165\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
        }
        return event;
    }

    private String packLine(MEvent event) {
        int function = event.getFunctionCode();
        String line = "";
        String uuid = event.getStr("file.manipulate.record.uuid");
        this.logger.debug("[" + uuid + "]" + "\u6253\u5305\u8bf7\u6c42[" + function + "] \u7684\u54cd\u5e94  e=" + event.entrySet());
        switch (function) {
            case 620001: {
                line = SingleEntrust.packLine(event);
                break;
            }
            case 620004: {
                line = SingleAdvice.packLine(event);
                break;
            }
            case 620021: {
                line = SingleCancelEntrust.packLine(event);
                event.put((Object)"file.manipulate.record.withdraw.count", (Object)1);
                break;
            }
            case 620022: {
                line = BatchCancelByBatchNo.packLine(event);
                event.put((Object)"file.manipulate.record.withdraw.count", (Object)1);
                break;
            }
            case 620023: {
                line = BatchCancelByContractNo.packLine(event);
                event.put((Object)"file.manipulate.record.withdraw.count", (Object)1);
                break;
            }
            case 620002: {
                line = BatchEntrust.packLine(event);
                break;
            }
            case 620003: {
                line = BatchOrder.packLine(event);
                break;
            }
            case 620005: {
                line = BasketAdvice.packLine(event);
                break;
            }
            case 654106: {
                line = CapitalTransfer.packLine(event);
                break;
            }
            case 630952: {
                line = Report.packLine(event);
                break;
            }
            case 630004: {
                line = QueryStock.packLine(event);
                break;
            }
            case 630002: {
                line = QueryCapital.packLine(event);
                break;
            }
            case 640002: {
                line = QueryMarginCapital.packLine(event);
                break;
            }
            case 630005: {
                line = QueryEntrust.packLine(event);
                break;
            }
            case 630006: {
                line = QueryDeal.packLine(event);
                break;
            }
            case 654112: {
                line = StockTransfer.packLine(event);
                break;
            }
            case 620011: {
                line = LimitSellQuery.packLine(event);
                break;
            }
            case 620041: {
                line = SingleEntrustMargin.packLine(event);
                break;
            }
            case 620043: {
                line = BatchEntrustMargin.packLine(event);
                break;
            }
            case 620042: {
                line = SingleCancelEntrustMargin.packLine(event);
                break;
            }
            case 640005: {
                line = QueryMarginEntrust.packLine(event);
                break;
            }
            case 640006: {
                line = QueryMarginDeal.packLine(event);
                break;
            }
            case 640004: {
                line = QueryMarginPosition.packLine(event);
                break;
            }
            case 640007: {
                line = QueryPledgeSecurity.packLine(event);
                break;
            }
            case 640008: {
                line = QueryUnderlyingSecurity.packLine(event);
            }
        }
        return line;
    }

    private MEvent parseLine(String line) {
        MEvent e = null;
        String[] values = line.split(",", -1);
        String code = values[0].trim();
        if (code.length() != 6 && code.charAt(0) == '\ufeff') {
            code = code.substring(1);
        }
        switch (Integer.valueOf(code)) {
            case 620006: {
                e = FastSingleAdvice.build(values);
                break;
            }
            case 620008: {
                e = LightingSingleAdvice.build(values);
                break;
            }
            case 620009: {
                e = LightingInstructionCancel.build(values);
                break;
            }
            case 620001: {
                e = SingleEntrust.build(values);
                break;
            }
            case 620004: {
                e = SingleAdvice.build(values);
                break;
            }
            case 620005: {
                e = BasketAdvice.build(values);
                break;
            }
            case 620021: {
                e = SingleCancelEntrust.build(values);
                break;
            }
            case 620002: {
                e = BatchEntrust.build(values);
                break;
            }
            case 620003: {
                e = BatchOrder.build(values);
                break;
            }
            case 620022: {
                e = BatchCancelByBatchNo.build(values);
                break;
            }
            case 600013: {
                e = InstructionCancel.build(values);
                break;
            }
            case 620007: {
                e = TopSpeedInstructionCancel.build(values);
                break;
            }
            case 620023: {
                e = BatchCancelByContractNo.build(values);
                break;
            }
            case 630004: {
                e = QueryStock.build(values);
                break;
            }
            case 654106: {
                e = CapitalTransfer.build(values);
                break;
            }
            case 630002: {
                e = QueryCapital.build(values);
                break;
            }
            case 630007: {
                e = QueryTransfer.build(values);
                break;
            }
            case 640002: {
                e = QueryMarginCapital.build(values);
                break;
            }
            case 630005: {
                e = QueryEntrust.build(values);
                break;
            }
            case 630006: {
                e = QueryDeal.build(values);
                break;
            }
            case 654112: {
                e = StockTransfer.build(values);
                break;
            }
            case 620011: {
                e = LimitSellQuery.build(values);
                break;
            }
            case 620041: {
                e = SingleEntrustMargin.build(values);
                break;
            }
            case 620042: {
                e = SingleCancelEntrustMargin.build(values);
                break;
            }
            case 500011: {
                e = InstructionQuery.build(values);
                break;
            }
            case 640005: {
                e = QueryMarginEntrust.build(values);
                break;
            }
            case 640006: {
                e = QueryMarginDeal.build(values);
                break;
            }
            case 640004: {
                e = QueryMarginPosition.build(values);
                break;
            }
            case 640007: {
                e = QueryPledgeSecurity.build(values);
                break;
            }
            case 640008: {
                e = QueryUnderlyingSecurity.build(values);
                break;
            }
            case 640009: {
                e = QueryContract.build(values);
                break;
            }
            case 640010: {
                e = QueryMarginRate.build(values);
                break;
            }
            case 620043: {
                e = BatchEntrustMargin.build(values);
                break;
            }
            case 620050: {
                e = MarginTransfer.build(values);
                break;
            }
            case 620051: {
                e = MarginBatchCancelByBatchNo.build(values);
                break;
            }
            case 620060: {
                e = MarginTransferCancel.build(values);
                break;
            }
            default: {
                e = new MEvent();
                e.setCode(999996);
                e.setDesc(String.format("unknown transaction: %s", values[0]));
            }
        }
        return e;
    }

    private MEvent checkFormatLine(String line, int pos, String ... remark) {
        MEvent e = null;
        String[] values = line.split(",", -1);
        String code = values[0].trim();
        if (code.length() != 6 && code.charAt(0) == '\ufeff') {
            code = code.substring(1);
        }
        switch (StringUtils.parseInt((String)code)) {
            case 620006: {
                e = FastSingleAdvice.regexMatchLine(values, pos, remark);
                break;
            }
            case 620008: {
                e = LightingSingleAdvice.regexMatchLine(values, pos, remark);
                break;
            }
            case 620009: {
                e = LightingInstructionCancel.regexMatchLine(values, pos, remark);
                break;
            }
            case 620002: {
                e = BatchEntrust.regexMatchLine(values, pos, remark);
                break;
            }
            case 620003: {
                e = BatchOrder.regexMatchLine(values, pos, remark);
                break;
            }
            case 620001: {
                this.logger.info(" \u683c\u5f0f\u6548\u9a8c\u5355\u7b14\u59d4\u6258\uff1a" + line);
                e = SingleEntrust.regexMatchLine(values, pos, remark);
                break;
            }
            case 620005: {
                e = BasketAdvice.regexMatchLine(values, pos, remark);
                break;
            }
            case 620004: {
                e = SingleAdvice.regexMatchLine(values, pos, remark);
                break;
            }
            case 620021: {
                e = SingleCancelEntrust.regexMatchLine(values, pos, remark);
                break;
            }
            case 620022: {
                e = BatchCancelByBatchNo.regexMatchLine(values, pos, remark);
                break;
            }
            case 600013: {
                e = InstructionCancel.regexMatchLine(values, pos, remark);
                break;
            }
            case 620007: {
                e = TopSpeedInstructionCancel.regexMatchLine(values, pos, remark);
                break;
            }
            case 620023: {
                e = BatchCancelByContractNo.regexMatchLine(values, pos, remark);
                break;
            }
            case 630004: {
                this.logger.info(" \u683c\u5f0f\u6548\u9a8c\u6301\u4ed3\u67e5\u8be2\uff1a" + line);
                e = QueryStock.regexMatchLine(values, pos, remark);
                break;
            }
            case 654106: {
                e = CapitalTransfer.regexMatchLine(values, pos, remark);
                break;
            }
            case 630002: {
                this.logger.info(" \u683c\u5f0f\u6548\u9a8c\u8d44\u91d1\u67e5\u8be2\uff1a" + line);
                e = QueryCapital.regexMatchLine(values, pos, remark);
                break;
            }
            case 630007: {
                this.logger.info(" \u683c\u5f0f\u6548\u9a8c\u6295\u7ec4\u5212\u8f6c\u67e5\u8be2\uff1a" + line);
                e = QueryTransfer.regexMatchLine(values, pos, remark);
                break;
            }
            case 640002: {
                e = QueryMarginCapital.regexMatchLine(values, pos, remark);
                break;
            }
            case 630005: {
                this.logger.info(" \u683c\u5f0f\u6548\u9a8c\u59d4\u6258\u67e5\u8be2\uff1a" + line);
                e = QueryEntrust.regexMatchLine(values, pos, remark);
                break;
            }
            case 630006: {
                this.logger.info(" \u683c\u5f0f\u6548\u9a8c\u6210\u4ea4\u67e5\u8be2\uff1a" + line);
                e = QueryDeal.regexMatchLine(values, pos, remark);
                break;
            }
            case 654112: {
                e = StockTransfer.regexMatchLine(values, pos, remark);
                break;
            }
            case 620011: {
                e = LimitSellQuery.regexMatchLine(values, pos, remark);
                break;
            }
            case 620041: {
                e = SingleEntrustMargin.regexMatchLine(values, pos, remark);
                break;
            }
            case 620042: {
                e = SingleCancelEntrustMargin.regexMatchLine(values, pos, remark);
                break;
            }
            case 500011: {
                e = InstructionQuery.regexMatchLine(values, pos, remark);
                break;
            }
            case 640005: {
                this.logger.info(" \u683c\u5f0f\u6548\u9a8c\u878d\u8d44\u878d\u5238\u59d4\u6258\u67e5\u8be2\uff1a" + line);
                e = QueryMarginEntrust.regexMatchLine(values, pos, remark);
                break;
            }
            case 640006: {
                this.logger.info(" \u683c\u5f0f\u6548\u9a8c\u878d\u8d44\u878d\u5238\u6210\u4ea4\u67e5\u8be2\uff1a" + line);
                e = QueryMarginDeal.regexMatchLine(values, pos, remark);
                break;
            }
            case 640004: {
                this.logger.info(" \u683c\u5f0f\u6548\u9a8c\u878d\u8d44\u878d\u5238\u6301\u4ed3\u67e5\u8be2\uff1a" + line);
                e = QueryMarginPosition.regexMatchLine(values, pos, remark);
                break;
            }
            case 640007: {
                this.logger.info("\u683c\u5f0f\u6548\u9a8c\u62c5\u4fdd\u8bc1\u5238\u67e5\u8be2" + line);
                e = QueryPledgeSecurity.regexMatchLine(values, pos, remark);
                break;
            }
            case 640008: {
                this.logger.info("\u683c\u5f0f\u6548\u9a8c\u6807\u7684\u8bc1\u5238\u67e5\u8be2" + line);
                e = QueryUnderlyingSecurity.regexMatchLine(values, pos, remark);
                break;
            }
            case 640009: {
                this.logger.info("\u5408\u7ea6\u67e5\u8be2" + line);
                e = QueryContract.regexMatchLine(values, pos, remark);
                break;
            }
            case 640010: {
                this.logger.info("\u5e74\u5229\u7387\u67e5\u8be2" + line);
                e = QueryMarginRate.regexMatchLine(values, pos, remark);
                break;
            }
            case 620043: {
                this.logger.info("\u878d\u8d44\u878d\u5238\u6279\u91cf\u4e0b\u5355" + line);
                e = BatchEntrustMargin.regexMatchLine(values, pos, remark);
                break;
            }
            case 620050: {
                this.logger.info("\u878d\u8d44\u878d\u5238\u8fd8\u5238\u8fd8\u6b3e" + line);
                e = MarginTransfer.regexMatchLine(values, pos, remark);
                break;
            }
            case 620051: {
                this.logger.info("\u878d\u8d44\u878d\u5238\u6279\u91cf\u64a4\u5355" + line);
                e = MarginBatchCancelByBatchNo.regexMatchLine(values, pos, remark);
                break;
            }
            case 620060: {
                this.logger.info("\u878d\u8d44\u878d\u5238\u76f4\u63a5\u8fd8\u5238\u64a4\u5355" + line);
                e = MarginTransferCancel.regexMatchLine(values, pos, remark);
                break;
            }
            default: {
                e = new MEvent();
                e.setCode(999996);
                e.setDesc(String.format("\u672a\u77e5\u529f\u80fd\u53f7[%s]", values[0]));
            }
        }
        return e;
    }
}

