/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;

public class StockTransfer {
    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(654112);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"operate_type", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"sec_code", (Object)value);
                        break;
                    }
                    case 5: {
                        event.put((Object)"market_code", (Object)value);
                        break;
                    }
                    case 6: {
                        event.put((Object)"holder_acc_no", (Object)value);
                        break;
                    }
                    case 7: {
                        event.put((Object)"count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 8: {
                        event.put((Object)"remark", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(654112);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value) && value.equals(remark[0]);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account!!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isOPERATE_TYPE(value);
                    event.setDesc("OPERATE_TYPE'format is error !");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCK_CODE(value);
                    event.setDesc("STOCK_CODE'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isFUND_MARKET(value);
                    event.setDesc("MARKET'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value);
                    event.setDesc("HOLDER_ACC_NO'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("SEC_VOL'format is error!");
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isREMARK(value) || value.isEmpty();
                    event.setDesc("REMARK'format is error!");
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count != 8) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(MEvent event) {
        int count = 0;
        int pos = event.getInt("format.current.line.pos");
        String line = event.getStr("file.line");
        String[] values = line.split(",", -1);
        event.setFunctionCode(654112);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value) && event.getStr("user_id").equals(value);
                    event.setDesc("FUND_ACCOUNT'format is error!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isOPERATE_TYPE(value);
                    event.setDesc("OPERATE_TYPE'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCK_CODE(value);
                    event.setDesc("STOCK_CODE'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isFUND_MARKET(value);
                    event.setDesc("MARKET'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value);
                    event.setDesc("HOLDER_ACC_NO'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("SEC_VOL'format is error!");
                    break;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count != 8) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent e) {
        return String.format("%d,%s", e.getCode(), e.getDesc());
    }
}

