/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SingleEntrustMargin {
    private static Logger logger = LogManager.getLogger(SingleEntrustMargin.class);

    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(620041);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"market_code", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"holder_acc_no", (Object)value);
                        break;
                    }
                    case 5: {
                        event.put((Object)"price", (Object)StringUtils.parseDouble((String)value, (int)3));
                        break;
                    }
                    case 6: {
                        event.put((Object)"count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 7: {
                        event.put((Object)"sec_code", (Object)value);
                        break;
                    }
                    case 8: {
                        event.put((Object)"market_indicator", (Object)value);
                        break;
                    }
                    case 9: {
                        event.put((Object)"client_seq", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.put((Object)"func_no", (Object)620041);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            logger.info(" \u5b57\u6bb5\u503c\uff1a" + value);
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account! FUND_ACCOUNT value:" + value);
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_MARKET(value);
                    event.setDesc("MARKET'format is error! MARKET value:" + value);
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value);
                    event.setDesc("STOCKHOLDER_CODE'format is error! STOCKHOLDER_CODE value:" + value);
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isPRICE(value);
                    event.setDesc("PRICE'format is error! PRICE value:" + value);
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("COUNT'format is error! COUNT value:" + value);
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isSTOCK_CODE(value);
                    event.setDesc("STOCK_CODE'format is error! STOCK_CODE value:" + value);
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isMARKET_INDICATOR(value);
                    event.setDesc("MARKET_INDICATOR'format is error! MARKET_INDICATOR value:" + value);
                    break;
                }
                case 9: {
                    isMatch = RegexUtils.isCLIENT_SEQ(value) || value.isEmpty();
                    event.setDesc("CLIENT_SEQ'format is error! CLIENT_SEQ value:" + value);
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 8) {
            String log = String.format("\u683c\u5f0f\u6548\u9a8c line %d field counts error", pos);
            logger.info(log);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(MEvent event) {
        int count = 0;
        int pos = event.getInt("format.current.line.pos");
        String line = event.getStr("file.line");
        String[] values = line.split(",", -1);
        event.put((Object)"func_no", (Object)620041);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value) && event.getStr("user_id").equals(value);
                    event.setDesc("FUND_ACCOUNT'format is error!  FUND_ACCOUNT value:" + value);
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_MARKET(value);
                    event.setDesc("MARKET'format is error! MARKET value:" + value);
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value);
                    event.setDesc("STOCKHOLDER_CODE'format is error! STOCKHOLDER_CODE value:" + value);
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isDOUBLE_POSITIVE(value);
                    event.setDesc("PRICE'format is error! PRICE value:" + value);
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("COUNT'format is error! COUNT value:" + value);
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isSTOCK_CODE(value);
                    event.setDesc("STOCK_CODE'format is error! STOCK_CODE value:" + value);
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isMARKET_INDICATOR(value);
                    event.setDesc("MARKET_INDICATOR'format is error! MARKET_INDICATOR value:" + value);
                    break;
                }
                case 9: {
                    isMatch = RegexUtils.isCLIENT_SEQ(value) || value.isEmpty();
                    event.setDesc("CLIENT_SEQ'format is error! CLIENT_SEQ value:" + value);
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 8) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent event) {
        String line = String.format("%d,%s,%s,%s,%s", event.getCode(), event.getDesc(), event.getStr("contract_no"), event.getStr("fund_acct"), event.getStr("client_seq"));
        return line;
    }
}

