/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;
import javax.inject.Inject;
import javax.inject.Named;

public class SingleCancelEntrust {
    @Inject
    @Named(value="core_event")
    private static MEvent eCore;

    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(620021);
        int i = 0;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"entrust_no", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"client_seq", (Object)value);
                        break;
                    }
                    case 5: {
                        event.put((Object)"portfolio_id", (Object)value);
                        break;
                    }
                    case 6: {
                        event.put((Object)"market_code", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(620021);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account!!");
                    break;
                }
                case 3: {
                    isMatch = StringUtils.isEmpty((String)value) ? true : RegexUtils.isENG_NUM_20(value);
                    event.setDesc("ENTRUST_NO_OLD'format is error!");
                    break;
                }
                case 4: {
                    isMatch = StringUtils.isEmpty((String)value) ? true : RegexUtils.isCLIENT_SEQ(value);
                    event.setDesc("CLIENT_SEQ'format is error!");
                    break;
                }
                case 5: {
                    isMatch = StringUtils.isEmpty((String)value) ? true : RegexUtils.isPORTFOLIO_ID(value);
                    event.setDesc("PORTFOLIO_ID format is error!");
                    break;
                }
                case 6: {
                    isMatch = StringUtils.isEmpty((String)value) ? true : RegexUtils.isFUND_MARKET(value);
                    event.setDesc("MARKET'format is error! MARKET value:" + value);
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 4) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent event) {
        return String.format("%d,%s,%s,%s,%s", event.getCode(), event.getDesc(), event.getStr("withdraw_no"), event.getStr("fund_acct"), event.getStr("client_seq"));
    }
}

