/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;

public class QueryStock {
    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(630004);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"market_code", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"sec_code", (Object)value);
                        break;
                    }
                    case 5: {
                        event.put((Object)"sec_type", (Object)value);
                        break;
                    }
                    case 6: {
                        event.put((Object)"query_index", (Object)value);
                        break;
                    }
                    case 7: {
                        event.put((Object)"query_count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 8: {
                        event.put((Object)"portfolio_id", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(630004);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account!!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_MARKET(value) || value.isEmpty();
                    event.setDesc("MARKET'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCK_CODE(value) || value.isEmpty();
                    event.setDesc("STOCK_CODE'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isSTOCK_TYPE(value) || value.isEmpty();
                    event.setDesc("STOCK_TYPE'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isQUERY_INDEX(value) || value.isEmpty();
                    event.setDesc("QUERY_INDEX'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("QUERY_COUNT'format is error!");
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isPORTFOLIO_ID(value) || value.isEmpty();
                    event.setDesc("PORTFOLIO_ID'format is error!");
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 7) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(MEvent event) {
        int count = 0;
        int pos = event.getInt("format.current.line.pos");
        String line = event.getStr("file.line");
        String[] values = line.split(",", -1);
        event.setFunctionCode(630004);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_MARKET(value) || value.isEmpty();
                    event.setDesc("MARKET'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCK_CODE(value) || value.isEmpty();
                    event.setDesc("STOCK_CODE'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isSTOCK_TYPE(value) || value.isEmpty();
                    event.setDesc("STOCK_TYPE'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_INDEX'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_COUNT'format is error!");
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count != 7) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent event) {
        return String.format("%d,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", event.getCode(), event.getDesc(), event.getStr("fund_acct"), event.getStr("query_index"), event.getStr("total_vol"), event.getStr("sec_day_start"), event.getStr("sec_avl"), event.getStr("sec_trans_avl"), event.getStr("cur_sell_vol"), event.getStr("cur_buy_vol"), event.getStr("holder_acc_no"), event.getStr("market_code"), event.getStr("sec_code"), event.getStr("sec_name"), event.getStr("sec_type"), event.getStr("sell_frozen_vol"), event.getStr("manual_frozen_vol"), event.getStr("manual_unfrozen_vol"), event.getStr("transfer_in_vol"), event.getStr("transfer_out_vol"), event.getStr("cost_price"), event.getStr("profit"));
    }
}

