/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;

public class QueryMarginEntrust {
    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(640005);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"query_count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 3: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"holder_acc_no", (Object)value);
                        break;
                    }
                    case 5: {
                        event.put((Object)"withdraw_flag", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 6: {
                        event.put((Object)"batch_id", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(640005);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("QUERY_COUNT'format is error!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error!");
                    break;
                }
                case 4: {
                    isMatch = "0".equals(value) || "1".equals(value) || value.isEmpty();
                    event.setDesc("WITHDRAW_FLAG'format is error!");
                    break;
                }
                case 5: {
                    isMatch = true;
                    event.setDesc("BATCH_ID'format is error!");
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 3) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent event) {
        return String.format("%d,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", event.getCode(), event.getDesc(), event.getStr("fund_acct"), event.getStr("batch_sno"), event.getStr("query_index"), event.getStr("contract_no"), event.getStr("currency_type"), event.getStr("entrust_price"), event.getStr("bs"), event.getStr("entrust_vol"), event.getStr("holder_acc_no"), event.getStr("market_code"), event.getStr("sec_code"), event.getStr("sec_name"), event.getStr("entrust_time"), event.getStr("entrust_status"), event.getStr("withdraw_flag"), event.getStr("entrust_date"), event.getStr("org_contract_no"), event.getStr("done_vol"), event.getStr("done_price"), event.getStr("withdraw_vol"), event.getStr("rpt_contract_no"), event.getStr("basket_no"), event.getStr("client_seq"));
    }
}

