/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;

public class QueryMarginDeal {
    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(640006);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"query_count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 3: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"holder_acc_no", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(640006);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("QUERY_COUNT'format is error!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value) || value.isEmpty();
                    event.setDesc("STOCKHOLDER_CODE'format is error!");
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 3) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent e) {
        return String.format("%d,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", e.getCode(), e.getDesc(), e.getStr("fund_acct"), e.getStr("query_index"), e.getStr("contract_no"), e.getStr("currency_type"), e.getStr("bs"), e.getStr("done_no"), e.getStr("done_amt"), e.getStr("done_price"), e.getStr("done_time"), e.getStr("done_vol"), e.getStr("market_code"), e.getStr("sec_code"), e.getStr("sec_name"), e.getStr("withdraw_flag"), e.getStr("done_status"), e.getStr("cust_fee"), e.getStr("rpt_contract_no"), e.getStr("basket_no"), e.getStr("exchange_err_code"), e.getStr("err_msg"));
    }
}

