/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;

public class QueryEntrust {
    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(630005);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"market_code", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"holder_acc_no", (Object)value);
                        break;
                    }
                    case 5: {
                        event.put((Object)"contract_no", (Object)value);
                        break;
                    }
                    case 6: {
                        event.put((Object)"bs", (Object)value);
                        break;
                    }
                    case 7: {
                        event.put((Object)"batch_sno", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 8: {
                        event.put((Object)"sec_code", (Object)value);
                        break;
                    }
                    case 9: {
                        event.put((Object)"query_flag", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 10: {
                        event.put((Object)"withdraw_flag", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 11: {
                        event.put((Object)"rank_type", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 12: {
                        event.put((Object)"query_index", (Object)value);
                        break;
                    }
                    case 13: {
                        event.put((Object)"query_count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 14: {
                        event.put((Object)"portfolio_id", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(630005);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account!!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_MARKET(value) || value.isEmpty();
                    event.setDesc("MARKET'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value) || value.isEmpty();
                    event.setDesc("STOCKHOLDER_CODE'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isCONTRACT_NO(value) || value.isEmpty();
                    event.setDesc("CONTRACT_NO'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isBS_FLAG(value) || value.isEmpty();
                    event.setDesc("BS_FLAG'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("BATCH_NO'format is error!");
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isSTOCK_CODE(value) || value.isEmpty();
                    event.setDesc("STOCK_CODE'format is error!");
                    break;
                }
                case 9: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_FLAG'format is error!");
                    break;
                }
                case 10: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("WITHDRAW_FLAG'format is error!");
                    break;
                }
                case 11: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("RANK_TYPE'format is error!");
                    break;
                }
                case 12: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_INDEX'format is error!");
                    break;
                }
                case 13: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("QUERY_COUNT'format is error!");
                    break;
                }
                case 14: {
                    isMatch = RegexUtils.isPORTFOLIO_ID(value) || value.isEmpty();
                    event.setDesc("PORTFOLIO_ID'format is error!");
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 13) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(MEvent event) {
        int count = 0;
        int pos = event.getInt("format.current.line.pos");
        String line = event.getStr("file.line");
        String[] values = line.split(",", -1);
        event.setFunctionCode(630005);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value) && event.getStr("user_id").equals(value);
                    event.setDesc("FUND_ACCOUNT'format is error!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_MARKET(value) || value.isEmpty();
                    event.setDesc("MARKET'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value) || value.isEmpty();
                    event.setDesc("STOCKHOLDER_CODE'format is error!");
                }
                case 5: {
                    isMatch = RegexUtils.isCONTRACT_NO(value) || value.isEmpty();
                    event.setDesc("CONTRACT_NO'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isBS_FLAG(value) || value.isEmpty();
                    event.setDesc("BS_FLAG'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("BATCH_NO'format is error!");
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isSTOCK_CODE(value) || value.isEmpty();
                    event.setDesc("STOCK_CODE'format is error!");
                    break;
                }
                case 9: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_FLAG'format is error!");
                    break;
                }
                case 10: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("WITHDRAW_FLAG'format is error!");
                    break;
                }
                case 11: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("RANK_TYPE'format is error!");
                    break;
                }
                case 12: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_INDEX'format is error!");
                    break;
                }
                case 13: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("QUERY_COUNT'format is error!");
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count != 13) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent event) {
        return String.format("%d,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", event.getCode(), event.getDesc(), event.getStr("fund_acct"), event.getStr("batch_sno"), event.getStr("query_index"), event.getStr("contract_no"), event.getStr("currency_type"), event.getStr("entrust_price"), event.getStr("bs"), event.getStr("entrust_vol"), event.getStr("holder_acc_no"), event.getStr("market_code"), event.getStr("sec_code"), event.getStr("sec_name"), event.getStr("entrust_time"), event.getStr("entrust_status"), event.getStr("withdraw_flag"), event.getStr("entrust_date"), event.getStr("org_contract_no"), event.getStr("done_vol"), event.getStr("done_price"), event.getStr("withdraw_vol"), event.getStr("rpt_contract_no"), event.getStr("basket_no"), event.getStr("client_seq"));
    }

    public static String statusChange(int status) {
        String resStatus = "";
        switch (status) {
            case 3: {
                resStatus = "E";
                break;
            }
            case 4: {
                resStatus = "F";
                break;
            }
            case 5: {
                resStatus = "7";
                break;
            }
            case 6: {
                resStatus = "8";
                break;
            }
            case 7: {
                resStatus = "5";
                break;
            }
            case 8: {
                resStatus = "6";
                break;
            }
            case 9: {
                resStatus = "C";
                break;
            }
            case 10: {
                resStatus = "D";
                break;
            }
            default: {
                resStatus = Integer.toString(status);
            }
        }
        return resStatus;
    }
}

