/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;

public class QueryDeal {
    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(630006);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"market_code", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"holder_acc_no", (Object)value);
                        break;
                    }
                    case 5: {
                        event.put((Object)"contract_no", (Object)value);
                        break;
                    }
                    case 6: {
                        event.put((Object)"bs", (Object)value);
                        break;
                    }
                    case 7: {
                        event.put((Object)"batch_sno", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 8: {
                        event.put((Object)"sec_code", (Object)value);
                        break;
                    }
                    case 9: {
                        event.put((Object)"query_flag", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 10: {
                        event.put((Object)"query_index", (Object)value);
                        break;
                    }
                    case 11: {
                        event.put((Object)"query_count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 12: {
                        event.put((Object)"portfolio_id", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(630006);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account!!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_MARKET(value) || value.isEmpty();
                    event.setDesc("MARKET'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value) || value.isEmpty();
                    event.setDesc("STOCKHOLDER_CODE'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isCONTRACT_NO(value) || value.isEmpty();
                    event.setDesc("CONTRACT_NO'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isBS_FLAG(value) || value.isEmpty();
                    event.setDesc("BS_FLAG'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("BATCH_NO'format is error!");
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isSTOCK_CODE(value) || value.isEmpty();
                    event.setDesc("STOCK_CODE'format is error!");
                    break;
                }
                case 9: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_FLAG'format is error!");
                    break;
                }
                case 10: {
                    isMatch = RegexUtils.isQUERY_INDEX(value) || value.isEmpty();
                    event.setDesc("QUERY_INDEX'format is error!");
                    break;
                }
                case 11: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("QUERY_COUNTS'format is error!");
                    break;
                }
                case 12: {
                    isMatch = RegexUtils.isPORTFOLIO_ID(value) || value.isEmpty();
                    event.setDesc("PORTFOLIO_ID'format is error!");
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 11) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(MEvent event) {
        int count = 0;
        int pos = event.getInt("format.current.line.pos");
        String line = event.getStr("file.line");
        String[] values = line.split(",", -1);
        event.setFunctionCode(630006);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value) && event.getStr("user_id").equals(value);
                    event.setDesc("FUND_ACCOUNT'format is error!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_MARKET(value) || value.isEmpty();
                    event.setDesc("MARKET'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value) || value.isEmpty();
                    event.setDesc("STOCKHOLDER_CODE'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isCONTRACT_NO(value) || value.isEmpty();
                    event.setDesc("CONTRACT_NO'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isBS_FLAG(value) || value.isEmpty();
                    event.setDesc("BS_FLAG'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("BATCH_NO'format is error!");
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isSTOCK_CODE(value) || value.isEmpty();
                    event.setDesc("STOCK_CODE'format is error!");
                    break;
                }
                case 9: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_FLAG'format is error!");
                    break;
                }
                case 10: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_INDEX'format is error!");
                    break;
                }
                case 11: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) || value.isEmpty();
                    event.setDesc("QUERY_COUNTS'format is error!");
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, i, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count != 11) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent e) {
        return String.format("%d,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", e.getCode(), e.getDesc(), e.getStr("fund_acct"), e.getStr("query_index"), e.getStr("contract_no"), e.getStr("currency_type"), e.getStr("bs"), e.getStr("done_no"), e.getStr("done_amt"), e.getStr("done_price"), e.getStr("done_time"), e.getStr("done_vol"), e.getStr("market_code"), e.getStr("sec_code"), e.getStr("sec_name"), e.getStr("withdraw_flag"), e.getStr("done_status"), e.getStr("cust_fee"), e.getStr("rpt_contract_no"), e.getStr("basket_no"), e.getStr("exchange_err_code"), e.getStr("err_msg"));
    }
}

