/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarginTransferCancel {
    private static Logger logger = LogManager.getLogger(MarginTransferCancel.class);

    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(620060);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"holder_acc_no", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"trans_seq", (Object)value);
                    }
                    case 5: {
                        event.put((Object)"client_seq", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.put((Object)"func_no", (Object)620060);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            logger.info(" \u5b57\u6bb5\u503c\uff1a" + value);
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account! FUND_ACCOUNT value:" + value);
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value);
                    event.setDesc("STOCKHOLDER_CODE'format is error! STOCKHOLDER_CODE value:" + value);
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isENG_NUM_20(value) || value.isEmpty();
                    event.setDesc("trans seq'format is error! trans seq value:" + value);
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isCLIENT_SEQ(value) || value.isEmpty();
                    event.setDesc("CLIENT_SEQ'format is error! CLIENT_SEQ value:" + value);
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 4) {
            String log = String.format("\u683c\u5f0f\u6548\u9a8c line %d field counts error", pos);
            logger.info(log);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }
}

