/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.file.order.utils.builder.FieldBuilder;
import cms.tmx.file.order.utils.builder.StringFieldBuilder;
import cms.tmx.file.order.utils.matcher.RegexMatcher;
import cms.tmx.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class LightingInstructionCancel {
    private static final Map<Integer, FieldBuilder> BUILDER_MAP = new HashMap<Integer, FieldBuilder>(16){
        private static final long serialVersionUID = 1L;
        {
            this.put(2, new StringFieldBuilder("invest_id"));
            this.put(3, new StringFieldBuilder("INSTRUCTION_ID"));
            this.put(4, new StringFieldBuilder("cl_instruction_id"));
            this.put(5, new StringFieldBuilder("order_id"));
            this.put(6, new StringFieldBuilder("cl_order_id"));
        }
    };
    private static final Map<Integer, RegexMatcher> MATHER_MAP = new HashMap<Integer, RegexMatcher>(16){
        private static final long serialVersionUID = 1L;
        {
            this.put(2, new RegexMatcher("^[0-9]+$", false, "INVEST_ID"));
            this.put(3, new RegexMatcher("^[A-Za-z0-9]{1,16}$", true, "INSTRUCTION_ID"));
            this.put(4, new RegexMatcher("[^\\|]{1,30}$", true, "CL_INSTRUCTION_ID"));
            this.put(5, new RegexMatcher("[^\\|]{1,30}$", true, "ORDER_ID"));
            this.put(6, new RegexMatcher("[^\\|]{1,30}$", true, "CL_ORDER_ID"));
        }
    };

    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(620009);
        int i = 1;
        while (i < values.length) {
            FieldBuilder fieldBuilder;
            String value = values[i].trim();
            if (!value.isEmpty() && (fieldBuilder = BUILDER_MAP.get(i + 1)) != null) {
                event.put((Object)fieldBuilder.getKey(), fieldBuilder.build(value));
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(620009);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            RegexMatcher regexMatcher = MATHER_MAP.get(count);
            isMatch = regexMatcher != null ? regexMatcher.match(value) : true;
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 4) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(MEvent event) {
        int count = 0;
        int pos = event.getInt("format.current.line.pos");
        String line = event.getStr("file.line");
        String[] values = line.split(",", -1);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = StringUtils.isEmpty((String)value) ? true : RegexUtils.isENG_NUM(value);
                    event.setDesc("INSTRUCTION_ID'format is error!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("INVEST_ID'format is error!");
                    break;
                }
                case 4: {
                    if (StringUtils.isEmpty((String)value)) {
                        isMatch = true;
                        break;
                    }
                    isMatch = RegexUtils.isCLIENT_SEQ(value);
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 4) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }
}

