/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.builder.DoubleFieldBuilder;
import cms.tmx.file.order.utils.builder.FieldBuilder;
import cms.tmx.file.order.utils.builder.IntegerFieldBuilder;
import cms.tmx.file.order.utils.builder.StringFieldBuilder;
import cms.tmx.file.order.utils.matcher.RegexMatcher;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FastSingleAdvice {
    private static Logger logger = LogManager.getLogger(FastSingleAdvice.class);
    private static final Map<Integer, FieldBuilder> BUILDER_MAP = new HashMap<Integer, FieldBuilder>(16){
        private static final long serialVersionUID = 1L;
        {
            this.put(2, new StringFieldBuilder("fund_acct"));
            this.put(3, new StringFieldBuilder("market_code"));
            this.put(4, new StringFieldBuilder("holder_acc_no"));
            this.put(5, new DoubleFieldBuilder("price", 3));
            this.put(6, new StringFieldBuilder("Bsflag"));
            this.put(7, new IntegerFieldBuilder("count"));
            this.put(8, new StringFieldBuilder("sec_code"));
            this.put(9, new StringFieldBuilder("client_seq"));
            this.put(10, new StringFieldBuilder("portfolio_id"));
        }
    };
    private static final Map<Integer, RegexMatcher> MATHER_MAP = new HashMap<Integer, RegexMatcher>(16){
        private static final long serialVersionUID = 1L;
        {
            this.put(2, new RegexMatcher("^[0-9]+$", false, "FUND_ACCOUNT"));
            this.put(3, new RegexMatcher("^[1|2]{1,1}$", false, "FUND_MARKET"));
            this.put(4, new RegexMatcher("^[a-zA-Z0-9]{1,}[0-9]{9,10}$", false, "STOCKHOLDER_CODE"));
            this.put(5, new RegexMatcher("^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|[0-9]\\d*|0{1,20}$", false, "PRICE"));
            this.put(6, new RegexMatcher("^[a-zA-Z@#!0-9]{1,2}$", false, "ENTRUST_BS"));
            this.put(7, new RegexMatcher("^[1-9]\\d*|0$", false, "INTEGER_POSITIVE"));
            this.put(8, new RegexMatcher("^[0-9]\\d{5}$", false, "STOCK_CODE"));
            this.put(9, new RegexMatcher("[^\\|]{1,30}$", true, "CLIENT_SEQ"));
            this.put(10, new RegexMatcher("^[P][0-9]{7}$", true, "PORTFOLIO_ID"));
        }
    };

    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(620006);
        int i = 1;
        while (i < values.length) {
            FieldBuilder fieldBuilder;
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("") && (fieldBuilder = BUILDER_MAP.get(i + 1)) != null) {
                event.put((Object)fieldBuilder.getKey(), fieldBuilder.build(value));
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.put((Object)"func_no", (Object)620006);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            RegexMatcher regexMatcher = MATHER_MAP.get(count);
            isMatch = regexMatcher != null ? regexMatcher.match(value) : true;
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 9) {
            String log = String.format("\u683c\u5f0f\u6548\u9a8c line %d field counts error", pos);
            logger.info(log);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent event) {
        String line = String.format("%d,%s,%s,%s,%s", event.getCode(), event.getDesc(), event.getStr("contract_no"), event.getStr("fund_acct"), event.getStr("client_seq"));
        return line;
    }
}

