/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;

public class CapitalTransfer {
    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(654106);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"datasource", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"currency_type", (Object)value);
                        break;
                    }
                    case 5: {
                        event.put((Object)"other_fund_acct", (Object)value);
                        break;
                    }
                    case 6: {
                        event.put((Object)"amt", (Object)StringUtils.parseDouble((String)value, (int)2));
                        break;
                    }
                    case 7: {
                        event.put((Object)"operate_type", (Object)value);
                        break;
                    }
                    case 8: {
                        event.put((Object)"remark", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(654106);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isDATASOURCE(value);
                    event.setDesc("DATASOURCE'format is error!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value) && value.equals(remark[0]);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account!!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isBZ(value);
                    event.setDesc("CURRENCY_TYPE'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("OTHER_FUND_ACCOUNT'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isAMT(value);
                    event.setDesc("AMT'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isOPERATE_TYPE(value);
                    event.setDesc("OPERATE_TYPE'format is error!");
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isREMARK(value) || value.isEmpty();
                    event.setDesc("REMARK'format is error!");
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count != 8) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(MEvent event) {
        int count = 0;
        int pos = event.getInt("format.current.line.pos");
        String line = event.getStr("file.line");
        String[] values = line.split(",", -1);
        event.setFunctionCode(654106);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isDATASOURCE(value);
                    event.setDesc("DATASOURCE'format is error!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value) && event.getStr("user_id").equals(value);
                    event.setDesc("FUND_ACCOUNT'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isBZ(value);
                    event.setDesc("CURRENCY_TYPE'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("OTHER_FUND_ACCOUNT'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isDOUBLE_POSITIVE(value);
                    event.setDesc("AMT'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isOPERATE_TYPE(value);
                    event.setDesc("OPERATE_TYPE'format is error!");
                    break;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count != 8) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent e) {
        return String.format("%d,%s,%s", e.getCode(), e.getDesc(), e.getStr("sequence"));
    }
}

