/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;

public class BatchOrder {
    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(620003);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty() && !value.equals("")) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"pwd", (Object)value);
                        break;
                    }
                    case 4: {
                        event.put((Object)"order_count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 5: {
                        event.put((Object)"market_code", (Object)value);
                        break;
                    }
                    case 6: {
                        event.put((Object)"price", (Object)StringUtils.parseDouble((String)value, (int)3));
                        break;
                    }
                    case 7: {
                        event.put((Object)"Bsflag", (Object)value);
                        break;
                    }
                    case 8: {
                        event.put((Object)"count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 9: {
                        event.put((Object)"sec_code", (Object)value);
                        break;
                    }
                    case 10: {
                        event.put((Object)"holder_acc_no", (Object)value);
                        break;
                    }
                    case 11: {
                        event.put((Object)"cl_list_id", (Object)value);
                    }
                    case 12: {
                        event.put((Object)"cl_order_id", (Object)value);
                        break;
                    }
                    case 13: {
                        event.put((Object)"portfolio_id", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(620003);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account!!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isPWD(value) || value.isEmpty();
                    event.setDesc("TRADE_PASSWORD'format is error!");
                    break;
                }
                case 4: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("ORDER_COUNT'format is error!");
                    break;
                }
                case 5: {
                    isMatch = RegexUtils.isFUND_MARKET(value);
                    event.setDesc("MARKET'format is error!");
                    break;
                }
                case 6: {
                    isMatch = RegexUtils.isPRICE(value);
                    event.setDesc("PRICE'format is error!");
                    break;
                }
                case 7: {
                    isMatch = RegexUtils.isENTRUST_BS(value);
                    event.setDesc("ENTRUST_BS'format is error!");
                    break;
                }
                case 8: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("COUNT'format is error!");
                    break;
                }
                case 9: {
                    isMatch = RegexUtils.isSTOCK_CODE(value);
                    event.setDesc("STOCK_CODE'format is error!");
                    break;
                }
                case 10: {
                    isMatch = RegexUtils.isSTOCKHOLDER_CODE(value);
                    event.setDesc("STOCKHOLDER_CODE'format is error!");
                    break;
                }
                case 11: {
                    isMatch = RegexUtils.isCLIENT_SEQ(value) || value.isEmpty();
                    event.setDesc("CLIENT_SEQ'format is error!");
                }
                case 12: {
                    isMatch = RegexUtils.isCLIENT_LIST_SEQ(value) || value.isEmpty();
                    event.setDesc("CL_LIST_ID'format is error!");
                    break;
                }
                case 13: {
                    isMatch = RegexUtils.isPORTFOLIO_ID(value) || value.isEmpty();
                    event.setDesc("PORTFOLIO_ID'format is error!");
                    break;
                }
                default: {
                    isMatch = true;
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count < 12) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent event) {
        return String.format("%d,%s,%s,%s,%s,%s,%s,%s,%s,%s", event.getCode(), event.getDesc(), event.getStr("entrust_suc_counts"), event.getStr("fail_count"), event.getStr("batch_sno"), event.getStr("fund_acct"), event.getStr("pos"), event.getStr("contract_no"), event.getStr("err_code"), event.getStr("client_seq"));
    }
}

