/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.pares;

import cms.tmx.core.MEvent;
import cms.tmx.file.order.utils.RegexUtils;
import cms.tmx.utils.StringUtils;

public class BatchCancelByContractNo {
    public static MEvent build(String[] values) {
        MEvent event = new MEvent();
        event.setFunctionCode(620023);
        int i = 1;
        while (i < values.length) {
            String value = values[i].trim();
            if (!value.isEmpty()) {
                switch (i + 1) {
                    case 2: {
                        event.put((Object)"fund_acct", (Object)value);
                        break;
                    }
                    case 3: {
                        event.put((Object)"count", (Object)StringUtils.parseInt((String)value));
                        break;
                    }
                    case 4: {
                        event.put((Object)"entrust_no_set", (Object)value);
                    }
                }
            }
            ++i;
        }
        event.setCode(0);
        return event;
    }

    public static MEvent regexMatchLine(String[] values, int pos, String ... remark) {
        int count = 0;
        MEvent event = new MEvent();
        event.setFunctionCode(620023);
        int entrustCount = 0;
        int realEntrustCount = 0;
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value) && value.equals(remark[0]);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account!!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value) && StringUtils.parseInt((String)value) != 0;
                    entrustCount = isMatch ? StringUtils.parseInt((String)value) : 0;
                    event.setDesc("COUNT'format is error or count isn't 0!");
                    break;
                }
                case 4: {
                    String[] subVal;
                    String[] stringArray = subVal = value.split("\\|");
                    int n = subVal.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        isMatch = RegexUtils.isENG_NUM(val);
                        if (!isMatch) break;
                        ++n2;
                    }
                    isMatch = isMatch && subVal.length != 0;
                    realEntrustCount = subVal.length;
                    event.setDesc("ENTRUST_NO'format is error!");
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (entrustCount != realEntrustCount) {
            event.setDesc("COUNT=\ufffd\ufffd" + entrustCount + "\ufffd\ufffd\ufffd\ufffdENTRUST_NO size=\ufffd\ufffd" + realEntrustCount + "\ufffd\ufffd");
            event.setCode(999984);
            return event;
        }
        if (count != 4) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static MEvent regexMatchLine(MEvent event) {
        int count = 0;
        int pos = event.getInt("format.current.line.pos");
        String line = event.getStr("file.line");
        String[] values = line.split(",", -1);
        int i = 1;
        while (i < values.length) {
            count = i + 1;
            String value = values[i].trim();
            boolean isMatch = false;
            switch (count) {
                case 2: {
                    isMatch = RegexUtils.isFUND_ACCOUNT(value) && event.getStr("user_id").equals(value);
                    event.setDesc("FUND_ACCOUNT'format is error or account doesn't match longin account!!");
                    break;
                }
                case 3: {
                    isMatch = RegexUtils.isINTEGER_POSITIVE(value);
                    event.setDesc("COUNT'format is error or isn't 0!");
                    break;
                }
                case 4: {
                    String[] subVal;
                    String[] stringArray = subVal = value.split("\\|");
                    int n = subVal.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String val = stringArray[n2];
                        isMatch = RegexUtils.isENG_NUM(val);
                        if (!isMatch) break;
                        ++n2;
                    }
                    event.setDesc("ENTRUST_NO'format is error!");
                }
            }
            if (!isMatch) {
                String log = String.format("line[%d] field[%d] %s", pos, count, event.getDesc());
                event.setDesc(log);
                event.setCode(999984);
                return event;
            }
            ++i;
        }
        if (count != 4) {
            String log = String.format("line %d field counts error", pos);
            event.setCode(999983);
            event.setDesc(log);
            return event;
        }
        event.setOK();
        return event;
    }

    public static String packLine(MEvent event) {
        return String.format("%d,%s,%s,%s,%s,%s,%s,%s", event.getCode(), event.getDesc(), event.getStr("entrust_suc_counts"), event.getStr("fail_count"), event.getStr("fund_acct"), event.getStr("withdraw_contract_no"), event.getStr("org_contract_no"), event.getStr("err_code"));
    }
}

