/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.model;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.file.order.api.AccountApi;
import cms.tmx.file.order.api.BalanceSheetApi;
import cms.tmx.file.order.api.ContractApi;
import cms.tmx.file.order.api.DealApi;
import cms.tmx.file.order.api.MarginDealApi;
import cms.tmx.file.order.api.MarginOrderApi;
import cms.tmx.file.order.api.MarginPositionApi;
import cms.tmx.file.order.api.MarginTransferApi;
import cms.tmx.file.order.api.OrderApi;
import cms.tmx.file.order.api.PledgeSecurityApi;
import cms.tmx.file.order.api.PositionApi;
import cms.tmx.file.order.api.TradeApi;
import cms.tmx.file.order.api.TradeApiNew;
import cms.tmx.file.order.api.TransferApi;
import cms.tmx.file.order.api.UnderlyingSecurityApi;
import cms.tmx.file.order.utils.FileHander;
import cms.tmx.file.order.utils.LoggerUtils;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.LockModel;
import cms.tmx.query.current.mng.InstructionMng;
import cms.tmx.utils.ListUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TranHandler {
    @Inject
    protected MEventService es;
    @Inject
    private OrderApi orderApi;
    @Inject
    private DealApi dealApi;
    @Inject
    private InstructionMng isnMng;
    @Inject
    private PositionApi posApi;
    @Inject
    private MarginOrderApi marginOrderApi;
    @Inject
    private MarginDealApi marginDealApi;
    @Inject
    private MarginPositionApi marginPositionApi;
    @Inject
    private PledgeSecurityApi pledgeSecurityApi;
    @Inject
    private UnderlyingSecurityApi underlyingSecurityApi;
    @Inject
    private ContractApi contractApi;
    @Inject
    private BalanceSheetApi balanceSheetApi;
    @Inject
    private AccountApi accountApi;
    @Inject
    private TransferApi transferApi;
    @Inject
    private FileHander fileHander;
    @Inject
    private TradeApi api;
    @Inject
    private TradeApiNew apiNew;
    @Inject
    private MarginTransferApi transApi;
    @Inject
    private FundAccountMngServiceImpl fundService;
    @Inject
    private LockModel lockModel;
    @Inject
    private AccountMngServiceImpl accService;
    @Inject
    private HttpBaseApi apiBase;
    private Lock initLock = new ReentrantLock();
    private AtomicBoolean initDone = new AtomicBoolean(false);
    @Inject
    @Named(value="fixed.fileorder.pool")
    protected ExecutorService fixedPool;
    private static final Logger logger = LogManager.getLogger(TranHandler.class);
    private Set<String> needPopAccountsId = new HashSet<String>();

    @PostConstruct
    public void init() {
        logger.info("\u6587\u4ef6\u5355\u4ea4\u6613\u5904\u7406\u5668\u6a21\u5757\u521d\u59cb\u5316============");
        this.es.subscribe("tran/file", e -> this.onFile(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFile(MEvent e) {
        block58: {
            this.initLock.lock();
            try {
                try {
                    if (!this.initDone.get()) {
                        ObservableList accntList = this.accService.getAccountListByPost(this.apiBase.getBaseApi().getPostId());
                        this.needPopAccountsId.addAll(accntList.stream().filter(item -> item.isFileOrderManualConfirmation()).map(Account::getInvestorId).collect(Collectors.toList()));
                        this.initDone.set(true);
                    }
                }
                catch (MException | Exception e1) {
                    logger.error("\u521d\u59cb\u5316\u8d26\u53f7\u5f39\u6846\u6807\u5fd7\u5931\u8d25", e1);
                    this.initLock.unlock();
                    break block58;
                }
            }
            catch (Throwable throwable) {
                this.initLock.unlock();
                throw throwable;
            }
            this.initLock.unlock();
        }
        logger.info("begin");
        String uuid = e.getStr("file.manipulate.record.uuid");
        boolean containsEntrust = e.getBool("is_contain_cntrust");
        if (this.lockModel.isIsLocked()) {
            e.setCode(-1);
            logger.info("[" + uuid + "] \u4ea4\u6613\u9501\u5b9a\u72b6\u6001\uff0c\u53d6\u6d88\u4e0b\u5355!");
            return;
        }
        this.es.postEvent("window.active", new MEvent());
        String workMode = e.getStr("work.mode");
        HashSet<String> accounts = new HashSet<String>();
        boolean isPop = false;
        boolean hasPortofolio = false;
        if (containsEntrust && workMode.equals("monitor.work.mode")) {
            for (MEvent mEvent : e.getChildren()) {
                if (mEvent.getStr("portfolio_id") != null && !mEvent.getStr("portfolio_id").isEmpty()) {
                    hasPortofolio = true;
                    continue;
                }
                accounts.add(mEvent.getStr("invest_id"));
                accounts.add(mEvent.getStr("fund_acct"));
            }
            for (String id : accounts) {
                if (!this.needPopAccountsId.contains(id)) continue;
                isPop = true;
                break;
            }
            if (hasPortofolio) {
                isPop = true;
            }
            if (isPop) {
                String id;
                logger.info("[" + uuid + "] \u7cfb\u7edf\u53d1\u8d77\u4e0b\u5355\u8be2\u95ee\uff0c\u7b49\u5f85\u7528\u6237\u786e\u8ba4...!");
                e.put((Object)"user.confirm", (Object)false);
                this.es.sendEvent("file/order/request/confirm", e);
                id = e;
                synchronized (id) {
                    try {
                        logger.info("[" + uuid + "] \u5f39\u6846\u5df2\u7ecf\u5f39\u51fa\uff0c\u7b49\u5f85\u7528\u6237\u901a\u77e5! ");
                        while (!e.getBool("user.confirm")) {
                            e.wait();
                        }
                    }
                    catch (IllegalMonitorStateException | InterruptedException e1) {
                        logger.error((Object)e1);
                    }
                    logger.info("[" + uuid + "]\u6536\u5230\u901a\u77e5");
                    if (!e.isOK()) {
                        e.setCode(999980);
                        e.setDesc("\u7528\u6237\u53d6\u6d88\u4e0b\u5355!");
                        logger.error("############[" + uuid + "] \u7528\u6237\u53d6\u6d88\u4e0b\u5355!");
                        return;
                    }
                    logger.info("##############[" + uuid + "] \u7528\u6237\u786e\u8ba4\u4e0b\u5355!");
                }
            }
        }
        e.put((Object)"file.manipulate.record.succ.count", (Object)0);
        e.put((Object)"file.manipulate.record.fail.count", (Object)0);
        boolean hasBatchEntrust = false;
        boolean hasBatchOrder = false;
        boolean hasBasketAdvice = false;
        boolean hasBatchEntrustMargin = false;
        boolean hasBatchCancelEntrustMargin = false;
        boolean hasSingleAdvice = false;
        boolean hasFastSingleAdvice = false;
        boolean hasLightingSingleAdvice = false;
        boolean hasFastCancelIns = false;
        try {
            CountDownLatch cdl;
            logger.info("[" + uuid + "] \u5f00\u59cb\u904d\u5386\u6bcf\u7b14\u4ea4\u6613 \u603b\u5171[" + e.children.size() + "]\u7b14");
            int i = 0;
            ArrayList<MEvent> insList = new ArrayList<MEvent>();
            ArrayList<MEvent> fastInsList = new ArrayList<MEvent>();
            ArrayList<MEvent> lightingInsList = new ArrayList<MEvent>();
            ArrayList<MEvent> fastCancelInsList = new ArrayList<MEvent>();
            for (MEvent sub : e.children) {
                sub.put((Object)"file.manipulate.record.uuid", (Object)uuid);
                if (e.children.size() == ++i) {
                    sub.put((Object)"is_last", (Object)true);
                }
                if (sub.getFunctionCode() == 620002) {
                    e.setFunctionCode(620002);
                    hasBatchEntrust = true;
                    continue;
                }
                if (sub.getFunctionCode() == 620003) {
                    e.setFunctionCode(620003);
                    hasBatchOrder = true;
                    continue;
                }
                if (sub.getFunctionCode() == 620005) {
                    e.setFunctionCode(620005);
                    hasBasketAdvice = true;
                    continue;
                }
                if (sub.getFunctionCode() == 620043) {
                    e.setFunctionCode(620043);
                    hasBatchEntrustMargin = true;
                    continue;
                }
                if (sub.getFunctionCode() == 620051) {
                    e.setFunctionCode(620051);
                    hasBatchCancelEntrustMargin = true;
                    continue;
                }
                if (sub.getFunctionCode() == 620004) {
                    hasSingleAdvice = true;
                    insList.add(sub);
                    continue;
                }
                if (sub.getFunctionCode() == 620006) {
                    hasFastSingleAdvice = true;
                    fastInsList.add(sub);
                    continue;
                }
                if (sub.getFunctionCode() == 620008) {
                    hasLightingSingleAdvice = true;
                    lightingInsList.add(sub);
                    continue;
                }
                if (sub.getFunctionCode() == 620007) {
                    hasFastCancelIns = true;
                    fastCancelInsList.add(sub);
                    continue;
                }
                logger.info("[" + uuid + "] \u5f53\u524d\u4ea4\u6613 event :" + sub.entrySet());
                this.handleTran(e, sub, i);
                if (sub.getCode() != 0) {
                    logger.info("[" + uuid + "] code: " + sub.getCode() + ", error\uff1a" + sub.getDesc());
                    e.put((Object)"file.manipulate.record.fail.count", (Object)(e.getInt("file.manipulate.record.fail.count") + 1));
                    continue;
                }
                e.put((Object)"file.manipulate.record.succ.count", (Object)(e.getInt("file.manipulate.record.succ.count") + 1));
            }
            if (hasLightingSingleAdvice) {
                logger.info("\u591a\u7ebf\u7a0b\u4e0b\u6781\u901f\u6307\u4ee4\u5f00\u59cb,size" + lightingInsList.size());
                List pageList = ListUtils.split(lightingInsList, (int)30);
                cdl = new CountDownLatch(pageList.size());
                for (Object inse : pageList) {
                    this.fixedPool.execute(() -> this.lambda$2(cdl, e, (List)inse));
                }
                cdl.await(60000L, TimeUnit.MILLISECONDS);
                logger.info("\u4e0b\u8fbe\u6781\u901f\u6307\u4ee42.0\u5b8c\u6210~~~~~~~~~~~~~");
            }
            if (hasBatchEntrust) {
                logger.info("[" + uuid + "] \u5904\u7406\u5269\u4e0b\u7684\u6279\u91cf\u59d4\u6258");
                this.handleTran(e, e, 1);
                if (e.getCode() != 0) {
                    e.put((Object)"file.manipulate.record.fail.count", (Object)(e.getInt("file.manipulate.record.fail.count") + 1));
                    logger.error(String.format("uuid[%s] %d-%d \u6279\u91cf\u59d4\u6258 failed, %d: %s", uuid, e.getFunctionCode(), e.get((Object)"guid"), e.getCode(), e.getDesc()));
                } else {
                    int batchNum = (int)e.children.stream().filter(val -> val.getFunctionCode() == 620002).count();
                    e.put((Object)"file.manipulate.record.succ.count", (Object)(e.getInt("file.manipulate.record.succ.count") + batchNum));
                }
            }
            if (hasBatchOrder) {
                logger.info("[" + uuid + "] \u5904\u7406\u5269\u4e0b\u7684\u6279\u91cf\u59d4\u6258");
                this.handleTran(e, e, 1);
                if (e.getCode() != 0) {
                    e.put((Object)"file.manipulate.record.fail.count", (Object)(e.getInt("file.manipulate.record.fail.count") + 1));
                    logger.error(String.format("uuid[%s] %d-%d \u6279\u91cf\u59d4\u6258 failed, %d: %s", uuid, e.getFunctionCode(), e.get((Object)"guid"), e.getCode(), e.getDesc()));
                } else {
                    int batchNum = (int)e.children.stream().filter(val -> val.getFunctionCode() == 620003).count();
                    e.put((Object)"file.manipulate.record.succ.count", (Object)(e.getInt("file.manipulate.record.succ.count") + batchNum));
                }
            }
            if (hasSingleAdvice) {
                CountDownLatch cdl2 = new CountDownLatch(insList.size());
                logger.info("\u591a\u7ebf\u7a0b\u4e0b\u5355\u7b14\u6307\u4ee4\u5f00\u59cb,size" + insList.size());
                for (MEvent inse : insList) {
                    this.fixedPool.execute(() -> {
                        block6: {
                            try {
                                try {
                                    this.handleTran(e, inse, 1);
                                    if (inse.getCode() != 0) {
                                        logger.info("[" + uuid + "] code: " + inse.getCode() + ", error\uff1a" + inse.getDesc());
                                        e.put((Object)"file.manipulate.record.fail.count", (Object)(e.getInt("file.manipulate.record.fail.count") + 1));
                                        break block6;
                                    }
                                    e.put((Object)"file.manipulate.record.succ.count", (Object)(e.getInt("file.manipulate.record.succ.count") + 1));
                                }
                                catch (Exception ee) {
                                    logger.error("\u591a\u7ebf\u7a0b\u4e0b\u6307\u4ee4\u5355\u51fa\u9519", (Throwable)ee);
                                    cdl2.countDown();
                                }
                            }
                            finally {
                                cdl2.countDown();
                            }
                        }
                    });
                }
                cdl2.await(60000L, TimeUnit.MILLISECONDS);
            }
            if (hasFastSingleAdvice) {
                logger.info("\u591a\u7ebf\u7a0b\u4e0b\u6781\u901f\u6307\u4ee4\u5f00\u59cb,size" + fastInsList.size());
                List pageList = ListUtils.split(fastInsList, (int)30);
                cdl = new CountDownLatch(pageList.size());
                for (Object inse : pageList) {
                    this.fixedPool.execute(() -> this.lambda$6(cdl, e, (List)inse));
                }
                cdl.await(60000L, TimeUnit.MILLISECONDS);
                logger.info("\u4e0b\u8fbe\u6781\u901f\u6307\u4ee4\u5b8c\u6210~~~~~~~~~~~~~");
            }
            if (hasFastCancelIns) {
                logger.info("\u591a\u7ebf\u7a0b\u64a4\u9500\u6781\u901f\u6307\u4ee4\u5f00\u59cb,size" + fastCancelInsList.size());
                ArrayList pageList = new ArrayList();
                int size = (fastCancelInsList.size() - 1) / 100 + 1;
                int j = 0;
                while (j < size) {
                    int n = j * 100;
                    int toIndex = (j + 1) * 100 > fastCancelInsList.size() ? fastCancelInsList.size() : (j + 1) * 100;
                    System.err.println(String.valueOf(n) + "|" + toIndex);
                    pageList.add(fastCancelInsList.subList(n, toIndex));
                    ++j;
                }
                CountDownLatch cdl3 = new CountDownLatch(pageList.size());
                for (List list : pageList) {
                    this.fixedPool.execute(() -> {
                        try {
                            try {
                                this.cancelIns(e, inse);
                            }
                            catch (Exception ee) {
                                logger.error("\u591a\u7ebf\u7a0b\u64a4\u9500\u6781\u901f\u6307\u4ee4\u5355\u51fa\u9519", (Throwable)ee);
                                cdl3.countDown();
                            }
                        }
                        finally {
                            cdl3.countDown();
                        }
                    });
                }
                cdl3.await(60000L, TimeUnit.MILLISECONDS);
                logger.info("\u64a4\u9500\u6781\u901f\u6307\u4ee4\u5904\u7406\u5b8c\u6210~~~~~~~~~~~~~");
            }
            if (hasBasketAdvice) {
                logger.info("[" + uuid + "] \u5904\u7406\u5269\u4e0b\u7684\u6279\u91cf\u59d4\u6258");
                this.handleTran(e, e, 1);
                if (e.getCode() != 0) {
                    e.put((Object)"file.manipulate.record.fail.count", (Object)(e.getInt("file.manipulate.record.fail.count") + 1));
                    logger.error(String.format("uuid[%s] %d-%d \u6279\u91cf\u59d4\u6258 failed, %d: %s", uuid, e.getFunctionCode(), e.get((Object)"guid"), e.getCode(), e.getDesc()));
                } else {
                    e.put((Object)"file.manipulate.record.succ.count", (Object)(e.getInt("file.manipulate.record.succ.count") + 1));
                }
            }
            if (hasBatchEntrustMargin) {
                logger.info("[" + uuid + "] \u5904\u7406\u5269\u4e0b\u7684\u6279\u91cf\u59d4\u6258");
                this.handleTran(e, e, 1);
                if (e.getCode() != 0) {
                    e.put((Object)"file.manipulate.record.fail.count", (Object)(e.getInt("file.manipulate.record.fail.count") + 1));
                    logger.error(String.format("uuid[%s] %d-%d \u6279\u91cf\u59d4\u6258 failed, %d: %s", uuid, e.getFunctionCode(), e.get((Object)"guid"), e.getCode(), e.getDesc()));
                } else {
                    int batchNum = (int)e.children.stream().filter(val -> val.getFunctionCode() == 620043).count();
                    e.put((Object)"file.manipulate.record.succ.count", (Object)(e.getInt("file.manipulate.record.succ.count") + batchNum));
                }
            }
            if (hasBatchCancelEntrustMargin) {
                logger.info("[" + uuid + "] \u5904\u7406\u5269\u4e0b\u7684\u6279\u91cf\u59d4\u6258");
                this.handleTran(e, e, 1);
                if (e.getCode() != 0) {
                    e.put((Object)"file.manipulate.record.fail.count", (Object)(e.getInt("file.manipulate.record.fail.count") + 1));
                    logger.error(String.format("uuid[%s] %d-%d \u6279\u91cf\u59d4\u6258 failed, %d: %s", uuid, e.getFunctionCode(), e.get((Object)"guid"), e.getCode(), e.getDesc()));
                } else {
                    int batchNum = (int)e.children.stream().filter(val -> val.getFunctionCode() == 620051).count();
                    e.put((Object)"file.manipulate.record.succ.count", (Object)(e.getInt("file.manipulate.record.succ.count") + batchNum));
                }
            }
            e.setOK();
            this.es.sendEvent("file/pack/request/csv", e);
            logger.info(String.format("uuid[%s]\u4ece\u6781\u901f\u67dc\u53f0\u5904\u7406\u4e0b\u5355\u5b8c\u6210\uff0c \u8bf7\u6c42\u5931\u8d25[%d], \u8bf7\u6c42\u6210\u529f[%d]", uuid, e.getInt("file.manipulate.record.fail.count"), e.getInt("file.manipulate.record.succ.count")));
        }
        catch (Exception e2) {
            logger.error("[" + uuid + "]", (Throwable)e2);
            e.clearResponse();
            e.setCode(999981);
        }
    }

    private void cancelIns(MEvent e, List<MEvent> inse) {
        String uuid = e.getStr("file.manipulate.record.uuid");
        int funcNo = e.getFunctionCode();
        int order_guid = e.getInt("guid");
        LoggerUtils.asyncLogger("[" + uuid + "] \u6839\u636e\u529f\u80fd\u53f7\uff0c\u5904\u7406\u64a4\u9500\u6781\u901f\u6307\u4ee4, tran_guid[" + order_guid + "] funcNo:" + funcNo + ", event :" + e.entrySet() + ",\u672c\u5305\u5927\u5c0f" + inse.size());
        this.api.topSpeedInstructionCancel(e, inse);
    }

    private void fastIns(MEvent e, List<MEvent> inse) throws MException {
        String uuid = e.getStr("file.manipulate.record.uuid");
        int funcNo = e.getFunctionCode();
        int order_guid = e.getInt("guid");
        LoggerUtils.asyncLogger("[" + uuid + "] \u6839\u636e\u529f\u80fd\u53f7\uff0c\u5904\u7406\u7b2c\u6781\u901f\u6307\u4ee4\u4e0b\u5355, tran_guid[" + order_guid + "] funcNo:" + funcNo + ", event :" + e.entrySet() + ",\u672c\u5305\u5927\u5c0f" + inse.size());
        this.api.newFastInstruction(e, inse);
    }

    private void lightingIns(MEvent e, List<MEvent> inse) throws MException {
        String uuid = e.getStr("file.manipulate.record.uuid");
        int funcNo = e.getFunctionCode();
        int order_guid = e.getInt("guid");
        LoggerUtils.asyncLogger("[" + uuid + "] \u6839\u636e\u529f\u80fd\u53f7\uff0c\u5904\u7406\u7b2c\u6781\u901f\u6307\u4ee4\u4e0b\u5355, tran_guid[" + order_guid + "] funcNo:" + funcNo + ", event :" + e.entrySet() + ",\u672c\u5305\u5927\u5c0f" + inse.size());
        this.api.lightingInstruction(e, inse);
    }

    public void handleTran(MEvent parent, MEvent e, int index) {
        String uuid = e.getStr("file.manipulate.record.uuid");
        int funcNo = e.getFunctionCode();
        long start = System.currentTimeMillis();
        int order_guid = e.getInt("guid");
        logger.info("[" + uuid + "] \u6839\u636e\u529f\u80fd\u53f7\uff0c\u5904\u7406\u7b2c[" + index + "]\u4e0b\u5355, tran_guid[" + order_guid + "] funcNo:" + funcNo + ", event :" + e.entrySet());
        switch (funcNo) {
            case 600013: {
                try {
                    e.setCode(-1);
                    this.instructionCancel(e);
                }
                catch (Exception e1) {
                    logger.error("600013\u6307\u4ee4\u64a4\u9500\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 620009: {
                try {
                    e.setCode(-1);
                    this.api.lightingInstructionCancel(e);
                }
                catch (Exception e1) {
                    logger.error("620009\u6307\u4ee4\u64a4\u9500\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 620001: {
                try {
                    this.api.newOrderSingle(e);
                }
                catch (Exception e1) {
                    logger.error("620001\u4e0b\u5355\u5931\u8d25\uff1a", (Throwable)e1);
                    parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                    break;
                }
                catch (MException e1) {
                    try {
                        e.setDesc(e1.getDesc());
                        e.setCode(999981);
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                    }
                }
                parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                break;
            }
            case 620004: {
                try {
                    e.setCode(-1);
                    this.api.newInstruction(e);
                }
                catch (Exception e1) {
                    logger.error("620001\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25\uff1a", (Throwable)e1);
                    parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                    break;
                }
                catch (MException e1) {
                    try {
                        e.setDesc(e1.getDesc());
                        e.setCode(999981);
                        this.es.postEvent("message.log", e);
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                    }
                }
                parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                break;
            }
            case 620002: {
                try {
                    e.setCode(-1);
                    this.batchEntrust(e);
                }
                catch (Exception e1) {
                    e.setDesc(e1.getMessage());
                    e.setCode(999981);
                    logger.error("620002\u6279\u91cf\u4e0b\u5355\u5931\u8d25\uff1a", (Throwable)e1);
                }
                catch (MException e1) {
                    e.setDesc(e1.getDesc());
                    e.setCode(999981);
                }
                break;
            }
            case 620003: {
                try {
                    e.setCode(-1);
                    this.batchOrder(e);
                }
                catch (Exception e1) {
                    e.setDesc(e1.getMessage());
                    e.setCode(999981);
                    logger.error("620003\u6279\u91cf\u59d4\u6258\u4e0b\u5355\u5931\u8d25\uff1a", (Throwable)e1);
                }
                catch (MException e1) {
                    e.setDesc(e1.getDesc());
                    e.setCode(999981);
                }
                break;
            }
            case 620005: {
                try {
                    e.setCode(-1);
                    this.basketAdvice(e);
                }
                catch (Exception e1) {
                    e.setDesc(e1.getMessage());
                    e.setCode(999981);
                    logger.error("620005\u6279\u91cf\u4e0b\u6307\u4ee4\u5931\u8d25\uff1a", (Throwable)e1);
                    this.es.postEvent("message.log", e);
                }
                catch (MException e1) {
                    e.setDesc(e1.getDesc());
                    e.setCode(999981);
                    logger.error("620005MException\u6279\u91cf\u4e0b\u6307\u4ee4\u5931\u8d25\uff1a", (Throwable)e1);
                    this.es.postEvent("message.log", e);
                }
                break;
            }
            case 620022: {
                try {
                    e.setCode(-1);
                    this.batchCancelByBatchNo(e);
                }
                catch (Exception e1) {
                    logger.error("620022\u64a4\u5355\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 620021: {
                try {
                    this.api.cancelOrderSingle(e);
                    parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                }
                catch (Exception e1) {
                    logger.error("620001\u4e0b\u5355\u5931\u8d25\uff1a", (Throwable)e1);
                }
                catch (MException e1) {
                    e.setDesc(e1.getDesc());
                    e.setCode(999981);
                }
                break;
            }
            case 630004: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildPositionQuery(this.posApi.queryPositions(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("630004\u6301\u4ed3\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                catch (MException e1) {
                    logger.error("630004\u6301\u4ed3\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 630002: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildAccountQuery(this.accountApi.queryAccounts(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("630002\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 630007: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildTransferQuery(this.transferApi.queryTransfer(event), event, parent);
                }
                catch (MException | Exception e1) {
                    logger.error("630002\u67e5\u8be2\u6295\u7ec4\u5212\u8f6c\u5931\u8d25\uff1a", e1);
                }
                break;
            }
            case 640002: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildMarginAccountQuery(this.balanceSheetApi.GetBalanceSheetReq(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("630002\u67e5\u8be2\u878d\u8d44\u878d\u5238\u8d44\u91d1\u8d26\u53f7\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 630005: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildOrderQuery(this.orderApi.queryOrders(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("630005\u59d4\u6258\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 640005: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildMarginOrderQuery(this.marginOrderApi.getOrderList(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("640005\u878d\u8d44\u878d\u5238\u59d4\u6258\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 640006: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildMarginDealQuery(this.marginDealApi.GetExecutionsList(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("640006\u878d\u8d44\u878d\u5238\u6210\u4ea4\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 640004: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildMarginPositionQuery(this.marginPositionApi.getExtPositionList(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("640004\u878d\u8d44\u878d\u5238\u6301\u4ed3\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 640007: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildPledgeSecurityQuery(this.pledgeSecurityApi.getPledgeList(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("640007\u62c5\u4fdd\u8bc1\u5238\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 640008: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildUnderlyingSecurityQuery(this.underlyingSecurityApi.getUnderlyingSecurityList(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("640008\u6807\u7684\u8bc1\u5238\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 640009: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildContractQuery(this.contractApi.getContractList(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("640008\u5408\u7ea6\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 640010: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildMarginRateQuery(this.balanceSheetApi.GetBalanceSheetReq(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("630002\u67e5\u8be2\u878d\u8d44\u878d\u5238\u5e74\u5229\u7387\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 630006: {
                MEvent event;
                try {
                    event = e.clone();
                    this.fileHander.buildDealQuery(this.dealApi.queryDeals(event), event, parent);
                }
                catch (Exception e1) {
                    logger.error("500004\u6210\u4ea4\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                break;
            }
            case 620041: {
                try {
                    this.apiNew.newOrderSingle(e);
                }
                catch (Exception e1) {
                    logger.error("620001\u4e0b\u5355\u5931\u8d25\uff1a", (Throwable)e1);
                    parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                    break;
                }
                catch (MException e1) {
                    try {
                        e.setDesc(e1.getDesc());
                        e.setCode(999981);
                        MEvent event = new MEvent();
                        event.setDesc(e1.getDesc());
                        this.es.postEvent("message.log", event);
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                    }
                }
                parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                break;
            }
            case 620042: {
                try {
                    this.apiNew.cancelOrderSingle(e);
                }
                catch (Exception e1) {
                    logger.error("620001\u4e0b\u5355\u5931\u8d25\uff1a", (Throwable)e1);
                    parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                    break;
                }
                catch (MException e1) {
                    try {
                        e.setDesc(e1.getDesc());
                        e.setCode(999981);
                        MEvent event = new MEvent();
                        event.setDesc(e1.getDesc());
                        this.es.postEvent("message.log", event);
                        break;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                    }
                }
                parent.put((Object)"fundAccount", e.get((Object)"fundAccount"));
                break;
            }
            case 500011: {
                try {
                    e.setCode(-1);
                    this.fileHander.buildInstructionQuery(this.isnMng.query(), e, parent);
                    e.setOK();
                }
                catch (Exception e1) {
                    logger.error("500004\u6210\u4ea4\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                }
                catch (MException e1) {
                    logger.error("500004\u6210\u4ea4\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
                    e.setDesc(e1.getDesc());
                }
                break;
            }
            case 620043: {
                try {
                    this.apiNew.newOrderList(e);
                }
                catch (Exception e1) {
                    logger.error("620001\u4e0b\u5355\u5931\u8d25\uff1a", (Throwable)e1);
                }
                catch (MException e1) {
                    e.setDesc(e1.getDesc());
                    e.setCode(999981);
                    MEvent event = new MEvent();
                    event.setDesc(e1.getDesc());
                    this.es.postEvent("message.log", event);
                }
                break;
            }
            case 620050: {
                try {
                    this.transApi.MarginTransfer(e);
                }
                catch (Exception e1) {
                    logger.error("620050\u8fd8\u6b3e\u8fd8\u5238\u5931\u8d25\uff1a", (Throwable)e1);
                }
                catch (MException e1) {
                    e.setDesc(e1.getDesc());
                    e.setCode(999981);
                    MEvent event = new MEvent();
                    event.setDesc(e1.getDesc());
                    this.es.postEvent("message.log", event);
                }
                break;
            }
            case 620051: {
                try {
                    this.apiNew.batchCancelByBatchNo(e);
                }
                catch (Exception e1) {
                    logger.error("620050\u8fd8\u6b3e\u8fd8\u5238\u5931\u8d25\uff1a", (Throwable)e1);
                }
                catch (MException e1) {
                    e.setDesc(e1.getDesc());
                    e.setCode(999981);
                    MEvent event = new MEvent();
                    event.setDesc(e1.getDesc());
                    this.es.postEvent("message.log", event);
                }
                break;
            }
            case 620060: {
                try {
                    this.transApi.CancelMarginVoucherPayOff(e);
                }
                catch (Exception e1) {
                    logger.error("620050\u8fd8\u6b3e\u8fd8\u5238\u64a4\u5355\u5931\u8d25\uff1a", (Throwable)e1);
                }
                catch (MException e1) {
                    e.setDesc(e1.getDesc());
                    e.setCode(999981);
                    MEvent event = new MEvent();
                    event.setDesc(e1.getDesc());
                    this.es.postEvent("message.log", event);
                }
                break;
            }
            default: {
                logger.error("[" + uuid + "]" + funcNo + " \u4e0d\u8bc6\u522b");
                return;
            }
        }
        long end = System.currentTimeMillis();
        logger.info("[" + uuid + "] tran_guid[" + String.valueOf(e.getInt("guid")) + "], req time consuming:" + String.valueOf(end - start));
    }

    private void basketAdvice(MEvent e) throws Exception, MException {
        this.api.basketAdvice(e);
    }

    private void instructionCancel(MEvent e) {
        this.api.instructionCancel(e);
    }

    private void batchCancelByBatchNo(MEvent e) throws Exception {
        this.api.batchCancelByBatchNo(e);
    }

    private void batchEntrust(MEvent event) throws Exception, MException {
        this.api.batchEntrust(event);
    }

    private void batchOrder(MEvent event) throws Exception, MException {
        this.api.batchOrder(event);
    }

    private /* synthetic */ void lambda$2(CountDownLatch countDownLatch, MEvent mEvent, List list) {
        try {
            try {
                this.lightingIns(mEvent, list);
            }
            catch (MException | Exception ee) {
                logger.error("\u591a\u7ebf\u7a0b\u4e0b\u6781\u901f\u6307\u4ee4\u5355\u51fa\u9519", ee);
                countDownLatch.countDown();
            }
        }
        finally {
            countDownLatch.countDown();
        }
    }

    private /* synthetic */ void lambda$6(CountDownLatch countDownLatch, MEvent mEvent, List list) {
        try {
            try {
                this.fastIns(mEvent, list);
            }
            catch (MException | Exception ee) {
                logger.error("\u591a\u7ebf\u7a0b\u4e0b\u6781\u901f\u6307\u4ee4\u5355\u51fa\u9519", ee);
                countDownLatch.countDown();
            }
        }
        finally {
            countDownLatch.countDown();
        }
    }
}

