/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.model;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.file.order.entity.ResultStatistics;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ResultStatisticsModel
extends MxModel {
    @Inject
    private MEventService es;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ObservableList<ResultStatistics> list = FxUtils.newList();
    private ResultStatistics statistic = new ResultStatistics(0, 0, 0, 0);
    private String workMode;

    @PostConstruct
    public void init() {
        this.es.subscribe("file/request/record", e -> this.onFileRecordUpdate(e));
        this.es.subscribe("monitor/file/deal/success", e -> this.onOrderDealUpdate(e));
    }

    private void onOrderDealUpdate(MEvent e) {
        if (!this.workMode.equals(e.getStr("work.mode"))) {
            return;
        }
        int doneVol = 1;
        Platform.runLater(() -> this.statistic.update(0, 0, doneVol, 0));
    }

    private void onFileRecordUpdate(MEvent e) {
        if (!this.workMode.equals(e.getStr("work.mode"))) {
            return;
        }
        String uuid = e.getStr("file.manipulate.record.uuid");
        int failC = e.getInt("file.manipulate.record.fail.count");
        int succC = e.getInt("file.manipulate.record.succ.count");
        int deal = 0;
        int entrustVol = failC + succC;
        int withdrawVol = e.getInt("file.manipulate.record.withdraw.count");
        this.logger.info("[" + uuid + "]" + " update manipulate file record to  statistic surface! failC:" + failC + " succC:" + succC + " withdrawVol:" + withdrawVol);
        Platform.runLater(() -> this.statistic.update(entrustVol, withdrawVol, deal, failC));
    }

    public ObservableList<ResultStatistics> getList() {
        return this.list;
    }

    public ResultStatistics getStatistic() {
        return this.statistic;
    }

    public String getWorkMode() {
        return this.workMode;
    }

    public void setWorkMode(String workMode) {
        this.workMode = workMode;
    }
}

