/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.model;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.file.order.entity.DocScanAndOrderRecord;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class DocScanAndOrderRecordModel
extends MxModel {
    @Inject
    private MEventService es;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ObservableList<DocScanAndOrderRecord> docScanAndOrderRecordList = FxUtils.newList();
    private ObservableMap<String, DocScanAndOrderRecord> docScanAndOrderRecordMap = FxUtils.newMap();
    private String workMode;

    @PostConstruct
    public void init() {
        this.es.subscribe("file/request/record", e -> this.onFileRecordUpdate(e));
        this.es.subscribe("file/request/success", e -> this.onFileRecordUpdate(e));
    }

    private void onFileRecordUpdate(MEvent e) {
        if (!this.workMode.equals(e.getStr("work.mode"))) {
            return;
        }
        String uuid = e.getStr("file.manipulate.record.uuid");
        int succC = e.getInt("file.manipulate.record.succ.count");
        int failC = e.getInt("file.manipulate.record.fail.count");
        int errorC = e.getInt("file.manipulate.record.error.count");
        this.logger.info("[" + uuid + "]" + "\u66f4\u65b0\u64cd\u4f5c\u8bb0\u5f55\u5230\u754c\u9762!");
        Platform.runLater(() -> {
            if (this.docScanAndOrderRecordMap.containsKey((Object)uuid)) {
                DocScanAndOrderRecord docScanRecord = (DocScanAndOrderRecord)((Object)((Object)this.docScanAndOrderRecordMap.get((Object)uuid)));
                docScanRecord.update(e.getLong("file.manipulate.record.start.time"), e.getLong("file.manipulate.record.end.time"), succC, failC, errorC, succC + failC);
            } else {
                DocScanAndOrderRecord docScanRecord = new DocScanAndOrderRecord();
                docScanRecord.update(e);
                this.docScanAndOrderRecordMap.put((Object)uuid, (Object)docScanRecord);
                this.docScanAndOrderRecordList.add(0, (Object)docScanRecord);
            }
        });
    }

    public ObservableList<DocScanAndOrderRecord> getList() {
        return this.docScanAndOrderRecordList;
    }

    public String getWorkMode() {
        return this.workMode;
    }

    public void setWorkMode(String workMode) {
        this.workMode = workMode;
    }
}

