/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.file.order.utils.ConvertUtils;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.Page;
import cms.tmx.http.query.GetUnderlyingSecuritysReq;
import cms.tmx.http.query.GetUnderlyingSecuritysResp;
import cms.tmx.http.query.UnderlyingSecurity;
import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UnderlyingSecurityApi
extends HttpService {
    @Inject
    private MConfService cs;
    private Gson gson = new Gson();
    @Inject
    private HttpBaseApi httpBase;
    private static final Logger logger = LogManager.getLogger(UnderlyingSecurityApi.class);

    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/collateral/CollateralService";
    }

    public List<UnderlyingSecurity> getUnderlyingSecurityList(MEvent event) {
        LinkedList<UnderlyingSecurity> list = new LinkedList<UnderlyingSecurity>();
        try {
            String market = ConvertUtils.getMarket(event.getStr("market_code"));
            int pageSize = event.getInt("query_count") > 150 ? 150 : event.getInt("query_count");
            pageSize = pageSize == 0 ? 150 : pageSize;
            GetUnderlyingSecuritysReq req = new GetUnderlyingSecuritysReq();
            Page httpDefPage = this.httpBase.getHttpDefPage();
            httpDefPage.setPageSize(pageSize);
            req.setOpUser(this.httpBase.getHttpOpUser());
            req.setMarket(market);
            boolean flag = false;
            do {
                req.setPage(httpDefPage);
                String json = this.gson.toJson((Object)req);
                logger.info("\u878d\u8d44\u878d\u5238\u6587\u4ef6\u5355\u6807\u7684\u5238\u67e5\u8be2\u8bf7\u6c42\uff1a", (Object)json);
                String respBody = this.doPost("GetUnderlyingSecurity", json);
                logger.info("\u878d\u8d44\u878d\u5238\u6587\u4ef6\u5355\u6807\u7684\u5238\u67e5\u8be2\u54cd\u5e94\uff1a", (Object)respBody);
                GetUnderlyingSecuritysResp resp = new GetUnderlyingSecuritysResp();
                if (respBody == null) {
                    event.setDesc("\u6ca1\u6709\u6570\u636e");
                    return list;
                }
                resp = (GetUnderlyingSecuritysResp)this.gson.fromJson(respBody, GetUnderlyingSecuritysResp.class);
                this.checkStatus(resp.getStatus());
                if (resp.getUnderlyingSecurity() == null) {
                    event.setCode(resp.getStatus().getStatus());
                    event.setDesc("\u6ca1\u6709\u6570\u636e");
                    return list;
                }
                list.addAll(resp.getUnderlyingSecurity());
                event.setCode(resp.getStatus().getStatus());
                event.setDesc(resp.getStatus().getReason());
                boolean bl = flag = resp.getPage().getTotalRow() > resp.getPage().getStartRow() + resp.getPage().getPageSize() - 1;
                if (!flag) continue;
                httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
            } while (flag);
        }
        catch (MException e) {
            logger.error("640008\u6807\u7684\u8bc1\u5238\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e);
            event.setCode(e.getCode());
            event.setDesc(e.getDesc());
        }
        return list;
    }
}

