/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.api.CallApi;
import cms.tmx.api.IServiceDefine;
import cms.tmx.api.TradeServiceDefines;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.trade.PCashService;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.trade.TransRecord;
import cms.tmx.query.current.models.PortfolioAccountModel;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TransferApi
extends CallApi {
    @Inject
    private IBaseApi bmi;
    @Inject
    private PortfolioAccountModel portfolioModel;
    @Inject
    private TradeServiceDefines.TransCashServiceDefine tcs;
    @Inject
    private TradeServiceDefines.TransPosiServiceDefine tps;
    @Inject
    private MObjFactory of;
    private static final Logger logger = LogManager.getLogger(TransferApi.class);

    public List<TransRecord> queryTransfer(MEvent e) throws MException {
        LinkedList<TransRecord> list = new LinkedList<TransRecord>();
        String portfolioId = e.getStr("portfolio_id");
        String beginDate = e.getStr("begin_date");
        String endDate = e.getStr("end_date");
        boolean isCash = "1".equals(e.getStr("transfer_type"));
        Portfolio portfolio = this.portfolioModel.getPortfolio(portfolioId, "CCS");
        if (portfolio == null) {
            MEvent event = new MEvent();
            event.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u65e0\u6743\u9650");
            this.es.postEvent("message.log", event);
            e.setDesc("\u6295\u7ec4\u4ee3\u7801\uff1a" + portfolioId + "\u65e0\u6743\u9650");
            return list;
        }
        if (isCash) {
            List<PCashService.CashTransRecord> listRecord = this.getCashTransfer(beginDate, endDate, portfolio.getId(), e);
            for (PCashService.CashTransRecord cash : listRecord) {
                TransRecord record = (TransRecord)this.of.create(TransRecord.class);
                record.update((Object)cash);
                list.add(record);
            }
        } else {
            List<PCashService.PosTransRecord> listRecord = this.getPosTransfer(beginDate, endDate, portfolio.getId(), e);
            for (PCashService.PosTransRecord cash : listRecord) {
                TransRecord record = (TransRecord)this.of.create(TransRecord.class);
                record.update((Object)cash);
                list.add(record);
            }
        }
        return list;
    }

    private List<PCashService.CashTransRecord> getCashTransfer(String start, String end, String portfolioId, MEvent e) {
        LinkedList<PCashService.CashTransRecord> list = new LinkedList<PCashService.CashTransRecord>();
        try {
            PCashService.GetCashTransRecordsResp resp;
            PCashService.GetCashTransRecordsReq.Builder builder = PCashService.GetCashTransRecordsReq.newBuilder();
            builder.setOpUser(this.bmi.getOpUser());
            builder.setBeginTime(start);
            builder.setEndTime(end);
            builder.addAllPortfolioIdArray(Arrays.asList(portfolioId));
            PBase.Page.Builder page = PBase.Page.newBuilder();
            page.setStartRow(1);
            page.setPageSize(200);
            do {
                builder.setPage(page);
                MEvent event = new MEvent();
                event.setObj((Object)builder.build());
                this.action((IServiceDefine)this.tcs, "027", event);
                resp = (PCashService.GetCashTransRecordsResp)event.takeObj(PCashService.GetCashTransRecordsResp.class);
                this.checkStatus(resp.getStatus());
                if (resp.getRecordList().isEmpty()) {
                    e.setCode(resp.getStatus().getStatus());
                    e.setDesc(resp.getStatus().getReason());
                    return list;
                }
                list.addAll(resp.getRecordList());
                int startRow = page.getStartRow();
                int pageSize = page.getPageSize();
                page.setStartRow(startRow + pageSize);
                e.setCode(resp.getStatus().getStatus());
                e.setDesc(resp.getStatus().getReason());
            } while (page.getStartRow() <= resp.getPage().getTotalRow());
        }
        catch (MException e1) {
            logger.error("630007\u6295\u7ec4\u5212\u8f6c\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
            e.setCode(e1.getEvent().getCode());
            e.setDesc(e1.getDesc());
        }
        return list;
    }

    private List<PCashService.PosTransRecord> getPosTransfer(String start, String end, String portfolioId, MEvent e) {
        LinkedList<PCashService.PosTransRecord> list = new LinkedList<PCashService.PosTransRecord>();
        try {
            PCashService.GetPosTransRecordsResp resp;
            PCashService.GetPosTransRecordsReq.Builder builder = PCashService.GetPosTransRecordsReq.newBuilder();
            builder.setOpUser(this.bmi.getOpUser());
            builder.setBeginTime(start);
            builder.setEndTime(end);
            builder.addAllPortfolioIdArray(Arrays.asList(portfolioId));
            PBase.Page.Builder page = PBase.Page.newBuilder();
            page.setStartRow(1);
            page.setPageSize(10);
            do {
                builder.setPage(page);
                MEvent event = new MEvent();
                event.setObj((Object)builder.build());
                this.action((IServiceDefine)this.tps, "023", event);
                resp = (PCashService.GetPosTransRecordsResp)event.takeObj(PCashService.GetPosTransRecordsResp.class);
                this.checkStatus(resp.getStatus());
                if (resp.getRecordList().isEmpty()) {
                    e.setCode(resp.getStatus().getStatus());
                    e.setDesc(resp.getStatus().getReason());
                    return list;
                }
                list.addAll(resp.getRecordList());
                int startRow = page.getStartRow();
                int pageSize = page.getPageSize();
                page.setStartRow(startRow + pageSize);
                e.setCode(resp.getStatus().getStatus());
                e.setDesc(resp.getStatus().getReason());
            } while (page.getStartRow() <= resp.getPage().getTotalRow());
        }
        catch (MException e1) {
            logger.error("630007\u6295\u7ec4\u5212\u8f6c\u67e5\u8be2\u5931\u8d25\uff1a", (Throwable)e1);
            e.setCode(e1.getEvent().getCode());
            e.setDesc(e1.getDesc());
        }
        return list;
    }
}

