/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.file.order.utils.ConvertUtils;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.api.trade.dto.DoListCancelReq;
import cms.tmx.http.api.trade.dto.DoNewOrderListReq;
import cms.tmx.http.api.trade.dto.OrdLeg;
import cms.tmx.http.api.trade.dto.Orders;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TradeApiNew {
    @Inject
    private TradeServiceApi api;
    @Inject
    private HttpBaseApi apiBase;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private MarginAccountMap marginAccMap;
    @Inject
    private MEventService es;
    private Map<String, RefItem> map = new HashMap<String, RefItem>();
    private ChangeListener<? super Boolean> refListener = (ob, old, now) -> {
        if (now.booleanValue()) {
            Collection items = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"});
            items.forEach(item -> this.map.put(String.valueOf(item.getCode()) + item.getMarket(), (RefItem)item));
        }
    };
    private static final Logger logger = LogManager.getLogger(TradeApiNew.class);

    @PostConstruct
    private void init() {
        if (!this.refMng.doneProperty().get()) {
            this.refMng.doneProperty().addListener(this.refListener);
        } else {
            Collection items = this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"});
            items.forEach(item -> this.map.put(String.valueOf(item.getCode()) + item.getMarket(), (RefItem)item));
        }
    }

    public void newOrderSingle(MEvent e) throws MException {
        SecAccount secAccount;
        String uuid = e.getStr("file.manipulate.record.uuid");
        String investorId = e.getStr("fund_acct");
        String market = ConvertUtils.getMarket(e.getStr("market_code"));
        String investorSecId = e.getStr("holder_acc_no");
        double price = e.getDouble("price");
        String sec_code = e.getStr("sec_code");
        int count = e.getInt("count");
        String marketIndicate = MarketIndicator.getValue((String)e.getStr("market_indicator"));
        if (marketIndicate.isEmpty()) {
            e.put((Object)"order_id", (Object)"\u5355\u7b14\u59d4\u6258\u5931\u8d25");
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)"\u672a\u77e5\u7684\u4e1a\u52a1\u6807\u8bc6");
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"market_code", (Object)sec_code);
            e.put((Object)"topic", (Object)"response_entrust_confirm");
            return;
        }
        String client_seq = e.getStr("client_seq");
        RefItem item = this.refMng.getItem(market, sec_code);
        if (item == null) {
            e.put((Object)"order_id", (Object)"\u5355\u7b14\u59d4\u6258\u5931\u8d25");
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)("securityId:" + sec_code + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5"));
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"market_code", (Object)sec_code);
            e.put((Object)"topic", (Object)"response_entrust_confirm");
            return;
        }
        NewOrderSingle order = new NewOrderSingle();
        order.setOpUser(this.apiBase.getHttpOpUser());
        Instrument inst = new Instrument();
        inst.setSecurityId(sec_code);
        inst.setMarket(market);
        inst.setMarketIndicator(marketIndicate);
        if (item != null) {
            inst.setSymbol(item.getName());
            inst.setSecurityType(item.getType());
        }
        inst.setApplId("750");
        inst.setMarketGroup("CCS");
        order.setInstrument(inst);
        order.setOrdType(OrdType.ORD_TYPE_LIMIT);
        order.setOrderQty((double)count);
        order.setPrice(price);
        client_seq = "file|" + investorId + "|" + client_seq;
        order.setClOrdId(client_seq);
        String extSecAccntId = "";
        String extCashAccntId = "";
        CcsFundAccount fundAcc = this.marginAccMap.getFundAcc(investorId);
        if (fundAcc != null) {
            extCashAccntId = fundAcc.getNewCashAccntId();
        }
        if ((secAccount = this.marginAccMap.getSecAcc(investorSecId)) != null) {
            extSecAccntId = secAccount.getExtSecAccntId();
        }
        if (extSecAccntId.isEmpty()) {
            e.setCode(-1);
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)("\u8b49\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25"));
            e.put((Object)"order_id", (Object)"\u5355\u7b14\u59d4\u6258\u5931\u8d25");
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"market_code", (Object)sec_code);
            e.put((Object)"topic", (Object)"response_entrust_confirm");
            MEvent event = new MEvent();
            event.setDesc("\u8b49\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", event);
            return;
        }
        if (extCashAccntId.isEmpty()) {
            e.setCode(-1);
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25"));
            e.put((Object)"order_id", (Object)"\u5355\u7b14\u59d4\u6258\u5931\u8d25");
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"market_code", (Object)sec_code);
            e.put((Object)"topic", (Object)"response_entrust_confirm");
            MEvent event = new MEvent();
            event.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", event);
            return;
        }
        order.setAccount(investorId);
        order.setInvestorSecId(investorSecId);
        order.setExtCashAccntId(extCashAccntId);
        order.setExtSecAccntId(extSecAccntId);
        order.setTradePlatformId(fundAcc.getCounterId());
        long startTime = e.getLong("file.manipulate.record.start.time");
        e.put((Object)"fundAccount", (Object)fundAcc);
        this.es.sendEvent("save.order.fundid", e);
        String orderId = "";
        try {
            logger.info("[" + uuid + "]" + "\u5f00\u59cb\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u4e0b\u5355\u7b14\u59d4\u6258: " + e.entrySet());
            OpStatus op = this.api.newOrderSingle(order);
            logger.info("[" + uuid + "]" + "\u4ece\u5f00\u59cb\u5230\u4e0b\u5355\u8017\u65f6: " + (System.currentTimeMillis() - startTime));
            orderId = op.getData();
        }
        catch (MException e2) {
            e.put((Object)"order_id", (Object)"\u5355\u7b14\u59d4\u6258\u5931\u8d25");
            e.put((Object)"error_code", (Object)e2.getCode());
            e.put((Object)"erroe_msg", (Object)e2.getMessage());
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"market_code", (Object)sec_code);
            e.put((Object)"topic", (Object)"response_entrust_confirm");
            return;
        }
        e.put((Object)"error_code", (Object)"1");
        e.put((Object)"erroe_msg", (Object)"\u5355\u7b14\u59d4\u6258\u6210\u529f");
        e.put((Object)"order_id", (Object)orderId);
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"market_code", (Object)sec_code);
        e.put((Object)"topic", (Object)"response_entrust_confirm");
        e.setOK();
    }

    public void cancelOrderSingle(MEvent e) throws MException {
        String uuid = e.getStr("file.manipulate.record.uuid");
        String investorId = e.getStr("fund_acct");
        String orderId = e.getStr("entrust_no");
        String client_seq = e.getStr("client_seq");
        client_seq = "file|" + investorId + "|" + client_seq;
        OrderCancelRequest req = new OrderCancelRequest();
        req.setOpUser(this.apiBase.getHttpOpUser());
        String extCashAccntId = "";
        CcsFundAccount fundAcc = this.marginAccMap.getFundAcc(investorId);
        if (fundAcc != null) {
            extCashAccntId = fundAcc.getNewCashAccntId();
        }
        if (extCashAccntId.isEmpty()) {
            e.setCode(-1);
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25"));
            e.put((Object)"order_id", (Object)"\u5355\u7b14\u64a4\u5355\u5931\u8d25");
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"topic", (Object)"response_entrust_cancel_confirm");
            MEvent event = new MEvent();
            event.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", event);
            return;
        }
        Instrument inst = new Instrument();
        inst.setApplId("750");
        inst.setMarketGroup("CCS");
        req.setInstrument(inst);
        req.setOrderId(orderId);
        req.setOrigClOrdId(client_seq);
        req.setClOrdId(client_seq);
        req.setExtCashAccntId(extCashAccntId);
        req.setTradePlatformId(fundAcc.getCounterId());
        logger.info("[" + uuid + "]" + "\u5f00\u59cb\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u65b0\u6846\u67b6\u5355\u7b14\u64a4\u5355: " + e.entrySet());
        long startTime = e.getLong("file.manipulate.record.start.time");
        logger.info("[" + uuid + "]" + "\u4ece\u5f00\u59cb\u5230\u8c03\u7528\u64a4\u5355\u8017\u65f6: " + (System.currentTimeMillis() - startTime));
        try {
            this.api.orderCancel(req);
        }
        catch (MException e2) {
            e.put((Object)"error_code", (Object)e2.getCode());
            e.put((Object)"erroe_msg", (Object)e2.getMessage());
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"order_id", (Object)orderId);
            e.put((Object)"topic", (Object)"response_entrust_cancel_confirm");
            return;
        }
        e.put((Object)"error_code", (Object)"1");
        e.put((Object)"erroe_msg", (Object)"\u8bf7\u6c42\u6210\u529f");
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"order_id", (Object)orderId);
        e.put((Object)"topic", (Object)"response_entrust_cancel_confirm");
    }

    /*
     * Unable to fully structure code
     */
    public void newOrderList(MEvent e) throws MException {
        block15: {
            batchlist = e.children.stream().filter((Predicate<MEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$2(cms.tmx.core.MEvent ), (Lcms/tmx/core/MEvent;)Z)()).collect(Collectors.toList());
            clListIds = new HashSet<String>();
            accounts = new HashSet<String>();
            clListID = "";
            extCashAccntId = "";
            uuid = e.getStr("file.manipulate.record.uuid");
            TradeApiNew.logger.error("\u6279\u91cf\u4e0b\u5355\u5f00\u59cb,size:" + batchlist.size() + " uuid:" + uuid);
            tradeItems = new ArrayList<OrdLeg>();
            investorId = "";
            for (MEvent mEvent : batchlist) {
                mEvent.setCode(-1);
                investorId = mEvent.getStr("fund_acct");
                investorSecId = mEvent.getStr("holder_acc_no");
                clOrderId = mEvent.getStr("cl_order_id");
                marketIndicate = MarketIndicator.getValue((String)mEvent.getStr("market_indicator"));
                if (marketIndicate.isEmpty()) {
                    this.onBatchEntrustError(e, investorId, "", "\u672a\u77e5\u7684\u4e1a\u52a1\u6807\u8bc6");
                    this.onErrorTip("\u672a\u77e5\u7684\u4e1a\u52a1\u6807\u8bc6");
                    this.buildBatchEntrusEventError(e, "\u672a\u77e5\u7684\u4e1a\u52a1\u6807\u8bc6");
                    return;
                }
                price = mEvent.getDouble("price");
                count = mEvent.getDouble("count");
                clListID = mEvent.getStr("cl_list_id");
                e.put((Object)"cl_list_id", (Object)new String(clListID));
                clListID = "file|" + investorId + "|" + clListID;
                clListIds.add(clListID);
                clOrderId = "file|" + investorId + "|" + clOrderId;
                if (clListIds.size() > 1) {
                    this.onBatchEntrustError(e, investorId, "", "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u81ea\u5b9a\u4e49\u6279\u6b21\u53f7\u7684\u6279\u91cf\u5355");
                    this.buildBatchEntrusEventError(e, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u81ea\u5b9a\u4e49\u6279\u6b21\u53f7\u7684\u6279\u91cf\u5355");
                    return;
                }
                market = ConvertUtils.getMarket(mEvent.getStr("market_code"));
                refItem = this.refMng.getItem(market, securityId = mEvent.getStr("sec_code"));
                if (refItem == null) {
                    errorMsg = "securityId:" + securityId + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5";
                    this.onBatchEntrustError(e, investorId, "", errorMsg);
                    this.onErrorTip(errorMsg);
                    this.buildBatchEntrusEventError(e, errorMsg);
                    return;
                }
                leg = new OrdLeg();
                inst = new Instrument();
                inst.setSecurityId(securityId);
                inst.setSymbol(refItem.getName());
                inst.setMarketGroup("CCS");
                inst.setMarket(market);
                inst.setSecurityType(refItem.getType());
                inst.setMarketIndicator(marketIndicate);
                inst.setApplId("750");
                leg.setInstrument(inst);
                leg.setClOrdId(clOrderId);
                leg.setOrdType(OrdType.ORD_TYPE_LIMIT);
                leg.setOrderQty(count);
                leg.setPrice(price);
                extSecAccntId = "";
                fundAcc = this.marginAccMap.getFundAcc(investorId);
                if (fundAcc != null) {
                    extCashAccntId = fundAcc.getNewCashAccntId();
                }
                if ((secAccount = this.marginAccMap.getSecAcc(investorSecId)) != null) {
                    extSecAccntId = secAccount.getExtSecAccntId();
                }
                if (fundAcc != null) {
                    accounts.add(investorId);
                    eventAcc = new MEvent();
                    eventAcc.put((Object)"fundAccount", (Object)fundAcc);
                    this.es.sendEvent("save.order.fundid", eventAcc);
                }
                if (accounts.size() > 1) {
                    errorMsg = "\u6279\u91cf\u59d4\u6258\u5931\u8d25   \u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\u7684\u6279\u91cf\u5355";
                    this.onBatchEntrustError(e, investorSecId, "", errorMsg);
                    this.onErrorTip(errorMsg);
                    this.buildBatchEntrusEventError(e, errorMsg);
                    return;
                }
                if (extSecAccntId.isEmpty()) {
                    errorMsg = "\u8bc1\u5238\u8d26\u6237\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25";
                    this.onBatchEntrustError(e, investorSecId, "", errorMsg);
                    this.onErrorTip(errorMsg);
                    this.buildBatchEntrusEventError(e, errorMsg);
                    return;
                }
                if (extCashAccntId.isEmpty()) {
                    errorMsg = "\u8d44\u91d1\u8d26\u6237\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25";
                    this.onBatchEntrustError(e, investorId, "", errorMsg);
                    this.onErrorTip(errorMsg);
                    this.buildBatchEntrusEventError(e, errorMsg);
                    return;
                }
                leg.setExtCashAccntId(extCashAccntId);
                leg.setExtSecAccntId(extSecAccntId);
                tradeItems.add(leg);
            }
            if (tradeItems.size() == 0) {
                this.onBatchEntrustError(e, "", "", "\u6279\u91cf\u59d4\u6258\u5931\u8d25   \u65e0\u6821\u9a8c\u901a\u8fc7\u7684\u6279\u91cf\u5355");
                this.onErrorTip("\u6279\u91cf\u59d4\u6258\u5931\u8d25   \u65e0\u6821\u9a8c\u901a\u8fc7\u7684\u6279\u91cf\u5355");
                this.buildBatchEntrusEventError(e, "\u6279\u91cf\u59d4\u6258\u5931\u8d25   \u65e0\u6821\u9a8c\u901a\u8fc7\u7684\u6279\u91cf\u5355");
                return;
            }
            orders = new Orders();
            orders.setOrdLeg(tradeItems);
            fundAcc = this.marginAccMap.getFundAcc(investorId);
            req = new DoNewOrderListReq();
            req.setOrders(orders);
            req.setOpUser(this.apiBase.getHttpOpUser());
            req.setMarketGrp("CCS");
            req.setApplId("750");
            req.setClListId(clListID);
            req.setTradePlatformId(fundAcc.getCounterId());
            try {
                status = this.api.newOrderList(req);
                TradeApiNew.logger.info("\u6279\u91cf\u4e0b\u5355\u5b8c\u6210,\u7b14\u6570\uff1a" + tradeItems.size());
                e.setOK();
                e.put((Object)"list_id", (Object)"");
                e.put((Object)"list_leg_id", (Object)"");
                e.put((Object)"sec_code", (Object)"");
                e.put((Object)"cl_order_id", (Object)"");
                for (MEvent et : e.children) {
                    et.put((Object)"error_code", (Object)"1");
                    et.put((Object)"invest_id", (Object)et.getStr("fund_acct"));
                    et.put((Object)"erroe_msg", (Object)"\u6279\u91cf\u59d4\u6258\u6210\u529f");
                    et.put((Object)"sec_code", (Object)et.getStr("sec_code"));
                    et.put((Object)"topic", (Object)"response_batch_entrust_confirm");
                }
                listId = status.getData();
                TradeApiNew.logger.info("\u6279\u91cf\u55ae\u5f8c\u53f0\u8fd4\u8ff4\u6279\u6b21\u865f\uff1a" + listId);
                break block15;
            }
            catch (MException e2) {
                ** for (et : e.children)
            }
lbl-1000:
            // 1 sources

            {
                et.put((Object)"error_code", (Object)"-1");
                et.put((Object)"invest_id", (Object)et.getStr("fund_acct"));
                et.put((Object)"erroe_msg", (Object)("\u6279\u91cf\u59d4\u6258\u5931\u8d25" + e2.getMessage()));
                et.put((Object)"sec_code", (Object)et.getStr("sec_code"));
                et.put((Object)"topic", (Object)"response_batch_entrust_confirm");
                continue;
            }
lbl147:
            // 1 sources

            this.onBatchEntrustError(e, extCashAccntId, "", "\u6279\u91cf\u59d4\u6258\u5931\u8d25");
        }
    }

    private void buildBatchEntrusEventError(MEvent e, String msg) {
        for (MEvent et : e.children) {
            et.put((Object)"error_code", (Object)"-1");
            et.put((Object)"invest_id", (Object)et.getStr("fund_acct"));
            et.put((Object)"erroe_msg", (Object)("\u6279\u91cf\u59d4\u6258\u5931\u8d25:" + msg));
            et.put((Object)"sec_code", (Object)et.getStr("sec_code"));
            et.put((Object)"topic", (Object)"response_batch_entrust_confirm");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void batchCancelByBatchNo(MEvent event) throws MException {
        block14: {
            children = event.children;
            clListIds = new HashSet<String>();
            accounts = new HashSet<String>();
            clListID = "";
            extCashAccntId = "";
            uuid = event.getStr("file.manipulate.record.uuid");
            legs = new ArrayList<OrdLeg>();
            TradeApiNew.logger.info("[" + uuid + "]" + "\u5f00\u59cb\u6279\u6b21\u53f7\u6279\u91cf\u64a4\u5355");
            req = new DoListCancelReq();
            investorId = "";
            for (MEvent e : children) {
                investorId = e.getStr("fund_acct");
                legId = e.getStr("batch_leg_sno");
                clOrderId = e.getStr("cl_order_id");
                clListId = e.getStr("cl_list_id");
                if (!clOrderId.isEmpty()) {
                    clOrderId = "file|" + investorId + "|" + clOrderId;
                }
                if (!clListId.isEmpty()) {
                    clListId = "file|" + investorId + "|" + clListId;
                }
                if ((fundAcc = this.marginAccMap.getFundAcc(investorId)) != null) {
                    extCashAccntId = fundAcc.getNewCashAccntId();
                }
                if (fundAcc != null) {
                    accounts.add(investorId);
                    eventAcc = new MEvent();
                    eventAcc.put((Object)"fundAccount", (Object)fundAcc);
                    this.es.sendEvent("save.order.fundid", eventAcc);
                }
                if (accounts.size() > 1) {
                    errorMsg = "\u6279\u91cf\u59d4\u6258\u5931\u8d25   \u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\u7684\u6279\u91cf\u5355";
                    this.onBatchCancelError(event, legId, clOrderId, clListID, errorMsg);
                    this.onErrorTip(errorMsg);
                    return;
                }
                if (extCashAccntId.isEmpty()) {
                    errorMsg = "\u8d44\u91d1\u8d26\u6237\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25";
                    this.onBatchCancelError(event, legId, clOrderId, clListID, errorMsg);
                    this.onErrorTip(errorMsg);
                    return;
                }
                if (StringUtils.isEmpty((String)legId) && StringUtils.isEmpty((String)clOrderId)) {
                    clListID = clListId;
                    clListIds.add(clListID);
                    if (clListIds.size() <= 1) continue;
                    this.onBatchCancelError(e, legId, clOrderId, clListID, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u81ea\u5b9a\u4e49\u6279\u6b21\u53f7\u7684\u6279\u91cf\u5355");
                    return;
                }
                inst = new Instrument();
                inst.setMarketGroup("CCS");
                inst.setApplId("750");
                leg = new OrdLeg();
                leg.setExtCashAccntId(extCashAccntId);
                leg.setClOrdId(clOrderId);
                leg.setOrigClOrdId(clOrderId);
                leg.setOrderId(legId);
                leg.setInstrument(inst);
                legs.add(leg);
            }
            req.setOpUser(this.apiBase.getHttpOpUser());
            if (!StringUtils.isEmpty((String)clListID)) {
                req.setOrigListId(clListID);
                req.setAttachment(extCashAccntId);
                req.setMarketGrp("CCS");
            } else {
                orders = new Orders();
                orders.setOrdLeg(legs);
                req.setOrders(orders);
                req.setMarketGrp("CCS");
            }
            fundAcc = this.marginAccMap.getFundAcc(investorId);
            req.setTradePlatformId(fundAcc.getCounterId());
            req.setApplId("750");
            try {
                this.api.orderListCancel(req);
                for (MEvent et : event.children) {
                    et.put((Object)"error_code", (Object)"1");
                    et.put((Object)"erroe_msg", (Object)"\u6279\u91cf\u64a4\u5355\u8bf7\u6c42\u6210\u529f");
                    et.put((Object)"topic", (Object)"response_batch_cancel_margin_confirm");
                }
                break block14;
            }
            catch (MException e2) {
                ** for (et : event.children)
            }
lbl-1000:
            // 1 sources

            {
                et.put((Object)"error_code", (Object)"-1");
                et.put((Object)"erroe_msg", (Object)"\u6279\u91cf\u64a4\u5355\u8bf7\u6c42\u5931\u8d25");
                et.put((Object)"topic", (Object)"response_batch_cancel_margin_confirm");
                continue;
            }
lbl92:
            // 1 sources

            this.onBatchCancelError(event, "", "", "", e2.getMessage());
            return;
        }
        event.setOK();
        TradeApiNew.logger.info("[" + uuid + "]" + "\u6279\u6b21\u53f7\u6279\u91cf\u64a4\u5355\u8bf7\u6c42\u5df2\u53d1\u9001 ");
    }

    private void onErrorTip(String msg) {
        MEvent ev = new MEvent();
        ev.setDesc(msg);
        this.es.postEvent("message.log", ev);
    }

    private void onBatchEntrustError(MEvent e, String investorId, String clListId, String errMsg) {
        e.put((Object)"list_id", (Object)"");
        e.put((Object)"list_leg_id", (Object)"");
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"sec_code", (Object)"");
        e.put((Object)"cl_order_id", (Object)"");
        e.put((Object)"cl_list_id", (Object)clListId);
        e.put((Object)"error_code", (Object)"-1");
        e.put((Object)"erroe_msg", (Object)errMsg);
        e.put((Object)"topic", (Object)"response_batch_entrust_confirm");
        e.setCode(999981);
        e.setDesc(errMsg);
    }

    private void onBatchCancelError(MEvent e, String legId, String clOrderId, String clListId, String errMsg) {
        e.put((Object)"list_leg_id", (Object)legId);
        e.put((Object)"cl_order_id", (Object)clOrderId);
        e.put((Object)"cl_list_id", (Object)clListId);
        e.put((Object)"error_code", (Object)"-1");
        e.put((Object)"erroe_msg", (Object)errMsg);
        e.put((Object)"topic", (Object)"response_batch_cancel_margin_confirm");
        e.setCode(999981);
        e.setDesc(errMsg);
    }

    private static /* synthetic */ boolean lambda$2(MEvent val) {
        return val.getFunctionCode() == 620043;
    }
}

