/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.file.order.api;

import cms.tmx.api.basket.IBasketCancelOrderApi;
import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.ICancelOrderApi;
import cms.tmx.api.trade.INewOrderSingleApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.define.BsDict;
import cms.tmx.define.IDictMap;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.BasketOrderAdvice;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionCancelResult;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.file.order.entity.OrderRecord;
import cms.tmx.file.order.utils.ConvertUtils;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.api.trade.dto.Trade;
import cms.tmx.http.instruction.api.LightingInstructionApi;
import cms.tmx.http.instruction.dto.LightingInstruction;
import cms.tmx.http.instruction.dto.LightingInstructionBatch;
import cms.tmx.http.instruction.dto.LightingOrderCancel;
import cms.tmx.manage.IAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.models.basket.BasketCcsOrderModel;
import cms.tmx.trade.entrust.BatchEntrust;
import cms.tmx.utils.ListUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import cn.hutool.core.lang.UUID;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TradeApi {
    @Inject
    private IBaseApi apiBase;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private INewOrderSingleApi apiOrder;
    @Inject
    private ICancelOrderApi cancelApi;
    @Inject
    private CcsAccountMap map;
    @Inject
    private MEventService es;
    @Inject
    private BatchEntrust batchEn;
    @Inject
    private MObjFactory of;
    @Inject
    private IBasketCancelOrderApi bsktCancelApi;
    @Inject
    private static IDictMap dmap;
    @Inject
    protected IAccountService accountService;
    @Inject
    private BasketCcsOrderModel bsktOrderModel;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    protected PortfolioAccountModel portfolioAccountModel;
    @Inject
    private MConfService mConf;
    private Map<String, String> extAccProductMap = new HashMap<String, String>();
    @Inject
    private IInstructionApi insApi;
    @Inject
    private LightingInstructionApi lightingInsApi;
    @Inject
    private InstructionModel insModel;
    @Inject
    @Named(value="fixed.fileorder.pool")
    protected ExecutorService fixedPool;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private ConcurrentHashMap<String, OrderRecord> fileorderMap = new ConcurrentHashMap();
    private static final Logger logger;
    private static int PAR_VALUE;
    private final Set<String> STAR_SPEC_MARKET_TYPE = new HashSet<String>(){
        {
            this.add("0t");
            this.add("0v");
            this.add("0u");
            this.add("0w");
        }
    };
    protected Message message = null;
    protected PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();
    private AtomicInteger count = new AtomicInteger(0);

    static {
        logger = LogManager.getLogger(TradeApi.class);
        PAR_VALUE = 100;
    }

    private int getParValue(String market) {
        return market.equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    public void newOrderSingle(MEvent e) throws MException {
        String uuid = e.getStr("file.manipulate.record.uuid");
        String investorId = e.getStr("fund_acct");
        String market = ConvertUtils.getMarket(e.getStr("market_code"));
        String investorSecId = e.getStr("holder_acc_no");
        double price = e.getDouble("price");
        int bstype = ConvertUtils.getBsFlag(e.getStr("Bsflag"));
        String sec_code = e.getStr("sec_code");
        int count = e.getInt("count");
        String client_seq = e.getStr("client_seq");
        RefItem item = this.refMng.getItem(market, sec_code);
        if (item == null) {
            this.checkSingleOrderError(e, investorId, sec_code, e.getStr("portfolio_id"), "securityId:" + sec_code + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5", "\u5355\u7b14\u59d4\u6258\u5931\u8d25");
            return;
        }
        PComponent.Instrument.Builder builderI = PComponent.Instrument.newBuilder();
        builderI.setSecurityId(sec_code);
        builderI.setMarket(market);
        if (item != null) {
            builderI.setSecurityType(item.getType());
        }
        if ("XSHG".equals(market) && sec_code.startsWith("688")) {
            builderI.setApplId("700");
        } else {
            builderI.setApplId("010");
        }
        builderI.setMarketGroup("CCS");
        PComponent.Instrument instrument = builderI.build();
        PMessage.NewOrderSingle.Builder builderO = PMessage.NewOrderSingle.newBuilder();
        builderO.setOpUser(this.apiBase.getOpUser());
        builderO.setInstrument(instrument);
        builderO.setOrdTypeValue(50);
        builderO.setSideValue(bstype);
        builderO.setOrderQty((double)count);
        builderO.setPrice(price);
        client_seq = "file|" + investorId + "|" + client_seq;
        builderO.setClOrdId(client_seq);
        String portfolioId = e.getStr("portfolio_id");
        if (!StringUtils.isEmpty((String)portfolioId)) {
            List list;
            Portfolio portfolio = this.portfolioAccountModel.getPortfolio(portfolioId, "CCS");
            if (portfolio == null) {
                this.checkSingleOrderError(e, investorId, sec_code, portfolioId, "\u8be5\u6295\u7ec4:" + portfolioId + " \u65e0\u6743\u9650", "\u5355\u7b14\u59d4\u6258\u5931\u8d25");
                return;
            }
            e.put((Object)"fundAccount", (Object)portfolio);
            this.es.sendEvent("save.order.fundid", e);
            CcsSubFundAccount subAccount = null;
            CcsSubSecAccount subSecAccount = null;
            Map portfolioAccountMap = this.portfolioAccountModel.getMap(portfolio);
            if (portfolioAccountMap == null) {
                this.checkSingleOrderError(e, investorId, sec_code, portfolioId, "\u4f7f\u7528\u6295\u7ec4:" + portfolioId + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u8d26\u53f7", "\u5355\u7b14\u59d4\u6258\u5931\u8d25");
                return;
            }
            for (CcsFundAccount ccsFundAccount : portfolioAccountMap.keySet()) {
                if (!investorId.equals(ccsFundAccount.getInvestId())) continue;
                subAccount = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
                break;
            }
            if (subAccount != null && (list = (List)portfolioAccountMap.get(subAccount)) != null) {
                for (SecAccount secAccount : list) {
                    if (!investorSecId.equals(secAccount.getInverstorSecId())) continue;
                    subSecAccount = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                    break;
                }
            }
            if (subAccount == null || subSecAccount == null) {
                this.checkSingleOrderError(e, investorId, sec_code, portfolioId, "\u4f7f\u7528\u6295\u7ec4:" + portfolioId + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u4e8c\u7ea7\u8d26\u53f7", "\u5355\u7b14\u59d4\u6258\u5931\u8d25");
                return;
            }
            builderO.setPortfolioId(portfolioId);
            builderO.setSubAccntId(subSecAccount.getSubAccntId());
            builderO.setSubSecAccntId(subSecAccount.getSubSecAccntId());
            builderO.setExtSecAccntId(subSecAccount.getExtSecAccntId());
            builderO.setExtAccntId(subAccount.getExtAccntId());
        } else {
            CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
            SecAccount secAcc = this.map.getSecAcc(investorSecId, market);
            if (fundAcc == null) {
                this.checkSingleOrderError(e, investorId, sec_code, "", "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25", "\u5355\u7b14\u59d4\u6258\u5931\u8d25");
                return;
            }
            builderO.setExtAccntId(fundAcc.getExtAccntId());
            e.put((Object)"fundAccount", (Object)fundAcc);
            this.es.sendEvent("save.order.fundid", e);
            if (secAcc != null) {
                builderO.setExtSecAccntId(secAcc.getExtSecAccntId());
            } else {
                this.checkSingleOrderError(e, investorId, sec_code, "", "\u8bc1\u5238\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25", "\u5355\u7b14\u59d4\u6258\u5931\u8d25");
                return;
            }
        }
        PMessage.NewOrderSingle order = builderO.build();
        logger.info("[" + uuid + "]" + "\u5f00\u59cb\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u4e0b\u5355\u7b14\u59d4\u6258: " + e.entrySet());
        long startTime = e.getLong("file.manipulate.record.start.time");
        logger.info("[" + uuid + "]" + "\u4ece\u5f00\u59cb\u5230\u4e0b\u5355\u8017\u65f6: " + (System.currentTimeMillis() - startTime));
        String orderId = "";
        try {
            orderId = this.apiOrder.submit(order);
        }
        catch (MException e2) {
            e.put((Object)"order_id", (Object)"\u5355\u7b14\u59d4\u6258\u5931\u8d25");
            e.put((Object)"error_code", (Object)String.valueOf(e2.getCode()));
            e.put((Object)"erroe_msg", (Object)e2.getMessage());
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"market_code", (Object)sec_code);
            e.put((Object)"portfolio_id", (Object)portfolioId);
            e.put((Object)"topic", (Object)"response_entrust_confirm");
            return;
        }
        e.put((Object)"error_code", (Object)"1");
        e.put((Object)"erroe_msg", (Object)"\u5355\u7b14\u59d4\u6258\u6210\u529f");
        e.put((Object)"order_id", (Object)orderId);
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"market_code", (Object)sec_code);
        e.put((Object)"portfolio_id", (Object)portfolioId);
        e.put((Object)"topic", (Object)"response_entrust_confirm");
        e.setOK();
    }

    private void checkSingleOrderError(MEvent e, String investorId, String sec_code, String portfolioId, String errorMsg, String tipMsg) {
        e.setCode(-1);
        e.put((Object)"error_code", (Object)"-1");
        e.put((Object)"erroe_msg", (Object)errorMsg);
        e.put((Object)"order_id", (Object)tipMsg);
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"portfolio_id", (Object)portfolioId);
        e.put((Object)"market_code", (Object)sec_code);
        e.put((Object)"topic", (Object)"response_entrust_confirm");
        MEvent event = new MEvent();
        event.setDesc(errorMsg);
        this.es.postEvent("message.log", event);
    }

    public void newInstruction(MEvent e) throws MException {
        String uuid = e.getStr("file.manipulate.record.uuid");
        String investorId = e.getStr("fund_acct");
        String market = ConvertUtils.getMarket(e.getStr("market_code"));
        String investorSecId = e.getStr("holder_acc_no");
        double price = e.getDouble("price");
        String ordType = e.getStr("Bsflag");
        String sec_code = e.getStr("sec_code");
        int count = e.getInt("count");
        String oriClientSeq = e.getStr("client_seq");
        String clientSeq = "file|" + investorId + "|" + oriClientSeq;
        String portfolioId = e.getStr("portfolio_id");
        RefItem item = this.refMng.getItem(market, sec_code);
        if (item == null) {
            this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "securityId:" + sec_code + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
            return;
        }
        if (!item.getMarket().equals(market)) {
            this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "securityId:" + sec_code + ",market:" + market + ",\u5408\u7ea6\u4ee3\u7801\u672a\u5728\u5bf9\u5e94\u5e02\u573a\u627e\u5230");
            return;
        }
        OrderAdvice oa = (OrderAdvice)this.of.create(OrderAdvice.class);
        oa.setCanModify(false);
        oa.setAccntLevel(0);
        oa.setInstructionType(2);
        if (!StringUtils.isEmpty((String)portfolioId)) {
            oa.setAccntLevel(1);
            oa.setInstructionType(3);
        }
        oa.setMarket(item.getMarket());
        oa.setSec(item.getCode());
        oa.setSecType(item.getType());
        oa.setSecName(item.getName());
        oa.setClInstructionId(clientSeq);
        boolean isStar = sec_code.startsWith("688");
        oa.setStar(isStar);
        if (!isStar && this.checkMarketType(ordType)) {
            this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u975e\u79d1\u521b\u677f\u4ee3\u7801\u9009\u62e9\u4e86\u79d1\u521b\u677f\u72ec\u6709\u7684\u5e02\u4ef7\u7b56\u7565");
            return;
        }
        if (!BsDict.FILE_INSTRUCTION_BUY_TYPES.contains(ordType) && !BsDict.FILE_INSTRUCTION_SELL_TYPES.contains(ordType)) {
            this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u6307\u4ee4\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u522b\uff1a" + ordType);
            return;
        }
        if (item.getType().equals("REPO")) {
            oa.setSide(BsDict.FILE_INSTRUCTION_BUY_TYPES.contains(ordType) ? 71 : 70);
        } else {
            oa.setSide(BsDict.FILE_INSTRUCTION_BUY_TYPES.contains(ordType) ? 49 : 50);
        }
        this.buildPriceType(price, ordType, oa);
        if (isStar && BsDict.FILE_INSTRUCTION_MARKET_TYPES.contains(ordType)) {
            if (price <= 0.0 || price >= 10000.0) {
                this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u79d1\u521b\u677f\u5e02\u4ef7\u6307\u4ee4\uff0c\u4fdd\u62a4\u4ef7\u683c\u9700\u5927\u4e8e0\uff0c\u5c0f\u4e8e10000");
                return;
            }
            oa.setProtectedLimitPrice(price);
        }
        ArrayList<AccntSecInfo> accntSecList = new ArrayList<AccntSecInfo>();
        AccntSecInfo accntSec = new AccntSecInfo();
        WorkFlowDescriptor workflow = null;
        if (!StringUtils.isEmpty((String)portfolioId)) {
            List list;
            Portfolio portfolio = this.portfolioAccountModel.getPortfolio(portfolioId, "CCS");
            if (portfolio == null) {
                this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u8be5\u6295\u7ec4:" + portfolioId + " \u65e0\u6743\u9650");
                return;
            }
            oa.setPortfolioId(portfolioId);
            oa.setPortfolioName(portfolio.getName());
            e.put((Object)"fundAccount", (Object)portfolio);
            this.es.sendEvent("save.order.fundid", e);
            CcsSubFundAccount subAccount = null;
            CcsSubSecAccount subSecAccount = null;
            Map portfolioAccountMap = this.portfolioAccountModel.getMap(portfolio);
            if (portfolioAccountMap == null) {
                this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u4f7f\u7528\u6295\u7ec4:" + portfolio + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u8d26\u53f7");
                return;
            }
            for (CcsFundAccount ccsFundAccount : portfolioAccountMap.keySet()) {
                if (!investorId.equals(ccsFundAccount.getInvestId())) continue;
                subAccount = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
                break;
            }
            if (subAccount != null && (list = (List)portfolioAccountMap.get(subAccount)) != null) {
                for (SecAccount secAccount : list) {
                    if (!investorSecId.equals(secAccount.getInverstorSecId())) continue;
                    subSecAccount = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                    break;
                }
            }
            if (subAccount == null || subSecAccount == null) {
                this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u4f7f\u7528\u6295\u7ec4:" + portfolioId + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u4e8c\u7ea7\u8d26\u53f7");
                return;
            }
            accntSec.setAccntId(subAccount.getSubAccntId());
            accntSec.setInvestorId(subAccount.getInvestId());
            accntSec.setParentId(subAccount.getParentId());
            accntSec.setSubParentId(subAccount.getParentSubAccntId());
            accntSec.setSecAccntId(subSecAccount.getSubSecAccntId());
            workflow = this.instrAccModel.getWorkflow(portfolioId);
        } else {
            CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
            SecAccount secAcc = this.map.getSecAcc(investorSecId, market);
            if (fundAcc == null) {
                e.setCode(-1);
                this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
                return;
            }
            accntSec.setAccntId(fundAcc.getExtAccntId());
            accntSec.setInvestorId(fundAcc.getInvestId());
            accntSec.setParentId(fundAcc.getParentId());
            e.put((Object)"fundAccount", (Object)fundAcc);
            this.es.sendEvent("save.order.fundid", e);
            if (secAcc == null) {
                e.setCode(-1);
                this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650");
                return;
            }
            accntSec.setSecAccntId(secAcc.getExtSecAccntId());
            oa.setProductId(this.accountService.getAccountFromCache(fundAcc.getParentId()).getProductId());
            workflow = this.instrAccModel.getWorkflow(fundAcc.getParentId());
        }
        this.instrAccModel.getActiveAccMap("");
        if (workflow == null) {
            this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u6b64\u8d26\u53f7\u6ca1\u6709\u914d\u7f6e\u6307\u4ee4\u6d41\u6a21\u677f");
            return;
        }
        List stepList = workflow.getSteps();
        if (stepList != null && !stepList.isEmpty()) {
            for (AccntStepAttribute step : stepList) {
                if (1 != step.getStepId()) continue;
                if ("2".equals(step.getInstructType().getRaw())) {
                    oa.setInstructionPanelType("2");
                } else if ("1".equals(step.getInstructType().getRaw())) {
                    oa.setInstructionPanelType("1");
                }
                oa.setFlowAttriId(step.getFlowAttriId());
                oa.setStepAttrId(step.getStepAttriId());
                break;
            }
        }
        accntSec.setOrderQty((long)count);
        accntSec.setMarket(item.getMarket());
        accntSecList.add(accntSec);
        oa.setAccSecInfoList(accntSecList);
        oa.setOrderQty((long)count);
        if (item.getType().equals("REPO")) {
            oa.setAmount((double)(count * this.getParValue(item.getMarket())));
        } else {
            int convert = 1;
            if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getType())) {
                convert = 10;
            }
            oa.setAmount(price * (double)count * (double)convert);
        }
        logger.info("[" + uuid + "]" + "\u5f00\u59cb\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u4e0b\u5355\u7b14\u59d4\u6258: " + e.entrySet());
        long startTime = e.getLong("file.manipulate.record.start.time");
        logger.info("[" + uuid + "]" + "\u4ece\u5f00\u59cb\u5230\u4e0b\u5355\u8017\u65f6: " + (System.currentTimeMillis() - startTime));
        InstructionSubmitResult submit = null;
        String instructionId = "";
        try {
            submit = oa.submit();
            instructionId = submit.getInstructionId();
        }
        catch (MException me) {
            e.put((Object)"topic", (Object)"response_new_single_advice");
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)"\u4e0b\u8fbe\u5355\u7b14\u6307\u4ee4\u5931\u8d25");
            e.put((Object)"INSTRUCTION_ID", (Object)instructionId);
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"client_seq", (Object)oriClientSeq);
            throw me;
        }
        logger.info("\u6587\u4ef6\u5355\u6307\u4ee4\u4e0b\u8fbe\u5b8c\u6210\uff0cid\uff1a" + submit.getInstructionId());
        e.put((Object)"error_code", (Object)"1");
        e.put((Object)"erroe_msg", (Object)"\u4e0b\u8fbe\u5355\u7b14\u6307\u4ee4\u6210\u529f");
        e.put((Object)"INSTRUCTION_ID", (Object)instructionId);
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"client_seq", (Object)oriClientSeq);
        e.put((Object)"topic", (Object)"response_new_single_advice");
        e.setOK();
    }

    private void addSingleAdviceCheckErrMsg(MEvent e, String investorId, String client_seq, String errMsg) {
        e.put((Object)"error_code", (Object)"-1");
        e.put((Object)"erroe_msg", (Object)errMsg);
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"client_seq", (Object)client_seq);
        e.put((Object)"topic", (Object)"response_new_single_advice");
        this.sendErrMsgLog(-1, errMsg);
    }

    private void addBasketAdviceCheckErrMsg(MEvent e, String investorId, String clListId, String errMsg) {
        e.put((Object)"error_code", (Object)"-1");
        e.put((Object)"erroe_msg", (Object)errMsg);
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"cl_list_id", (Object)clListId);
        e.put((Object)"topic", (Object)"response_new_basket_advice");
        this.sendErrMsgLog(-1, errMsg);
    }

    private void buildPriceType(double price, String ordType, OrderAdvice oa) {
        switch (ordType) {
            case "01": 
            case "02": {
                oa.setOrdType(50);
                oa.setPriceLimit(Integer.valueOf("2").intValue());
                oa.setPrice(price);
                break;
            }
            case "0F": {
                oa.setOrdType(50);
                oa.setPriceLimit(Integer.valueOf("1").intValue());
                oa.setPrice(price);
                break;
            }
            case "0E": {
                oa.setOrdType(50);
                oa.setPriceLimit(Integer.valueOf("4").intValue());
                oa.setPrice(price);
                break;
            }
            case "0A": 
            case "0B": {
                oa.setOrdType(99);
                oa.setPriceLimit(Integer.valueOf("1").intValue());
                oa.setPrice(price);
                break;
            }
            case "0C": 
            case "0D": {
                oa.setOrdType(50);
                oa.setPriceLimit(Integer.valueOf("3").intValue());
                oa.setPrice(price);
                break;
            }
            case "0U": 
            case "0W": {
                oa.setOrdType(49);
                oa.setMarketPriceLimit("SH1");
                oa.setMaxLevels(5);
                oa.setTif(48);
                break;
            }
            case "0T": 
            case "0V": {
                oa.setOrdType(49);
                oa.setMarketPriceLimit("SH2");
                oa.setMaxLevels(5);
                oa.setTif(51);
                break;
            }
            case "0t": 
            case "0v": {
                oa.setOrdType(49);
                oa.setMarketPriceLimit("SH3");
                oa.setMaxLevels(1);
                oa.setTif(48);
                break;
            }
            case "0u": 
            case "0w": {
                oa.setOrdType(49);
                oa.setMarketPriceLimit("SH4");
                oa.setMaxLevels(0);
                oa.setTif(48);
                break;
            }
            case "0X": 
            case "0Z": {
                oa.setOrdType(49);
                oa.setMarketPriceLimit("SZ1");
                oa.setMaxLevels(1);
                oa.setTif(48);
                break;
            }
            case "0@": 
            case "0Y": {
                oa.setOrdType(49);
                oa.setMarketPriceLimit("SZ2");
                oa.setMaxLevels(0);
                oa.setTif(48);
                break;
            }
            case "0g": 
            case "0j": {
                oa.setOrdType(49);
                oa.setMarketPriceLimit("SZ4");
                oa.setMaxLevels(5);
                oa.setTif(51);
                break;
            }
            case "0h": 
            case "0k": {
                oa.setOrdType(49);
                oa.setMarketPriceLimit("SZ3");
                oa.setMaxLevels(0);
                oa.setTif(51);
                break;
            }
            case "0i": 
            case "0l": {
                oa.setOrdType(49);
                oa.setMarketPriceLimit("SZ5");
                oa.setMaxLevels(0);
                oa.setTif(52);
                break;
            }
        }
    }

    private boolean checkMarketType(String ordType) {
        return this.STAR_SPEC_MARKET_TYPE.contains(ordType);
    }

    public static void main(String[] args) {
        String ss = "\\347\\263\\273\\347\\273\\237\\346\\255\\243\\345\\234\\250\\346\\270\\205\\347\\256\\227!";
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(ss.getBytes());
        int read = -1;
        byte[] byte3 = new byte[3];
        while ((read = inputStream.read()) > -1) {
            if (read == 92) {
                try {
                    inputStream.read(byte3);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                outputStream.write(Integer.parseInt(new String(byte3), 8));
                continue;
            }
            outputStream.write(read);
        }
        String decodeMessage = null;
        try {
            decodeMessage = new String(outputStream.toByteArray(), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        System.out.println(decodeMessage);
    }

    /*
     * Unable to fully structure code
     */
    public void cancelOrderSingle(MEvent e) throws MException {
        investorId = e.getStr("fund_acct");
        orderId = e.getStr("entrust_no");
        client_seq = e.getStr("client_seq");
        builder = PMessage.OrderCancelRequest.newBuilder();
        builder.setOpUser(this.apiBase.getOpUser());
        builder.setOrderId(orderId);
        client_seq = "file|" + investorId + "|" + client_seq;
        builder.setOrigClOrdId(client_seq);
        builder.setClOrdId(client_seq);
        this.inst.setApplId("010");
        this.inst.setMarketGroup("CCS");
        market = ConvertUtils.getMarket(e.getStr("market_code"));
        this.inst.setMarket(StringUtils.isEmpty((String)market) != false ? "XSHG" : market);
        portfolioId = e.getStr("portfolio_id");
        if (StringUtils.isEmpty((String)portfolioId)) ** GOTO lbl84
        portfolio = this.portfolioAccountModel.getPortfolio(portfolioId, "CCS");
        if (portfolio == null) {
            event = new MEvent();
            event.setDesc("\u6295\u8d44\u7ec4\u5408:" + portfolioId + " \u672a\u83b7\u53d6\u5230");
            this.es.postEvent("message.log", event);
            e.setCode(-1);
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)("\u6295\u8d44\u7ec4\u5408:" + portfolio + " \u672a\u83b7\u53d6\u5230"));
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"order_id", (Object)orderId);
            e.put((Object)"topic", (Object)"response_entrust_cancel_confirm");
            return;
        }
        e.put((Object)"fundAccount", (Object)portfolio);
        this.es.sendEvent("save.order.fundid", e);
        subAccount = null;
        portfolioAccountMap = this.portfolioAccountModel.getMap(portfolio);
        if (portfolioAccountMap == null) {
            event = new MEvent();
            event.setDesc("\u6295\u8d44\u7ec4\u5408:" + portfolioId + " \u4e0b\u672a\u83b7\u53d6\u5230\u8d26\u53f7");
            this.es.postEvent("message.log", event);
            e.setCode(-1);
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)("\u6295\u8d44\u7ec4\u5408:" + portfolio + " \u4e0b\u672a\u83b7\u53d6\u5230\u8d26\u53f7"));
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"order_id", (Object)orderId);
            e.put((Object)"topic", (Object)"response_entrust_cancel_confirm");
            return;
        }
        for (CcsFundAccount ccsFundAccount : portfolioAccountMap.keySet()) {
            if (!investorId.equals(ccsFundAccount.getInvestId())) continue;
            subAccount = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
            break;
        }
        if (subAccount != null) {
            builder.setExtAccntId(subAccount.getExtAccntId());
        } else {
            event = new MEvent();
            event.setDesc("\u8d44\u91d1\u8d26\u53f7:" + investorId + " \u672a\u5173\u8054\u8be5\u6295\u7ec4");
            this.es.postEvent("message.log", event);
            e.setCode(-1);
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)("\u8d44\u91d1\u8d26\u53f7:" + investorId + " \u672a\u5173\u8054\u8be5\u6295\u7ec4"));
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"order_id", (Object)orderId);
            e.put((Object)"topic", (Object)"response_entrust_cancel_confirm");
            return;
lbl84:
            // 1 sources

            fundAcc = this.map.getFundAcc(investorId);
            if (fundAcc != null) {
                builder.setExtAccntId(fundAcc.getExtAccntId());
            } else {
                e.setCode(-1);
                e.put((Object)"error_code", (Object)"-1");
                e.put((Object)"erroe_msg", (Object)("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650"));
                e.put((Object)"invest_id", (Object)investorId);
                e.put((Object)"order_id", (Object)orderId);
                e.put((Object)"topic", (Object)"response_entrust_cancel_confirm");
                event = new MEvent();
                event.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650");
                this.es.postEvent("message.log", event);
                return;
            }
        }
        builder.setInstrument(this.inst);
        try {
            this.cancelApi.submit(builder.build());
        }
        catch (MException e2) {
            e.put((Object)"error_code", (Object)String.valueOf(e2.getCode()));
            e.put((Object)"erroe_msg", (Object)e2.getMessage());
            e.put((Object)"invest_id", (Object)investorId);
            e.put((Object)"order_id", (Object)orderId);
            e.put((Object)"topic", (Object)"response_entrust_cancel_confirm");
            return;
        }
        e.put((Object)"error_code", (Object)"1");
        e.put((Object)"erroe_msg", (Object)"\u8bf7\u6c42\u6210\u529f");
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"order_id", (Object)orderId);
        e.put((Object)"topic", (Object)"response_entrust_cancel_confirm");
    }

    public void batchEntrust(MEvent event) throws MException {
        List batchlist = event.children.stream().filter(val -> val.getFunctionCode() == 620002).collect(Collectors.toList());
        HashSet<String> clListIds = new HashSet<String>();
        HashSet<String> accounts = new HashSet<String>();
        HashSet<String> portfolioIds = new HashSet<String>();
        String clistId = "";
        String uuid = event.getStr("file.manipulate.record.uuid");
        logger.error("\u6279\u91cf\u4e0b\u5355\u5f00\u59cb,size:" + batchlist.size() + " uuid:" + uuid);
        ArrayList<BasketTradeItem> tradeItems = new ArrayList<BasketTradeItem>();
        for (MEvent mEvent : batchlist) {
            String securityId;
            mEvent.setCode(-1);
            String investorId = mEvent.getStr("fund_acct");
            String investorSecId = mEvent.getStr("holder_acc_no");
            String clOrderId = mEvent.getStr("cl_order_id");
            clistId = mEvent.getStr("cl_list_id");
            event.put((Object)"cl_list_id", (Object)new String(clistId));
            clistId = "file|" + investorId + "|" + clistId;
            clListIds.add(clistId);
            if (clListIds.size() > 1) {
                this.checkBatchEntrustError(event, investorId, "\u6279\u91cf\u59d4\u6258\u5931\u8d25  \u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u81ea\u5b9a\u4e49\u6279\u6b21\u53f7\u7684\u6279\u91cf\u5355");
                this.sendErrMsgLog(-1, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u81ea\u5b9a\u4e49\u6279\u6b21\u53f7\u7684\u6279\u91cf\u5355");
                return;
            }
            String market = ConvertUtils.getMarket(mEvent.getStr("market_code"));
            RefItem refItem = this.refMng.getItem(market, securityId = mEvent.getStr("sec_code"));
            if (refItem == null) {
                this.checkBatchEntrustError(event, investorId, "\u6279\u91cf\u59d4\u6258\u5931\u8d25:securityId:" + securityId + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                this.sendErrMsgLog(-1, "\u6279\u91cf\u59d4\u6258\u5931\u8d25:securityId:" + securityId + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                return;
            }
            String portfolio = mEvent.getStr("portfolio_id");
            portfolioIds.add(portfolio);
            if (portfolioIds.size() > 1) {
                this.checkBatchEntrustError(event, investorId, "\u6279\u91cf\u59d4\u6258\u5931\u8d25  \u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u6295\u7ec4\u7684\u6279\u91cf\u5355");
                this.sendErrMsgLog(-1, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u6295\u7ec4\u7684\u6279\u91cf\u5355");
                return;
            }
            BasketTradeItem item = new BasketTradeItem();
            BasketItem bi = new BasketItem();
            bi.setSecurityId(securityId);
            bi.setSecurityName(refItem.getName());
            bi.getMarket().setRaw(market);
            bi.setSecurityType(refItem.getType());
            bi.setRefItem(refItem);
            item.setItem(bi);
            clOrderId = "file|" + investorId + "|" + clOrderId;
            item.setClOrderId(clOrderId);
            if (mEvent.getStr("Bsflag", "").equals("01")) {
                item.getBsTrade().setRaw("49");
                item.setBuyPrice(mEvent.getDouble("price"));
                item.setBuyCount((long)mEvent.getInt("count"));
            } else if (mEvent.getStr("Bsflag", "").equals("02")) {
                item.getBsTrade().setRaw("50");
                item.setSellPrice(mEvent.getDouble("price"));
                item.setSellCount((long)mEvent.getInt("count"));
            }
            item.setTargetCount(mEvent.getLong("count"));
            if (!StringUtils.isEmpty((String)portfolio)) {
                List list;
                Portfolio p = this.portfolioAccountModel.getPortfolio(portfolio, "CCS");
                if (p == null) {
                    this.checkBatchEntrustError(event, "", "\u8be5\u6295\u7ec4:" + portfolio + " \u65e0\u6743\u9650");
                    this.sendErrMsgLog(-1, "\u8be5\u6295\u7ec4:" + portfolio + " \u65e0\u6743\u9650");
                    return;
                }
                event.put((Object)"fundAccount", (Object)p);
                this.es.sendEvent("save.order.fundid", event);
                CcsSubFundAccount subAccount = null;
                CcsSubSecAccount subSecAccount = null;
                Map portfolioAccountMap = this.portfolioAccountModel.getMap(portfolio);
                if (portfolioAccountMap == null) {
                    this.checkBatchEntrustError(event, "", "\u4f7f\u7528\u6295\u7ec4:" + portfolio + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u8d26\u53f7");
                    this.sendErrMsgLog(-1, "\u4f7f\u7528\u6295\u7ec4:" + portfolio + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u8d26\u53f7");
                    return;
                }
                for (CcsFundAccount ccsFundAccount : portfolioAccountMap.keySet()) {
                    if (!investorId.equals(ccsFundAccount.getInvestId())) continue;
                    subAccount = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
                    break;
                }
                if (subAccount != null && (list = (List)portfolioAccountMap.get(subAccount)) != null) {
                    for (SecAccount secAccount : list) {
                        if (!investorSecId.equals(secAccount.getInverstorSecId())) continue;
                        subSecAccount = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                        break;
                    }
                }
                if (subAccount == null || subSecAccount == null) {
                    this.checkBatchEntrustError(event, "", "\u4f7f\u7528\u6295\u7ec4:" + portfolio + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u4e8c\u7ea7\u8d26\u53f7");
                    this.sendErrMsgLog(-1, "\u4f7f\u7528\u6295\u7ec4:" + portfolio + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u4e8c\u7ea7\u8d26\u53f7");
                    return;
                }
                item.setAcc(subAccount);
                item.setSecAcc(subSecAccount);
            } else {
                CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
                SecAccount secAcc = this.map.getSecAcc(investorSecId, market);
                if (fundAcc == null) {
                    this.checkBatchEntrustError(event, investorId, "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
                    this.sendErrMsgLog(-1, "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
                    return;
                }
                item.setAcc(fundAcc);
                accounts.add(investorId);
                MEvent eventAcc = new MEvent();
                eventAcc.put((Object)"fundAccount", (Object)fundAcc);
                this.es.sendEvent("save.order.fundid", eventAcc);
                if (accounts.size() > 1) {
                    this.checkBatchEntrustError(event, investorId, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\u7684\u6279\u91cf\u5355");
                    this.sendErrMsgLog(-1, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\u7684\u6279\u91cf\u5355");
                    return;
                }
                if (secAcc != null) {
                    item.setSecAcc(secAcc);
                } else {
                    this.checkBatchEntrustError(event, investorId, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650");
                    this.sendErrMsgLog(-1, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650");
                    return;
                }
            }
            tradeItems.add(item);
        }
        if (tradeItems.size() == 0) {
            this.checkBatchEntrustError(event, "", "\u65e0\u6821\u9a8c\u901a\u8fc7\u7684\u6279\u91cf\u5355");
            this.sendErrMsgLog(-1, "\u65e0\u6821\u9a8c\u901a\u8fc7\u7684\u6279\u91cf\u5355");
            return;
        }
        Basket basket = new Basket();
        basket.setName("\u6587\u4ef6\u6279\u91cf\u5355");
        BasketSubmitResult submit = this.batchEn.submit(null, tradeItems, basket, clistId);
        logger.info("\u6279\u91cf\u4e0b\u5355\u5b8c\u6210,\u7b14\u6570\uff1a" + tradeItems.size());
        event.setOK();
        List successedIds = submit.getSuccessedIds();
        if (successedIds.isEmpty()) {
            event.put((Object)"list_id", (Object)"");
            event.put((Object)"list_leg_id", (Object)"");
            event.put((Object)"invest_id", (Object)"");
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"cl_list_id", (Object)"");
            event.put((Object)"error_code", (Object)"-1");
            event.put((Object)"erroe_msg", (Object)"\u6279\u91cf\u59d4\u6258\u5931\u8d25");
            event.put((Object)"cl_order_id", (Object)"");
            event.put((Object)"topic", (Object)"response_batch_entrust_confirm");
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            event.put((Object)"basket_orders", concurrentHashMap);
        } else {
            Map map = this.bsktOrderModel.synQueryByListIds(successedIds);
            event.put((Object)"basket_orders", (Object)map);
            if (!portfolioIds.isEmpty()) {
                for (String pId : portfolioIds) {
                    event.put((Object)"portfolio_id", (Object)pId);
                }
            }
        }
    }

    public void batchOrder(MEvent event) throws MException {
        ConcurrentHashMap concurrentHashMap;
        List batchlist = event.children.stream().filter(val -> val.getFunctionCode() == 620003).collect(Collectors.toList());
        HashSet<String> clListIds = new HashSet<String>();
        HashSet<String> accounts = new HashSet<String>();
        HashSet<String> portfolioIds = new HashSet<String>();
        String clistId = "";
        String uuid = event.getStr("file.manipulate.record.uuid");
        String investId = "";
        for (MEvent mEvent : batchlist) {
            String investorId;
            mEvent.setCode(-1);
            investId = investorId = mEvent.getStr("fund_acct");
            clistId = mEvent.getStr("cl_list_id");
            event.put((Object)"cl_list_id", (Object)new String(clistId));
            clistId = "file|" + investorId + "|" + clistId;
            clListIds.add(clistId);
            String portfolio = mEvent.getStr("portfolio_id");
            if (!StringUtils.isEmpty((String)portfolio)) {
                portfolioIds.add(portfolio);
            } else {
                accounts.add(investorId);
            }
            if (clListIds.size() > 1) {
                this.checkBatchOrderError(event, investorId, "\u6279\u91cf\u59d4\u6258\u5931\u8d25  \u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u81ea\u5b9a\u4e49\u6279\u6b21\u53f7\u7684\u6279\u91cf\u5355");
                this.sendErrMsgLog(-1, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u81ea\u5b9a\u4e49\u6279\u6b21\u53f7\u7684\u6279\u91cf\u5355");
                return;
            }
            if (portfolioIds.size() > 1) {
                this.checkBatchOrderError(event, investorId, "\u6279\u91cf\u59d4\u6258\u5931\u8d25  \u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u6295\u7ec4\u7684\u6279\u91cf\u5355");
                this.sendErrMsgLog(-1, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u6295\u7ec4\u7684\u6279\u91cf\u5355");
                return;
            }
            if (accounts.size() <= 1) continue;
            this.checkBatchOrderError(event, investorId, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\u7684\u6279\u91cf\u5355");
            this.sendErrMsgLog(-1, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\u7684\u6279\u91cf\u5355");
            return;
        }
        if (batchlist.size() == 0) {
            this.checkBatchOrderError(event, "", "\u65e0\u6821\u9a8c\u901a\u8fc7\u7684\u6279\u91cf\u5355");
            this.sendErrMsgLog(-1, "\u65e0\u6821\u9a8c\u901a\u8fc7\u7684\u6279\u91cf\u5355");
            return;
        }
        logger.error("\u6279\u91cf\u59d4\u6258\u4e0b\u5355\u5f00\u59cb,size:" + batchlist.size() + " uuid:" + uuid);
        List pageList = ListUtils.split(batchlist, (int)30);
        CountDownLatch cdl = new CountDownLatch(pageList.size());
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger failedCount = new AtomicInteger(0);
        for (List inse : pageList) {
            this.fixedPool.execute(() -> {
                try {
                    try {
                        this.batchOrderByPage(event, inse);
                        successCount.getAndAdd(inse.size());
                    }
                    catch (MException | Exception ee) {
                        failedCount.getAndAdd(inse.size());
                        logger.error("\u65b0\u6279\u91cf\u59d4\u6258\u51fa\u9519", ee);
                        cdl.countDown();
                    }
                }
                finally {
                    cdl.countDown();
                }
            });
        }
        logger.info("\u65b0\u6279\u91cf\u59d4\u6258\u4e0b\u5355\u5b8c\u6210~~~~~~~~~~~~~");
        event.setOK();
        event.put((Object)"topic", (Object)"response_batch_order_confirm");
        if (failedCount.get() > 0) {
            event.put((Object)"list_id", (Object)"");
            event.put((Object)"list_leg_id", (Object)"");
            event.put((Object)"invest_id", (Object)investId);
            event.put((Object)"sec_code", (Object)"");
            event.put((Object)"cl_list_id", (Object)"");
            event.put((Object)"error_code", (Object)"-1");
            event.put((Object)"erroe_msg", (Object)("\u6279\u91cf\u59d4\u6258\u5931\u8d25" + failedCount.get() + "\u7b14"));
            event.put((Object)"cl_order_id", (Object)"");
            event.put((Object)"topic", (Object)"response_batch_order_confirm");
            concurrentHashMap = new ConcurrentHashMap();
            event.put((Object)"basket_orders", concurrentHashMap);
        } else {
            concurrentHashMap = new ConcurrentHashMap();
            event.put((Object)"basket_orders", concurrentHashMap);
            event.put((Object)"error_code", (Object)"1");
            event.put((Object)"invest_id", (Object)investId);
            event.put((Object)"erroe_msg", (Object)"\u6279\u91cf\u59d4\u6258\u63d0\u4ea4\u6210\u529f");
        }
    }

    void batchOrderByPage(MEvent event, List<MEvent> orders) throws MException {
        PMessage.NewOrderBatchRequest.Builder nob = PMessage.NewOrderBatchRequest.newBuilder();
        PComponent.Instrument.Builder pi = PComponent.Instrument.newBuilder();
        String reqUuid = UUID.randomUUID().toString();
        pi.setMarketGroup("CCS");
        nob.setInstrument(pi.build());
        nob.setExtAccntId(String.valueOf(this.count.incrementAndGet()));
        nob.setOpUser(this.apiBase.getOpUser());
        for (MEvent mEvent : orders) {
            mEvent.setCode(-1);
            String investorId = mEvent.getStr("fund_acct");
            String investorSecId = mEvent.getStr("holder_acc_no");
            String clOrderId = mEvent.getStr("cl_order_id");
            String market = ConvertUtils.getMarket(mEvent.getStr("market_code"));
            double price = mEvent.getDouble("price");
            int count = mEvent.getInt("count");
            int bstype = ConvertUtils.getBsFlag(mEvent.getStr("Bsflag"));
            String secCode = mEvent.getStr("sec_code");
            RefItem refItem = this.refMng.getItem(market, secCode);
            if (refItem == null) {
                this.sendErrMsgLog(-1, "\u6279\u91cf\u59d4\u6258\u5931\u8d25:securityId:" + secCode + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                continue;
            }
            String portfolio = mEvent.getStr("portfolio_id");
            clOrderId = "file|" + investorId + "|" + clOrderId;
            CcsFundAccount fundAcc = null;
            SecAccount secAcc = null;
            CcsSubFundAccount subAccount = null;
            CcsSubSecAccount subSecAccount = null;
            if (!StringUtils.isEmpty((String)portfolio)) {
                List list;
                Portfolio p = this.portfolioAccountModel.getPortfolio(portfolio, "CCS");
                if (p == null) {
                    this.checkBatchOrderError(event, "", "\u8be5\u6295\u7ec4:" + portfolio + " \u65e0\u6743\u9650");
                    this.sendErrMsgLog(-1, "\u8be5\u6295\u7ec4:" + portfolio + " \u65e0\u6743\u9650");
                    return;
                }
                event.put((Object)"fundAccount", (Object)p);
                this.es.sendEvent("save.order.fundid", event);
                Map portfolioAccountMap = this.portfolioAccountModel.getMap(portfolio);
                if (portfolioAccountMap == null) {
                    this.checkBatchOrderError(event, "", "\u4f7f\u7528\u6295\u7ec4:" + portfolio + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u8d26\u53f7");
                    this.sendErrMsgLog(-1, "\u4f7f\u7528\u6295\u7ec4:" + portfolio + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u8d26\u53f7");
                    return;
                }
                for (CcsFundAccount ccsFundAccount : portfolioAccountMap.keySet()) {
                    if (!investorId.equals(ccsFundAccount.getInvestId())) continue;
                    subAccount = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
                    break;
                }
                if (subAccount != null && (list = (List)portfolioAccountMap.get(subAccount)) != null) {
                    for (SecAccount secAccount : list) {
                        if (!investorSecId.equals(secAccount.getInverstorSecId())) continue;
                        subSecAccount = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                        break;
                    }
                }
                if (subAccount == null || subSecAccount == null) {
                    this.checkBatchOrderError(event, "", "\u4f7f\u7528\u6295\u7ec4:" + portfolio + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u4e8c\u7ea7\u8d26\u53f7");
                    this.sendErrMsgLog(-1, "\u4f7f\u7528\u6295\u7ec4:" + portfolio + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u4e8c\u7ea7\u8d26\u53f7");
                    return;
                }
            } else {
                fundAcc = this.map.getFundAcc(investorId);
                secAcc = this.map.getSecAcc(investorSecId, market);
                if (fundAcc == null) {
                    this.checkBatchOrderError(event, investorId, "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
                    this.sendErrMsgLog(-1, "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
                    return;
                }
                MEvent eventAcc = new MEvent();
                eventAcc.put((Object)"fundAccount", (Object)fundAcc);
                this.es.sendEvent("save.order.fundid", eventAcc);
                if (secAcc == null) {
                    this.checkBatchOrderError(event, investorId, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650");
                    this.sendErrMsgLog(-1, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650");
                    return;
                }
            }
            PComponent.Instrument.Builder builderI = PComponent.Instrument.newBuilder();
            builderI.setSecurityId(secCode);
            builderI.setMarket(market);
            if (refItem != null) {
                builderI.setSecurityType(refItem.getType());
            }
            if ("XSHG".equals(market) && secCode.startsWith("688")) {
                builderI.setApplId("700");
            } else if (refItem != null && refItem.isGem()) {
                builderI.setApplId("GEM");
            } else {
                builderI.setApplId("010");
            }
            builderI.setMarketGroup("CCS");
            PComponent.Instrument instrument = builderI.build();
            PMessage.NewOrderSingle.Builder builderO = PMessage.NewOrderSingle.newBuilder();
            builderO.setInstrument(instrument);
            builderO.setOrdTypeValue(50);
            builderO.setSideValue(bstype);
            builderO.setOpUser(this.apiBase.getOpUser());
            builderO.setOrderQty((double)count);
            builderO.setPrice(price);
            PComponent.ExecMode.Builder eb = PComponent.ExecMode.newBuilder();
            eb.setEmId(999);
            builderO.setExecMode(eb.build());
            builderO.setClOrdId(clOrderId);
            if (!StringUtils.isEmpty((String)portfolio)) {
                builderO.setSubAccntId(subAccount.getSubAccntId());
                builderO.setSubSecAccntId(subSecAccount.getSubSecAccntId());
                builderO.setPortfolioId(portfolio);
            } else {
                builderO.setExtAccntId(fundAcc.getExtAccntId());
                builderO.setExtSecAccntId(secAcc.getExtSecAccntId());
            }
            if (secAcc == null) {
                this.sendErrMsgLog(-1, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650");
                continue;
            }
            if (!secAcc.getExtAccntId().equals(fundAcc.getExtAccntId())) {
                this.sendErrMsgLog(-1, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + "\u4e0e\u8d44\u91d1\u8d26\u53f7:" + investorId + "\u4e0d\u5339\u914d");
                continue;
            }
            builderO.setBatchId(reqUuid);
            PMessage.NewOrderSingle newOrd = builderO.build();
            nob.addOrders(newOrd);
        }
        if (!nob.getOrdersList().isEmpty()) {
            this.apiOrder.batchSubmit(nob.build());
        } else {
            this.sendErrMsgLog(-1, "\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8ba2\u5355\u59d4\u6258");
        }
    }

    private void checkBatchEntrustError(MEvent event, String investorId, String errorMsg) {
        event.put((Object)"list_id", (Object)"");
        event.put((Object)"list_leg_id", (Object)"");
        event.put((Object)"invest_id", (Object)investorId);
        event.put((Object)"sec_code", (Object)"");
        event.put((Object)"cl_list_id", (Object)"");
        event.put((Object)"error_code", (Object)"-1");
        event.put((Object)"erroe_msg", (Object)errorMsg);
        event.put((Object)"cl_order_id", (Object)"");
        event.put((Object)"topic", (Object)"response_batch_entrust_confirm");
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        event.put((Object)"basket_orders", concurrentHashMap);
        event.setCode(999981);
        event.setDesc(errorMsg);
    }

    private void checkBatchOrderError(MEvent event, String investorId, String errorMsg) {
        event.put((Object)"invest_id", (Object)investorId);
        event.put((Object)"error_code", (Object)"-1");
        event.put((Object)"erroe_msg", (Object)errorMsg);
        event.put((Object)"topic", (Object)"response_batch_order_confirm");
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        event.put((Object)"basket_orders", concurrentHashMap);
        event.setCode(999981);
        event.setDesc(errorMsg);
    }

    public void batchCancelByBatchNo(MEvent e) {
        CcsFundAccount fundAcc;
        String investorId = e.getStr("fund_acct");
        String uuid = e.getStr("file.manipulate.record.uuid");
        String listId = e.getStr("batch_sno");
        String legId = e.getStr("batch_leg_sno");
        logger.info("[" + uuid + "]" + "\u5f00\u59cb\u6279\u6b21\u53f7\u6279\u91cf\u64a4\u5355\uff0clistId: " + listId + ", legId:" + legId);
        String clOrderId = e.getStr("cl_order_id");
        String clListId = e.getStr("cl_list_id");
        if (!clOrderId.isEmpty()) {
            clOrderId = "file|" + investorId + "|" + clOrderId;
        }
        if (!clListId.isEmpty()) {
            clListId = "file|" + investorId + "|" + clListId;
        }
        if ((fundAcc = this.map.getFundAcc(investorId)) == null) {
            e.put((Object)"error_code", (Object)"-1");
            e.put((Object)"erroe_msg", (Object)("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25"));
            e.put((Object)"batch_leg_sno", (Object)"");
            e.put((Object)"batch_sno", (Object)listId);
            e.put((Object)"cl_order_id", (Object)"");
            e.put((Object)"topic", (Object)"response_batch_entrust__cancel_confirm");
            MEvent me = new MEvent();
            me.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", me);
            return;
        }
        MEvent eventAcc = new MEvent();
        eventAcc.put((Object)"fundAccount", (Object)fundAcc);
        this.es.sendEvent("save.order.fundid", eventAcc);
        if (StringUtils.isEmpty((String)legId) && StringUtils.isEmpty((String)clOrderId)) {
            try {
                this.bsktCancelApi.cancelSingleOrder(listId, "CCS", clListId);
            }
            catch (MException e1) {
                logger.error("\u6279\u91cf\u5355\u64a4\u5355\u5931\u8d25\uff0cbatchId:" + listId, (Throwable)e1);
                e.put((Object)"error_code", (Object)String.valueOf(e1.getCode()));
                e.put((Object)"erroe_msg", (Object)e1.getMessage());
                e.put((Object)"batch_leg_sno", (Object)legId);
                e.put((Object)"batch_sno", (Object)listId);
                e.put((Object)"topic", (Object)"response_batch_entrust__cancel_confirm");
                return;
            }
            e.put((Object)"error_code", (Object)"1");
            e.put((Object)"erroe_msg", (Object)"\u6279\u91cf\u64a4\u5355\u8bf7\u6c42\u6210\u529f");
            e.put((Object)"batch_leg_sno", (Object)legId);
            e.put((Object)"batch_sno", (Object)listId);
            e.put((Object)"topic", (Object)"response_batch_entrust__cancel_confirm");
            e.setOK();
            return;
        }
        if (StringUtils.isEmpty((String)listId) && legId.length() > 12) {
            listId = legId.substring(0, 12);
        }
        MEvent ev = new MEvent();
        BasketCcsOrder basketCcsOrder = new BasketCcsOrder();
        basketCcsOrder.setListId(listId);
        basketCcsOrder.setLegId(legId);
        basketCcsOrder.setClOrderId(clOrderId);
        basketCcsOrder.setClListId(clListId);
        ArrayList<BasketCcsOrder> legOrders = new ArrayList<BasketCcsOrder>();
        legOrders.add(basketCcsOrder);
        ev.setObj(legOrders);
        this.es.sendEvent("basket.cancel.order", ev);
        if (ev.get((Object)"data") == null) {
            e.put((Object)"error_code", (Object)"1");
            e.put((Object)"erroe_msg", (Object)"\u6279\u91cf\u64a4\u5355\u64a4\u817f\u5355\u8bf7\u6c42\u6210\u529f");
            e.put((Object)"batch_leg_sno", (Object)legId);
            e.put((Object)"batch_sno", (Object)listId);
            e.put((Object)"topic", (Object)"response_batch_entrust__cancel_confirm");
        } else {
            MException cast = (MException)((Object)MException.class.cast(ev.get((Object)"data")));
            e.put((Object)"error_code", (Object)String.valueOf(cast.getCode()));
            e.put((Object)"erroe_msg", (Object)cast.getMessage());
            e.put((Object)"batch_leg_sno", (Object)legId);
            e.put((Object)"batch_sno", (Object)listId);
            e.put((Object)"topic", (Object)"response_batch_entrust__cancel_confirm");
        }
        e.setOK();
        logger.info("[" + uuid + "]" + "\u6279\u6b21\u53f7\u6279\u91cf\u64a4\u5355\u8bf7\u6c42\u5df2\u53d1\u9001 ");
    }

    public void instructionCancel(MEvent e) {
        String uuid = e.getStr("file.manipulate.record.uuid");
        String investorId = e.getStr("invest_id");
        String instructionId = e.getStr("INSTRUCTION_ID");
        String clInstructionId = e.getStr("cl_instruction_id");
        logger.info("[" + uuid + "]" + "\u5f00\u59cb\u6307\u4ee4\u64a4\u9500\uff0cinstructionId: " + instructionId + ", investorId:" + investorId);
        CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
        if (fundAcc == null) {
            this.addSingleAdviceCheckErrMsg(e, investorId, "", "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            e.setCode(-1);
            MEvent me = new MEvent();
            me.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", me);
            return;
        }
        MEvent eventAcc = new MEvent();
        eventAcc.put((Object)"fundAccount", (Object)fundAcc);
        this.es.sendEvent("save.order.fundid", eventAcc);
        if (!StringUtils.isEmpty((String)instructionId)) {
            Instruction instruction = null;
            try {
                String[] split;
                instruction = this.insModel.instructionCancelById(instructionId);
                if (!StringUtils.isEmpty((String)instruction.getClInstructionId()) && instruction.getClInstructionId().contains("|") && (split = instruction.getClInstructionId().split("\\|")).length == 3) {
                    clInstructionId = split[2];
                }
            }
            catch (MException e1) {
                MEvent me = new MEvent();
                me.setDesc("\u6587\u4ef6\u5355\u64a4\u9500\u6307\u4ee4\u5931\u8d25\uff0c\u6307\u4ee4id\uff1a" + instructionId);
                this.es.postEvent("message.log", me);
                logger.error("\u6587\u4ef6\u5355\u64a4\u9500\u6307\u4ee4\u5931\u8d25\uff0c\u6307\u4ee4id\uff1a" + instructionId, (Throwable)e1);
                this.addInstructionCancelErrMsg(e, String.valueOf(e1.getCode()), "\u64a4\u9500\u6307\u4ee4\u5931\u8d25\uff0c" + e1.getMessage(), investorId, instructionId, clInstructionId);
                return;
            }
            this.addInstructionCancelErrMsg(e, "1", "\u64a4\u9500\u6307\u4ee4\u6210\u529f", investorId, instructionId, clInstructionId);
            e.setOK();
        } else {
            InstructionCancelResult insRes = new InstructionCancelResult();
            if (StringUtils.isEmpty((String)clInstructionId)) {
                this.addInstructionCancelErrMsg(e, String.valueOf("-1"), "\u6307\u4ee4id\u53ca\u524d\u7aef\u6d41\u6c34\u53f7\u5747\u4e3a\u7a7a\uff0c\u64a4\u9500\u5931\u8d25", investorId, instructionId, clInstructionId);
                return;
            }
            try {
                insRes = this.insModel.instructionCancelByClId("file|" + investorId + "|" + clInstructionId);
            }
            catch (MException e1) {
                this.sendErrMsgLog(999981, "\u6587\u4ef6\u5355\u64a4\u9500\u6307\u4ee4\u5f02\u5e38\uff0c\u6307\u4ee4\u524d\u7aef\u6d41\u6c34\u53f7\uff1a" + clInstructionId);
                logger.error("\u6587\u4ef6\u5355\u64a4\u9500\u6307\u4ee4\u5f02\u5e38\uff0c\u6307\u4ee4\u524d\u7aef\u6d41\u6c34\u53f7\uff1a" + clInstructionId, (Throwable)e1);
                this.addInstructionCancelErrMsg(e, String.valueOf(e1.getCode()), e1.getMessage(), investorId, instructionId, clInstructionId);
                return;
            }
            this.addInstructionCancelErrMsg(e, insRes.getCode(), insRes.getErrMsg(), investorId, insRes.getLastOne() == null ? "" : insRes.getLastOne().getId(), insRes.getLastOne() == null ? "" : insRes.getLastOne().getClInstructionId());
            e.setOK();
        }
        logger.info("[" + uuid + "]" + "\u6279\u6b21\u53f7\u6279\u91cf\u64a4\u5355\u8bf7\u6c42\u5df2\u53d1\u9001 ");
    }

    private void sendErrMsgLog(int code, String message) {
        MEvent me = new MEvent();
        me.setCode(code);
        me.setDesc(message);
        this.es.postEvent("message.log", me);
    }

    private void addInstructionCancelErrMsg(MEvent e, String errCode, String errMsg, String investorId, String instructionId, String clInstructionId) {
        e.put((Object)"topic", (Object)"response_instruction_revoke");
        e.put((Object)"error_code", (Object)errCode);
        e.put((Object)"erroe_msg", (Object)errMsg);
        e.put((Object)"INSTRUCTION_ID", (Object)instructionId);
        e.put((Object)"invest_id", (Object)investorId);
        e.put((Object)"client_seq", (Object)clInstructionId);
    }

    public void basketAdvice(MEvent event) throws MException {
        List batchlist = event.children.stream().filter(val -> val.getFunctionCode() == 620005).collect(Collectors.toList());
        if (batchlist.size() == 0) {
            this.addBasketAdviceCheckErrMsg(event, "", "", "\u65e0\u6709\u6548\u7684\u6279\u91cf\u6307\u4ee4\u5355");
            return;
        }
        HashSet<String> clListIds = new HashSet<String>();
        HashSet<String> accounts = new HashSet<String>();
        HashSet<String> portfolioIds = new HashSet<String>();
        HashSet<String> sides = new HashSet<String>();
        HashSet<String> secs = new HashSet<String>();
        String clListId = "";
        String uuid = event.getStr("file.manipulate.record.uuid");
        logger.error("\u6279\u91cf\u4e0b\u5355\u5f00\u59cb,size:" + batchlist.size() + " uuid:" + uuid);
        String investorId = "";
        for (MEvent mEvent : batchlist) {
            investorId = mEvent.getStr("fund_acct");
            clListId = mEvent.getStr("cl_list_id");
            accounts.add(investorId);
            secs.add(mEvent.getStr("sec_code"));
            sides.add(mEvent.getStr("Bsflag", ""));
            if (mEvent.getStr("portfolio_id").isEmpty()) continue;
            portfolioIds.add(mEvent.getStr("portfolio_id"));
        }
        if (accounts.size() > 1) {
            this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u8d44\u91d1\u8d26\u53f7\u7684\u6279\u91cf\u5355");
            return;
        }
        if (portfolioIds.size() > 1) {
            this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u6295\u7ec4\u7684\u6279\u91cf\u5355");
            return;
        }
        if (secs.size() < batchlist.size()) {
            this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u4e0d\u5141\u8bb8\u5305\u542b\u76f8\u540c\u7684\u6210\u5206\u80a1");
            return;
        }
        int side = 0;
        if (sides.size() > 1) {
            side = 3;
        } else if (sides.size() == 1) {
            String s = (String)sides.iterator().next();
            if ("01".equals(s)) {
                side = 1;
            } else if ("02".equals(s)) {
                side = 2;
            }
        }
        if (side == 0) {
            this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u65e0\u6548\u7684\u4e70\u5356\u65b9\u5411");
            return;
        }
        BasketOrderAdvice boa = (BasketOrderAdvice)this.of.create(BasketOrderAdvice.class);
        CcsFundAccount fundAcc = null;
        CcsSubFundAccount subAccount = null;
        Map portfolioAccountMap = null;
        String portfolioId = "";
        fundAcc = this.map.getFundAcc(investorId);
        if (fundAcc == null) {
            this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            return;
        }
        if (portfolioIds.isEmpty()) {
            MEvent eventAcc = new MEvent();
            eventAcc.put((Object)"fundAccount", (Object)fundAcc);
            this.es.sendEvent("save.order.fundid", eventAcc);
            String productId = "";
            if (StringUtils.isEmpty((String)this.extAccProductMap.get(fundAcc.getExtAccntId()))) {
                this.extAccProductMap.put(fundAcc.getExtAccntId(), this.accountService.getAccountFromCache(fundAcc.getParentId()).getProductId());
            }
            productId = this.extAccProductMap.get(fundAcc.getExtAccntId());
            this.buildBasketOrderAdvice(productId, fundAcc, boa, "");
        } else {
            portfolioId = (String)portfolioIds.iterator().next();
            Portfolio portfolio = this.portfolioAccountModel.getPortfolio(portfolioId, "CCS");
            if (portfolio == null) {
                this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u8be5\u6295\u7ec4:" + portfolioId + " \u65e0\u6743\u9650");
                return;
            }
            MEvent eventPor = new MEvent();
            eventPor.put((Object)"fundAccount", (Object)portfolio);
            this.es.sendEvent("save.order.fundid", eventPor);
            this.buildBasketOrderAdvice("", fundAcc, boa, portfolioId);
            portfolioAccountMap = this.portfolioAccountModel.getMap(portfolio);
            if (portfolioAccountMap == null) {
                this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u4f7f\u7528\u6295\u7ec4:" + portfolioId + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u8d26\u53f7");
                return;
            }
            for (CcsFundAccount ccsFundAccount : portfolioAccountMap.keySet()) {
                if (!investorId.equals(ccsFundAccount.getInvestId())) continue;
                subAccount = (CcsSubFundAccount)CcsSubFundAccount.class.cast(ccsFundAccount);
                break;
            }
            if (subAccount == null) {
                this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u4f7f\u7528\u6295\u7ec4:" + portfolioId + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u4e8c\u7ea7\u8d26\u53f7");
                return;
            }
        }
        long orderQty = 0L;
        double totalAmount = 0.0;
        for (MEvent mEvent : batchlist) {
            String securityId;
            mEvent.setCode(-1);
            BasketSecurityInst bs = new BasketSecurityInst();
            String investorSecId = mEvent.getStr("holder_acc_no");
            clListId = mEvent.getStr("cl_list_id");
            int count = mEvent.getInt("count");
            event.put((Object)"cl_list_id", (Object)new String(clListId));
            double price = mEvent.getDouble("price");
            String client_seq = mEvent.getStr("client_seq");
            clListId = "file|" + investorId + "|" + clListId;
            clListIds.add(clListId);
            if (clListIds.size() > 1) {
                this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u4e00\u4e2a\u6279\u91cf\u5355\u6587\u4ef6\u53ea\u5141\u8bb8\u4e0b\u4e00\u4e2a\u81ea\u5b9a\u4e49\u6279\u6b21\u53f7\u7684\u6279\u91cf\u5355");
                return;
            }
            String market = ConvertUtils.getMarket(mEvent.getStr("market_code"));
            RefItem refItem = this.refMng.getItem(market, securityId = mEvent.getStr("sec_code"));
            if (refItem == null) {
                this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "securityId:" + securityId + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                return;
            }
            if (!refItem.getMarket().equals(market)) {
                this.addSingleAdviceCheckErrMsg(event, investorId, client_seq, "securityId:" + securityId + ",market:" + market + ",\u5408\u7ea6\u4ee3\u7801\u672a\u5728\u5bf9\u5e94\u5e02\u573a\u627e\u5230");
                return;
            }
            bs.setSecurityId(securityId);
            bs.setSymbol(refItem.getName());
            bs.setMarket(market);
            bs.setSecurityType(refItem.getType());
            if (mEvent.getStr("Bsflag", "").equals("01")) {
                bs.setSide(Integer.valueOf("49").intValue());
            } else if (mEvent.getStr("Bsflag", "").equals("02")) {
                bs.setSide(Integer.valueOf("50").intValue());
            }
            bs.setOrderPrice(price);
            bs.setOrderQty((double)count);
            if (refItem.getType().equals("REPO")) {
                bs.setOrderAmount((double)(count * this.getParValue(refItem.getMarket())));
            } else {
                int convert = 1;
                if ("XSHG".equals(refItem.getMarket()) && "BOND".equals(refItem.getType())) {
                    convert = 10;
                }
                bs.setOrderAmount(price * (double)count * (double)convert);
            }
            totalAmount += bs.getOrderAmount();
            bs.setClOrderId("file|" + fundAcc.getInvestId() + "|" + client_seq);
            boa.setClListId(clListId);
            if (portfolioId.isEmpty()) {
                SecAccount secAcc = this.map.getSecAcc(investorSecId, market);
                if (secAcc == null) {
                    this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650");
                    return;
                }
                bs.setParentId(fundAcc.getParentId());
                bs.setExtAccntId(fundAcc.getExtAccntId());
                bs.setExtSecAccntId(secAcc.getExtSecAccntId());
                bs.setInvestorId(fundAcc.getInvestId());
                if (StringUtils.isEmpty((String)boa.getInvestorId())) {
                    boa.setInvestorId(fundAcc.getInvestId());
                }
            } else {
                List list;
                CcsSubSecAccount subSecAccount = null;
                if (subAccount != null && (list = (List)portfolioAccountMap.get(subAccount)) != null) {
                    for (SecAccount secAccount : list) {
                        if (!investorSecId.equals(secAccount.getInverstorSecId())) continue;
                        subSecAccount = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                        break;
                    }
                }
                if (subAccount == null || subSecAccount == null) {
                    this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u4f7f\u7528\u6295\u7ec4:" + portfolioId + " \u4e0b\u5355,\u672a\u627e\u5230\u6295\u7ec4\u4e0b\u4e8c\u7ea7\u8d26\u53f7");
                    return;
                }
                bs.setParentId(subAccount.getParentId());
                bs.setSubParentId(subAccount.getParentSubAccntId());
                bs.setExtAccntId(subAccount.getExtAccntId());
                bs.setExtSecAccntId(subSecAccount.getExtSecAccntId());
                bs.setInvestorId(subAccount.getInvestId());
                bs.setSubAccntId(subAccount.getSubAccntId());
                bs.setSubSecAccntId(subSecAccount.getSubSecAccntId());
            }
            bs.setSelected(true);
            bs.setSampleQty((double)count);
            bs.setFixedPrice(price);
            orderQty = (long)((double)orderQty + bs.getOrderQty());
            boa.getItemList().add(bs);
        }
        if (boa.getItemList().size() == 0) {
            this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u65e0\u6821\u9a8c\u901a\u8fc7\u7684\u6279\u91cf\u5355");
            event.setCode(999981);
            event.setDesc("\u65e0\u6821\u9a8c\u901a\u8fc7\u7684\u6279\u91cf\u5355");
            return;
        }
        if (orderQty <= 0L) {
            this.addBasketAdviceCheckErrMsg(event, investorId, clListId, "\u975e\u6cd5\u6570\u91cf");
            event.setCode(999981);
            event.setDesc("\u975e\u6cd5\u6570\u91cf");
            return;
        }
        boa.setOrderQty(orderQty);
        boa.setAmount(totalAmount);
        boa.setFixedPriceLimit("2");
        boa.setSide(side);
        boa.setStrategyValue(1.0);
        String instructionId = "";
        try {
            InstructionSubmitResult submitResult = boa.submit();
            instructionId = submitResult.getInstructionId();
            if (!StringUtils.isEmpty((String)submitResult.getReason())) {
                MEvent e = new MEvent();
                e.setDesc("\u6307\u4ee4" + instructionId + "," + submitResult.getReason());
                this.es.postEvent("message.log", e);
            }
            event.setOK();
        }
        catch (MException e) {
            logger.error("\u6587\u4ef6\u5355\u6279\u91cf\u6307\u4ee4\u4e0b\u8fbe\u5efa\u8bae\u5931\u8d25", (Throwable)e);
            this.es.postEvent("message.log", e.event);
            event.put((Object)"error_code", (Object)"1");
            event.put((Object)"erroe_msg", (Object)"\u4e0b\u8fbe\u6307\u4ee4\u5931\u8d25");
            event.put((Object)"INSTRUCTION_ID", (Object)instructionId);
            event.put((Object)"invest_id", (Object)fundAcc.getInvestId());
            event.put((Object)"cl_list_id", (Object)clListId);
            event.put((Object)"portfolio_id", (Object)portfolioId);
            event.put((Object)"topic", (Object)"response_new_basket_advice");
            return;
        }
        event.put((Object)"error_code", (Object)"1");
        event.put((Object)"erroe_msg", (Object)"\u4e0b\u8fbe\u6307\u4ee4\u6210\u529f");
        event.put((Object)"INSTRUCTION_ID", (Object)instructionId);
        event.put((Object)"invest_id", (Object)fundAcc.getInvestId());
        event.put((Object)"portfolio_id", (Object)portfolioId);
        event.put((Object)"cl_list_id", (Object)clListId);
        event.put((Object)"topic", (Object)"response_new_basket_advice");
    }

    private void buildBasketOrderAdvice(String productId, CcsFundAccount acc, BasketOrderAdvice boa, String portfolioId) {
        List stepList = null;
        if (portfolioId.isEmpty() && !productId.isEmpty()) {
            boa.setInstructionType(4);
            boa.setProductId(productId);
            boa.setBasketName("\u6587\u4ef6\u6279\u91cf\u6307\u4ee4");
            this.instrAccModel.getActiveAccMap("");
            stepList = this.instrAccModel.getWorkflow(acc.getParentId()).getSteps();
        } else if (productId.isEmpty() && !portfolioId.isEmpty()) {
            boa.setInstructionType(5);
            boa.setPortfolioId(portfolioId);
            boa.setBasketName("\u6587\u4ef6\u6295\u7ec4\u6279\u91cf\u6307\u4ee4");
            this.instrAccModel.getActiveAccMap("");
            stepList = this.instrAccModel.getWorkflow(portfolioId).getSteps();
        }
        boa.setAutoSell(false);
        boa.setUsePosition(false);
        boa.setBasketId("file_basket");
        boa.setPriceType(Integer.valueOf("11").intValue());
        boa.setStrategyType(Integer.valueOf("1").intValue());
        if (stepList != null && !stepList.isEmpty()) {
            for (AccntStepAttribute step : stepList) {
                if (1 != step.getStepId()) continue;
                boa.setFlowAttriId(step.getFlowAttriId());
                boa.setStepAttrId(step.getStepAttriId());
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void newFastInstruction(MEvent pe, List<MEvent> inse) throws MException {
        block33: {
            if (this.eCore.get((Object)"fileorderMap") == null) {
                this.eCore.put((Object)"fileorderMap", this.fileorderMap);
            }
            beginTime = System.currentTimeMillis();
            successSize = 0;
            System.nanoTime();
            passed = new ArrayList<MEvent>();
            checkFailed = new ArrayList<MEvent>();
            postIds = new HashSet<E>();
            workflowAttrId = "";
            descId = 0;
            fundAcc = null;
            beforeChcek = true;
            reason = "";
            investorId = "";
            flowAttriId = "";
            stepAttriId = "";
            investorIds = new HashSet<String>();
            for (MEvent e : inse) {
                investorId = e.getStr("fund_acct");
                investorIds.add(investorId);
            }
            if (investorIds.size() != 1) {
                beforeChcek = false;
                reason = "\u540c\u4e00\u6587\u4ef6\u8bf7\u4f7f\u7528\u5355\u4e00\u8d44\u91d1\u8d26\u53f7\u4e0b\u5355";
            }
            if (beforeChcek) {
                fundAcc = this.map.getFundAcc(investorId);
                if (fundAcc == null) {
                    beforeChcek = false;
                    reason = "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25";
                } else {
                    eventAcc = new MEvent();
                    eventAcc.put((Object)"fundAccount", (Object)fundAcc);
                    this.es.sendEvent("save.order.fundid", eventAcc);
                }
            }
            if (beforeChcek) {
                workflow = this.instrAccModel.getWorkflow(fundAcc.getParentId());
                this.instrAccModel.getActiveAccMap("");
                if (workflow == null || workflow.getId() != 1) {
                    beforeChcek = false;
                    reason = "\u6b64\u8d26\u53f7\u6ca1\u6709\u914d\u7f6e\u4e8c\u8282\u70b9\u5efa\u8bae\u6d41\u6a21\u677f";
                } else {
                    workflowAttrId = workflow.getWorkflowAttrId();
                    descId = workflow.getId();
                    stepList = workflow.getSteps();
                    if (stepList != null && !stepList.isEmpty()) {
                        var21_19 = stepList.iterator();
                        while (var21_19.hasNext()) {
                            step = (AccntStepAttribute)var21_19.next();
                            if (1 == step.getStepId()) {
                                flowAttriId = step.getFlowAttriId();
                                stepAttriId = step.getStepAttriId();
                                continue;
                            }
                            if (2 != step.getStepId()) continue;
                            postIds.addAll(step.getObjIds());
                        }
                    }
                }
            }
            if (!beforeChcek) {
                for (MEvent be : inse) {
                    this.addSingleAdviceCheckErrMsg(be, be.getStr("fund_acct"), be.getStr("client_seq"), reason);
                }
                pe.put((Object)"file.manipulate.record.fail.count", (Object)(pe.getInt("file.manipulate.record.fail.count") + inse.size()));
                return;
            }
            for (MEvent e : inse) {
                e.getStr("file.manipulate.record.uuid");
                market = ConvertUtils.getMarket(e.getStr("market_code"));
                investorSecId = e.getStr("holder_acc_no");
                price = e.getDouble("price");
                ordType = e.getStr("Bsflag");
                sec_code = e.getStr("sec_code");
                count = e.getInt("count");
                oriClientSeq = e.getStr("client_seq");
                this.fileorderMap.put(oriClientSeq, new OrderRecord(oriClientSeq, beginTime));
                clientSeq = "file|" + investorId + "|" + oriClientSeq;
                item = this.refMng.getItem(market, sec_code);
                if (item == null) {
                    this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "securityId:" + sec_code + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                    checkFailed.add(e);
                    continue;
                }
                if (!item.getMarket().equals(market)) {
                    this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "securityId:" + sec_code + ",market:" + market + ",\u5408\u7ea6\u4ee3\u7801\u672a\u5728\u5bf9\u5e94\u5e02\u573a\u627e\u5230");
                    checkFailed.add(e);
                    continue;
                }
                oa = new OrderAdvice();
                oa.setCanModify(false);
                oa.setAccntLevel(0);
                oa.setInstructionType(2);
                oa.setMarket(item.getMarket());
                oa.setSec(item.getCode());
                oa.setSecType(item.getType());
                oa.setSecName(item.getName());
                oa.setClInstructionId(clientSeq);
                isStar = sec_code.startsWith("688");
                oa.setStar(isStar);
                if (!isStar && this.checkMarketType(ordType)) {
                    this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u975e\u79d1\u521b\u677f\u4ee3\u7801\u9009\u62e9\u4e86\u79d1\u521b\u677f\u72ec\u6709\u7684\u5e02\u4ef7\u7b56\u7565");
                    checkFailed.add(e);
                    continue;
                }
                if (!BsDict.FILE_INSTRUCTION_BUY_TYPES.contains(ordType) && !BsDict.FILE_INSTRUCTION_SELL_TYPES.contains(ordType)) {
                    this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u6307\u4ee4\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u522b\uff1a" + ordType);
                    checkFailed.add(e);
                    continue;
                }
                if (!"01".equals(ordType) && !"02".equals(ordType)) {
                    this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u6307\u4ee4\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u522b\uff1a" + ordType);
                    checkFailed.add(e);
                    continue;
                }
                if (item.getType().equals("REPO")) {
                    oa.setSide(BsDict.FILE_INSTRUCTION_BUY_TYPES.contains(ordType) != false ? 71 : 70);
                } else {
                    oa.setSide(BsDict.FILE_INSTRUCTION_BUY_TYPES.contains(ordType) != false ? 49 : 50);
                }
                oa.setOrdType(50);
                oa.setPriceLimit(Integer.valueOf("2").intValue());
                oa.setPrice(price);
                accntSecList = new ArrayList<AccntSecInfo>();
                accntSec = new AccntSecInfo();
                secAcc = this.map.getSecAcc(investorSecId, market);
                accntSec.setAccntId(fundAcc.getExtAccntId());
                accntSec.setInvestorId(fundAcc.getInvestId());
                accntSec.setParentId(fundAcc.getParentId());
                e.put((Object)"fundAccount", (Object)fundAcc);
                this.es.sendEvent("save.order.fundid", e);
                if (secAcc == null) {
                    e.setCode(-1);
                    this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u8bc1\u5238\u8d26\u6237:" + (String)investorSecId + " \u65e0\u6743\u9650");
                    checkFailed.add(e);
                    continue;
                }
                accntSec.setSecAccntId(secAcc.getExtSecAccntId());
                oa.setProductId(this.accountService.getAccountFromCache(fundAcc.getParentId()).getProductId());
                oa.setInstructionPanelType("2");
                oa.setFlowAttriId(flowAttriId);
                oa.setStepAttrId(stepAttriId);
                accntSec.setOrderQty((long)count);
                accntSec.setMarket(item.getMarket());
                accntSecList.add(accntSec);
                oa.setAccSecInfoList(accntSecList);
                oa.setOrderQty((long)count);
                if (item.getType().equals("REPO")) {
                    oa.setAmount((double)(count * this.getParValue(item.getMarket())));
                } else {
                    convert = 1;
                    if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getType())) {
                        convert = 10;
                    }
                    oa.setAmount(price * (double)count * (double)convert);
                }
                e.put((Object)"single_advice", (Object)oa);
                passed.add(e);
            }
            newInsB = PInstructionManagement.NewFastInstructionReq.newBuilder();
            newInsB.addAllPostId(postIds);
            newInsB.setFlowAttrId(workflowAttrId);
            newInsB.setDescId(descId);
            eventMap = new HashMap<String, MEvent>();
            TradeApi.logger.info("\u5f00\u59cb\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u4e0b\u5355\u7b14\u6570: " + passed.size());
            for (MEvent mEvent : passed) {
                orderAdvice = (OrderAdvice)mEvent.get(OrderAdvice.class, "single_advice");
                if (orderAdvice == null) continue;
                if (StringUtils.isEmpty((String)mEvent.getStr("client_seq"))) {
                    clientSeq = "file|" + investorId + "|" + (int)(Math.random() * 1000000.0);
                    orderAdvice.setClInstructionId(clientSeq);
                }
                eventMap.put(orderAdvice.getClInstructionId(), mEvent);
                newInsB.addInstruction(orderAdvice.buildFastInstruction());
            }
            try {
                fastInstructions = this.insApi.fastInstructions(newInsB);
                for (PInstructionManagement.NewFastInstructionResult newFastInstructionResult : fastInstructions) {
                    mEvent = (MEvent)eventMap.get(newFastInstructionResult.getSerialId());
                    if (newFastInstructionResult.getStatus().getStatus() == 1) {
                        ++successSize;
                        mEvent.put((Object)"erroe_msg", (Object)"\u4e0b\u8fbe\u5355\u7b14\u6307\u4ee4\u6210\u529f");
                    }
                    if (mEvent == null) continue;
                    mEvent.put((Object)"error_code", (Object)String.valueOf(newFastInstructionResult.getStatus().getStatus()));
                    mEvent.put((Object)"INSTRUCTION_ID", (Object)newFastInstructionResult.getInstructionId());
                    mEvent.put((Object)"invest_id", (Object)mEvent.getStr("fund_acct"));
                    mEvent.put((Object)"client_seq", (Object)mEvent.getStr("client_seq"));
                    mEvent.put((Object)"topic", (Object)"response_new_single_advice");
                }
                break block33;
            }
            catch (MException | Exception e) {
                ** for (mEvent : passed)
            }
lbl-1000:
            // 1 sources

            {
                this.addSingleAdviceCheckErrMsg(mEvent, mEvent.getStr("fund_acct"), mEvent.getStr("client_seq"), e.getMessage());
                continue;
            }
        }
        pe.put((Object)"file.manipulate.record.fail.count", (Object)(pe.getInt("file.manipulate.record.fail.count") + inse.size() - successSize));
        pe.put((Object)"file.manipulate.record.succ.count", (Object)(pe.getInt("file.manipulate.record.succ.count") + successSize));
    }

    /*
     * Unable to fully structure code
     */
    public void lightingInstruction(MEvent pe, List<MEvent> inse) throws MException {
        block16: {
            passed = new ArrayList<MEvent>();
            checkFailed = new ArrayList<MEvent>();
            fundAcc = null;
            beforeChcek = true;
            reason = "";
            investorId = "";
            investorIds = new HashSet<String>();
            for (MEvent e : inse) {
                investorId = e.getStr("fund_acct");
                investorIds.add(investorId);
            }
            if (investorIds.size() != 1) {
                beforeChcek = false;
                reason = "\u540c\u4e00\u6587\u4ef6\u8bf7\u4f7f\u7528\u5355\u4e00\u8d44\u91d1\u8d26\u53f7\u4e0b\u5355";
            }
            if (beforeChcek) {
                fundAcc = this.map.getFundAcc(investorId);
                if (fundAcc == null) {
                    beforeChcek = false;
                    reason = "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25";
                } else {
                    eventAcc = new MEvent();
                    eventAcc.put((Object)"fundAccount", (Object)fundAcc);
                    this.es.sendEvent("save.order.fundid", eventAcc);
                }
            }
            if (!beforeChcek) {
                for (MEvent be : inse) {
                    this.addSingleAdviceCheckErrMsg(be, be.getStr("fund_acct"), be.getStr("client_seq"), reason);
                }
                pe.put((Object)"file.manipulate.record.fail.count", (Object)(pe.getInt("file.manipulate.record.fail.count") + inse.size()));
                return;
            }
            lightingIns = new LightingInstruction();
            batch = new LightingInstructionBatch();
            lightingIns.setBatch(batch);
            lightingIns.setAccountId("");
            basket_no = "";
            uuid = UUID.randomUUID().toString().substring(0, 6);
            for (MEvent e : inse) {
                market = ConvertUtils.getMarket(e.getStr("market_code"));
                investorSecId = e.getStr("holder_acc_no");
                price = e.getDouble("price");
                ordType = e.getStr("Bsflag");
                sec_code = e.getStr("sec_code");
                count = e.getInt("count");
                basket_no = e.getStr("basket_no");
                oriClientSeq = e.getStr("client_seq");
                clientSeq = "file|" + investorId + "|" + uuid;
                item = this.refMng.getItem(market, sec_code);
                secAcc = this.map.getSecAcc(investorSecId, market);
                e.put((Object)"fundAccount", (Object)fundAcc);
                this.es.sendEvent("save.order.fundid", e);
                if (secAcc == null) {
                    e.setCode(-1);
                    this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "\u8bc1\u5238\u8d26\u6237:" + investorSecId + " \u65e0\u6743\u9650");
                    checkFailed.add(e);
                    continue;
                }
                if (item == null) {
                    this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "securityId:" + sec_code + ",market:" + market + ",\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                    checkFailed.add(e);
                    continue;
                }
                if (!item.getMarket().equals(market)) {
                    this.addSingleAdviceCheckErrMsg(e, investorId, oriClientSeq, "securityId:" + sec_code + ",market:" + market + ",\u5408\u7ea6\u4ee3\u7801\u672a\u5728\u5bf9\u5e94\u5e02\u573a\u627e\u5230");
                    checkFailed.add(e);
                    continue;
                }
                leg = new Trade();
                leg.setClOrdId(clientSeq);
                leg.setMarket(market);
                lightingIns.setAccountId(this.mConf.getValue("lighting.accntid"));
                leg.setApplId("010");
                leg.setSecAccntId(secAcc.getExtSecAccntId());
                leg.setSecAccntId(this.mConf.getValue("lighting.secaccntid"));
                leg.setOrderQty((double)count);
                leg.setSecurityType(item.getType());
                leg.setOrdType(OrdType.ORD_TYPE_LIMIT);
                leg.setPrice(price);
                leg.setSecurityId(sec_code);
                if (item.getType().equals("REPO")) {
                    leg.setSide(BsDict.FILE_INSTRUCTION_BUY_TYPES.contains(ordType) != false ? Side.SIDE_BORROW : Side.SIDE_LEND);
                } else {
                    leg.setSide(BsDict.FILE_INSTRUCTION_BUY_TYPES.contains(ordType) != false ? Side.SIDE_BUY : Side.SIDE_SELL);
                }
                batch.getLeg().add(leg);
                passed.add(e);
            }
            clientInsSeq = "file|" + investorId + "|" + basket_no + uuid;
            lightingIns.setClInsId(clientInsSeq);
            TradeApi.logger.info("\u5f00\u59cb\u8c03\u7528\u540e\u53f0\u63a5\u53e3\uff0c\u4e0b\u5355\u7b14\u6570: " + passed.size());
            try {
                lightingIns.getBatch().setAccountId(lightingIns.getAccountId());
                this.lightingInsApi.newLightingInstruction(lightingIns);
                break block16;
            }
            catch (MException | Exception e) {
                ** for (mEvent : passed)
            }
lbl-1000:
            // 1 sources

            {
                this.addSingleAdviceCheckErrMsg(mEvent, mEvent.getStr("fund_acct"), mEvent.getStr("client_seq"), e.getMessage());
                continue;
            }
        }
        pe.put((Object)"file.manipulate.record.fail.count", (Object)(pe.getInt("file.manipulate.record.fail.count") + 0));
        pe.put((Object)"file.manipulate.record.succ.count", (Object)(pe.getInt("file.manipulate.record.succ.count") + 1));
    }

    /*
     * Unable to fully structure code
     */
    public void topSpeedInstructionCancel(MEvent pe, List<MEvent> inse) {
        block25: {
            uuid = pe.getStr("file.manipulate.record.uuid");
            beforeChcek = true;
            reason = "";
            investorId = "";
            fundAcc = null;
            investorIds = new HashSet<String>();
            postIds = new HashSet<E>();
            for (MEvent e : inse) {
                investorId = e.getStr("invest_id");
                investorIds.add(investorId);
            }
            if (investorIds.size() > 1) {
                beforeChcek = false;
                reason = "\u540c\u4e00\u6587\u4ef6\u8bf7\u4f7f\u7528\u5355\u4e00\u8d44\u91d1\u8d26\u53f7\u4e0b\u5355";
            }
            if (beforeChcek) {
                fundAcc = this.map.getFundAcc(investorId);
                if (fundAcc != null) {
                    eventAcc = new MEvent();
                    eventAcc.put((Object)"fundAccount", (Object)fundAcc);
                    this.es.sendEvent("save.order.fundid", eventAcc);
                } else {
                    beforeChcek = false;
                    reason = "\u540c\u4e00\u6587\u4ef6\u8bf7\u4f7f\u7528\u5355\u4e00\u8d44\u91d1\u8d26\u53f7\u4e0b\u5355";
                }
            }
            if (beforeChcek) {
                fundAcc = this.map.getFundAcc(investorId);
                if (fundAcc == null) {
                    beforeChcek = false;
                    reason = "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25";
                } else {
                    eventAcc = new MEvent();
                    eventAcc.put((Object)"fundAccount", (Object)fundAcc);
                    this.es.sendEvent("save.order.fundid", eventAcc);
                }
            }
            if (beforeChcek) {
                workflow = this.instrAccModel.getWorkflow(fundAcc.getParentId());
                this.instrAccModel.getActiveAccMap("");
                if (workflow == null || workflow.getId() != 1) {
                    beforeChcek = false;
                    reason = "\u6b64\u8d26\u53f7\u6ca1\u6709\u914d\u7f6e\u4e8c\u8282\u70b9\u5efa\u8bae\u6d41\u6a21\u677f";
                } else {
                    stepList = workflow.getSteps();
                    if (stepList != null && !stepList.isEmpty()) {
                        var13_12 = stepList.iterator();
                        while (var13_12.hasNext()) {
                            step = (AccntStepAttribute)var13_12.next();
                            if (2 != step.getStepId()) continue;
                            postIds.addAll(step.getObjIds());
                            break;
                        }
                    }
                }
            }
            if (!beforeChcek) {
                for (MEvent be : inse) {
                    this.addSingleAdviceCheckErrMsg(be, be.getStr("fund_acct"), be.getStr("client_seq"), reason);
                }
                pe.put((Object)"file.manipulate.record.fail.count", (Object)(pe.getInt("file.manipulate.record.fail.count") + inse.size()));
                return;
            }
            passed = new ArrayList<MEvent>();
            failed = new ArrayList<MEvent>();
            idMap = new HashMap<String, MEvent>();
            clIdMap = new HashMap<String, MEvent>();
            instructionIds = new HashSet<String>();
            clInstructionIds = new HashSet<String>();
            for (MEvent e : inse) {
                instructionId = e.getStr("INSTRUCTION_ID");
                clInstructionId = e.getStr("cl_instruction_id");
                if (!StringUtils.isEmpty((String)instructionId)) {
                    idMap.put(instructionId, e);
                    instructionIds.add(instructionId);
                    passed.add(e);
                    continue;
                }
                if (!StringUtils.isEmpty((String)clInstructionId)) {
                    clIdMap.put("file|" + investorId + "|" + clInstructionId, e);
                    clInstructionIds.add("file|" + investorId + "|" + clInstructionId);
                    passed.add(e);
                    continue;
                }
                failed.add(e);
            }
            successSize = 0;
            if (passed.size() > 0) {
                cb = PInstructionManagement.CancelFastInstructionReq.newBuilder();
                cb.addAllInstructionId(instructionIds);
                cb.addAllClInstructionId(clInstructionIds);
                cb.addAllPostId(postIds);
                try {
                    cancelResults = this.insApi.cancelFastInstruction(cb);
                    for (PInstructionManagement.CancelResult cancelResult : cancelResults) {
                        if (idMap.get(cancelResult.getInstructionId()) != null) {
                            re = (MEvent)idMap.get(cancelResult.getInstructionId());
                            this.addInstructionCancelErrMsg(re, String.valueOf(cancelResult.getStatus().getStatus()), cancelResult.getStatus().getStatus() == 1 ? "\u64a4\u9500\u6307\u4ee4\u6210\u529f" : (String)TradeApi.dmap.get("error_code").get(String.valueOf(cancelResult.getStatus().getStatus())), investorId, cancelResult.getInstructionId(), re.getStr("cl_instruction_id"));
                            ++successSize;
                            continue;
                        }
                        if (clIdMap.get(cancelResult.getClInstructionId()) == null) continue;
                        re = (MEvent)clIdMap.get(cancelResult.getClInstructionId());
                        this.addInstructionCancelErrMsg(re, String.valueOf(cancelResult.getStatus().getStatus()), cancelResult.getStatus().getStatus() == 1 ? "\u64a4\u9500\u6307\u4ee4\u6210\u529f" : (String)TradeApi.dmap.get("error_code").get(String.valueOf(cancelResult.getStatus().getStatus())), investorId, cancelResult.getInstructionId(), re.getStr("cl_instruction_id"));
                        ++successSize;
                    }
                    break block25;
                }
                catch (MException | Exception e1) {
                    ** for (me : passed)
                }
lbl-1000:
                // 1 sources

                {
                    this.addInstructionCancelErrMsg(me, "-1", "\u64a4\u9500\u6307\u4ee4\u5931\u8d25" + e1.getMessage(), investorId, me.getStr("INSTRUCTION_ID"), me.getStr("cl_instruction_id"));
                    continue;
                }
            }
        }
        for (MEvent me : failed) {
            this.addInstructionCancelErrMsg(me, "-1", "\u6307\u4ee4id\uff0c\u524d\u7aef\u6d41\u6c34\u53f7\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a", investorId, me.getStr("INSTRUCTION_ID"), me.getStr("cl_instruction_id"));
        }
        pe.put((Object)"file.manipulate.record.fail.count", (Object)(pe.getInt("file.manipulate.record.fail.count") + inse.size() - successSize));
        pe.put((Object)"file.manipulate.record.succ.count", (Object)(pe.getInt("file.manipulate.record.succ.count") + successSize));
        TradeApi.logger.info("[" + uuid + "]" + "\u5f00\u59cb\u6307\u4ee4\u64a4\u9500,\u6821\u9a8c\u901a\u8fc7: " + passed.size() + ", \u6821\u9a8c\u4e0d\u901a\u8fc7:" + failed.size());
    }

    public void lightingInstructionCancel(MEvent e) {
        String uuid = e.getStr("file.manipulate.record.uuid");
        String investorId = e.getStr("invest_id");
        String instructionId = e.getStr("INSTRUCTION_ID");
        String clInstructionId = e.getStr("cl_instruction_id");
        String orderId = e.getStr("order_id");
        String clOrderId = e.getStr("cl_order_id");
        logger.info("[" + uuid + "]" + "\u5f00\u59cb\u6307\u4ee4\u64a4\u9500\uff0cinstructionId: " + instructionId + ", investorId:" + investorId);
        CcsFundAccount fundAcc = this.map.getFundAcc(investorId);
        if (fundAcc == null) {
            this.addSingleAdviceCheckErrMsg(e, investorId, "", "\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            e.setCode(-1);
            MEvent me = new MEvent();
            me.setDesc("\u8d44\u91d1\u8d26\u6237:" + investorId + " \u65e0\u6743\u9650\u6216\u8005\u767b\u5f55\u5931\u8d25");
            this.es.postEvent("message.log", me);
            return;
        }
        MEvent eventAcc = new MEvent();
        eventAcc.put((Object)"fundAccount", (Object)fundAcc);
        this.es.sendEvent("save.order.fundid", eventAcc);
        try {
            LightingInstruction req = new LightingInstruction();
            req.setAccountId(this.mConf.getValue("lighting.accntid"));
            LightingOrderCancel orderCancel = new LightingOrderCancel();
            orderCancel.setAccountId(req.getAccountId());
            orderCancel.setOrigClOrdId("file|" + investorId + "|" + clOrderId);
            orderCancel.setOrderId(orderId);
            req.setOrderCancel(orderCancel);
            this.lightingInsApi.newLightingInstruction(req);
        }
        catch (MException e1) {
            MEvent me = new MEvent();
            me.setDesc("\u6587\u4ef6\u5355\u64a4\u9500\u6307\u4ee4\u5931\u8d25\uff0c\u6307\u4ee4id\uff1a" + instructionId);
            this.es.postEvent("message.log", me);
            logger.error("\u6587\u4ef6\u5355\u64a4\u9500\u6307\u4ee4\u5931\u8d25\uff0c\u6307\u4ee4id\uff1a" + instructionId, (Throwable)e1);
            this.addInstructionCancelErrMsg(e, String.valueOf(e1.getCode()), "\u64a4\u9500\u6307\u4ee4\u5931\u8d25\uff0c" + e1.getMessage(), investorId, instructionId, clInstructionId);
            return;
        }
        this.addInstructionCancelErrMsg(e, "1", "\u64a4\u9500\u6307\u4ee4\u6210\u529f", investorId, instructionId, clInstructionId);
        e.setOK();
        logger.info("[" + uuid + "]" + "\u6279\u6b21\u53f7\u6279\u91cf\u64a4\u5355\u8bf7\u6c42\u5df2\u53d1\u9001 ");
    }
}

